/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tooltip;

import com.alee.laf.tooltip.AdaptiveToolTipPainter;
import com.alee.laf.tooltip.IToolTipPainter;
import com.alee.laf.tooltip.ToolTipPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicToolTipUI;

public class WebToolTipUI
extends BasicToolTipUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=ToolTipPainter.class)
    protected IToolTipPainter painter;
    protected PropertyChangeListener propertyChangeListener;
    protected JComponent tooltip = null;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebToolTipUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.tooltip = c;
        StyleManager.installSkin(this.tooltip);
    }

    @Override
    protected void installListeners(JComponent c) {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String name = e.getPropertyName();
                if (name.equals("tiptext") || name.equals("tiptext") || name.equals("tiptext")) {
                    JToolTip tip = (JToolTip)e.getSource();
                    String text = tip.getTipText();
                    BasicHTML.updateRenderer(tip, text);
                }
            }
        };
        c.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.tooltip);
        this.tooltip = null;
        super.uninstallUI(c);
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.tooltip);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.tooltip, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.tooltip, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.tooltip, new DataRunnable<IToolTipPainter>(){

            public void run(IToolTipPainter newPainter) {
                WebToolTipUI.this.painter = newPainter;
            }
        }, this.painter, painter, IToolTipPainter.class, AdaptiveToolTipPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, this.painter);
    }
}

