/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table.renderers;

import com.alee.laf.label.WebLabel;
import com.alee.managers.style.StyleId;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class WebTableCellRenderer
extends WebLabel
implements TableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;

    public WebTableCellRenderer() {
        this.setName("Table.cellRenderer");
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setStyleId(StyleId.tableCellRenderer.at(table));
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            Color alternateColor;
            Color background;
            Color color = background = this.unselectedBackground != null ? this.unselectedBackground : table.getBackground();
            if ((background == null || background instanceof javax.swing.plaf.UIResource) && (alternateColor = UIManager.getColor("Table.alternateRowColor")) != null && row % 2 == 0) {
                background = alternateColor;
            }
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(background);
        }
        this.setFont(table.getFont());
        this.setValue(value);
        this.setEnabled(table.isEnabled());
        return this;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    public static class UIResource
    extends WebTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

