/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.table.WebTableHeader;
import com.alee.laf.table.WebTableUI;
import com.alee.managers.log.Log;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.GeometryUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.FontMethods;
import com.alee.utils.swing.SizeMethods;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.EventObject;
import java.util.Map;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class WebTable
extends JTable
implements Styleable,
Skinnable,
Paintable,
ShapeProvider,
MarginSupport,
PaddingSupport,
FontMethods<WebTable>,
SizeMethods<WebTable> {
    private boolean editable = true;
    private int visibleRowCount = -1;
    protected ToolTipProvider<? extends WebTable> toolTipProvider = null;

    public WebTable() {
    }

    public WebTable(TableModel dm) {
        super(dm);
    }

    public WebTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public WebTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public WebTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public WebTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public WebTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public WebTable(StyleId id) {
        this.setStyleId(id);
    }

    public WebTable(StyleId id, TableModel dm) {
        super(dm);
        this.setStyleId(id);
    }

    public WebTable(StyleId id, TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.setStyleId(id);
    }

    public WebTable(StyleId id, TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.setStyleId(id);
    }

    public WebTable(StyleId id, int numRows, int numColumns) {
        super(numRows, numColumns);
        this.setStyleId(id);
    }

    public WebTable(StyleId id, Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.setStyleId(id);
    }

    public WebTable(StyleId id, Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.setStyleId(id);
    }

    @Override
    protected WebTableHeader createDefaultTableHeader() {
        return new WebTableHeader(this.getColumnModel());
    }

    public ToolTipProvider<? extends WebTable> getToolTipProvider() {
        return this.toolTipProvider;
    }

    public void setToolTipProvider(ToolTipProvider<? extends WebTable> provider) {
        this.toolTipProvider = provider;
    }

    public void optimizeColumnWidths() {
        this.optimizeColumnWidths(false, 20, Integer.MAX_VALUE);
    }

    public void optimizeColumnWidths(boolean processData) {
        this.optimizeColumnWidths(processData, 20, Integer.MAX_VALUE);
    }

    public void optimizeColumnWidths(boolean processData, int minWidth, int maxWidth) {
        if (this.getTableHeader() != null || processData) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                int width = this.getOptimalColumnWidth(column, processData, minWidth, maxWidth);
                this.getColumnModel().getColumn(column).setPreferredWidth(width);
            }
        }
    }

    protected int getOptimalColumnWidth(int column, boolean processData, int minWidth, int maxWidth) {
        int width = 0;
        JTableHeader th = this.getTableHeader();
        if (th != null) {
            Object value = th.getColumnModel().getColumn(column).getHeaderValue();
            TableCellRenderer hr = th.getDefaultRenderer();
            Component r = hr.getTableCellRendererComponent(this, value, false, false, -1, column);
            width = Math.max(width, r.getPreferredSize().width);
        }
        if (processData) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object value = this.getModel().getValueAt(row, column);
                TableCellRenderer cr = this.getCellRenderer(row, column);
                Component r = cr.getTableCellRendererComponent(this, value, false, false, row, column);
                width = Math.max(width, r.getPreferredSize().width);
            }
        }
        return Math.max(minWidth, Math.min(width, maxWidth));
    }

    public void setSelectedRow(int row) {
        this.setSelectedRow(row, true);
    }

    public void setSelectedRow(int row, boolean scroll) {
        this.clearSelection();
        this.addSelectedRow(row);
        if (row != -1 && scroll) {
            this.scrollToRow(row);
        }
    }

    public void addSelectedRow(int row) {
        if (row != -1) {
            this.addColumnSelectionInterval(0, this.getColumnCount() - 1);
            this.addRowSelectionInterval(row, row);
        }
    }

    public void setSelectedRows(int startRow, int endRow) {
        this.clearSelection();
        this.addSelectedRows(startRow, endRow);
    }

    public void addSelectedRows(int startRow, int endRow) {
        if (startRow != -1 && endRow != -1) {
            this.addColumnSelectionInterval(0, this.getColumnCount() - 1);
            this.addRowSelectionInterval(startRow, endRow);
        }
    }

    public void setSelectedColumn(int column) {
        this.setSelectedColumn(column, true);
    }

    public void setSelectedColumn(int column, boolean scroll) {
        this.clearSelection();
        this.addSelectedColumn(column);
        if (scroll) {
            this.scrollToColumn(column);
        }
    }

    public void addSelectedColumn(int column) {
        if (column != -1) {
            this.addColumnSelectionInterval(column, column);
            this.addRowSelectionInterval(0, this.getRowCount() - 1);
        }
    }

    public void setSelectedColumns(int startColumn, int endColumn) {
        this.clearSelection();
        this.addSelectedColumns(startColumn, endColumn);
    }

    public void addSelectedColumns(int startColumn, int endColumn) {
        if (startColumn != -1 && endColumn != -1) {
            this.addColumnSelectionInterval(startColumn, endColumn);
            this.addRowSelectionInterval(0, this.getRowCount() - 1);
        }
    }

    public void scrollToRow(int row) {
        Rectangle lastCell;
        Rectangle firstCell = this.getCellRect(row, 0, true);
        Rectangle rect = GeometryUtils.getContainingRect((Rectangle)firstCell, (Rectangle)(lastCell = this.getCellRect(row, this.getColumnCount() - 1, true)));
        if (rect != null) {
            this.scrollRectToVisible(rect);
        }
    }

    public void scrollToColumn(int column) {
        Rectangle lastCell;
        Rectangle firstCell = this.getCellRect(0, column, true);
        Rectangle rect = GeometryUtils.getContainingRect((Rectangle)firstCell, (Rectangle)(lastCell = this.getCellRect(this.getRowCount() - 1, column, true)));
        if (rect != null) {
            this.scrollRectToVisible(rect);
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject event) {
        boolean editingStarted = super.editCellAt(row, column, event);
        if (editingStarted) {
            TableCellEditor cellEditor = this.getCellEditor();
            try {
                Object o = cellEditor.getClass().getMethod("getComponent", new Class[0]).invoke((Object)cellEditor, new Object[0]);
                if (o instanceof Component) {
                    ((Component)o).requestFocusInWindow();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return editingStarted;
    }

    public boolean stopCellEditing() {
        TableCellEditor cellEditor = this.getCellEditor();
        return cellEditor != null && cellEditor.stopCellEditing();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editable && super.isCellEditable(row, column);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
        this.setPreferredScrollableViewportSize(null);
        JScrollPane scrollPane = SwingUtils.getScrollPane(this);
        if (scrollPane != null) {
            scrollPane.getViewport().invalidate();
        }
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.preferredViewportSize != null) {
            return this.preferredViewportSize;
        }
        Dimension ps = this.getPreferredSize();
        if (this.visibleRowCount != -1) {
            int rowHeight;
            if (this.getRowCount() > 0) {
                Rectangle r = this.getCellRect(0, 0, true);
                rowHeight = r.height;
            } else {
                rowHeight = this.getRowHeight();
            }
            ps.height = this.visibleRowCount * rowHeight;
        }
        return ps;
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setPreferredScrollableViewportSize(null);
    }

    @Override
    public StyleId getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this);
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this);
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this, id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this, id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    @Override
    public Insets getPadding() {
        return this.getWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        this.getWebUI().setPadding(padding);
    }

    private WebTableUI getWebUI() {
        return (WebTableUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getTableHeader() != null) {
            this.getTableHeader().updateUI();
        }
        this.configureScrollPane();
        if (this.getUI() == null || !(this.getUI() instanceof WebTableUI)) {
            try {
                this.setUI((WebTableUI)ReflectUtils.createInstance((String)WebLookAndFeel.tableUI, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                Log.error((Object)this, (Throwable)e);
                this.setUI(new WebTableUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    protected void configureScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            Component corner = scrollPane.getCorner("UPPER_TRAILING_CORNER");
            if (corner == null || corner instanceof UIResource) {
                corner = null;
                Object componentClass = UIManager.get("Table.scrollPaneCornerComponent");
                if (componentClass instanceof Class) {
                    try {
                        corner = (Component)((Class)componentClass).newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                scrollPane.setCorner("UPPER_TRAILING_CORNER", corner);
            }
        }
    }

    @Override
    public WebTable setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebTable setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebTable setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebTable setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebTable setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebTable setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebTable setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTable setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebTable setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebTable changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebTable setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTable setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTable setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebTable setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebTable setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebTable setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebTable setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public int getMaximumWidth() {
        return SizeUtils.getMaximumWidth(this);
    }

    @Override
    public WebTable setMaximumWidth(int maximumWidth) {
        return SizeUtils.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeUtils.getMaximumHeight(this);
    }

    @Override
    public WebTable setMaximumHeight(int maximumHeight) {
        return SizeUtils.setMaximumHeight(this, maximumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    public WebTable setPreferredSize(int width, int height) {
        return SizeUtils.setPreferredSize(this, width, height);
    }
}

