/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.table.ITablePainter;
import com.alee.laf.table.WebTable;
import com.alee.laf.table.WebTableUI;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.painter.AbstractPainter;
import com.alee.utils.CompareUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TablePainter<E extends JTable, U extends WebTableUI>
extends AbstractPainter<E, U>
implements ITablePainter<E, U> {
    protected MouseAdapter mouseAdapter;
    protected Point rolloverCell;
    protected CellRendererPane rendererPane = null;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateMouseover(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.updateMouseover(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.clearMouseover();
            }

            private void updateMouseover(MouseEvent e) {
                Point point = e.getPoint();
                Point cell = TablePainter.this.p(((JTable)TablePainter.this.component).columnAtPoint(point), ((JTable)TablePainter.this.component).rowAtPoint(point));
                if (cell.x != -1 && cell.y != -1) {
                    if (!CompareUtils.equals((Object)TablePainter.this.rolloverCell, (Object[])new Object[]{cell})) {
                        this.updateRolloverCell(TablePainter.this.rolloverCell, cell);
                    }
                } else {
                    this.clearMouseover();
                }
            }

            private void clearMouseover() {
                if (TablePainter.this.rolloverCell != null) {
                    this.updateRolloverCell(TablePainter.this.rolloverCell, null);
                }
            }

            private void updateRolloverCell(Point oldCell, Point newCell) {
                TablePainter.this.rolloverCell = newCell;
                ToolTipProvider<WebTable> provider = TablePainter.this.getToolTipProvider();
                if (provider != null) {
                    int oldIndex = oldCell != null ? oldCell.y : -1;
                    int oldColumn = oldCell != null ? oldCell.x : -1;
                    int newIndex = newCell != null ? newCell.y : -1;
                    int newColumn = newCell != null ? newCell.x : -1;
                    provider.hoverCellChanged((WebTable)TablePainter.this.component, oldIndex, oldColumn, newIndex, newColumn);
                }
            }
        };
        ((JTable)this.component).addMouseListener(this.mouseAdapter);
        ((JTable)this.component).addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void uninstall(E c, U ui) {
        ((JTable)this.component).removeMouseListener(this.mouseAdapter);
        ((JTable)this.component).removeMouseMotionListener(this.mouseAdapter);
        this.mouseAdapter = null;
        super.uninstall(c, ui);
    }

    @Override
    public void prepareToPaint(CellRendererPane rendererPane) {
        this.rendererPane = rendererPane;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        Rectangle clip = g2d.getClipBounds();
        if (((JTable)this.component).getRowCount() <= 0 || ((JTable)this.component).getColumnCount() <= 0 || !bounds.intersects(clip)) {
            this.paintDropLines(g2d);
            return;
        }
        Point upperLeft = clip.getLocation();
        if (!this.ltr) {
            ++upperLeft.x;
        }
        Point lowerRight = this.p(clip.x + clip.width - (this.ltr ? 1 : 0), clip.y + clip.height);
        int rMin = ((JTable)this.component).rowAtPoint(upperLeft);
        int rMax = ((JTable)this.component).rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = ((JTable)this.component).getRowCount() - 1;
        }
        int cMin = ((JTable)this.component).columnAtPoint(this.ltr ? upperLeft : lowerRight);
        int cMax = ((JTable)this.component).columnAtPoint(this.ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = ((JTable)this.component).getColumnCount() - 1;
        }
        this.paintGrid(g2d, rMin, rMax, cMin, cMax);
        this.paintCells(g2d, rMin, rMax, cMin, cMax);
        this.paintDropLines(g2d);
        this.rendererPane = null;
    }

    protected void paintDropLines(Graphics g) {
        JTable.DropLocation loc = ((JTable)this.component).getDropLocation();
        if (loc == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color shortColor = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle rect = this.getHDropLineRect(loc);
        if (rect != null) {
            int x = rect.x;
            int w = rect.width;
            if (color != null) {
                this.extendRect(rect, true);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(x, rect.y, w, rect.height);
            }
        }
        if ((rect = this.getVDropLineRect(loc)) != null) {
            int y = rect.y;
            int h = rect.height;
            if (color != null) {
                this.extendRect(rect, false);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertRow() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(rect.x, y, rect.width, h);
            }
        }
    }

    protected Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return null;
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= ((JTable)this.component).getColumnCount()) {
            --col;
        }
        Rectangle rect = ((JTable)this.component).getCellRect(row, col, true);
        if (row >= ((JTable)this.component).getRowCount()) {
            Rectangle prevRect = ((JTable)this.component).getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    protected Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return null;
        }
        int col = loc.getColumn();
        Rectangle rect = ((JTable)this.component).getCellRect(loc.getRow(), col, true);
        if (col >= ((JTable)this.component).getColumnCount()) {
            rect = ((JTable)this.component).getCellRect(loc.getRow(), --col, true);
            if (this.ltr) {
                rect.x += rect.width;
            }
        } else if (!this.ltr) {
            rect.x += rect.width;
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }

    protected Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect != null) {
            if (horizontal) {
                rect.x = 0;
                rect.width = ((JTable)this.component).getWidth();
            } else {
                rect.y = 0;
                if (((JTable)this.component).getRowCount() != 0) {
                    Rectangle lastRect = ((JTable)this.component).getCellRect(((JTable)this.component).getRowCount() - 1, 0, true);
                    rect.height = lastRect.y + lastRect.height;
                } else {
                    rect.height = ((JTable)this.component).getHeight();
                }
            }
        }
        return rect;
    }

    protected void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        block6: {
            int x;
            g.setColor(((JTable)this.component).getGridColor());
            Rectangle minCell = ((JTable)this.component).getCellRect(rMin, cMin, true);
            Rectangle maxCell = ((JTable)this.component).getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            if (((JTable)this.component).getShowHorizontalLines()) {
                int tableWidth = damagedArea.x + damagedArea.width;
                int y = damagedArea.y;
                for (int row = rMin; row <= rMax; ++row) {
                    g.drawLine(damagedArea.x, (y += ((JTable)this.component).getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                }
            }
            if (!((JTable)this.component).getShowVerticalLines()) break block6;
            TableColumnModel cm = ((JTable)this.component).getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.ltr) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x;
                for (int column = cMax; column >= cMin; --column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            }
        }
    }

    protected void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = ((JTable)this.component).getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = ((JTable)this.component).getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.ltr) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = ((JTable)this.component).getCellRect(row, cMin, false);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (int row = rMin; row <= rMax; ++row) {
                int columnWidth;
                Rectangle cellRect = ((JTable)this.component).getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(g, cellRect, row, column);
                }
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    protected void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (((JTable)this.component).isEditing() && ((JTable)this.component).getEditingRow() == row && ((JTable)this.component).getEditingColumn() == column) {
            Component editor = ((JTable)this.component).getEditorComponent();
            editor.setBounds(cellRect);
            editor.validate();
        } else {
            TableCellRenderer renderer = ((JTable)this.component).getCellRenderer(row, column);
            Component prepareRenderer = ((JTable)this.component).prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, prepareRenderer, this.component, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    protected void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = ((JTable)this.component).getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = ((JTable)this.component).getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(((JTable)this.component).getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(((JTable)this.component).getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (((JTable)this.component).getShowVerticalLines()) {
            g.setColor(((JTable)this.component).getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = ((JTable)this.component).getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!((JTable)this.component).getShowHorizontalLines()) continue;
            g.setColor(((JTable)this.component).getGridColor());
            Rectangle rcr = ((JTable)this.component).getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    protected int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = ((JTable)this.component).getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    protected ToolTipProvider<? extends WebTable> getToolTipProvider() {
        return this.component != null && this.component instanceof WebTable ? ((WebTable)this.component).getToolTipProvider() : null;
    }
}

