/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.laf.tabbedpane.AdaptiveTabbedPanePainter;
import com.alee.laf.tabbedpane.ITabbedPanePainter;
import com.alee.laf.tabbedpane.TabStretchType;
import com.alee.laf.tabbedpane.TabbedPanePainter;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebBasicTabbedPaneUI;
import com.alee.laf.tabbedpane.WebTabbedPaneStyle;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.MergeUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class WebTabbedPaneUI
extends WebBasicTabbedPaneUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=TabbedPanePainter.class)
    protected ITabbedPanePainter painter;
    protected int tabRunIndent = WebTabbedPaneStyle.tabRunIndent;
    protected int tabOverlay = WebTabbedPaneStyle.tabOverlay;
    protected TabbedPaneStyle tabbedPaneStyle = WebTabbedPaneStyle.tabbedPaneStyle;
    protected TabStretchType tabStretchType = WebTabbedPaneStyle.tabStretchType;
    protected Insets contentInsets = WebTabbedPaneStyle.contentInsets;
    protected Insets tabInsets = WebTabbedPaneStyle.tabInsets;
    protected boolean rotateTabInsets = WebTabbedPaneStyle.rotateTabInsets;
    protected final Map<Integer, Color> selectedForegroundAt = new HashMap<Integer, Color>();
    protected final Map<Integer, Painter> backgroundPainterAt = new HashMap<Integer, Painter>();
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.tabPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.tabPane);
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.tabPane);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.tabPane, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.tabPane, this.painter);
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.tabPane, new DataRunnable<ITabbedPanePainter>(){

            public void run(ITabbedPanePainter newPainter) {
                WebTabbedPaneUI.this.painter = newPainter;
            }
        }, this.painter, painter, ITabbedPanePainter.class, AdaptiveTabbedPanePainter.class);
    }

    public boolean isRotateTabInsets() {
        return this.rotateTabInsets;
    }

    public void setRotateTabInsets(boolean rotateTabInsets) {
        this.rotateTabInsets = rotateTabInsets;
    }

    public Insets getContentInsets() {
        return this.contentInsets;
    }

    public void setContentInsets(Insets contentInsets) {
        this.contentInsets = contentInsets;
    }

    public Insets getTabInsets() {
        return this.tabInsets;
    }

    public void setTabInsets(Insets tabInsets) {
        this.tabInsets = tabInsets;
    }

    public void setSelectedForegroundAt(int tabIndex, Color foreground) {
        this.selectedForegroundAt.put(tabIndex, foreground);
    }

    public Color getSelectedForegroundAt(int tabIndex) {
        return this.selectedForegroundAt.get(tabIndex);
    }

    public void setBackgroundPainterAt(int tabIndex, Painter painter) {
        this.backgroundPainterAt.put(tabIndex, painter);
    }

    public Painter getBackgroundPainterAt(int tabIndex) {
        return this.backgroundPainterAt.get(tabIndex);
    }

    public TabbedPaneStyle getTabbedPaneStyle() {
        return this.tabbedPaneStyle;
    }

    public void setTabbedPaneStyle(TabbedPaneStyle tabbedPaneStyle) {
        this.tabbedPaneStyle = tabbedPaneStyle;
        PainterSupport.updateBorder(this.painter);
    }

    public int getTabRunIndent() {
        return this.tabRunIndent;
    }

    public void setTabRunIndent(int tabRunIndent) {
        this.tabRunIndent = tabRunIndent;
    }

    public int getTabOverlay() {
        return this.tabOverlay;
    }

    public void setTabOverlay(int tabOverlay) {
        this.tabOverlay = tabOverlay;
    }

    public TabStretchType getTabStretchType() {
        return this.tabStretchType;
    }

    public void setTabStretchType(TabStretchType tabStretchType) {
        this.tabStretchType = tabStretchType;
    }

    public Vector<View> getHtmlViews() {
        return this.htmlViews;
    }

    public WebBasicTabbedPaneUI.ScrollableTabSupport getTabScroller() {
        return this.tabScroller;
    }

    public int[] getTabRuns() {
        return this.tabRuns;
    }

    public Rectangle[] getRects() {
        return this.rects;
    }

    public int getMaxTabHeight() {
        return this.maxTabHeight;
    }

    public int getMaxTabWidth() {
        return this.maxTabWidth;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    protected int getTabRunIndent(int tabPlacement, int run) {
        return this.tabRunIndent;
    }

    @Override
    public int getTabRunOverlay(int tabPlacement) {
        return this.tabOverlay;
    }

    @Override
    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        Insets targetInsets = new Insets(0, 0, 0, 0);
        WebTabbedPaneUI.rotateInsets(this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone) ? new Insets(2, 2, 2, 1) : new Insets(0, 0, 0, 0), targetInsets, tabPlacement);
        return targetInsets;
    }

    @Override
    public Insets getTabAreaInsets(int tabPlacement) {
        Insets targetInsets = new Insets(0, 0, 0, 0);
        WebTabbedPaneUI.rotateInsets(this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone) ? new Insets(tabPlacement == 4 ? 1 : 0, 1, 0, 2) : new Insets(-1, -1, 0, 0), targetInsets, tabPlacement);
        return targetInsets;
    }

    @Override
    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    @Override
    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return !this.tabStretchType.equals((Object)TabStretchType.never) && (this.tabStretchType.equals((Object)TabStretchType.always) || this.tabStretchType.equals((Object)TabStretchType.multiline) && this.runCount > 1);
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            Insets insets = tabPlacement == 1 ? new Insets(1, 2, 1, 2) : (tabPlacement == 3 ? new Insets(2, 2, 0, 2) : (tabPlacement == 2 ? new Insets(2, 1, 2, 1) : (tabPlacement == 4 ? new Insets(2, 2, 2, 0) : new Insets(0, 0, 0, 0))));
            insets.top += this.contentInsets.top - 1;
            insets.left += this.contentInsets.left - 1;
            insets.bottom += this.contentInsets.bottom - 1;
            insets.right += this.contentInsets.right - 1;
            return insets;
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        Insets insets = (Insets)MergeUtils.clone((Object)this.tabInsets);
        if (tabIndex == 0 && this.tabPane.getSelectedIndex() == 0) {
            --insets.left;
            ++insets.right;
        }
        if (this.rotateTabInsets) {
            Insets targetInsets = new Insets(0, 0, 0, 0);
            WebTabbedPaneUI.rotateInsets(insets, targetInsets, tabPlacement);
            return targetInsets;
        }
        return insets;
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }
}

