/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.global.StyleConstants;
import com.alee.laf.tabbedpane.ITabbedPanePainter;
import com.alee.laf.tabbedpane.TabShapeType;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebBasicTabbedPaneUI;
import com.alee.laf.tabbedpane.WebTabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPaneUI;
import com.alee.painter.AbstractPainter;
import com.alee.painter.Painter;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.WebBorder;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class TabbedPanePainter<E extends JTabbedPane, U extends WebTabbedPaneUI>
extends AbstractPainter<E, U>
implements ITabbedPanePainter<E, U> {
    protected int round = WebTabbedPaneStyle.round;
    protected int shadeWidth = WebTabbedPaneStyle.shadeWidth;
    protected Color selectedTopBg = WebTabbedPaneStyle.selectedTopBg;
    protected Color selectedBottomBg = WebTabbedPaneStyle.selectedBottomBg;
    protected Color topBg = WebTabbedPaneStyle.topBg;
    protected Color bottomBg = WebTabbedPaneStyle.bottomBg;
    protected Color tabBorderColor = WebTabbedPaneStyle.tabBorderColor;
    protected Color contentBorderColor = WebTabbedPaneStyle.contentBorderColor;
    protected Color backgroundColor = WebTabbedPaneStyle.backgroundColor;
    protected boolean paintBorderOnlyOnSelectedTab = WebTabbedPaneStyle.paintBorderOnlyOnSelectedTab;
    protected boolean forceUseSelectedTabBgColors = WebTabbedPaneStyle.forceUseSelectedTabBgColors;
    protected boolean paintOnlyTopBorder = WebTabbedPaneStyle.paintOnlyTopBorder;
    protected FocusAdapter focusAdapter;
    protected boolean tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
    protected boolean tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
    protected int textIconGap = UIManager.getInt("TabbedPane.textIconGap");
    protected Vector htmlViews;
    protected int[] tabRuns;
    protected Rectangle[] rects;
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected int runCount;
    protected boolean scrollableTabLayoutEnabled;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        ((JTabbedPane)this.component).setBackground(this.backgroundColor);
        this.focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JTabbedPane)TabbedPanePainter.this.component).repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((JTabbedPane)TabbedPanePainter.this.component).repaint();
            }
        };
        ((JTabbedPane)this.component).addFocusListener(this.focusAdapter);
    }

    @Override
    public void uninstall(E c, U ui) {
        if (this.focusAdapter != null) {
            ((JTabbedPane)this.component).removeFocusListener(this.focusAdapter);
            this.focusAdapter = null;
        }
        super.uninstall(c, ui);
    }

    @Override
    public void updateBorder() {
        if (this.component != null) {
            if (SwingUtils.isPreserveBorders(this.component)) {
                return;
            }
            Insets bgInsets = this.i(0, 0, 0, 0);
            if (((WebTabbedPaneUI)this.ui).getTabbedPaneStyle().equals((Object)TabbedPaneStyle.standalone)) {
                Insets sbi = this.i(this.shadeWidth, this.shadeWidth, this.shadeWidth, this.shadeWidth);
                ((JTabbedPane)this.component).setBorder(new WebBorder(SwingUtils.max(bgInsets, sbi)));
            } else {
                ((JTabbedPane)this.component).setBorder(new WebBorder(bgInsets));
            }
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public Color getSelectedTopBg() {
        return this.selectedTopBg;
    }

    public void setSelectedTopBg(Color selectedTopBg) {
        this.selectedTopBg = selectedTopBg;
    }

    public Color getSelectedBottomBg() {
        return this.selectedBottomBg;
    }

    public void setSelectedBottomBg(Color selectedBottomBg) {
        this.selectedBottomBg = selectedBottomBg;
    }

    public Color getTopBg() {
        return this.topBg;
    }

    public void setTopBg(Color topBg) {
        this.topBg = topBg;
    }

    public Color getBottomBg() {
        return this.bottomBg;
    }

    public void setBottomBg(Color bottomBg) {
        this.bottomBg = bottomBg;
    }

    public Color getTabBorderColor() {
        return this.tabBorderColor;
    }

    public void setTabBorderColor(Color tabBorderColor) {
        this.tabBorderColor = tabBorderColor;
    }

    public Color getContentBorderColor() {
        return this.contentBorderColor;
    }

    public void setContentBorderColor(Color contentBorderColor) {
        this.contentBorderColor = contentBorderColor;
    }

    public boolean isPaintBorderOnlyOnSelectedTab() {
        return this.paintBorderOnlyOnSelectedTab;
    }

    public void setPaintBorderOnlyOnSelectedTab(boolean paintBorderOnlyOnSelectedTab) {
        this.paintBorderOnlyOnSelectedTab = paintBorderOnlyOnSelectedTab;
    }

    public boolean isForceUseSelectedTabBgColors() {
        return this.forceUseSelectedTabBgColors;
    }

    public void setForceUseSelectedTabBgColors(boolean forceUseSelectedTabBgColors) {
        this.forceUseSelectedTabBgColors = forceUseSelectedTabBgColors;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isPaintOnlyTopBorder() {
        return this.paintOnlyTopBorder;
    }

    public void setPaintOnlyTopBorder(boolean paintOnlyTopBorder) {
        this.paintOnlyTopBorder = paintOnlyTopBorder;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        Map hints = SwingUtils.setupTextAntialias(g2d);
        this.runCount = ((JTabbedPane)this.component).getTabRunCount();
        this.htmlViews = ((WebTabbedPaneUI)ui).getHtmlViews();
        this.tabRuns = ((WebTabbedPaneUI)ui).getTabRuns();
        this.rects = ((WebTabbedPaneUI)ui).getRects();
        this.maxTabHeight = ((WebTabbedPaneUI)ui).getMaxTabHeight();
        this.maxTabWidth = ((WebTabbedPaneUI)ui).getMaxTabWidth();
        this.scrollableTabLayoutEnabled = ((JTabbedPane)this.component).getLayout() instanceof WebBasicTabbedPaneUI.TabbedPaneScrollLayout;
        int selectedIndex = ((JTabbedPane)this.component).getSelectedIndex();
        int tabPlacement = ((JTabbedPane)this.component).getTabPlacement();
        this.ensureCurrentLayout();
        if (this.tabsOverlapBorder) {
            this.paintContentBorder(g2d, tabPlacement, selectedIndex);
        }
        if (!this.scrollableTabLayoutEnabled) {
            this.paintTabArea(g2d, tabPlacement, selectedIndex);
        }
        if (!this.tabsOverlapBorder) {
            this.paintContentBorder(g2d, tabPlacement, selectedIndex);
        }
        this.htmlViews = null;
        this.tabRuns = null;
        this.rects = null;
        SwingUtils.restoreTextAntialias(g2d, hints);
    }

    protected void ensureCurrentLayout() {
        if (!((JTabbedPane)this.component).isValid()) {
            ((JTabbedPane)this.component).validate();
        }
        if (!((JTabbedPane)this.component).isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)((JTabbedPane)this.component).getLayout();
            layout.calculateLayoutInfo();
        }
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int tabCount = ((JTabbedPane)this.component).getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        int runCount = ((JTabbedPane)this.component).getTabRunCount();
        for (int i = runCount - 1; i >= 0; --i) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            for (int j = start; j <= end; ++j) {
                if (j == selectedIndex || !this.rects[j].intersects(clipRect)) continue;
                this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
            }
        }
        if (selectedIndex >= 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
        }
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean isSelected;
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = ((JTabbedPane)this.component).getSelectedIndex();
        boolean bl = isSelected = selectedIndex == tabIndex;
        if (this.tabsOpaque || ((JTabbedPane)this.component).isOpaque()) {
            this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        }
        String title = ((JTabbedPane)this.component).getTitleAt(tabIndex);
        Font font = ((JTabbedPane)this.component).getFont();
        FontMetrics metrics = SwingUtils.getFontMetrics(this.component, g, font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        if (((JTabbedPane)this.component).getTabComponentAt(tabIndex) == null) {
            WebBasicTabbedPaneUI.CroppedEdge croppedEdge;
            String clippedTitle = title;
            if (this.scrollableTabLayoutEnabled && (croppedEdge = ((WebTabbedPaneUI)this.ui).getTabScroller().croppedEdge).isParamsSet() && croppedEdge.getTabIndex() == tabIndex && this.isHorizontalTabPlacement()) {
                int availTextWidth = croppedEdge.getCropline() - (textRect.x - tabRect.x) - croppedEdge.getCroppedSideWidth();
                clippedTitle = SwingUtils.clipStringIfNecessary(null, metrics, title, availTextWidth);
            }
            this.paintText(g, tabPlacement, font, metrics, tabIndex, clippedTitle, textRect, isSelected);
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
    }

    protected boolean isHorizontalTabPlacement() {
        return ((JTabbedPane)this.component).getTabPlacement() == 1 || ((JTabbedPane)this.component).getTabPlacement() == 3;
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            ((JTabbedPane)this.component).putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.component, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        ((JTabbedPane)this.component).putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null) {
            icon.paintIcon(this.component, g, iconRect.x, iconRect.y);
        }
    }

    protected View getTextViewForTab(int tabIndex) {
        if (this.htmlViews != null) {
            return (View)this.htmlViews.elementAt(tabIndex);
        }
        return null;
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean drawFocus;
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        GeneralPath borderShape = this.createTabShape(TabShapeType.border, tabPlacement, x, y, w, h, isSelected);
        if (((WebTabbedPaneUI)this.ui).getTabbedPaneStyle().equals((Object)TabbedPaneStyle.standalone)) {
            GeneralPath shadeShape = this.createTabShape(TabShapeType.shade, tabPlacement, x, y, w, h, isSelected);
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)shadeShape, (Color)new Color(210, 210, 210), (int)this.shadeWidth, (Shape)new Rectangle2D.Double(0.0, 0.0, ((JTabbedPane)this.component).getWidth(), y + h), (this.round > 0 ? 1 : 0) != 0);
        }
        GeneralPath bgShape = this.createTabShape(TabShapeType.background, tabPlacement, x, y, w, h, isSelected);
        Painter backgroundPainterAt = ((WebTabbedPaneUI)this.ui).getBackgroundPainterAt(tabIndex);
        if (backgroundPainterAt != null && isSelected) {
            Shape old = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)bgShape);
            backgroundPainterAt.paint(g2d, new Rectangle(x, y, w, h), this.component, this.ui);
            GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)old);
        } else {
            Point topPoint = this.getTopTabBgPoint(tabPlacement, x, y, w, h);
            Point bottomPoint = this.getBottomTabBgPoint(tabPlacement, x, y, w, h);
            if (isSelected) {
                if (this.forceUseSelectedTabBgColors) {
                    g2d.setPaint(new GradientPaint(topPoint.x, topPoint.y, this.selectedTopBg, bottomPoint.x, bottomPoint.y, this.selectedBottomBg));
                } else {
                    Color bg = ((JTabbedPane)this.component).getBackgroundAt(tabIndex);
                    bg = bg != null ? bg : ((JTabbedPane)this.component).getBackground();
                    g2d.setPaint(new GradientPaint(topPoint.x, topPoint.y, this.selectedTopBg, bottomPoint.x, bottomPoint.y, bg));
                }
            } else {
                g2d.setPaint(new GradientPaint(topPoint.x, topPoint.y, this.topBg, bottomPoint.x, bottomPoint.y, this.bottomBg));
            }
            g2d.fill(isSelected ? borderShape : bgShape);
        }
        g2d.setPaint(this.tabBorderColor);
        g2d.draw(borderShape);
        boolean bl = drawFocus = isSelected && ((JTabbedPane)this.component).isFocusOwner();
        if (((WebTabbedPaneUI)this.ui).getTabbedPaneStyle().equals((Object)TabbedPaneStyle.standalone)) {
            LafUtils.drawCustomWebFocus(g2d, null, StyleConstants.focusType, borderShape, null, drawFocus);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected Icon getIconForTab(int tabIndex) {
        return !((JTabbedPane)this.component).isEnabled() || !((JTabbedPane)this.component).isEnabledAt(tabIndex) ? ((JTabbedPane)this.component).getDisabledIconAt(tabIndex) : ((JTabbedPane)this.component).getIconAt(tabIndex);
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = ((JTabbedPane)this.component).getDisplayedMnemonicIndexAt(tabIndex);
            if (((JTabbedPane)this.component).isEnabled() && ((JTabbedPane)this.component).isEnabledAt(tabIndex)) {
                Color fg = ((JTabbedPane)this.component).getForegroundAt(tabIndex);
                if (isSelected && fg instanceof UIResource) {
                    Color selectedForegroundAt = ((WebTabbedPaneUI)this.ui).getSelectedForegroundAt(tabIndex);
                    if (selectedForegroundAt != null) {
                        fg = selectedForegroundAt;
                    } else {
                        Color selectedFG = UIManager.getColor("TabbedPane.selectedForeground");
                        if (selectedFG != null) {
                            fg = selectedFG;
                        }
                    }
                }
                g.setColor(fg);
                SwingUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(((JTabbedPane)this.component).getBackgroundAt(tabIndex).brighter());
                SwingUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(((JTabbedPane)this.component).getBackgroundAt(tabIndex).darker());
                SwingUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    protected GeneralPath createTabShape(TabShapeType tabShapeType, int tabPlacement, int x, int y, int w, int h, boolean isSelected) {
        Insets insets = ((JTabbedPane)this.component).getInsets();
        if (((WebTabbedPaneUI)this.ui).getTabbedPaneStyle().equals((Object)TabbedPaneStyle.attached) && isSelected && tabPlacement == 1 && x == insets.left) {
            --x;
            ++w;
        }
        int actualRound = ((WebTabbedPaneUI)this.ui).getTabbedPaneStyle().equals((Object)TabbedPaneStyle.standalone) ? this.round : 0;
        GeneralPath bgShape = new GeneralPath(0);
        if (!isSelected && this.paintBorderOnlyOnSelectedTab) {
            return bgShape;
        }
        if (tabPlacement == 1) {
            bgShape.moveTo(x, y + h + this.getChange(tabShapeType));
            bgShape.lineTo(x, y + actualRound);
            bgShape.quadTo(x, y, x + actualRound, y);
            bgShape.lineTo(x + w - actualRound, y);
            bgShape.quadTo(x + w, y, x + w, y + actualRound);
            bgShape.lineTo(x + w, y + h + this.getChange(tabShapeType));
        } else if (tabPlacement == 3) {
            bgShape.moveTo(x, y - this.getChange(tabShapeType));
            bgShape.lineTo(x, y + h - actualRound);
            bgShape.quadTo(x, y + h, x + actualRound, y + h);
            bgShape.lineTo(x + w - actualRound, y + h);
            bgShape.quadTo(x + w, y + h, x + w, y + h - actualRound);
            bgShape.lineTo(x + w, y - this.getChange(tabShapeType));
        } else if (tabPlacement == 2) {
            bgShape.moveTo(x + w + this.getChange(tabShapeType), y);
            bgShape.lineTo(x + actualRound, y);
            bgShape.quadTo(x, y, x, y + actualRound);
            bgShape.lineTo(x, y + h - actualRound);
            bgShape.quadTo(x, y + h, x + actualRound, y + h);
            bgShape.lineTo(x + w + this.getChange(tabShapeType), y + h);
        } else {
            bgShape.moveTo(x - this.getChange(tabShapeType), y);
            bgShape.lineTo(x + w - actualRound, y);
            bgShape.quadTo(x + w, y, x + w, y + actualRound);
            bgShape.lineTo(x + w, y + h - actualRound);
            bgShape.quadTo(x + w, y + h, x + w - actualRound, y + h);
            bgShape.lineTo(x - this.getChange(tabShapeType), y + h);
        }
        return bgShape;
    }

    protected int getChange(TabShapeType tabShapeType) {
        if (tabShapeType.equals((Object)TabShapeType.shade)) {
            return -(this.round > 0 ? this.round : 1);
        }
        if (tabShapeType.equals((Object)TabShapeType.border)) {
            return -1;
        }
        if (tabShapeType.equals((Object)TabShapeType.backgroundPainter)) {
            return 2;
        }
        return 0;
    }

    protected Point getTopTabBgPoint(int tabPlacement, int x, int y, int w, int h) {
        if (tabPlacement == 1) {
            return this.p(x, y);
        }
        if (tabPlacement == 3) {
            return this.p(x, y + h);
        }
        if (tabPlacement == 2) {
            return this.p(x, y);
        }
        return this.p(x + w, y);
    }

    protected Point getBottomTabBgPoint(int tabPlacement, int x, int y, int w, int h) {
        if (tabPlacement == 1) {
            return this.p(x, y + h - 4);
        }
        if (tabPlacement == 3) {
            return this.p(x, y + 4);
        }
        if (tabPlacement == 2) {
            return this.p(x + w - 4, y);
        }
        return this.p(x + 4, y);
    }

    protected void paintContentBorder(Graphics2D g2d, int tabPlacement, int selectedIndex) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        int tabAreaSize = this.getTabAreaLength(tabPlacement);
        Insets bi = ((JTabbedPane)this.component).getInsets();
        bi = tabPlacement == 1 || tabPlacement == 3 ? this.i(bi.top, bi.left, bi.bottom, bi.right + 1) : this.i(bi.top, bi.left, bi.bottom + 1, bi.right);
        Rectangle selected = selectedIndex != -1 ? ((WebTabbedPaneUI)this.ui).getTabBounds((JTabbedPane)this.component, selectedIndex) : null;
        Shape bs = this.createBackgroundShape(tabPlacement, tabAreaSize, bi, selected);
        if (((WebTabbedPaneUI)this.ui).getTabbedPaneStyle().equals((Object)TabbedPaneStyle.standalone)) {
            GeneralPath clip = new GeneralPath(0);
            clip.append(new Rectangle2D.Double(0.0, 0.0, ((JTabbedPane)this.component).getWidth(), ((JTabbedPane)this.component).getHeight()), false);
            clip.append(bs, false);
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)bs, (Color)new Color(210, 210, 210), (int)this.shadeWidth, (Shape)clip, (this.round > 0 ? 1 : 0) != 0);
            Painter backgroundPainterAt = ((WebTabbedPaneUI)this.ui).getBackgroundPainterAt(selectedIndex);
            if (backgroundPainterAt != null) {
                Shape old = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)bs);
                backgroundPainterAt.paint(g2d, bs.getBounds(), this.component, this.ui);
                GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)old);
            } else {
                Color bg = selectedIndex != -1 ? ((JTabbedPane)this.component).getBackgroundAt(selectedIndex) : null;
                g2d.setPaint(bg != null ? bg : ((JTabbedPane)this.component).getBackground());
                g2d.fill(bs);
            }
            g2d.setPaint(this.contentBorderColor);
            g2d.draw(bs);
            LafUtils.drawCustomWebFocus(g2d, null, StyleConstants.focusType, bs, null, ((JTabbedPane)this.component).isFocusOwner());
        } else {
            Painter backgroundPainterAt = ((WebTabbedPaneUI)this.ui).getBackgroundPainterAt(selectedIndex);
            if (backgroundPainterAt != null) {
                backgroundPainterAt.paint(g2d, bs.getBounds(), this.component, this.ui);
            } else {
                Color bg = selectedIndex != -1 ? ((JTabbedPane)this.component).getBackgroundAt(selectedIndex) : null;
                g2d.setPaint(bg != null ? bg : ((JTabbedPane)this.component).getBackground());
                g2d.fill(bs);
            }
            g2d.setPaint(this.contentBorderColor);
            if (tabPlacement == 1) {
                if (selected != null) {
                    if (bi.left < selected.x) {
                        g2d.drawLine(bi.left, bi.top + tabAreaSize, selected.x, bi.top + tabAreaSize);
                    }
                    if (selected.x + selected.width < ((JTabbedPane)this.component).getWidth() - bi.right) {
                        g2d.drawLine(selected.x + selected.width, bi.top + tabAreaSize, ((JTabbedPane)this.component).getWidth() - bi.right, bi.top + tabAreaSize);
                    }
                } else {
                    g2d.drawLine(bi.left, bi.top + tabAreaSize, ((JTabbedPane)this.component).getWidth() - bi.right, bi.top + tabAreaSize);
                }
            }
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected int getTabAreaLength(int tabPlacement) {
        return tabPlacement == 1 || tabPlacement == 3 ? this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - 1 : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - 1;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets tabAreaInsets = ((WebTabbedPaneUI)this.ui).getTabAreaInsets(tabPlacement);
        int tabRunOverlay = ((WebTabbedPaneUI)this.ui).getTabRunOverlay(tabPlacement);
        return horizRunCount > 0 ? horizRunCount * (maxTabHeight - tabRunOverlay) + tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        Insets tabAreaInsets = ((WebTabbedPaneUI)this.ui).getTabAreaInsets(tabPlacement);
        int tabRunOverlay = ((WebTabbedPaneUI)this.ui).getTabRunOverlay(tabPlacement);
        return vertRunCount > 0 ? vertRunCount * (maxTabWidth - tabRunOverlay) + tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right : 0;
    }

    protected Shape createBackgroundShape(int tabPlacement, int tabAreaSize, Insets bi, Rectangle selected) {
        if (((WebTabbedPaneUI)this.ui).getTabbedPaneStyle().equals((Object)TabbedPaneStyle.standalone)) {
            if (selected != null) {
                GeneralPath gp = new GeneralPath(0);
                if (tabPlacement == 1) {
                    int topY = bi.top + tabAreaSize;
                    gp.moveTo(selected.x, topY);
                    if (selected.x > bi.left + this.round && this.round > 0) {
                        gp.lineTo(bi.left + this.round, topY);
                        gp.quadTo(bi.left, topY, bi.left, topY + this.round);
                    } else {
                        gp.lineTo(bi.left, topY);
                    }
                    if (this.round > 0) {
                        gp.lineTo(bi.left, ((JTabbedPane)this.component).getHeight() - bi.bottom - this.round);
                        gp.quadTo(bi.left, ((JTabbedPane)this.component).getHeight() - bi.bottom, bi.left + this.round, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right - this.round, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                        gp.quadTo(((JTabbedPane)this.component).getWidth() - bi.right, ((JTabbedPane)this.component).getHeight() - bi.bottom, ((JTabbedPane)this.component).getWidth() - bi.right, ((JTabbedPane)this.component).getHeight() - bi.bottom - this.round);
                    } else if (this.paintOnlyTopBorder) {
                        gp.moveTo(((JTabbedPane)this.component).getWidth() - bi.right, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                    } else {
                        gp.lineTo(bi.left, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                    }
                    if (selected.x + selected.width < ((JTabbedPane)this.component).getWidth() - bi.right - this.round && this.round > 0) {
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right, topY + this.round);
                        gp.quadTo(((JTabbedPane)this.component).getWidth() - bi.right, topY, ((JTabbedPane)this.component).getWidth() - bi.right - this.round, topY);
                    } else if (this.paintOnlyTopBorder) {
                        gp.moveTo(((JTabbedPane)this.component).getWidth() - bi.right, topY);
                    } else {
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right, topY);
                    }
                    gp.lineTo(selected.x + selected.width, topY);
                } else if (tabPlacement == 3) {
                    int bottomY = ((JTabbedPane)this.component).getHeight() - bi.bottom - tabAreaSize;
                    gp.moveTo(selected.x, bottomY);
                    if (selected.x > bi.left + this.round && this.round > 0) {
                        gp.lineTo(bi.left + this.round, bottomY);
                        gp.quadTo(bi.left, bottomY, bi.left, bottomY - this.round);
                    } else {
                        gp.lineTo(bi.left, bottomY);
                    }
                    if (this.round > 0) {
                        gp.lineTo(bi.left, bi.top + this.round);
                        gp.quadTo(bi.left, bi.top, bi.left + this.round, bi.top);
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right - this.round, bi.top);
                        gp.quadTo(((JTabbedPane)this.component).getWidth() - bi.right, bi.top, ((JTabbedPane)this.component).getWidth() - bi.right, bi.top + this.round);
                    } else {
                        gp.lineTo(bi.left, bi.top);
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right, bi.top);
                    }
                    if (selected.x + selected.width < ((JTabbedPane)this.component).getWidth() - bi.right - this.round && this.round > 0) {
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right, bottomY - this.round);
                        gp.quadTo(((JTabbedPane)this.component).getWidth() - bi.right, bottomY, ((JTabbedPane)this.component).getWidth() - bi.right - this.round, bottomY);
                    } else {
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right, bottomY);
                    }
                    gp.lineTo(selected.x + selected.width, bottomY);
                } else if (tabPlacement == 2) {
                    int leftX = bi.left + tabAreaSize;
                    gp.moveTo(leftX, selected.y);
                    if (selected.y > bi.top + this.round && this.round > 0) {
                        gp.lineTo(leftX, bi.top + this.round);
                        gp.quadTo(leftX, bi.top, leftX + this.round, bi.top);
                    } else {
                        gp.lineTo(leftX, bi.top);
                    }
                    if (this.round > 0) {
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right - this.round, bi.top);
                        gp.quadTo(((JTabbedPane)this.component).getWidth() - bi.right, bi.top, ((JTabbedPane)this.component).getWidth() - bi.right, bi.top + this.round);
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right, ((JTabbedPane)this.component).getHeight() - bi.bottom - this.round);
                        gp.quadTo(((JTabbedPane)this.component).getWidth() - bi.right, ((JTabbedPane)this.component).getHeight() - bi.bottom, ((JTabbedPane)this.component).getWidth() - bi.right - this.round, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                    } else {
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right, bi.top);
                        gp.lineTo(((JTabbedPane)this.component).getWidth() - bi.right, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                    }
                    if (selected.y + selected.height < ((JTabbedPane)this.component).getHeight() - bi.bottom - this.round && this.round > 0) {
                        gp.lineTo(leftX + this.round, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                        gp.quadTo(leftX, ((JTabbedPane)this.component).getHeight() - bi.bottom, leftX, ((JTabbedPane)this.component).getHeight() - bi.bottom - this.round);
                    } else {
                        gp.lineTo(leftX, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                    }
                    gp.lineTo(leftX, selected.y + selected.height);
                } else {
                    int rightX = ((JTabbedPane)this.component).getWidth() - bi.right - tabAreaSize;
                    gp.moveTo(rightX, selected.y);
                    if (selected.y > bi.top + this.round && this.round > 0) {
                        gp.lineTo(rightX, bi.top + this.round);
                        gp.quadTo(rightX, bi.top, rightX - this.round, bi.top);
                    } else {
                        gp.lineTo(rightX, bi.top);
                    }
                    if (this.round > 0) {
                        gp.lineTo(bi.left + this.round, bi.top);
                        gp.quadTo(bi.left, bi.top, bi.left, bi.top + this.round);
                        gp.lineTo(bi.left, ((JTabbedPane)this.component).getHeight() - bi.bottom - this.round);
                        gp.quadTo(bi.left, ((JTabbedPane)this.component).getHeight() - bi.bottom, bi.left + this.round, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                    } else {
                        gp.lineTo(bi.left, bi.top);
                        gp.lineTo(bi.left, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                    }
                    if (selected.y + selected.height < ((JTabbedPane)this.component).getHeight() - bi.bottom - this.round && this.round > 0) {
                        gp.lineTo(rightX - this.round, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                        gp.quadTo(rightX, ((JTabbedPane)this.component).getHeight() - bi.bottom, rightX, ((JTabbedPane)this.component).getHeight() - bi.bottom - this.round);
                    } else {
                        gp.lineTo(rightX, ((JTabbedPane)this.component).getHeight() - bi.bottom);
                    }
                    gp.lineTo(rightX, selected.y + selected.height);
                }
                return gp;
            }
            boolean top = tabPlacement == 1;
            boolean bottom = tabPlacement == 3;
            boolean left = tabPlacement == 2;
            boolean right = tabPlacement == 4;
            return new RoundRectangle2D.Double(bi.left + (left ? tabAreaSize : 0), bi.top + (top ? tabAreaSize : 0), ((JTabbedPane)this.component).getWidth() - bi.left - bi.right - (left || right ? tabAreaSize : 0), ((JTabbedPane)this.component).getHeight() - bi.top - bi.bottom - (top || bottom ? tabAreaSize : 0), this.round * 2, this.round * 2);
        }
        int x = bi.left + (tabPlacement == 2 ? tabAreaSize : 0);
        int y = bi.top + (tabPlacement == 1 ? tabAreaSize : 0);
        int width = ((JTabbedPane)this.component).getWidth() - bi.left - bi.right - (tabPlacement == 2 || tabPlacement == 4 ? tabAreaSize : 0);
        int height = ((JTabbedPane)this.component).getHeight() - bi.top - bi.bottom - (tabPlacement == 1 || tabPlacement == 3 ? tabAreaSize : 0);
        return new Rectangle(x, y, width + 1, height);
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        if (((WebTabbedPaneUI)this.ui).getTabbedPaneStyle().equals((Object)TabbedPaneStyle.standalone)) {
            Rectangle tabRect = this.rects[tabIndex];
            switch (tabPlacement) {
                case 2: {
                    return isSelected ? -1 : 1;
                }
                case 4: {
                    return isSelected ? 1 : -1;
                }
            }
            return tabRect.width % 2;
        }
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        if (((WebTabbedPaneUI)this.ui).getTabbedPaneStyle().equals((Object)TabbedPaneStyle.standalone)) {
            Rectangle tabRect = this.rects[tabIndex];
            switch (tabPlacement) {
                case 3: {
                    return isSelected ? 1 : -1;
                }
                case 2: 
                case 4: {
                    return tabRect.height % 2;
                }
            }
            return isSelected ? -1 : 1;
        }
        return 0;
    }
}

