/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.slider;

import com.alee.laf.slider.AdaptiveSliderPainter;
import com.alee.laf.slider.ISliderPainter;
import com.alee.laf.slider.SliderPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class WebSliderUI
extends BasicSliderUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=SliderPainter.class)
    protected ISliderPainter painter;
    protected Insets margin = null;
    protected Insets padding = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebSliderUI((JSlider)c);
    }

    public WebSliderUI(JSlider b) {
        super(b);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.slider);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.slider);
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.slider);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.slider, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.slider, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.slider, new DataRunnable<ISliderPainter>(){

            public void run(ISliderPainter newPainter) {
                WebSliderUI.this.painter = newPainter;
            }
        }, this.painter, painter, ISliderPainter.class, AdaptiveSliderPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.setDragging(this.isDragging());
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

