/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class WebScrollPaneCorner
extends JComponent {
    protected Color borderColor;
    private final String corner;

    public WebScrollPaneCorner(String corner) {
        this.corner = corner;
        SwingUtils.setOrientation(this);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        Color backgroundColor = this.getBackground();
        if (this.corner.equals("LOWER_LEADING_CORNER")) {
            int vBorder = ltr ? this.getWidth() - 1 : 0;
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.borderColor);
            g.drawLine(0, 0, this.getWidth() - 1, 0);
            g.drawLine(vBorder, 0, vBorder, this.getHeight() - 1);
        } else if (this.corner.equals("LOWER_TRAILING_CORNER")) {
            int vBorder = ltr ? 0 : this.getWidth() - 1;
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.borderColor);
            g.drawLine(0, 0, this.getWidth() - 1, 0);
            g.drawLine(vBorder, 0, vBorder, this.getHeight() - 1);
        } else if (this.corner.equals("UPPER_TRAILING_CORNER")) {
            int vBorder = ltr ? 0 : this.getWidth() - 1;
            g.setColor(backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.borderColor);
            g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            g.drawLine(vBorder, 0, vBorder, this.getHeight() - 1);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }
}

