/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.combobox.WebComboBoxUI;
import com.alee.laf.menu.AbstractPopupPainter;
import com.alee.laf.menu.IPopupMenuPainter;
import com.alee.laf.menu.PopupMenuType;
import com.alee.laf.menu.PopupMenuWay;
import com.alee.laf.menu.PopupStyle;
import com.alee.laf.menu.WebPopupMenuUI;
import com.alee.utils.CompareUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.Popup;

public class PopupMenuPainter<E extends JPopupMenu, U extends WebPopupMenuUI>
extends AbstractPopupPainter<E, U>
implements IPopupMenuPainter<E, U> {
    protected int menuSpacing = 1;
    protected boolean fixLocation = true;
    protected boolean dropdownStyleForMenuBar = true;
    protected PopupMenuType popupMenuType = null;

    @Override
    protected void propertyChange(String property, Object oldValue, Object newValue) {
        super.propertyChange(property, oldValue, newValue);
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"visible"})) {
            if (newValue == Boolean.TRUE) {
                Component invoker = ((JPopupMenu)this.component).getInvoker();
                if (invoker != null) {
                    if (invoker instanceof JMenu) {
                        if (invoker.getParent() instanceof JPopupMenu) {
                            this.setPopupMenuType(PopupMenuType.menuBarSubMenu);
                        } else {
                            this.setPopupMenuType(PopupMenuType.menuBarMenu);
                        }
                    } else if (invoker instanceof JComboBox) {
                        this.setPopupMenuType(PopupMenuType.comboBoxMenu);
                    } else {
                        this.setPopupMenuType(PopupMenuType.customPopupMenu);
                    }
                } else {
                    this.setPopupMenuType(PopupMenuType.customPopupMenu);
                }
            }
            if (newValue == Boolean.TRUE) {
                if (!SystemUtils.isUnix()) {
                    this.installPopupSettings(SwingUtils.getWindowAncestor((Component)this.component), (JPopupMenu)this.component);
                }
            } else {
                this.uninstallPopupSettings(SwingUtils.getWindowAncestor((Component)this.component), (JPopupMenu)this.component);
            }
        }
    }

    @Override
    protected void orientationChange() {
        super.orientationChange();
        if (((JPopupMenu)this.component).isShowing()) {
            ((JPopupMenu)this.component).setVisible(false);
        }
    }

    public int getMenuSpacing() {
        return this.menuSpacing;
    }

    public void setMenuSpacing(int spacing) {
        this.menuSpacing = spacing;
    }

    public boolean isFixLocation() {
        return this.fixLocation;
    }

    public void setFixLocation(boolean fix) {
        this.fixLocation = fix;
    }

    public void setPopupMenuType(PopupMenuType type) {
        this.popupMenuType = type;
        if (this.popupMenuType == PopupMenuType.menuBarSubMenu) {
            this.setPopupStyle(PopupStyle.simple);
        }
    }

    @Override
    public Insets getBorders() {
        Insets margin = super.getBorders();
        margin.top += this.round;
        margin.bottom += this.round;
        return margin;
    }

    @Override
    protected void paintTransparentPopup(Graphics2D g2d, E popupMenu) {
        Dimension menuSize = ((Component)popupMenu).getSize();
        this.paintShade(g2d, popupMenu, menuSize);
        this.paintBackground(g2d, popupMenu, menuSize);
        this.paintDropdownCornerFill(g2d, popupMenu, menuSize);
        this.paintBorder(g2d, popupMenu, menuSize);
    }

    protected void paintDropdownCornerFill(Graphics2D g2d, E popupMenu, Dimension menuSize) {
        if (this.popupStyle == PopupStyle.dropdown && this.round == 0) {
            boolean stick;
            boolean top;
            boolean bl = top = this.cornerSide == 1;
            boolean bl2 = top ? this.getBorders().top == 0 : (stick = this.getBorders().bottom == 0);
            if (stick) {
                // empty if block
            }
        }
    }

    protected WebComboBoxUI geComboBoxUI(E popupMenu) {
        JComboBox comboBox = (JComboBox)ReflectUtils.getFieldValueSafely(popupMenu, (String)"comboBox");
        return comboBox != null && comboBox.getUI() instanceof WebComboBoxUI ? (WebComboBoxUI)comboBox.getUI() : null;
    }

    @Override
    public Point preparePopupMenu(E popupMenu, Component invoker, int x, int y) {
        if (invoker != null) {
            this.relativeCorner = this.ltr ? 0 : Integer.MAX_VALUE;
            boolean showing = invoker.isShowing();
            Point los = showing ? invoker.getLocationOnScreen() : new Point(0, 0);
            boolean fixLocation = this.fixLocation && showing;
            int sideWidth = this.getSideWidth();
            if (invoker instanceof JMenu) {
                if (invoker.getParent() instanceof JPopupMenu) {
                    this.setPopupStyle(PopupStyle.simple);
                    if (fixLocation) {
                        x += (los.x <= x ? -1 : 1) * (this.shaped ? sideWidth - this.menuSpacing : -this.menuSpacing);
                        y += (los.y <= y ? -1 : 1) * (this.shaped ? sideWidth + 1 + this.round : this.round);
                    }
                } else if (!this.dropdownStyleForMenuBar) {
                    this.setPopupStyle(PopupStyle.simple);
                    if (fixLocation) {
                        x += (los.x <= x ? -1 : 1) * (this.shaped ? sideWidth - this.menuSpacing : -this.menuSpacing);
                        y -= this.shaped ? sideWidth + this.round + 1 : this.round;
                    }
                } else {
                    this.setPopupStyle(PopupStyle.dropdown);
                    int n = this.cornerSide = los.y <= y ? 1 : 3;
                    if (fixLocation) {
                        x += (los.x <= x ? -1 : 1) * (this.shaped ? sideWidth : 0);
                        y += (los.y <= y ? -1 : 1) * (this.shaped ? sideWidth - this.cornerWidth : 0);
                    }
                    this.relativeCorner = los.x + invoker.getWidth() / 2 - x;
                }
            } else {
                PopupMenuWay popupMenuWay;
                boolean dropdown;
                boolean bl = dropdown = this.popupStyle == PopupStyle.dropdown;
                if (invoker instanceof JComboBox && ((Component)popupMenu).getName().equals("ComboPopup.popup")) {
                    int n = this.cornerSide = los.y <= y ? 1 : 3;
                    if (fixLocation) {
                        x += this.shaped ? -sideWidth : 0;
                        if (this.cornerSide == 1) {
                            y -= this.shaped ? sideWidth - (dropdown ? this.cornerWidth : 0) : 0;
                        } else {
                            int ih = invoker.getPreferredSize().height;
                            y -= ih + (this.shaped ? sideWidth - (dropdown ? this.cornerWidth : 0) : 0);
                        }
                    }
                    this.relativeCorner = los.x + invoker.getWidth() / 2 - x;
                } else if (fixLocation && (popupMenuWay = ((WebPopupMenuUI)this.ui).getPopupMenuWay()) != null) {
                    Dimension ps = ((JComponent)popupMenu).getPreferredSize();
                    Dimension is = invoker.getSize();
                    int cornerShear = dropdown ? sideWidth - this.cornerWidth : 0;
                    switch (popupMenuWay) {
                        case aboveStart: {
                            x = (this.ltr ? los.x : los.x + is.width - ps.width) + (this.shaped ? (this.ltr ? -sideWidth : sideWidth) : 0);
                            y = los.y - ps.height + cornerShear;
                            this.relativeCorner = this.ltr ? 0 : Integer.MAX_VALUE;
                            break;
                        }
                        case aboveMiddle: {
                            x = los.x + is.width / 2 - ps.width / 2;
                            y = los.y - ps.height + cornerShear;
                            this.relativeCorner = los.x + invoker.getWidth() / 2 - x;
                            break;
                        }
                        case aboveEnd: {
                            x = (this.ltr ? los.x + is.width - ps.width : los.x) + (this.shaped ? (this.ltr ? sideWidth : -sideWidth) : 0);
                            y = los.y - ps.height + cornerShear;
                            this.relativeCorner = this.ltr ? Integer.MAX_VALUE : 0;
                            break;
                        }
                        case belowStart: {
                            x = (this.ltr ? los.x : los.x + is.width - ps.width) + (this.shaped ? (this.ltr ? -sideWidth : sideWidth) : 0);
                            y = los.y + is.height - cornerShear;
                            this.relativeCorner = this.ltr ? 0 : Integer.MAX_VALUE;
                            break;
                        }
                        case belowMiddle: {
                            x = los.x + is.width / 2 - ps.width / 2;
                            y = los.y + is.height - cornerShear;
                            this.relativeCorner = los.x + invoker.getWidth() / 2 - x;
                            break;
                        }
                        case belowEnd: {
                            x = (this.ltr ? los.x + is.width - ps.width : los.x) + (this.shaped ? (this.ltr ? sideWidth : -sideWidth) : 0);
                            y = los.y + is.height - cornerShear;
                            this.relativeCorner = this.ltr ? Integer.MAX_VALUE : 0;
                        }
                    }
                    this.cornerSide = popupMenuWay.getCornerSide();
                }
            }
        } else {
            this.relativeCorner = 0;
        }
        return this.p(x, y);
    }

    @Override
    public void configurePopup(E popupMenu, Component invoker, int x, int y, Popup popup) {
        Component window = (Component)ReflectUtils.callMethodSafely((Object)popup, (String)"getComponent", (Object[])new Object[0]);
        if (window instanceof Window) {
            this.installPopupSettings((Window)window, popupMenu);
        }
    }

    protected void installPopupSettings(Window window, E popupMenu) {
        if (window != null && this.shaped && SwingUtils.isHeavyWeightWindow(window)) {
            if (window instanceof JWindow && SystemUtils.isMac()) {
                ((JWindow)window).getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
            }
            if (SwingUtils.isHeavyWeightWindow(window)) {
                if (ProprietaryUtils.isWindowTransparencyAllowed()) {
                    ProprietaryUtils.setWindowOpaque(window, false);
                } else if (ProprietaryUtils.isWindowShapeAllowed()) {
                    window.pack();
                    Rectangle bounds = window.getBounds();
                    ++bounds.width;
                    ++bounds.height;
                    Shape shape = this.provideShape(popupMenu, bounds);
                    ProprietaryUtils.setWindowShape(window, shape);
                }
            }
        }
    }

    protected void uninstallPopupSettings(Window window, E popupMenu) {
        if (window != null && this.shaped && SwingUtils.isHeavyWeightWindow(window)) {
            ProprietaryUtils.setWindowOpaque(window, true);
            ProprietaryUtils.setWindowShape(window, null);
        }
    }
}

