/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.laf.list.IListItemPainter;
import com.alee.laf.list.IListPainter;
import com.alee.laf.list.ListItemPainter;
import com.alee.laf.list.ListSelectionStyle;
import com.alee.laf.list.WebListUI;
import com.alee.painter.DefaultPainter;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.GeometryUtils;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListPainter<E extends JList, U extends WebListUI, D extends IDecoration<E, D>>
extends AbstractDecorationPainter<E, U, D>
implements IListPainter<E, U> {
    @DefaultPainter(value=ListItemPainter.class)
    protected IListItemPainter hoverPainter;
    @DefaultPainter(value=ListItemPainter.class)
    protected IListItemPainter selectionPainter;
    protected ListSelectionListener listSelectionListener;
    protected Integer layoutOrientation;
    protected CellRendererPane rendererPane;
    protected Integer listHeight = -1;
    protected Integer listWidth = -1;
    protected Integer columnCount;
    protected Integer preferredHeight;
    protected Integer rowsPerColumn;
    protected int cellWidth = -1;
    protected int cellHeight = -1;
    protected int[] cellHeights = null;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.hoverPainter = PainterSupport.installSectionPainter(this, this.hoverPainter, null, c, ui);
        this.selectionPainter = PainterSupport.installSectionPainter(this, this.selectionPainter, null, c, ui);
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListPainter.this.repaintSelection();
            }
        };
        ((JList)this.component).addListSelectionListener(this.listSelectionListener);
    }

    @Override
    public void uninstall(E c, U ui) {
        ((JList)this.component).removeListSelectionListener(this.listSelectionListener);
        this.listSelectionListener = null;
        this.cellHeights = null;
        this.selectionPainter = PainterSupport.uninstallSectionPainter(this.selectionPainter, c, ui);
        this.hoverPainter = PainterSupport.uninstallSectionPainter(this.hoverPainter, c, ui);
        super.uninstall(c, ui);
    }

    @Override
    public void prepareToPaint(Integer layoutOrientation, Integer listHeight, Integer listWidth, Integer columnCount, Integer rowsPerColumn, Integer preferredHeight, int cellWidth, int cellHeight, int[] cellHeights) {
        this.layoutOrientation = layoutOrientation;
        this.listHeight = listHeight;
        this.listWidth = listWidth;
        this.columnCount = columnCount;
        this.rowsPerColumn = rowsPerColumn;
        this.preferredHeight = preferredHeight;
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.cellHeights = cellHeights;
    }

    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        this.paintHoverCellBackground(g2d);
        this.paintSelectedCellsBackground(g2d);
        this.paintList(g2d);
        this.paintDropLocation(g2d);
    }

    protected void paintList(Graphics2D g2d) {
        Shape clip = g2d.getClip();
        this.layoutOrientation = ((JList)this.component).getLayoutOrientation();
        this.rendererPane = ((WebListUI)this.ui).getCellRendererPane();
        ListCellRenderer renderer = ((JList)this.component).getCellRenderer();
        ListModel dataModel = ((JList)this.component).getModel();
        int size = dataModel.getSize();
        if (renderer != null && size > 0) {
            int endColumn;
            int startColumn;
            Rectangle paintBounds = g2d.getClipBounds();
            if (this.ltr) {
                startColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
                endColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
            } else {
                startColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
                endColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
            }
            int maxY = paintBounds.y + paintBounds.height;
            int leadIndex = this.adjustIndex(((JList)this.component).getLeadSelectionIndex(), (JList)this.component);
            int rowIncrement = this.layoutOrientation == 2 ? this.columnCount : 1;
            ListSelectionModel selModel = ((JList)this.component).getSelectionModel();
            for (int colCounter = startColumn; colCounter <= endColumn; ++colCounter) {
                int row;
                int rowCount = this.getRowCount(colCounter);
                int index = this.getModelIndex(colCounter, row);
                Rectangle rowBounds = ((WebListUI)this.ui).getCellBounds((JList)this.component, index, index);
                if (rowBounds == null) {
                    return;
                }
                for (row = this.convertLocationToRowInColumn(paintBounds.y, colCounter); row < rowCount && rowBounds.y < maxY && index < size; index += rowIncrement, ++row) {
                    rowBounds.height = this.getHeight(colCounter, row);
                    g2d.setClip(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
                    g2d.clipRect(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                    this.paintCell(g2d, index, rowBounds, renderer, dataModel, selModel, leadIndex);
                    rowBounds.y += rowBounds.height;
                }
            }
        }
        this.rendererPane.removeAll();
        this.rendererPane = null;
        g2d.setClip(clip);
    }

    protected int getHeight(int column, int row) {
        if (column < 0 || column > this.columnCount || row < 0) {
            return -1;
        }
        if (this.layoutOrientation != 0) {
            return this.cellHeight;
        }
        if (row >= ((JList)this.component).getModel().getSize()) {
            return -1;
        }
        return this.cellHeights == null ? this.cellHeight : (row < this.cellHeights.length ? this.cellHeights[row] : -1);
    }

    protected int getModelIndex(int column, int row) {
        switch (this.layoutOrientation) {
            case 1: {
                return Math.min(((JList)this.component).getModel().getSize() - 1, this.rowsPerColumn * column + Math.min(row, this.rowsPerColumn - 1));
            }
            case 2: {
                return Math.min(((JList)this.component).getModel().getSize() - 1, row * this.columnCount + column);
            }
        }
        return row;
    }

    protected int getRowCount(int column) {
        if (column < 0 || column >= this.columnCount) {
            return -1;
        }
        if (this.layoutOrientation == 0 || column == 0 && this.columnCount == 1) {
            return ((JList)this.component).getModel().getSize();
        }
        if (column >= this.columnCount) {
            return -1;
        }
        if (this.layoutOrientation == 1) {
            if (column < this.columnCount - 1) {
                return this.rowsPerColumn;
            }
            return ((JList)this.component).getModel().getSize() - (this.columnCount - 1) * this.rowsPerColumn;
        }
        int diff = this.columnCount - (this.columnCount * this.rowsPerColumn - ((JList)this.component).getModel().getSize());
        if (column >= diff) {
            return Math.max(0, this.rowsPerColumn - 1);
        }
        return this.rowsPerColumn;
    }

    protected int convertLocationToRowInColumn(int y, int column) {
        int x = 0;
        if (this.layoutOrientation != 0) {
            x = this.ltr ? column * this.cellWidth : ((JList)this.component).getWidth() - (column + 1) * this.cellWidth - ((JList)this.component).getInsets().right;
        }
        return this.convertLocationToRow(x, y, true);
    }

    protected int convertLocationToRow(int x, int y0, boolean closest) {
        int i;
        int size = ((JList)this.component).getModel().getSize();
        if (size <= 0) {
            return -1;
        }
        Insets insets = ((JList)this.component).getInsets();
        if (this.cellHeights == null) {
            int row;
            int n = row = this.cellHeight == 0 ? 0 : (y0 - insets.top) / this.cellHeight;
            if (closest) {
                if (row < 0) {
                    row = 0;
                } else if (row >= size) {
                    row = size - 1;
                }
            }
            return row;
        }
        if (size > this.cellHeights.length) {
            return -1;
        }
        int y = insets.top;
        int row = 0;
        if (closest && y0 < y) {
            return 0;
        }
        for (i = 0; i < size; ++i) {
            if (y0 >= y && y0 < y + this.cellHeights[i]) {
                return row;
            }
            y += this.cellHeights[i];
            ++row;
        }
        return i - 1;
    }

    protected int convertLocationToColumn(int x, int y) {
        if (this.cellWidth > 0) {
            if (this.layoutOrientation == 0) {
                return 0;
            }
            Insets insets = ((JList)this.component).getInsets();
            int col = this.ltr ? (x - insets.left) / this.cellWidth : (((JList)this.component).getWidth() - x - insets.right - 1) / this.cellWidth;
            if (col < 0) {
                return 0;
            }
            if (col >= this.columnCount) {
                return this.columnCount - 1;
            }
            return col;
        }
        return 0;
    }

    protected int adjustIndex(int index, E list) {
        return index < ((JList)list).getModel().getSize() ? index : -1;
    }

    protected void paintDropLocation(Graphics2D g2d) {
        JList.DropLocation loc = ((JList)this.component).getDropLocation();
        if (loc == null || !loc.isInsert()) {
            return;
        }
    }

    protected void paintCell(Graphics2D g2d, int index, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(index);
        boolean isSelected = selModel.isSelectedIndex(index);
        boolean cellHasFocus = ((JList)this.component).hasFocus() && index == leadIndex;
        Component renderer = cellRenderer.getListCellRendererComponent((JList)this.component, value, index, isSelected, cellHasFocus);
        this.rendererPane.paintComponent(g2d, renderer, this.component, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, true);
    }

    @Override
    public boolean isHoverDecorationSupported() {
        return this.hoverPainter != null && this.component != null && ((JList)this.component).isEnabled();
    }

    protected void paintHoverCellBackground(Graphics2D g2d) {
        Rectangle r;
        int hoverIndex;
        if (this.isHoverDecorationSupported() && (hoverIndex = ((WebListUI)this.ui).getHoverIndex()) != -1 && !((JList)this.component).isSelectedIndex(hoverIndex) && (r = ((WebListUI)this.ui).getCellBounds((JList)this.component, hoverIndex, hoverIndex)) != null) {
            this.hoverPainter.paint(g2d, r, this.component, this.ui);
        }
    }

    protected void paintSelectedCellsBackground(Graphics2D g2d) {
        if (this.selectionPainter != null && ((JList)this.component).getSelectedIndex() != -1 && ((WebListUI)this.ui).getSelectionStyle() != ListSelectionStyle.none) {
            List<Rectangle> selections = this.getSelectionRects();
            for (Rectangle rect : selections) {
                this.selectionPainter.paint(g2d, rect, this.component, this.ui);
            }
        }
    }

    protected List<Rectangle> getSelectionRects() {
        if (((WebListUI)this.ui).getSelectionStyle() == ListSelectionStyle.none) {
            return Collections.emptyList();
        }
        int[] indices = ((JList)this.component).getSelectedIndices();
        if (indices == null || indices.length == 0) {
            return Collections.emptyList();
        }
        Arrays.sort(indices);
        ArrayList<Rectangle> selections = new ArrayList<Rectangle>(indices.length);
        Rectangle maxRect = null;
        int lastRow = -1;
        for (int index : indices) {
            if (((WebListUI)this.ui).getSelectionStyle() == ListSelectionStyle.single) {
                selections.add(((JList)this.component).getCellBounds(index, index));
                continue;
            }
            if (lastRow != -1 && lastRow + 1 != index) {
                selections.add(maxRect);
                maxRect = null;
                lastRow = -1;
            }
            if (lastRow != -1 && lastRow + 1 != index) continue;
            Rectangle b = ((JList)this.component).getCellBounds(index, index);
            maxRect = lastRow == -1 ? b : GeometryUtils.getContainingRect((Rectangle)maxRect, (Rectangle)b);
            lastRow = index;
        }
        if (maxRect != null) {
            selections.add(maxRect);
        }
        return selections;
    }

    protected void repaintSelection() {
        if (((JList)this.component).getSelectedIndex() != -1) {
            for (Rectangle rect : this.getSelectionRects()) {
                ((JList)this.component).repaint(rect);
            }
        }
    }
}

