/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.filechooser;

import com.alee.global.GlobalConstants;
import com.alee.laf.filechooser.AdaptiveFileChooserPainter;
import com.alee.laf.filechooser.FileAcceptText;
import com.alee.laf.filechooser.FileChooserListener;
import com.alee.laf.filechooser.FileChooserPainter;
import com.alee.laf.filechooser.FileChooserType;
import com.alee.laf.filechooser.FileSelectionMode;
import com.alee.laf.filechooser.IFileChooserPainter;
import com.alee.laf.filechooser.WebFileChooserPanel;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.FileUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.swing.DataRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;

public class WebFileChooserUI
extends FileChooserUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=FileChooserPainter.class)
    protected IFileChooserPainter painter;
    protected Insets margin = null;
    protected Insets padding = null;
    protected JFileChooser fileChooser;
    protected WebFileView fileView;
    protected WebFileChooserPanel fileChooserPanel;
    protected boolean ignoreFileSelectionChanges = false;
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebFileChooserUI();
    }

    protected WebFileChooserPanel createPanel(JFileChooser fileChooser) {
        return new WebFileChooserPanel(this.getFileChooserType(), fileChooser.getControlButtonsAreShown());
    }

    @Override
    public void installUI(JComponent c) {
        this.fileChooser = (JFileChooser)c;
        StyleManager.installSkin(this.fileChooser);
        this.fileView = new WebFileView();
        this.fileChooser.setLayout(new BorderLayout());
        this.fileChooserPanel = this.createPanel(this.fileChooser);
        this.fileChooserPanel.setFileSelectionMode(FileSelectionMode.get(this.fileChooser.getFileSelectionMode()));
        this.fileChooserPanel.setMultiSelectionEnabled(this.fileChooser.isMultiSelectionEnabled());
        this.fileChooserPanel.setShowHiddenFiles(!this.fileChooser.isFileHidingEnabled());
        this.fileChooserPanel.setAcceptListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserUI.this.ignoreFileSelectionChanges = true;
                List<File> selectedFiles = WebFileChooserUI.this.fileChooserPanel.getSelectedFiles();
                WebFileChooserUI.this.fileChooser.setSelectedFiles(selectedFiles.toArray(new File[selectedFiles.size()]));
                WebFileChooserUI.this.ignoreFileSelectionChanges = false;
                WebFileChooserUI.this.fileChooser.approveSelection();
            }
        });
        this.fileChooserPanel.setCancelListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserUI.this.fileChooser.cancelSelection();
            }
        });
        this.fileChooserPanel.addFileChooserListener(new FileChooserListener(){

            @Override
            public void directoryChanged(File newDirectory) {
                WebFileChooserUI.this.ignoreFileSelectionChanges = true;
                WebFileChooserUI.this.fileChooser.setCurrentDirectory(newDirectory);
                WebFileChooserUI.this.ignoreFileSelectionChanges = false;
            }

            @Override
            public void selectionChanged(List<File> selectedFiles) {
                WebFileChooserUI.this.ignoreFileSelectionChanges = true;
                WebFileChooserUI.this.fileChooser.setSelectedFiles(selectedFiles.toArray(new File[selectedFiles.size()]));
                WebFileChooserUI.this.ignoreFileSelectionChanges = false;
            }

            @Override
            public void fileFilterChanged(FileFilter oldFilter, FileFilter newFilter) {
                WebFileChooserUI.this.ignoreFileSelectionChanges = true;
                WebFileChooserUI.this.fileChooser.setFileFilter(FileUtils.getSwingFileFilter((AbstractFileFilter)WebFileChooserUI.this.fileChooserPanel.getActiveFileFilter()));
                WebFileChooserUI.this.ignoreFileSelectionChanges = false;
            }
        });
        this.fileChooser.add((Component)this.fileChooserPanel, "Center");
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebFileChooserUI.this.propertyChanged(evt);
            }
        };
        this.fileChooser.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.fileChooser);
        this.fileChooser.removePropertyChangeListener(this.propertyChangeListener);
        this.fileChooserPanel = null;
        this.fileView = null;
        this.fileChooser = null;
    }

    protected void propertyChanged(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if (prop.equals("AccessoryChangedProperty")) {
            this.fileChooserPanel.setAccessory((JComponent)event.getNewValue());
        } else if (prop.equals("ApproveButtonTextChangedProperty")) {
            this.fileChooserPanel.setAcceptButtonText(this.fileChooser.getApproveButtonText());
        } else if (prop.equals("ControlButtonsAreShownChangedProperty")) {
            this.fileChooserPanel.setShowControlButtons(this.fileChooser.getControlButtonsAreShown());
        } else if (prop.equals("MultiSelectionEnabledChangedProperty")) {
            this.fileChooserPanel.setMultiSelectionEnabled(this.fileChooser.isMultiSelectionEnabled());
        } else if (prop.equals("fileFilterChanged") || prop.equals("ChoosableFileFilterChangedProperty") || prop.equals("acceptAllFileFilterUsedChanged")) {
            if (!this.ignoreFileSelectionChanges) {
                FileFilter filter = this.fileChooser.getFileFilter();
                FileFilter[] filters = this.fileChooser.getChoosableFileFilters();
                int initialCapacity = (filters != null ? filters.length : 0) + (filter != null ? 1 : 0);
                ArrayList<FileFilter> collected = new ArrayList<FileFilter>(initialCapacity);
                if (filter != null) {
                    collected.add(filter);
                }
                if (filters != null && filters.length > 0) {
                    for (FileFilter fileFilter : filters) {
                        if (collected.contains(fileFilter)) continue;
                        collected.add(fileFilter);
                    }
                }
                if (collected.size() > 0) {
                    this.fileChooserPanel.setFileFilters(collected.toArray(new FileFilter[collected.size()]));
                } else {
                    this.fileChooserPanel.setFileFilter((AbstractFileFilter)GlobalConstants.ALL_FILES_FILTER);
                }
            }
        } else if (prop.equals("fileSelectionChanged")) {
            int mode = this.fileChooser.getFileSelectionMode();
            this.fileChooserPanel.setFileSelectionMode(FileSelectionMode.get(mode));
        } else if (prop.equals("directoryChanged")) {
            if (!this.ignoreFileSelectionChanges) {
                this.fileChooserPanel.setCurrentFolder(this.fileChooser.getCurrentDirectory());
            }
        } else if (prop.equals("SelectedFileChangedProperty")) {
            if (!this.ignoreFileSelectionChanges) {
                File[] selectedFiles = this.fileChooser.getSelectedFiles();
                if (selectedFiles.length > 0) {
                    this.fileChooserPanel.setSelectedFiles(selectedFiles);
                } else {
                    this.fileChooserPanel.setSelectedFile(this.fileChooser.getSelectedFile());
                }
            }
        } else if (prop.equals("DialogTypeChangedProperty")) {
            this.fileChooserPanel.setChooserType(this.getFileChooserType());
        } else if (prop.equals("FileHidingChanged")) {
            this.fileChooserPanel.setShowHiddenFiles(!this.fileChooser.isFileHidingEnabled());
        } else if (prop.equals("MultiSelectionEnabledChangedProperty")) {
            this.fileChooserPanel.setMultiSelectionEnabled(this.fileChooser.isMultiSelectionEnabled());
        } else if (prop.equals("componentOrientation")) {
            this.fileChooserPanel.applyComponentOrientation(this.fileChooser.getComponentOrientation());
        }
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.fileChooser);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.fileChooser, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.fileChooser, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.fileChooser, new DataRunnable<IFileChooserPainter>(){

            public void run(IFileChooserPainter newPainter) {
                WebFileChooserUI.this.painter = newPainter;
            }
        }, this.painter, painter, IFileChooserPainter.class, AdaptiveFileChooserPainter.class);
    }

    public WebFileChooserPanel getFileChooserPanel() {
        return this.fileChooserPanel;
    }

    public List<AbstractFileFilter> getAvailableFilters() {
        return this.fileChooserPanel.getAvailableFilters();
    }

    public AbstractFileFilter getActiveFileFilter() {
        return this.fileChooserPanel.getActiveFileFilter();
    }

    public boolean isGenerateThumbnails() {
        return this.fileChooserPanel.isGenerateThumbnails();
    }

    public void setGenerateThumbnails(boolean generate) {
        this.fileChooserPanel.setGenerateThumbnails(generate);
    }

    public void setApproveButtonText(FileAcceptText approveText) {
        this.fileChooserPanel.setAcceptButtonText(approveText);
    }

    public void setApproveButtonLanguage(String key) {
        this.fileChooserPanel.setAcceptButtonLanguage(key);
    }

    @Override
    public FileFilter getAcceptAllFileFilter(JFileChooser fc) {
        return GlobalConstants.ALL_FILES_FILTER;
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    public void setFileView(WebFileView fileView) {
        this.fileView = fileView;
    }

    @Override
    public String getApproveButtonText(JFileChooser fc) {
        return this.fileChooserPanel.getAcceptButtonText();
    }

    @Override
    public String getDialogTitle(JFileChooser fc) {
        String dialogTitle = fc.getDialogTitle();
        return dialogTitle != null ? dialogTitle : LanguageManager.get((String)"weblaf.filechooser.title");
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.fileChooserPanel.reloadCurrentFolder();
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    public FileChooserType getFileChooserType() {
        if (this.fileChooser.getDialogType() == 1) {
            return FileChooserType.save;
        }
        if (this.fileChooser.getDialogType() == 0) {
            return FileChooserType.open;
        }
        return FileChooserType.custom;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    protected class WebFileView
    extends FileView {
        protected WebFileView() {
        }

        @Override
        public String getName(File f) {
            return FileUtils.getDisplayFileName((File)f);
        }

        @Override
        public String getDescription(File f) {
            return this.getTypeDescription(f);
        }

        @Override
        public String getTypeDescription(File f) {
            return FileUtils.getFileTypeDescription((File)f);
        }

        @Override
        public Icon getIcon(File f) {
            return FileUtils.getFileIcon((File)f);
        }
    }
}

