/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.filechooser;

import com.alee.extended.drag.FileDragAndDropHandler;
import com.alee.extended.filechooser.PathFieldListener;
import com.alee.extended.filechooser.WebFileChooserField;
import com.alee.extended.filechooser.WebFileTable;
import com.alee.extended.filechooser.WebFileTableModel;
import com.alee.extended.filechooser.WebPathField;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.layout.ToolbarLayout;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.list.FileElement;
import com.alee.extended.list.WebFileList;
import com.alee.extended.tree.WebFileTree;
import com.alee.global.GlobalConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.combobox.WebComboBox;
import com.alee.laf.filechooser.FileAcceptText;
import com.alee.laf.filechooser.FileChooserListener;
import com.alee.laf.filechooser.FileChooserType;
import com.alee.laf.filechooser.FileChooserViewType;
import com.alee.laf.filechooser.FileSelectionMode;
import com.alee.laf.label.WebLabel;
import com.alee.laf.list.WebList;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.list.editor.ListEditAdapter;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.menu.WebRadioButtonMenuItem;
import com.alee.laf.optionpane.WebOptionPane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.scroll.WebScrollPaneBar;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.text.WebTextField;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.filefilter.FilterGroupType;
import com.alee.utils.filefilter.GroupedFileFilter;
import com.alee.utils.filefilter.NonHiddenFilter;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.DataProvider;
import com.alee.utils.text.FileNameProvider;
import com.alee.utils.text.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableRowSorter;

public class WebFileChooserPanel
extends WebPanel {
    public static final ImageIcon BACKWARD_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/backward.png"));
    public static final ImageIcon FORWARD_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/forward.png"));
    public static final ImageIcon HISTORY_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/history.png"));
    public static final ImageIcon FOLDER_UP_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/folder_up.png"));
    public static final ImageIcon FOLDER_HOME_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/folder_home.png"));
    public static final ImageIcon FOLDER_NEW_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/folder_new.png"));
    public static final ImageIcon REFRESH_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/refresh.png"));
    public static final ImageIcon REMOVE_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/remove.png"));
    public static final ImageIcon VIEW_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/view.png"));
    public static final ImageIcon VIEW_ICONS_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/icons.png"));
    public static final ImageIcon VIEW_TILES_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/tiles.png"));
    public static final ImageIcon VIEW_TABLE_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/table.png"));
    public static final ImageIcon SETTINGS_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/settings.png"));
    public static final ImageIcon ACCEPT_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/approve.png"));
    public static final ImageIcon CANCEL_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/cancel.png"));
    public static final FileNameProvider quotedFileNameProvider = new FileNameProvider(){

        public String getText(File object) {
            return "\"" + super.getText(object) + "\"";
        }
    };
    protected final AbstractFileFilter selectedFilesFilter = new AbstractFileFilter(){

        public ImageIcon getIcon() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public boolean accept(File file) {
            switch (WebFileChooserPanel.this.getFileSelectionMode()) {
                case filesOnly: {
                    return WebFileChooserPanel.this.chooserType == FileChooserType.open ? file.isFile() : !file.exists() || file.isFile();
                }
                case directoriesOnly: {
                    return WebFileChooserPanel.this.chooserType == FileChooserType.open ? file.isDirectory() : !file.exists() || file.isDirectory();
                }
            }
            return true;
        }
    };
    protected boolean showControlButtons;
    protected FileChooserType chooserType;
    protected FileSelectionMode fileSelectionMode = FileSelectionMode.filesAndDirectories;
    protected boolean showHiddenFiles = false;
    protected AbstractFileFilter fileFilter;
    protected List<AbstractFileFilter> availableFilters;
    protected FileChooserViewType viewType = FileChooserViewType.tiles;
    protected boolean multiSelectionEnabled = false;
    protected File currentFolder = null;
    protected int currentHistoryIndex = -1;
    protected List<File> navigationHistory = new ArrayList<File>();
    protected ActionListener acceptListener;
    protected ActionListener cancelListener;
    protected List<FileChooserListener> chooserListeners = new ArrayList<FileChooserListener>(1);
    protected int dividerLocation = 160;
    protected WebButton backward;
    protected WebButton forward;
    protected WebButton history;
    protected WebPathField pathField;
    protected PathFieldListener pathFieldListener;
    protected WebButton folderUp;
    protected WebButton folderHome;
    protected WebButton folderNew;
    protected WebButton refresh;
    protected WebButton remove;
    protected WebButton view;
    protected WebPanel centralContainer;
    protected WebSplitPane centralSplit;
    protected WebFileTree fileTree;
    protected TreeSelectionListener fileTreeListener;
    protected WebScrollPane treeScroll;
    protected WebFileList fileList;
    protected WebScrollPane fileListScroll;
    protected WebFileTable fileTable;
    protected WebScrollPane fileTableScroll;
    protected WebFileChooserField selectedFilesViewField;
    protected WebTextField selectedFilesTextField;
    protected WebComboBox fileFilters;
    protected WebButton acceptButton;
    protected WebButton cancelButton;
    protected WebPanel controlsPanel;
    protected JComponent accessory;
    protected DataProvider<Boolean> hotkeysAllowed = new DataProvider<Boolean>(){

        public Boolean provide() {
            return !WebFileChooserPanel.this.fileTree.isEditing() && !WebFileChooserPanel.this.fileList.isEditing() && !WebFileChooserPanel.this.fileTable.isEditing() && !WebFileChooserPanel.this.pathField.isEditing() && !WebFileChooserPanel.this.selectedFilesTextField.isFocusOwner();
        }
    };
    protected HiddenFilesFilter hiddenFilesFilter = new HiddenFilesFilter();

    public WebFileChooserPanel() {
        this(FileChooserType.open, false);
    }

    public WebFileChooserPanel(FileChooserType chooserType) {
        this(chooserType, false);
    }

    public WebFileChooserPanel(boolean showControlButtons) {
        this(FileChooserType.open, showControlButtons);
    }

    public WebFileChooserPanel(FileChooserType chooserType, boolean showControlButtons) {
        super(StyleId.filechooserPanel);
        this.showControlButtons = showControlButtons;
        this.chooserType = chooserType;
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.createTools(), (Object)"North");
        this.add(this.createContent(), (Object)"Center");
        this.add(this.createControls(), (Object)"South");
        this.updateSelectionMode();
        this.updateDirectoryComponentFilters();
        this.setFileFilter((AbstractFileFilter)GlobalConstants.ALL_FILES_FILTER);
        this.restoreButtonText();
    }

    protected Component createTools() {
        final StyleId decoratedId = StyleId.filechooserToolbar.at(this);
        final StyleId undecoratedId = StyleId.filechooserUndecoratedToolbar.at(this);
        final WebToolBar toolBar = new WebToolBar(decoratedId);
        toolBar.addAncestorListener((AncestorListener)new AncestorAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                this.updateToolbarStyle();
            }

            public void ancestorMoved(AncestorEvent event) {
                this.updateToolbarStyle();
            }

            private void updateToolbarStyle() {
                toolBar.setStyleId(LafUtils.isInDecoratedWindow(WebFileChooserPanel.this) ? undecoratedId : decoratedId);
            }
        });
        this.add((Component)toolBar, (Object)"North");
        StyleId toolbarButtonId = StyleId.filechooserToolbarButton.at(toolBar);
        this.backward = new WebButton(toolbarButtonId, (Icon)BACKWARD_ICON);
        this.backward.setLanguage("weblaf.filechooser.back", new Object[0]);
        this.backward.addHotkey(this, Hotkey.ALT_LEFT).setHotkeyDisplayWay(TooltipWay.down);
        this.backward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)WebFileChooserPanel.this.hotkeysAllowed.provide()).booleanValue()) {
                    WebFileChooserPanel.this.updateHistoryState(WebFileChooserPanel.this.currentHistoryIndex - 1);
                }
            }
        });
        this.forward = new WebButton(toolbarButtonId, (Icon)FORWARD_ICON);
        this.forward.setLanguage("weblaf.filechooser.forward", new Object[0]);
        this.forward.addHotkey(this, Hotkey.ALT_RIGHT).setHotkeyDisplayWay(TooltipWay.trailing);
        this.forward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)WebFileChooserPanel.this.hotkeysAllowed.provide()).booleanValue()) {
                    WebFileChooserPanel.this.updateHistoryState(WebFileChooserPanel.this.currentHistoryIndex + 1);
                }
            }
        });
        this.history = new WebButton(toolbarButtonId, (Icon)HISTORY_ICON);
        this.history.setLanguage("weblaf.filechooser.history", new Object[0]);
        this.history.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final WebPopupMenu historyPopup = new WebPopupMenu();
                final WebList historyList = new WebList(WebFileChooserPanel.this.navigationHistory);
                historyList.setOpaque(false);
                historyList.setVisibleRowCount(Math.min(10, WebFileChooserPanel.this.navigationHistory.size()));
                historyList.setSelectOnHover(true);
                historyList.setCellRenderer(new WebListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        WebStyledLabel renderer = (WebStyledLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                        File file = (File)value;
                        if (file == null) {
                            renderer.setIcon(FileUtils.getMyComputerIcon());
                            renderer.setText(LanguageManager.get((String)"weblaf.filechooser.root"));
                        } else {
                            renderer.setIcon(FileUtils.getFileIcon((File)file));
                            renderer.setText(TextUtils.shortenText((String)FileUtils.getDisplayFileName((File)file), (int)40, (boolean)true));
                        }
                        renderer.setBoldFont(index == WebFileChooserPanel.this.currentHistoryIndex);
                        return renderer;
                    }
                });
                historyList.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        WebFileChooserPanel.this.updateHistoryState(historyList.getSelectedIndex());
                        historyPopup.setVisible(false);
                    }
                });
                StyleId historyScrollId = StyleId.filechooserHistoryScrollPane.at(toolBar);
                historyPopup.add(new WebScrollPane(historyScrollId, historyList));
                historyPopup.showBelowMiddle(WebFileChooserPanel.this.history);
                historyList.setSelectedIndex(WebFileChooserPanel.this.currentHistoryIndex);
                historyList.scrollToCell(WebFileChooserPanel.this.currentHistoryIndex);
            }
        });
        this.pathField = new WebPathField(StyleId.filechooserPathField.at(toolBar));
        this.pathFieldListener = new PathFieldListener(){

            @Override
            public void directoryChanged(File newDirectory) {
                WebFileChooserPanel.this.updateCurrentFolder(newDirectory, UpdateSource.path);
            }
        };
        this.pathField.addPathFieldListener(this.pathFieldListener);
        this.folderUp = new WebButton(toolbarButtonId, (Icon)FOLDER_UP_ICON);
        this.folderUp.setLanguage("weblaf.filechooser.folderup", new Object[0]);
        this.folderUp.addHotkey(this, Hotkey.ALT_UP).setHotkeyDisplayWay(TooltipWay.down);
        this.folderUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)WebFileChooserPanel.this.hotkeysAllowed.provide()).booleanValue() && WebFileChooserPanel.this.currentFolder != null) {
                    WebFileChooserPanel.this.updateCurrentFolder(WebFileChooserPanel.this.currentFolder.getParentFile(), UpdateSource.toolbar);
                }
            }
        });
        this.folderHome = new WebButton(toolbarButtonId, (Icon)FOLDER_HOME_ICON);
        this.folderHome.setLanguage("weblaf.filechooser.home", new Object[0]);
        this.folderHome.addHotkey(this, Hotkey.ALT_HOME).setHotkeyDisplayWay(TooltipWay.down);
        this.folderHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)WebFileChooserPanel.this.hotkeysAllowed.provide()).booleanValue()) {
                    WebFileChooserPanel.this.updateCurrentFolder(FileUtils.getUserHome(), UpdateSource.toolbar);
                }
            }
        });
        this.refresh = new WebButton(toolbarButtonId, (Icon)REFRESH_ICON);
        this.refresh.setLanguage("weblaf.filechooser.refresh", new Object[0]);
        this.refresh.addHotkey(this, Hotkey.F5).setHotkeyDisplayWay(TooltipWay.down);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)WebFileChooserPanel.this.hotkeysAllowed.provide()).booleanValue()) {
                    WebFileChooserPanel.this.reloadCurrentFolder();
                }
            }
        });
        this.folderNew = new WebButton(toolbarButtonId, (Icon)FOLDER_NEW_ICON);
        this.folderNew.setLanguage("weblaf.filechooser.newfolder", new Object[0]);
        this.folderNew.addHotkey(this, Hotkey.CTRL_N).setHotkeyDisplayWay(TooltipWay.down);
        this.folderNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)WebFileChooserPanel.this.hotkeysAllowed.provide()).booleanValue() && WebFileChooserPanel.this.currentFolder != null) {
                    String defaultName = LanguageManager.get((String)"weblaf.filechooser.newfolder.name");
                    String freeName = FileUtils.getAvailableName((File)WebFileChooserPanel.this.currentFolder, (String)defaultName);
                    File file = new File(WebFileChooserPanel.this.currentFolder, freeName);
                    if (file.mkdir()) {
                        WebFileChooserPanel.this.reloadCurrentFolder();
                        WebFileChooserPanel.this.setSelectedFile(file);
                        WebFileChooserPanel.this.editSelectedFileName();
                    } else {
                        String message = LanguageManager.get((String)"weblaf.filechooser.newfolder.error.text");
                        String title = LanguageManager.get((String)"weblaf.filechooser.newfolder.error.title");
                        WebOptionPane.showMessageDialog(WebFileChooserPanel.this, message, title, 0);
                    }
                }
            }
        });
        this.remove = new WebButton(toolbarButtonId, (Icon)REMOVE_ICON);
        this.remove.setLanguage("weblaf.filechooser.delete", new Object[0]);
        this.remove.addHotkey(this, Hotkey.DELETE).setHotkeyDisplayWay(TooltipWay.down);
        this.remove.setEnabled(false);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)WebFileChooserPanel.this.hotkeysAllowed.provide()).booleanValue()) {
                    WebFileChooserPanel.this.deleteSelectedFiles();
                }
            }
        });
        this.view = new WebButton(toolbarButtonId, (Icon)VIEW_ICON);
        this.view.setLanguage("weblaf.filechooser.view", new Object[0]);
        final AbstractAction viewIcons = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.setViewType(FileChooserViewType.icons);
            }
        };
        final AbstractAction viewTiles = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.setViewType(FileChooserViewType.tiles);
            }
        };
        final AbstractAction viewTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.setViewType(FileChooserViewType.table);
            }
        };
        int menu = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        final KeyStroke ksViewIcons = KeyStroke.getKeyStroke(49, menu);
        final KeyStroke ksViewTiles = KeyStroke.getKeyStroke(50, menu);
        final KeyStroke ksViewTable = KeyStroke.getKeyStroke(51, menu);
        inputMap.put(ksViewIcons, "viewIcons");
        actionMap.put("viewIcons", viewIcons);
        inputMap.put(ksViewTiles, "viewTiles");
        actionMap.put("viewTiles", viewTiles);
        inputMap.put(ksViewTable, "viewTable");
        actionMap.put("viewTable", viewTable);
        this.view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPopupMenu viewChoose = new WebPopupMenu();
                WebRadioButtonMenuItem icons = new WebRadioButtonMenuItem(VIEW_ICONS_ICON);
                icons.setLanguage("weblaf.filechooser.view.icons", new Object[0]);
                icons.setAccelerator(new HotkeyData(ksViewIcons));
                icons.setSelected(WebFileChooserPanel.this.getViewType().equals((Object)FileChooserViewType.icons));
                icons.addActionListener(viewIcons);
                viewChoose.add(icons);
                WebRadioButtonMenuItem tiles = new WebRadioButtonMenuItem(VIEW_TILES_ICON);
                tiles.setLanguage("weblaf.filechooser.view.tiles", new Object[0]);
                tiles.setAccelerator(new HotkeyData(ksViewTiles));
                tiles.setSelected(WebFileChooserPanel.this.getViewType().equals((Object)FileChooserViewType.tiles));
                tiles.addActionListener(viewTiles);
                viewChoose.add(tiles);
                WebRadioButtonMenuItem table = new WebRadioButtonMenuItem(VIEW_TABLE_ICON);
                table.setLanguage("weblaf.filechooser.view.table", new Object[0]);
                table.setAccelerator(new HotkeyData(ksViewTable));
                table.setSelected(WebFileChooserPanel.this.getViewType().equals((Object)FileChooserViewType.table));
                table.addActionListener(viewTable);
                viewChoose.add(table);
                ButtonGroup viewGroup = new ButtonGroup();
                viewGroup.add(icons);
                viewGroup.add(tiles);
                viewGroup.add(table);
                viewChoose.showBelowMiddle(WebFileChooserPanel.this.view);
            }
        });
        toolBar.add((Component)this.backward);
        toolBar.add((Component)this.forward);
        toolBar.add((Component)this.history);
        toolBar.addFill(this.pathField);
        toolBar.addToEnd(this.folderUp);
        toolBar.addToEnd(this.folderHome);
        toolBar.addToEnd(this.refresh);
        toolBar.addSeparatorToEnd();
        toolBar.addToEnd(this.folderNew);
        toolBar.addToEnd(this.remove);
        toolBar.addSeparatorToEnd();
        toolBar.addToEnd(this.view);
        return toolBar;
    }

    protected void updateHistoryState(int historyIndex) {
        if (historyIndex >= 0 && historyIndex < this.navigationHistory.size()) {
            this.currentHistoryIndex = historyIndex;
            this.updateCurrentFolder(this.navigationHistory.get(historyIndex), UpdateSource.history);
        }
    }

    protected Component createContent() {
        this.centralContainer = new WebPanel(StyleId.filechooserCenterPanel.at(this), new BorderLayout(4, 0), new Component[0]);
        this.centralSplit = new WebSplitPane(StyleId.filechooserCenterSplit.at(this.centralContainer), 1);
        this.centralSplit.setOneTouchExpandable(true);
        this.createFileTree();
        this.createFileList();
        this.createFileTable();
        this.centralSplit.setLeftComponent(this.treeScroll);
        this.centralSplit.setRightComponent(this.fileListScroll);
        this.centralSplit.setDividerLocation(this.dividerLocation);
        this.centralContainer.add((Component)this.centralSplit);
        return this.centralContainer;
    }

    protected void createFileTree() {
        this.treeScroll = new WebScrollPane(StyleId.filechooserNavScroll.at(this.centralSplit));
        this.treeScroll.setPreferredSize(new Dimension(this.dividerLocation, 1));
        this.fileTree = new WebFileTree(StyleId.filechooserFileTree.at(this.treeScroll));
        this.fileTree.setAutoExpandSelectedNode(true);
        this.fileTree.setSelectionMode(1);
        this.treeScroll.setViewportView(this.fileTree);
        this.fileTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (WebFileChooserPanel.this.fileTree.getSelectionCount() > 0) {
                    WebFileChooserPanel.this.updateCurrentFolder(WebFileChooserPanel.this.fileTree.getSelectedFile(), UpdateSource.tree);
                }
            }
        };
        this.fileTree.addTreeSelectionListener(this.fileTreeListener);
    }

    protected void createFileList() {
        this.fileListScroll = new WebScrollPane(StyleId.filechooserViewScroll.at(this.centralSplit));
        this.fileListScroll.setHorizontalScrollBarPolicy(31);
        this.fileListScroll.setVerticalScrollBarPolicy(22);
        this.fileList = new WebFileList(StyleId.filechooserFileListTiles.at(this.fileListScroll));
        this.fileList.setDropMode(DropMode.ON);
        this.fileList.setEditable(true);
        this.fileList.setTransferHandler(new FilesLocateDropHandler(UpdateSource.list));
        this.fileListScroll.setViewportView(this.fileList);
        this.fileList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "openFolder");
        this.fileList.getActionMap().put("openFolder", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return WebFileChooserPanel.this.fileList.getSelectedIndex() != -1;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = WebFileChooserPanel.this.fileList.getSelectedFile();
                if (file.isDirectory()) {
                    WebFileChooserPanel.this.updateCurrentFolder(file, UpdateSource.list);
                }
            }
        });
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0 && WebFileChooserPanel.this.fileList.getSelectedIndex() != -1) {
                    File file = WebFileChooserPanel.this.fileList.getSelectedFile();
                    if (file.isDirectory()) {
                        WebFileChooserPanel.this.updateCurrentFolder(file, UpdateSource.list);
                    } else {
                        WebFileChooserPanel.this.fireAcceptAction(new ActionEvent(WebFileChooserPanel.this.fileList, e.getID(), "Files selected", e.getWhen(), e.getModifiers()));
                    }
                }
            }
        });
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    WebFileChooserPanel.this.updateSelectedFilesField();
                }
            }
        });
        this.fileList.addListEditListener(new ListEditAdapter(){

            @Override
            public void editFinished(int index, Object oldValue, Object newValue) {
                File file = ((FileElement)newValue).getFile();
                WebFileChooserPanel.this.reloadCurrentFolder();
                WebFileChooserPanel.this.fileList.setSelectedFile(file);
            }
        });
    }

    protected void createFileTable() {
        this.fileTableScroll = new WebScrollPane(StyleId.filechooserViewScroll.at(this.centralSplit));
        this.fileTableScroll.setHorizontalScrollBarPolicy(31);
        this.fileTableScroll.setVerticalScrollBarPolicy(22);
        this.fileTable = new WebFileTable(StyleId.filechooserFileTable.at(this.fileTableScroll));
        this.fileTable.setOpaque(false);
        this.fileTable.setEditable(true);
        this.fileTable.setRowSorter(this.createFileTableRowSorter());
        this.fileTable.setTransferHandler(new FilesLocateDropHandler(UpdateSource.table));
        this.fileTableScroll.setViewportView(this.fileTable);
        this.fileTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "openFolder");
        this.fileTable.getActionMap().put("openFolder", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return WebFileChooserPanel.this.fileTable.getSelectedRow() != -1;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = WebFileChooserPanel.this.fileTable.getSelectedFile();
                if (file.isDirectory()) {
                    WebFileChooserPanel.this.updateCurrentFolder(file, UpdateSource.table);
                }
            }
        });
        this.fileTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0 && WebFileChooserPanel.this.fileTable.getSelectedRow() != -1) {
                    File file = WebFileChooserPanel.this.fileTable.getSelectedFile();
                    if (file.isDirectory()) {
                        WebFileChooserPanel.this.updateCurrentFolder(file, UpdateSource.table);
                    } else {
                        WebFileChooserPanel.this.fireAcceptAction(new ActionEvent(WebFileChooserPanel.this.fileTable, e.getID(), "Files selected", e.getWhen(), e.getModifiers()));
                    }
                }
            }
        });
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    WebFileChooserPanel.this.updateSelectedFilesField();
                }
            }
        });
        this.fileTable.getDefaultEditor(File.class).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                File file = WebFileChooserPanel.this.fileTable.getSelectedFile();
                WebFileChooserPanel.this.reloadCurrentFolder();
                WebFileChooserPanel.this.fileTable.setSelectedFile(file);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
    }

    protected TableRowSorter<WebFileTableModel> createFileTableRowSorter() {
        WebFileTableModel tableModel = this.fileTable.getFileTableModel();
        TableRowSorter<WebFileTableModel> rowSorter = new TableRowSorter<WebFileTableModel>(tableModel);
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            String columnId = tableModel.getColumnId(i);
            Object comp = columnId.equals("weblaf.filechooser.table.column.name") ? GlobalConstants.FILE_COMPARATOR : (columnId.equals("weblaf.filechooser.table.column.size") ? new Comparator<File>(){

                @Override
                public int compare(File a, File b) {
                    long bl;
                    boolean ad = FileUtils.isDirectory((File)a);
                    boolean bd = FileUtils.isDirectory((File)b);
                    if (ad && bd) {
                        return 0;
                    }
                    if (ad) {
                        return -1;
                    }
                    if (bd) {
                        return 1;
                    }
                    long al = a.length();
                    return al < (bl = b.length()) ? -1 : (al > bl ? 1 : 0);
                }
            } : (columnId.equals("weblaf.filechooser.table.column.extension") ? new Comparator<File>(){

                @Override
                public int compare(File a, File b) {
                    boolean af = FileUtils.isFile((File)a);
                    boolean bf = FileUtils.isFile((File)b);
                    String as = af ? FileUtils.getFileExtPart((String)a.getName(), (boolean)true) : "";
                    String bs = bf ? FileUtils.getFileExtPart((String)b.getName(), (boolean)true) : "";
                    return as.compareToIgnoreCase(bs);
                }
            } : (columnId.equals("weblaf.filechooser.table.column.modification.date") ? new Comparator<File>(){

                @Override
                public int compare(File a, File b) {
                    long bl;
                    long al = a.lastModified();
                    return al < (bl = b.lastModified()) ? -1 : (al > bl ? 1 : 0);
                }
            } : null)));
            if (comp == null) {
                rowSorter.setSortable(i, false);
                continue;
            }
            rowSorter.setComparator(i, (Comparator<?>)comp);
        }
        return rowSorter;
    }

    protected Component createControls() {
        this.controlsPanel = new WebPanel(StyleId.filechooserSouthPanel.at(this), new ToolbarLayout(4), new Component[0]);
        this.add((Component)this.controlsPanel, (Object)"South");
        this.controlsPanel.add((Component)new WebLabel(StyleId.filechooserSelectedLabel.at(this.controlsPanel), "weblaf.filechooser.files.selected"));
        this.selectedFilesViewField = new WebFileChooserField(false);
        this.selectedFilesViewField.setShowRemoveButton(false);
        this.selectedFilesViewField.setShowFileShortName(true);
        this.selectedFilesViewField.setFilesDropEnabled(false);
        this.selectedFilesTextField = new WebTextField(0);
        this.selectedFilesTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                WebFileChooserPanel.this.updateAcceptButtonState(null);
            }
        });
        this.selectedFilesTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.acceptButton.doClick(0);
            }
        });
        this.controlsPanel.add((Component)(this.chooserType == FileChooserType.save ? this.selectedFilesTextField : this.selectedFilesViewField), (Object)"FILL");
        this.fileFilters = new WebComboBox();
        this.fileFilters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFileFilter oldFilter = WebFileChooserPanel.this.fileFilter;
                AbstractFileFilter newFilter = (AbstractFileFilter)WebFileChooserPanel.this.fileFilters.getSelectedItem();
                WebFileChooserPanel.this.setActiveFileFilter(newFilter, false);
                WebFileChooserPanel.this.fireFileFilterChanged((javax.swing.filechooser.FileFilter)oldFilter, (javax.swing.filechooser.FileFilter)newFilter);
            }
        });
        this.controlsPanel.add((Component)this.fileFilters, (Object)"END");
        this.acceptButton = new WebButton(StyleId.filechooserAcceptButton.at(this.controlsPanel), (Icon)ACCEPT_ICON);
        this.acceptButton.addHotkey((Component)this, Hotkey.CTRL_ENTER, TooltipWay.up);
        this.acceptButton.putClientProperty("fill.component.cell", true);
        this.acceptButton.setEnabled(false);
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.fireAcceptAction(e);
            }
        });
        this.cancelButton = new WebButton(StyleId.filechooserCancelButton.at(this.controlsPanel), "weblaf.filechooser.cancel", (Icon)CANCEL_ICON);
        this.cancelButton.addHotkey((Component)this, Hotkey.ESCAPE, TooltipWay.up);
        this.cancelButton.putClientProperty("fill.component.cell", true);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.fireCancelAction(e);
            }
        });
        SwingUtils.equalizeComponentsWidth(Arrays.asList("text"), this.acceptButton, this.cancelButton);
        this.updateControls();
        return this.controlsPanel;
    }

    public void setAccessory(JComponent accessory) {
        if (this.accessory != accessory) {
            if (this.accessory != null) {
                this.centralContainer.remove((Component)this.accessory);
            }
            this.accessory = accessory;
            if (accessory != null) {
                this.centralContainer.add((Component)accessory, (Object)"After");
            }
            this.centralContainer.revalidate();
        }
    }

    public WebFileTree getFileTree() {
        return this.fileTree;
    }

    public WebFileList getFileList() {
        return this.fileList;
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    public FileChooserViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(FileChooserViewType viewType) {
        boolean viewChanged = viewType.getComponentIndex() != this.viewType.getComponentIndex();
        this.viewType = viewType;
        int dividerLocation = this.centralSplit.getDividerLocation();
        switch (viewType) {
            case icons: {
                this.fileList.setStyleId(StyleId.filechooserFileListIcons.at(this.fileListScroll));
                this.centralSplit.setRightComponent(this.fileListScroll);
                if (viewChanged) {
                    this.fileList.setSelectedFiles(this.fileTable.getSelectedFiles());
                }
                this.fileList.requestFocusInWindow();
                break;
            }
            case tiles: {
                this.fileList.setStyleId(StyleId.filechooserFileListTiles.at(this.fileListScroll));
                this.centralSplit.setRightComponent(this.fileListScroll);
                if (viewChanged) {
                    this.fileList.setSelectedFiles(this.fileTable.getSelectedFiles());
                }
                this.fileList.requestFocusInWindow();
                break;
            }
            case table: {
                this.centralSplit.setRightComponent(this.fileTableScroll);
                if (viewChanged) {
                    this.fileTable.setSelectedFiles(this.fileList.getSelectedFiles());
                }
                this.fileTable.requestFocusInWindow();
            }
        }
        this.centralSplit.setDividerLocation(dividerLocation);
        this.centralSplit.revalidate();
    }

    public void setCurrentFolder(File folder) {
        this.updateCurrentFolder(folder, UpdateSource.other);
    }

    protected void updateCurrentFolder(File file, UpdateSource updateSource) {
        File toSelect = null;
        if (file != null && !FileUtils.isDirectory((File)file)) {
            toSelect = file;
            file = file.getParentFile();
        }
        if (file == null && !SystemUtils.isWindows()) {
            file = FileUtils.getDiskRoots()[0];
        }
        if (FileUtils.equals((File)this.currentFolder, (File)file)) {
            if (toSelect != null) {
                this.setSelectedFile(toSelect);
            }
            this.updateControlsState();
            return;
        }
        if (updateSource != UpdateSource.history) {
            if (this.currentHistoryIndex > -1) {
                while (this.currentHistoryIndex + 1 < this.navigationHistory.size()) {
                    this.navigationHistory.remove(this.currentHistoryIndex + 1);
                }
            }
            this.navigationHistory.add(file);
            this.currentHistoryIndex = this.navigationHistory.size() - 1;
        }
        if (updateSource != UpdateSource.path) {
            this.updatePath(file);
        }
        if (updateSource != UpdateSource.tree) {
            this.updateTree(file);
        }
        this.updateList(file);
        this.updateTable(file);
        this.currentFolder = file;
        this.updateControlsState();
        if (toSelect != null) {
            this.setSelectedFile(toSelect);
        }
        this.fireDirectoryChanged(this.currentFolder);
    }

    protected void updateControlsState() {
        this.backward.setEnabled(this.currentHistoryIndex > 0);
        this.forward.setEnabled(this.currentHistoryIndex + 1 < this.navigationHistory.size());
        this.folderNew.setEnabled(this.currentFolder != null);
        this.folderUp.setEnabled(SystemUtils.isWindows() ? this.currentFolder != null : this.currentFolder != null && this.currentFolder.getParentFile() != null);
    }

    public List<File> getSelectedFiles() {
        if (this.chooserType == FileChooserType.save) {
            return Arrays.asList(new File(this.currentFolder, this.selectedFilesTextField.getText().trim()));
        }
        List<File> files = this.getAllSelectedFiles();
        return this.getFilteredSelectedFiles(files);
    }

    protected List<File> getFilteredSelectedFiles(Collection<File> allFiles) {
        List files = FileUtils.filterFiles(allFiles, (AbstractFileFilter)this.fileFilter);
        return FileUtils.filterFiles((Collection)files, (AbstractFileFilter)this.selectedFilesFilter);
    }

    protected List<File> getAllSelectedFiles() {
        List<File> files = this.viewType.getComponentIndex() == 0 ? this.fileList.getSelectedFiles() : (this.viewType.getComponentIndex() == 1 ? this.fileTable.getSelectedFiles() : new ArrayList<File>(0));
        return files;
    }

    public void setSelectedFile(File file) {
        if (this.viewType.getComponentIndex() == 0) {
            this.fileList.setSelectedFile(file);
        }
        if (this.viewType.getComponentIndex() == 1) {
            this.fileTable.setSelectedFile(file);
        }
        if (file != null && !file.exists()) {
            this.updateSelectedFilesFieldImpl(Arrays.asList(file));
        } else {
            this.updateSelectedFilesFieldImpl(Collections.EMPTY_LIST);
        }
    }

    public void setSelectedFiles(File[] files) {
        this.setSelectedFiles(CollectionUtils.toList((Object[])files));
    }

    public void setSelectedFiles(Collection<File> files) {
        if (this.viewType.getComponentIndex() == 0) {
            this.fileList.setSelectedFiles(files);
        }
        if (this.viewType.getComponentIndex() == 1) {
            this.fileTable.setSelectedFiles(files);
        }
        this.updateSelectedFilesFieldImpl(files);
    }

    protected void updateSelectedFilesField() {
        List<File> allFiles = this.getAllSelectedFiles();
        this.updateSelectedFilesFieldImpl(allFiles);
    }

    protected void updateSelectedFilesFieldImpl(Collection<File> selected) {
        List<File> files = this.getFilteredSelectedFiles(selected);
        this.folderNew.setEnabled(this.currentFolder != null);
        this.remove.setEnabled(this.currentFolder != null && selected.size() > 0);
        if (this.chooserType == FileChooserType.save) {
            File file;
            if (files.size() > 0 && (!(file = files.get(0)).exists() || FileUtils.isFile((File)file))) {
                this.selectedFilesViewField.setSelectedFile(file);
                this.selectedFilesTextField.setText(this.getSingleFileView(file));
            }
        } else {
            this.selectedFilesViewField.setSelectedFiles(files);
            this.selectedFilesTextField.setText(this.getFilesView(files));
        }
        this.updateAcceptButtonState(files);
        this.fireFileSelectionChanged(files);
    }

    private String getFilesView(List<File> files) {
        return files.size() > 1 ? this.getMultiFilesView(files) : (files.size() == 1 ? this.getSingleFileView(files.get(0)) : "");
    }

    protected String getSingleFileView(File file) {
        return file.getName();
    }

    protected String getMultiFilesView(List<File> files) {
        return TextUtils.listToString(files, (String)", ", (TextProvider)quotedFileNameProvider);
    }

    protected void updateAcceptButtonState(List<File> files) {
        if (this.chooserType == FileChooserType.save) {
            this.acceptButton.setEnabled(!this.selectedFilesTextField.getText().trim().equals(""));
        } else {
            if (files == null) {
                files = this.getFilteredSelectedFiles(this.getAllSelectedFiles());
            }
            this.acceptButton.setEnabled(files.size() > 0);
        }
    }

    protected void updateSelectedFilesFieldPanel() {
        this.controlsPanel.remove(this.selectedFilesTextField, this.selectedFilesViewField);
        this.controlsPanel.add((Component)(this.chooserType == FileChooserType.save ? this.selectedFilesTextField : this.selectedFilesViewField), (Object)"FILL");
        this.controlsPanel.revalidate();
    }

    protected void updatePath(File file) {
        this.pathField.removePathFieldListener(this.pathFieldListener);
        this.pathField.setSelectedPath(file);
        this.pathField.addPathFieldListener(this.pathFieldListener);
    }

    protected void updateTree(final File file) {
        if (file != null) {
            this.fileTree.expandToFile(file, false, false, new Runnable(){

                @Override
                public void run() {
                    WebFileChooserPanel.this.fileTree.removeTreeSelectionListener(WebFileChooserPanel.this.fileTreeListener);
                    WebFileChooserPanel.this.fileTree.setSelectedNode(WebFileChooserPanel.this.fileTree.getNode(file));
                    WebFileChooserPanel.this.fileTree.addTreeSelectionListener(WebFileChooserPanel.this.fileTreeListener);
                }
            });
        } else {
            this.fileTree.clearSelection();
            this.fileTree.scrollToStart();
        }
    }

    protected void updateList(File file) {
        this.fileList.setDisplayedDirectory(file);
    }

    protected void updateTable(File file) {
        this.fileTable.setDisplayedDirectory(file);
    }

    protected void updateFiltersComboBox() {
        this.fileFilters.setModel(new DefaultComboBoxModel<Object>(this.availableFilters.toArray()));
    }

    public void setActiveFileFilter(AbstractFileFilter fileFilter) {
        this.setActiveFileFilter(fileFilter, true);
    }

    protected void setActiveFileFilter(AbstractFileFilter fileFilter, boolean select) {
        if (!this.availableFilters.contains(fileFilter)) {
            fileFilter = this.availableFilters.get(0);
        }
        this.fileFilter = fileFilter;
        if (select) {
            this.fileFilters.setSelectedItem(fileFilter);
        }
        this.updateFileComponentFilters();
    }

    protected void updateFileComponentFilters() {
        this.fileList.setFileFilter((FileFilter)this.applyHiddenFilesFilter((AbstractFileFilter)this.applyDirectoriesFilter(this.fileFilter)));
        this.fileTable.setFileFilter((AbstractFileFilter)this.applyHiddenFilesFilter((AbstractFileFilter)this.applyDirectoriesFilter(this.fileFilter)));
    }

    protected GroupedFileFilter applyDirectoriesFilter(AbstractFileFilter fileFilter) {
        return new GroupedFileFilter(this.getFileSelectionMode() == FileSelectionMode.directoriesOnly ? FilterGroupType.AND : FilterGroupType.OR, new FileFilter[]{fileFilter, GlobalConstants.DIRECTORIES_FILTER});
    }

    protected void updateDirectoryComponentFilters() {
        this.pathField.setFileFilter((AbstractFileFilter)this.applyHiddenFilesFilter((AbstractFileFilter)GlobalConstants.DIRECTORIES_FILTER));
        this.fileTree.setFileFilter((Filter<File>)this.applyHiddenFilesFilter((AbstractFileFilter)GlobalConstants.DIRECTORIES_FILTER));
    }

    protected GroupedFileFilter applyHiddenFilesFilter(AbstractFileFilter fileFilter) {
        return new GroupedFileFilter(FilterGroupType.AND, new FileFilter[]{fileFilter, this.hiddenFilesFilter});
    }

    public void reloadCurrentFolder() {
        if (this.currentFolder != null) {
            FileUtils.clearFilesCaches((File[])this.currentFolder.listFiles());
        }
        this.pathField.updatePath();
        this.fileTree.reloadChildren(this.currentFolder);
        this.fileList.reloadFiles();
        this.fileTable.reloadFiles();
    }

    public void editSelectedFileName() {
        if (this.viewType.getComponentIndex() == 0) {
            this.fileList.editSelectedCell();
        }
        if (this.viewType.getComponentIndex() == 1) {
            this.fileTable.editSelectedFileName();
        }
    }

    public void deleteSelectedFiles() {
        List<File> files = this.getAllSelectedFiles();
        if (files.isEmpty()) {
            return;
        }
        WebPanel all = new WebPanel((LayoutManager)new BorderLayout(0, 5), new Component[0]);
        all.add((Component)new WebLabel(LanguageManager.get((String)"weblaf.filechooser.delete.confirm.text")), (Object)"North");
        VerticalFlowLayout removalListLayout = new VerticalFlowLayout(0, 0, 5, true, false);
        WebPanel deleteFilesPanel = new WebPanel(StyleId.filechooserRemovalListPanel.at(this), removalListLayout, new Component[0]);
        for (File file : files) {
            deleteFilesPanel.add((Component)new WebLabel(file.getName(), FileUtils.getFileIcon((File)file), 2, new Object[0]));
        }
        WebScrollPane scroll = new WebScrollPane((Component)deleteFilesPanel){

            @Override
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                WebScrollPaneBar vsb = this.getVerticalScrollBar();
                if (vsb != null && vsb.isShowing()) {
                    ps.width += ((JComponent)vsb).getPreferredSize().width;
                }
                ps.height = Math.min(ps.height, 100);
                return ps;
            }
        };
        all.add((Component)scroll, (Object)"Center");
        String title = LanguageManager.get((String)"weblaf.filechooser.delete.confirm.title");
        int confirm = WebOptionPane.showConfirmDialog(this, all, title, 0, 3);
        if (confirm == 0) {
            FileUtils.deleteFiles(files);
            this.reloadCurrentFolder();
        }
    }

    public ActionListener getAcceptListener() {
        return this.acceptListener;
    }

    public void setAcceptListener(ActionListener acceptListener) {
        this.acceptListener = acceptListener;
    }

    public ActionListener getCancelListener() {
        return this.cancelListener;
    }

    public void setCancelListener(ActionListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    protected void fireAcceptAction(ActionEvent e) {
        if (this.acceptListener != null) {
            this.acceptListener.actionPerformed(e);
        }
    }

    protected void fireCancelAction(ActionEvent e) {
        if (this.cancelListener != null) {
            this.cancelListener.actionPerformed(e);
        }
    }

    public List<AbstractFileFilter> getAvailableFilters() {
        return this.availableFilters;
    }

    public AbstractFileFilter getActiveFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.setFileFilter(FileUtils.transformFileFilter((FileFilter)fileFilter));
    }

    public void setFileFilter(javax.swing.filechooser.FileFilter fileFilter) {
        this.setFileFilter(FileUtils.transformFileFilter((javax.swing.filechooser.FileFilter)fileFilter));
    }

    public void setFileFilter(AbstractFileFilter fileFilter) {
        this.availableFilters = Arrays.asList(fileFilter);
        this.updateFiltersComboBox();
        this.setActiveFileFilter(fileFilter);
    }

    public void setFileFilters(FileFilter[] fileFilters) {
        this.setFileFilters(0, fileFilters);
    }

    public void setFileFilters(int index, FileFilter[] fileFilters) {
        this.availableFilters = new ArrayList<AbstractFileFilter>(fileFilters.length);
        for (FileFilter fileFilter : fileFilters) {
            this.availableFilters.add(FileUtils.transformFileFilter((FileFilter)fileFilter));
        }
        this.updateFiltersComboBox();
        this.setActiveFileFilter(this.availableFilters.get(index));
    }

    public void setFileFilters(javax.swing.filechooser.FileFilter[] fileFilters) {
        this.setFileFilters(0, fileFilters);
    }

    public void setFileFilters(int index, javax.swing.filechooser.FileFilter[] fileFilters) {
        this.availableFilters = new ArrayList<AbstractFileFilter>(fileFilters.length);
        for (javax.swing.filechooser.FileFilter fileFilter : fileFilters) {
            this.availableFilters.add(FileUtils.transformFileFilter((javax.swing.filechooser.FileFilter)fileFilter));
        }
        this.updateFiltersComboBox();
        this.setActiveFileFilter(this.availableFilters.get(index));
    }

    public void setFileFilters(AbstractFileFilter[] fileFilters) {
        this.setFileFilters(0, fileFilters);
    }

    public void setFileFilters(int index, AbstractFileFilter[] fileFilters) {
        this.availableFilters = Arrays.asList(fileFilters);
        this.updateFiltersComboBox();
        this.setActiveFileFilter(this.availableFilters.get(index));
    }

    public void setFileFilters(List<AbstractFileFilter> fileFilters) {
        this.setFileFilters(0, fileFilters);
    }

    public void setFileFilters(int index, List<AbstractFileFilter> fileFilters) {
        this.availableFilters = CollectionUtils.copy(fileFilters);
        this.updateFiltersComboBox();
        this.setActiveFileFilter(this.availableFilters.get(index));
    }

    public boolean isShowControlButtons() {
        return this.showControlButtons;
    }

    public void setShowControlButtons(boolean showControlButtons) {
        this.showControlButtons = showControlButtons;
        this.updateControls();
    }

    protected void updateControls() {
        this.controlsPanel.remove(this.acceptButton, this.cancelButton);
        if (this.showControlButtons) {
            this.controlsPanel.add("END", this.acceptButton, this.cancelButton);
        }
        this.controlsPanel.revalidate();
    }

    public String getAcceptButtonText() {
        return this.acceptButton.getText();
    }

    public void restoreButtonText() {
        this.setAcceptButtonText((String)null);
    }

    public void setAcceptButtonText(String text) {
        if (text == null) {
            this.setAcceptButtonText(this.chooserType == FileChooserType.save ? FileAcceptText.save : (this.chooserType == FileChooserType.open ? FileAcceptText.open : FileAcceptText.choose));
        } else {
            this.acceptButton.removeLanguage();
            this.acceptButton.setText(text);
        }
    }

    public void setAcceptButtonText(FileAcceptText acceptText) {
        this.setAcceptButtonLanguage(acceptText.getLanguageKey());
    }

    public void setAcceptButtonLanguage(String key) {
        this.acceptButton.setLanguage(key, new Object[0]);
    }

    public FileChooserType getChooserType() {
        return this.chooserType;
    }

    public void setChooserType(FileChooserType chooserType) {
        this.chooserType = chooserType;
        this.updateSelectionMode();
        this.updateSelectedFilesFieldPanel();
        this.updateSelectedFilesField();
        this.restoreButtonText();
    }

    public FileSelectionMode getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public void setFileSelectionMode(FileSelectionMode fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
        this.updateFileComponentFilters();
        this.updateSelectedFilesField();
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
        this.updateDirectoryComponentFilters();
        this.updateFileComponentFilters();
    }

    public void addFileChooserListener(FileChooserListener listener) {
        this.chooserListeners.add(listener);
    }

    public void removeFileChooserListener(FileChooserListener listener) {
        this.chooserListeners.remove(listener);
    }

    protected void fireDirectoryChanged(File newDirectory) {
        for (FileChooserListener listener : CollectionUtils.copy(this.chooserListeners)) {
            listener.directoryChanged(newDirectory);
        }
    }

    protected void fireFileSelectionChanged(List<File> selectedFiles) {
        for (FileChooserListener listener : CollectionUtils.copy(this.chooserListeners)) {
            listener.selectionChanged(selectedFiles);
        }
    }

    protected void fireFileFilterChanged(javax.swing.filechooser.FileFilter oldFilter, javax.swing.filechooser.FileFilter newFilter) {
        for (FileChooserListener listener : CollectionUtils.copy(this.chooserListeners)) {
            listener.fileFilterChanged(oldFilter, newFilter);
        }
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
        this.updateSelectionMode();
    }

    protected void updateSelectionMode() {
        boolean ms = this.multiSelectionEnabled && this.chooserType != FileChooserType.save;
        int mode = ms ? 2 : 0;
        this.fileList.setSelectionMode(mode);
        this.fileTable.setSelectionMode(mode);
        this.selectedFilesViewField.setMultiSelectionEnabled(ms);
    }

    public boolean isGenerateThumbnails() {
        return this.fileList.isGenerateThumbnails();
    }

    public void setGenerateThumbnails(boolean generate) {
        this.fileList.setGenerateThumbnails(generate);
    }

    protected class HiddenFilesFilter
    extends NonHiddenFilter {
        protected HiddenFilesFilter() {
        }

        public ImageIcon getIcon() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public boolean accept(File file) {
            return WebFileChooserPanel.this.showHiddenFiles || !file.isHidden();
        }
    }

    protected class FilesLocateDropHandler
    extends FileDragAndDropHandler {
        protected UpdateSource updateSource;

        public FilesLocateDropHandler(UpdateSource updateSource) {
            this.updateSource = updateSource;
        }

        @Override
        public boolean filesDropped(List<File> files) {
            if (files.size() > 0) {
                File file = files.get(0);
                if (files.size() == 1 && FileUtils.isDirectory((File)file)) {
                    WebFileChooserPanel.this.updateCurrentFolder(file, this.updateSource);
                } else {
                    WebFileChooserPanel.this.updateCurrentFolder(file.getParentFile(), this.updateSource);
                    WebFileChooserPanel.this.setSelectedFiles(files);
                }
                return true;
            }
            return false;
        }
    }

    protected static enum UpdateSource {
        path,
        tree,
        list,
        table,
        toolbar,
        history,
        other;

    }
}

