/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.laf.WebFonts;
import com.alee.laf.button.WebButton;
import com.alee.laf.grouping.GroupPane;
import com.alee.laf.label.WebLabel;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.managers.style.StyleId;
import com.alee.utils.CompareUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import sun.swing.SwingUtilities2;

public class WebInternalFrameTitlePane
extends JComponent {
    protected static final String CLOSE_CMD = UIManager.getString("InternalFrameTitlePane.closeButtonText");
    protected static final String ICONIFY_CMD = UIManager.getString("InternalFrameTitlePane.minimizeButtonText");
    protected static final String RESTORE_CMD = UIManager.getString("InternalFrameTitlePane.restoreButtonText");
    protected static final String MAXIMIZE_CMD = UIManager.getString("InternalFrameTitlePane.maximizeButtonText");
    protected final JComponent parent;
    protected final JInternalFrame frame;
    protected WebLabel titleLabel;
    protected GroupPane buttonsPanel;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Handler handler;

    public WebInternalFrameTitlePane(JComponent parent, JInternalFrame frame) {
        this.parent = parent;
        this.frame = frame;
        this.initializeActions();
        this.initializeUI();
    }

    protected void initializeActions() {
        this.maximizeAction = new MaximizeAction();
        this.iconifyAction = new IconifyAction();
        this.closeAction = new CloseAction();
        this.restoreAction = new RestoreAction();
    }

    protected void initializeUI() {
        boolean isIconPane = this.parent instanceof JInternalFrame.JDesktopIcon;
        this.setLayout(new BorderLayout());
        Icon titleIcon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (WebInternalFrameTitlePane.this.frame.getFrameIcon() != null) {
                    WebInternalFrameTitlePane.this.frame.getFrameIcon().paintIcon(c, g, x, y);
                }
            }

            @Override
            public int getIconWidth() {
                return WebInternalFrameTitlePane.this.frame.getFrameIcon() != null ? WebInternalFrameTitlePane.this.frame.getFrameIcon().getIconWidth() : 16;
            }

            @Override
            public int getIconHeight() {
                return WebInternalFrameTitlePane.this.frame.getFrameIcon() != null ? WebInternalFrameTitlePane.this.frame.getFrameIcon().getIconHeight() : 16;
            }
        };
        this.titleLabel = new WebLabel(StyleId.internalframeTitleLabel.at(this.frame), titleIcon, 2){

            @Override
            public String getText() {
                return WebInternalFrameTitlePane.this.frame.getTitle();
            }
        };
        this.titleLabel.setFont(WebFonts.getSystemTitleFont());
        this.add((Component)this.titleLabel, "Center");
        this.buttonsPanel = new GroupPane(StyleId.internalframeButtonsPanel.at(this.parent), new Component[0]);
        this.buttonsPanel.setPaintSides(isIconPane, true, true, true);
        this.iconButton = new WebButton(StyleId.internalframeMinimizeButton.at(this.buttonsPanel));
        this.iconButton.setEnabled(this.frame.isIconifiable());
        this.iconButton.addActionListener(this.iconifyAction);
        if (this.frame.isIconifiable()) {
            this.buttonsPanel.add((Component)this.iconButton);
        }
        this.maxButton = new WebButton(StyleId.internalframeMaximizeButton.at(this.buttonsPanel));
        this.maxButton.setEnabled(this.frame.isMaximizable());
        this.maxButton.addActionListener(this.maximizeAction);
        if (this.frame.isMaximizable()) {
            this.buttonsPanel.add((Component)this.maxButton);
        }
        this.closeButton = new WebButton(StyleId.internalframeCloseButton.at(this.buttonsPanel));
        this.closeButton.setEnabled(this.frame.isClosable());
        this.closeButton.addActionListener(this.closeAction);
        if (this.frame.isClosable()) {
            this.buttonsPanel.add((Component)this.closeButton);
        }
        this.updateIcons();
        this.add((Component)this.buttonsPanel, "East");
    }

    protected void updateIcons() {
        this.iconButton.setIcon(this.frame.isIcon() ? WebRootPaneUI.restoreIcon : WebRootPaneUI.minimizeIcon);
        this.iconButton.setRolloverIcon(this.frame.isIcon() ? WebRootPaneUI.restoreActiveIcon : WebRootPaneUI.minimizeActiveIcon);
        this.maxButton.setIcon(this.frame.isIcon() ? WebRootPaneUI.maximizeIcon : (this.frame.isMaximum() ? WebRootPaneUI.restoreIcon : WebRootPaneUI.maximizeIcon));
        this.maxButton.setRolloverIcon(this.frame.isIcon() ? WebRootPaneUI.maximizeActiveIcon : (this.frame.isMaximum() ? WebRootPaneUI.restoreActiveIcon : WebRootPaneUI.maximizeActiveIcon));
        this.closeButton.setIcon(WebRootPaneUI.closeIcon);
        this.closeButton.setRolloverIcon(WebRootPaneUI.closeActiveIcon);
    }

    protected void updateActions() {
        this.restoreAction.setEnabled(this.frame.isMaximum() || this.frame.isIcon());
        this.maximizeAction.setEnabled(this.frame.isMaximizable() && !this.frame.isMaximum() && !this.frame.isIcon() || this.frame.isMaximizable() && this.frame.isIcon());
        this.iconifyAction.setEnabled(this.frame.isIconifiable() && !this.frame.isIcon());
        this.closeAction.setEnabled(this.frame.isClosable());
    }

    protected void install() {
        this.handler = new Handler();
        this.frame.addPropertyChangeListener(this.handler);
    }

    protected void uninstall() {
        this.frame.removePropertyChangeListener(this.handler);
        this.handler = null;
    }

    public class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(RESTORE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (WebInternalFrameTitlePane.this.frame.isMaximizable() && WebInternalFrameTitlePane.this.frame.isMaximum() && WebInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    WebInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (WebInternalFrameTitlePane.this.frame.isMaximizable() && WebInternalFrameTitlePane.this.frame.isMaximum()) {
                try {
                    WebInternalFrameTitlePane.this.frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (WebInternalFrameTitlePane.this.frame.isIconifiable() && WebInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    WebInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(ICONIFY_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WebInternalFrameTitlePane.this.frame.isIconifiable()) {
                if (!WebInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        WebInternalFrameTitlePane.this.frame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        WebInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(MAXIMIZE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (WebInternalFrameTitlePane.this.frame.isMaximizable()) {
                if (WebInternalFrameTitlePane.this.frame.isMaximum() && WebInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        WebInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (!WebInternalFrameTitlePane.this.frame.isMaximum()) {
                    try {
                        WebInternalFrameTitlePane.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        WebInternalFrameTitlePane.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(CLOSE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WebInternalFrameTitlePane.this.frame.isClosable()) {
                WebInternalFrameTitlePane.this.frame.doDefaultCloseAction();
            }
        }
    }

    protected class Handler
    implements LayoutManager,
    PropertyChangeListener {
        protected Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (CompareUtils.equals((Object)prop, (Object[])new Object[]{"frameIcon"})) {
                WebInternalFrameTitlePane.this.titleLabel.repaint();
            } else if (CompareUtils.equals((Object)prop, (Object[])new Object[]{"selected"})) {
                WebInternalFrameTitlePane.this.repaint();
            } else if (CompareUtils.equals((Object)prop, (Object[])new Object[]{"icon", "maximum"})) {
                WebInternalFrameTitlePane.this.updateIcons();
                WebInternalFrameTitlePane.this.updateActions();
            } else if (CompareUtils.equals((Object)prop, (Object[])new Object[]{"closable", "maximizable", "iconable"})) {
                WebInternalFrameTitlePane.this.buttonsPanel.removeAll();
                if (WebInternalFrameTitlePane.this.frame.isIconifiable()) {
                    WebInternalFrameTitlePane.this.buttonsPanel.add((Component)WebInternalFrameTitlePane.this.iconButton);
                }
                if (WebInternalFrameTitlePane.this.frame.isMaximizable()) {
                    WebInternalFrameTitlePane.this.buttonsPanel.add((Component)WebInternalFrameTitlePane.this.maxButton);
                }
                if (WebInternalFrameTitlePane.this.frame.isClosable()) {
                    WebInternalFrameTitlePane.this.buttonsPanel.add((Component)WebInternalFrameTitlePane.this.closeButton);
                }
                WebInternalFrameTitlePane.this.updateActions();
                WebInternalFrameTitlePane.this.revalidate();
                WebInternalFrameTitlePane.this.repaint();
            }
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 22;
            if (WebInternalFrameTitlePane.this.frame.isClosable()) {
                width += 19;
            }
            if (WebInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 19;
            }
            if (WebInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 19;
            }
            FontMetrics fm = WebInternalFrameTitlePane.this.frame.getFontMetrics(WebInternalFrameTitlePane.this.getFont());
            String frameTitle = WebInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? SwingUtilities2.stringWidth(WebInternalFrameTitlePane.this.frame, fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = SwingUtilities2.stringWidth(WebInternalFrameTitlePane.this.frame, fm, frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
            Icon icon = WebInternalFrameTitlePane.this.frame.getFrameIcon();
            int fontHeight = fm.getHeight();
            fontHeight += 2;
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            int height = Math.max(fontHeight, iconHeight += 2);
            Dimension dim = new Dimension(width, height);
            if (WebInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = WebInternalFrameTitlePane.this.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container c) {
            int x;
            boolean leftToRight = WebInternalFrameTitlePane.this.frame.getComponentOrientation().isLeftToRight();
            int w = WebInternalFrameTitlePane.this.getWidth();
            int h = WebInternalFrameTitlePane.this.getHeight();
            int buttonHeight = WebInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int n = x = leftToRight ? w - 16 - 2 : 2;
            if (WebInternalFrameTitlePane.this.frame.isClosable()) {
                WebInternalFrameTitlePane.this.closeButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (WebInternalFrameTitlePane.this.frame.isMaximizable()) {
                WebInternalFrameTitlePane.this.maxButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (WebInternalFrameTitlePane.this.frame.isIconifiable()) {
                WebInternalFrameTitlePane.this.iconButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
            }
        }
    }
}

