/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.laf.colorchooser.AdaptiveColorChooserPainter;
import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.ColorChooserPainter;
import com.alee.laf.colorchooser.IColorChooserPainter;
import com.alee.laf.colorchooser.WebColorChooserPanel;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicColorChooserUI;

public class WebColorChooserUI
extends BasicColorChooserUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=ColorChooserPainter.class)
    protected IColorChooserPainter painter;
    protected Insets margin = null;
    protected Insets padding = null;
    protected WebColorChooserPanel colorChooserPanel;
    protected ColorSelectionModel selectionModel;
    protected ChangeListener modelChangeListener;
    protected boolean modifying = false;

    public static ComponentUI createUI(JComponent c) {
        return new WebColorChooserUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.chooser = (JColorChooser)c;
        StyleManager.installSkin(this.chooser);
        this.selectionModel = this.chooser.getSelectionModel();
        this.chooser.setLayout(new BorderLayout());
        this.colorChooserPanel = new WebColorChooserPanel(false);
        this.colorChooserPanel.setColor(this.selectionModel.getSelectedColor());
        this.colorChooserPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!WebColorChooserUI.this.modifying) {
                    WebColorChooserUI.this.modifying = true;
                    WebColorChooserUI.this.selectionModel.setSelectedColor(WebColorChooserUI.this.colorChooserPanel.getColor());
                    WebColorChooserUI.this.modifying = false;
                }
            }
        });
        this.chooser.add((Component)this.colorChooserPanel, "Center");
        this.modelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!WebColorChooserUI.this.modifying) {
                    WebColorChooserUI.this.modifying = true;
                    WebColorChooserUI.this.colorChooserPanel.setColor(WebColorChooserUI.this.selectionModel.getSelectedColor());
                    WebColorChooserUI.this.modifying = false;
                }
            }
        };
        this.selectionModel.addChangeListener(this.modelChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.chooser);
        this.chooser.remove(this.colorChooserPanel);
        this.chooser.setLayout(null);
        this.selectionModel.removeChangeListener(this.modelChangeListener);
        this.modelChangeListener = null;
        this.colorChooserPanel = null;
        this.selectionModel = null;
        this.chooser = null;
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.chooser);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.chooser, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.chooser, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.chooser, new DataRunnable<IColorChooserPainter>(){

            public void run(IColorChooserPainter newPainter) {
                WebColorChooserUI.this.painter = newPainter;
            }
        }, this.painter, painter, IColorChooserPainter.class, AdaptiveColorChooserPainter.class);
    }

    public boolean isShowButtonsPanel() {
        return this.colorChooserPanel.isShowButtonsPanel();
    }

    public void setShowButtonsPanel(boolean showButtonsPanel) {
        this.colorChooserPanel.setShowButtonsPanel(showButtonsPanel);
    }

    public boolean isWebOnlyColors() {
        return this.colorChooserPanel.isWebOnlyColors();
    }

    public void setWebOnlyColors(boolean webOnlyColors) {
        this.colorChooserPanel.setWebOnlyColors(webOnlyColors);
    }

    public Color getOldColor() {
        return this.colorChooserPanel.getOldColor();
    }

    public void setOldColor(Color oldColor) {
        this.colorChooserPanel.setOldColor(oldColor);
    }

    public void resetResult() {
        this.colorChooserPanel.resetResult();
    }

    public void setResult(int result) {
        this.colorChooserPanel.setResult(result);
    }

    public int getResult() {
        return this.colorChooserPanel.getResult();
    }

    public void addColorChooserListener(ColorChooserListener colorChooserListener) {
        this.colorChooserPanel.addColorChooserListener(colorChooserListener);
    }

    public void removeColorChooserListener(ColorChooserListener colorChooserListener) {
        this.colorChooserPanel.removeColorChooserListener(colorChooserListener);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c), this.painter);
    }
}

