/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.extended.colorchooser.DoubleColorField;
import com.alee.extended.colorchooser.DoubleColorFieldListener;
import com.alee.extended.layout.TableLayout;
import com.alee.extended.layout.ToolbarLayout;
import com.alee.laf.button.WebButton;
import com.alee.laf.checkbox.WebCheckBox;
import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.HSBColor;
import com.alee.laf.colorchooser.LineColorChooser;
import com.alee.laf.colorchooser.PaletteColorChooser;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ColorUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.DialogOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WebColorChooserPanel
extends WebPanel
implements DialogOptions {
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private final List<ColorChooserListener> colorChooserListeners = new ArrayList<ColorChooserListener>(1);
    private boolean showButtonsPanel = false;
    private Boolean webOnlyColors = false;
    private Color oldColor = Color.WHITE;
    private Color color = Color.WHITE;
    private int result = -2;
    private boolean adjustingText = false;
    private final PaletteColorChooser palette;
    private final LineColorChooser lineColorChooser;
    private final DoubleColorField doubleColorField;
    private final WebTextField hueField;
    private final WebTextField saturationField;
    private final WebTextField brightnessField;
    private final WebTextField redField;
    private final WebTextField greenField;
    private final WebTextField blueField;
    private final WebTextField hexColor;
    private WebPanel buttonsPanel;

    public WebColorChooserPanel() {
        this(false);
    }

    public WebColorChooserPanel(boolean showButtonsPanel) {
        super(StyleId.colorchooserPanel);
        this.showButtonsPanel = showButtonsPanel;
        double p = -2.0;
        double f = -1.0;
        this.setLayout(new TableLayout(new double[][]{{-1.0, 4.0, -2.0, 4.0, -2.0}, {-2.0, -2.0}}));
        this.palette = new PaletteColorChooser();
        this.palette.setOpaque(false);
        this.palette.setWebOnlyColors(this.isWebOnlyColors());
        final ChangeListener paletteListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WebColorChooserPanel.this.color = WebColorChooserPanel.this.palette.getColor();
                WebColorChooserPanel.this.updateColors(WebColorChooserPanel.this.color, UpdateSource.palette);
            }
        };
        this.palette.addChangeListener(paletteListener);
        this.add((Component)this.palette, (Object)"0,0");
        this.lineColorChooser = new LineColorChooser();
        this.lineColorChooser.setOpaque(false);
        this.lineColorChooser.setWebOnlyColors(this.isWebOnlyColors());
        this.lineColorChooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WebColorChooserPanel.this.palette.setSideColor(WebColorChooserPanel.this.lineColorChooser.getColor());
            }
        });
        this.add((Component)this.lineColorChooser, (Object)"2,0");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new TableLayout(new double[][]{{-2.0, 4.0, -1.0}, {3.0, -1.0, 5.0, -2.0, 4.0, -2.0, 1.0, -2.0, 1.0, -2.0, 1.0, -2.0, 3.0}}));
        infoPanel.setOpaque(false);
        this.add((Component)infoPanel, (Object)"4,0");
        this.doubleColorField = new DoubleColorField();
        this.doubleColorField.addDoubleColorFieldListener(new DoubleColorFieldListener(){

            @Override
            public void newColorPressed(Color newColor) {
            }

            @Override
            public void oldColorPressed(Color currentColor) {
                WebColorChooserPanel.this.setColor(WebColorChooserPanel.this.doubleColorField.getOldColor());
            }
        });
        this.updateDoubleColorField(this.color);
        this.doubleColorField.setOldColor(this.oldColor);
        infoPanel.add((Component)this.doubleColorField, "0,1,2,3");
        infoPanel.add((Component)new WebSeparator(0), "0,5,2,5");
        JPanel colorsPanel = new JPanel();
        colorsPanel.setLayout(new TableLayout(new double[][]{{-1.0, 5.0, -2.0, 4.0, -2.0}, {-2.0, 0.0, -2.0, 0.0, -2.0, 1.0, -2.0, 1.0, -2.0, 0.0, -2.0, 0.0, -2.0}}));
        colorsPanel.setOpaque(false);
        infoPanel.add((Component)colorsPanel, "0,7,2,7");
        StyleId labelStyleId = StyleId.colorchooserLabel.at(this);
        colorsPanel.add((Component)new WebLabel(labelStyleId, "H:"), "0,0");
        this.hueField = new WebTextField();
        colorsPanel.add((Component)this.hueField, "2,0");
        colorsPanel.add((Component)new WebLabel(labelStyleId, "\u00b0"), "4,0");
        colorsPanel.add((Component)new WebLabel(labelStyleId, "S:"), "0,2");
        this.saturationField = new WebTextField();
        colorsPanel.add((Component)this.saturationField, "2,2");
        colorsPanel.add((Component)new WebLabel(labelStyleId, "%"), "4,2");
        colorsPanel.add((Component)new WebLabel(labelStyleId, "B:"), "0,4");
        this.brightnessField = new WebTextField();
        colorsPanel.add((Component)this.brightnessField, "2,4");
        colorsPanel.add((Component)new WebLabel(labelStyleId, "%"), "4,4");
        CaretListener hsbListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (!WebColorChooserPanel.this.adjustingText) {
                    WebColorChooserPanel.this.palette.removeChangeListener(paletteListener);
                    try {
                        float h = (float)Integer.parseInt(WebColorChooserPanel.this.hueField.getText()) / 360.0f;
                        float s = (float)Integer.parseInt(WebColorChooserPanel.this.saturationField.getText()) / 100.0f;
                        float b = (float)Integer.parseInt(WebColorChooserPanel.this.brightnessField.getText()) / 100.0f;
                        WebColorChooserPanel.this.color = new HSBColor(h, s, b).getColor();
                        WebColorChooserPanel.this.updateColors(WebColorChooserPanel.this.color, UpdateSource.hsbField);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    WebColorChooserPanel.this.palette.addChangeListener(paletteListener);
                }
            }
        };
        this.hueField.addCaretListener(hsbListener);
        this.saturationField.addCaretListener(hsbListener);
        this.brightnessField.addCaretListener(hsbListener);
        colorsPanel.add((Component)new WebSeparator(0), "0,6,4,6");
        colorsPanel.add((Component)new WebLabel(labelStyleId, "R:"), "0,8");
        this.redField = new WebTextField(3);
        colorsPanel.add((Component)this.redField, "2,8");
        colorsPanel.add((Component)new WebLabel(labelStyleId, "G:"), "0,10");
        this.greenField = new WebTextField(3);
        colorsPanel.add((Component)this.greenField, "2,10");
        colorsPanel.add((Component)new WebLabel(labelStyleId, "B:"), "0,12");
        this.blueField = new WebTextField(3);
        colorsPanel.add((Component)this.blueField, "2,12");
        CaretListener rgbListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (!WebColorChooserPanel.this.adjustingText) {
                    WebColorChooserPanel.this.palette.removeChangeListener(paletteListener);
                    try {
                        int r = Integer.parseInt(WebColorChooserPanel.this.redField.getText());
                        int g = Integer.parseInt(WebColorChooserPanel.this.greenField.getText());
                        int b = Integer.parseInt(WebColorChooserPanel.this.blueField.getText());
                        WebColorChooserPanel.this.color = new Color(r, g, b);
                        WebColorChooserPanel.this.updateColors(WebColorChooserPanel.this.color, UpdateSource.rgbField);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    WebColorChooserPanel.this.palette.addChangeListener(paletteListener);
                }
            }
        };
        this.redField.addCaretListener(rgbListener);
        this.greenField.addCaretListener(rgbListener);
        this.blueField.addCaretListener(rgbListener);
        infoPanel.add((Component)new WebSeparator(0), "0,9,2,9");
        WebLabel hexLabel = new WebLabel(labelStyleId, "#");
        infoPanel.add((Component)hexLabel, "0,11");
        this.hexColor = new WebTextField();
        this.updateHexField(this.color);
        CaretListener hexListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (!WebColorChooserPanel.this.adjustingText) {
                    WebColorChooserPanel.this.palette.removeChangeListener(paletteListener);
                    try {
                        WebColorChooserPanel.this.color = ColorUtils.parseHexColor((String)WebColorChooserPanel.this.hexColor.getText());
                        WebColorChooserPanel.this.updateColors(WebColorChooserPanel.this.color, UpdateSource.hexField);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    WebColorChooserPanel.this.palette.addChangeListener(paletteListener);
                }
            }
        };
        this.hexColor.addCaretListener(hexListener);
        infoPanel.add((Component)this.hexColor, "2,11");
        if (showButtonsPanel) {
            this.add((Component)this.getButtonsPanel(), (Object)"0,1,4,1");
        }
        this.setOldColor(this.oldColor);
        this.setColor(this.color);
    }

    private WebPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = this.createButtonsPanel();
        }
        return this.buttonsPanel;
    }

    private WebPanel createButtonsPanel() {
        StyleId controlsStyleId = StyleId.colorchooserControlsPanel.at(this);
        WebPanel controlsPanel = new WebPanel(controlsStyleId, new ToolbarLayout(2, 0), new Component[0]);
        StyleId webonlyStyleId = StyleId.colorchooserWebonlyCheck.at(controlsPanel);
        final WebCheckBox webOnly = new WebCheckBox(webonlyStyleId, "weblaf.colorchooser.webonly", this.isWebOnlyColors());
        webOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserPanel.this.setWebOnlyColors(webOnly.isSelected());
            }
        });
        controlsPanel.add((Component)webOnly);
        StyleId okId = StyleId.colorchooserOkButton.at(controlsPanel);
        final WebButton ok = new WebButton(okId, "weblaf.colorchooser.choose");
        ok.addHotkey(this, Hotkey.ENTER);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserPanel.this.result = 0;
                WebColorChooserPanel.this.fireOkPressed(e);
            }
        });
        this.palette.getColorChooser().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ok.doClick(0);
                }
            }
        });
        controlsPanel.add((Component)ok, (Object)"END");
        StyleId resetId = StyleId.colorchooserResetButton.at(controlsPanel);
        WebButton reset = new WebButton(resetId, "weblaf.colorchooser.reset");
        reset.addHotkey(this, Hotkey.ALT_R);
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserPanel.this.setColor(WebColorChooserPanel.this.getOldColor());
                WebColorChooserPanel.this.fireResetPressed(e);
            }
        });
        controlsPanel.add((Component)reset, (Object)"END");
        StyleId cancelId = StyleId.colorchooserCancelButton.at(controlsPanel);
        WebButton cancel = new WebButton(cancelId, "weblaf.colorchooser.cancel");
        cancel.addHotkey(this, Hotkey.ESCAPE);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserPanel.this.result = 1;
                WebColorChooserPanel.this.setColor(WebColorChooserPanel.this.getOldColor());
                WebColorChooserPanel.this.fireCancelPressed(e);
            }
        });
        controlsPanel.add((Component)cancel, (Object)"END");
        SwingUtils.equalizeComponentsWidth(Arrays.asList("text"), ok, reset, cancel);
        return controlsPanel;
    }

    public boolean isShowButtonsPanel() {
        return this.showButtonsPanel;
    }

    public void setShowButtonsPanel(boolean showButtonsPanel) {
        if (this.showButtonsPanel != showButtonsPanel) {
            this.showButtonsPanel = showButtonsPanel;
            if (showButtonsPanel) {
                this.add((Component)this.getButtonsPanel(), (Object)"0,1,4,1");
            } else {
                this.remove((Component)this.getButtonsPanel());
            }
            this.revalidate();
        }
    }

    public boolean isWebOnlyColors() {
        return this.webOnlyColors;
    }

    public void setWebOnlyColors(boolean webOnlyColors) {
        this.webOnlyColors = webOnlyColors;
        this.palette.setWebOnlyColors(webOnlyColors);
        this.lineColorChooser.setWebOnlyColors(webOnlyColors);
    }

    private void updateColors(Color color, UpdateSource updateSource) {
        this.adjustingText = true;
        if (!updateSource.equals((Object)UpdateSource.palette)) {
            this.updateView(color);
        }
        if (!updateSource.equals((Object)UpdateSource.doubleField)) {
            this.updateDoubleColorField(color);
        }
        if (!updateSource.equals((Object)UpdateSource.hsbField)) {
            this.updateHSBFields(color);
        }
        if (!updateSource.equals((Object)UpdateSource.rgbField)) {
            this.updateRGBFields(color);
        }
        if (!updateSource.equals((Object)UpdateSource.hexField)) {
            this.updateHexField(color);
        }
        this.adjustingText = false;
        this.fireStateChanged();
    }

    private void updateView(Color color) {
        this.lineColorChooser.setColor(color);
        this.palette.setSideColor(color);
        this.palette.setColor(color);
    }

    private void updateDoubleColorField(Color color) {
        this.doubleColorField.setNewColor(color);
    }

    private void updateHexField(Color color) {
        this.hexColor.setText(ColorUtils.getHexColor((Color)color).substring(1));
    }

    private void updateRGBFields(Color color) {
        this.redField.setText("" + color.getRed());
        this.greenField.setText("" + color.getGreen());
        this.blueField.setText("" + color.getBlue());
    }

    private void updateHSBFields(Color color) {
        float[] values = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.hueField.setText("" + this.lineColorChooser.getHue());
        this.saturationField.setText("" + Math.round(100.0f * values[1]));
        this.brightnessField.setText("" + Math.round(100.0f * values[2]));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.setOldColor(color);
        this.updateColors(color, UpdateSource.outer);
    }

    public Color getOldColor() {
        return this.oldColor;
    }

    public void setOldColor(Color oldColor) {
        this.oldColor = oldColor;
        this.doubleColorField.setOldColor(oldColor);
    }

    public void resetResult() {
        this.setResult(-2);
    }

    public void setResult(int result) {
        this.result = result;
    }

    public int getResult() {
        return this.result;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : CollectionUtils.copy(this.changeListeners)) {
            listener.stateChanged(changeEvent);
        }
    }

    public void addColorChooserListener(ColorChooserListener colorChooserListener) {
        this.colorChooserListeners.add(colorChooserListener);
    }

    public void removeColorChooserListener(ColorChooserListener colorChooserListener) {
        this.colorChooserListeners.remove(colorChooserListener);
    }

    private void fireOkPressed(ActionEvent actionEvent) {
        for (ColorChooserListener listener : CollectionUtils.copy(this.colorChooserListeners)) {
            listener.okPressed(actionEvent);
        }
    }

    private void fireResetPressed(ActionEvent actionEvent) {
        for (ColorChooserListener listener : CollectionUtils.copy(this.colorChooserListeners)) {
            listener.resetPressed(actionEvent);
        }
    }

    private void fireCancelPressed(ActionEvent actionEvent) {
        for (ColorChooserListener listener : CollectionUtils.copy(this.colorChooserListeners)) {
            listener.cancelPressed(actionEvent);
        }
    }

    private static enum UpdateSource {
        outer,
        palette,
        doubleField,
        hsbField,
        rgbField,
        hexField;

    }
}

