/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.extended.window.WebPopupWindow;
import com.alee.global.StyleConstants;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.WindowUtils;
import com.alee.utils.swing.PopupListener;
import com.alee.utils.swing.WebTimer;
import com.alee.utils.swing.WindowFollowBehavior;
import com.alee.utils.swing.WindowMethods;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JWindow;

public class WebPopup
extends WebPanel
implements WindowMethods<JWindow> {
    protected List<PopupListener> listeners = new ArrayList<PopupListener>(2);
    protected boolean closeOnOuterAction = true;
    protected boolean followInvoker = false;
    protected boolean alwaysOnTop = false;
    protected float opacity = 1.0f;
    protected boolean animate = true;
    protected float stepProgress = 0.05f;
    protected float displayProgress = 0.0f;
    protected final Object sync = new Object();
    protected boolean displaying = false;
    protected boolean hiding = false;
    protected WebTimer showAnimator = null;
    protected WebTimer hideAnimator = null;
    protected final List<Runnable> onFullDisplay = new ArrayList<Runnable>();
    protected final List<Runnable> onFullHide = new ArrayList<Runnable>();
    protected final Object lsync = new Object();
    protected WebPopupWindow window;
    protected Component invoker;
    protected Window invokerWindow;
    protected AWTEventListener mouseListener;
    protected GlobalFocusListener focusListener;
    protected WindowFollowBehavior followAdapter;

    public WebPopup() {
        super(StyleId.popup);
    }

    public WebPopup(Component component) {
        super(StyleId.popup, component);
    }

    public WebPopup(LayoutManager layout, Component ... components) {
        super(StyleId.popup, layout, components);
    }

    public WebPopup(StyleId styleId) {
        super(styleId);
    }

    public WebPopup(StyleId styleId, Component component) {
        super(styleId, component);
    }

    public WebPopup(StyleId styleId, LayoutManager layout, Component ... components) {
        super(styleId, layout, components);
    }

    public boolean isCloseOnOuterAction() {
        return this.closeOnOuterAction;
    }

    public void setCloseOnOuterAction(boolean closeOnOuterAction) {
        this.closeOnOuterAction = closeOnOuterAction;
    }

    public JWindow getWindow() {
        return this.window;
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public Window getInvokerWindow() {
        return this.invokerWindow;
    }

    public float getDisplayProgress() {
        return this.displayProgress;
    }

    public boolean isDisplaying() {
        return this.displaying;
    }

    public boolean isHiding() {
        return this.hiding;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        this.setWindowOpaque(isOpaque);
    }

    @Override
    public JWindow setWindowOpaque(boolean opaque) {
        return this.updateOpaque();
    }

    protected JWindow updateOpaque() {
        if (this.window != null) {
            WindowUtils.setWindowOpaque(this.window, this.isOpaque());
        }
        return this.window;
    }

    @Override
    public boolean isWindowOpaque() {
        return this.isOpaque();
    }

    @Override
    public JWindow setWindowOpacity(float opacity) {
        this.opacity = opacity;
        return this.updateOpacity();
    }

    protected JWindow updateOpacity() {
        if (this.window != null) {
            WindowUtils.setWindowOpacity(this.window, this.opacity * this.displayProgress);
        }
        return this.window;
    }

    @Override
    public float getWindowOpacity() {
        return this.opacity;
    }

    public boolean isFollowInvoker() {
        return this.followInvoker;
    }

    public void setFollowInvoker(boolean followInvoker) {
        this.followInvoker = followInvoker;
        if (followInvoker) {
            if (this.window != null && this.followAdapter == null && this.invokerWindow != null) {
                this.installFollowAdapter();
            }
        } else if (this.window != null && this.followAdapter != null && this.invokerWindow != null) {
            this.uninstallFollowAdapter();
        }
    }

    protected void installFollowAdapter() {
        this.followAdapter = WindowFollowBehavior.install(this.window, this.invokerWindow);
    }

    protected void uninstallFollowAdapter() {
        WindowFollowBehavior.uninstall(this.window, this.invokerWindow);
        this.followAdapter = null;
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.alwaysOnTop = alwaysOnTop;
        if (this.window != null) {
            this.window.setAlwaysOnTop(alwaysOnTop);
        }
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public float getStepProgress() {
        return this.stepProgress;
    }

    public void setStepProgress(float stepProgress) {
        this.stepProgress = stepProgress;
    }

    public WebPopup showPopup(Component invoker, Point location) {
        return this.showPopup(invoker, location.x, location.y);
    }

    public WebPopup showPopup(Component invoker, int x, int y) {
        this.showPopupImpl(invoker, x, y);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showPopupImpl(Component invoker, int x, int y) {
        Object object = this.sync;
        synchronized (object) {
            if (this.displaying || !this.hiding && this.window != null) {
                return;
            }
            if (this.hiding) {
                if (this.hideAnimator != null) {
                    this.hideAnimator.stop();
                    this.hideAnimator = null;
                }
                this.hiding = false;
                this.completePopupHide();
            }
            this.displaying = true;
            this.invoker = invoker;
            this.invokerWindow = SwingUtils.getWindowAncestor((Component)invoker);
            this.displayProgress = this.animate ? 0.0f : 1.0f;
            this.window = this.createWindow();
            this.window.add(this);
            if (this.invokerWindow != null) {
                Rectangle bos = SwingUtils.getBoundsOnScreen(invoker);
                this.window.setLocation(bos.x + x, bos.y + y);
            } else {
                this.window.setLocation(x, y);
            }
            this.window.pack();
            this.window.setAlwaysOnTop(this.alwaysOnTop);
            this.updateOpaque();
            this.updateOpacity();
            this.firePopupWillBeOpened();
            this.mouseListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    Component component;
                    MouseEvent e;
                    if (WebPopup.this.closeOnOuterAction && (e = (MouseEvent)event).getID() == 501 && WebPopup.this.window != (component = e.getComponent()) && !WebPopup.this.window.isAncestorOf(component)) {
                        WebPopup.this.hidePopup();
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this.mouseListener, 16L);
            this.focusListener = new GlobalFocusListener(){

                @Override
                public void focusChanged(Component oldFocus, Component newFocus) {
                    if (WebPopup.this.closeOnOuterAction && newFocus == null) {
                        WebPopup.this.hidePopup();
                    }
                }
            };
            FocusManager.registerGlobalFocusListener(this.focusListener);
            this.window.setVisible(true);
            this.transferFocus();
            if (this.animate) {
                this.showAnimator = WebTimer.repeat((long)StyleConstants.fps48, (long)0L, (ActionListener)new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object object = WebPopup.this.sync;
                        synchronized (object) {
                            if (WebPopup.this.displayProgress < 1.0f) {
                                WebPopup.this.displayProgress = Math.min(WebPopup.this.displayProgress + WebPopup.this.stepProgress, 1.0f);
                                WebPopup.this.setWindowOpacity(WebPopup.this.displayProgress);
                            } else {
                                WebPopup.this.showAnimator.stop();
                                WebPopup.this.showAnimator = null;
                                WebPopup.this.displaying = false;
                                WebPopup.this.fullyDisplayed();
                            }
                            WebPopup.this.showAnimationStepPerformed();
                        }
                    }
                });
            }
            if (this.followInvoker && this.invokerWindow != null) {
                this.installFollowAdapter();
            }
            if (!this.animate) {
                this.displaying = false;
            }
            this.firePopupOpened();
            if (!this.animate) {
                this.fullyDisplayed();
            }
        }
    }

    protected WebPopupWindow createWindow() {
        return new WebPopupWindow(this.invokerWindow);
    }

    public WebPopup hidePopup() {
        this.hidePopupImpl();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hidePopupImpl() {
        Object object = this.sync;
        synchronized (object) {
            if (this.hiding || this.window == null || this.window != null && !this.window.isShowing()) {
                return;
            }
            this.hiding = true;
            if (this.displaying) {
                if (this.showAnimator != null) {
                    this.showAnimator.stop();
                }
                this.displaying = false;
            }
            float f = this.displayProgress = this.animate ? 1.0f : 0.0f;
            if (this.animate) {
                this.hideAnimator = WebTimer.repeat((long)StyleConstants.fps48, (long)0L, (ActionListener)new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object object = WebPopup.this.sync;
                        synchronized (object) {
                            if (WebPopup.this.displayProgress > 0.0f) {
                                WebPopup.this.displayProgress = Math.max(WebPopup.this.displayProgress - WebPopup.this.stepProgress, 0.0f);
                                WebPopup.this.setWindowOpacity(WebPopup.this.displayProgress);
                            } else {
                                WebPopup.this.completePopupHide();
                                WebPopup.this.hideAnimator.stop();
                                WebPopup.this.hideAnimator = null;
                                WebPopup.this.hiding = false;
                            }
                            WebPopup.this.hideAnimationStepPerformed();
                        }
                    }
                });
            } else {
                this.completePopupHide();
            }
        }
    }

    protected void completePopupHide() {
        this.firePopupWillBeClosed();
        if (this.followInvoker && this.invokerWindow != null) {
            this.uninstallFollowAdapter();
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.mouseListener);
        this.mouseListener = null;
        FocusManager.unregisterGlobalFocusListener(this.focusListener);
        this.focusListener = null;
        this.invokerWindow = null;
        this.invoker = null;
        this.window.dispose();
        this.window = null;
        this.firePopupClosed();
        this.fullyHidden();
    }

    protected void showAnimationStepPerformed() {
    }

    protected void hideAnimationStepPerformed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFullDisplay(Runnable action) {
        Object object = this.lsync;
        synchronized (object) {
            if (!this.isShowing() || this.isDisplaying()) {
                this.onFullDisplay.add(action);
            } else if (this.isShowing() && !this.isHiding()) {
                action.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullyDisplayed() {
        Object object = this.lsync;
        synchronized (object) {
            for (Runnable runnable : this.onFullDisplay) {
                runnable.run();
            }
            this.onFullDisplay.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFullHide(Runnable action) {
        Object object = this.lsync;
        synchronized (object) {
            if (this.isShowing()) {
                this.onFullHide.add(action);
            } else {
                action.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullyHidden() {
        Object object = this.lsync;
        synchronized (object) {
            for (Runnable runnable : this.onFullHide) {
                runnable.run();
            }
            this.onFullHide.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPopupListener(PopupListener listener) {
        Object object = this.lsync;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePopupListener(PopupListener listener) {
        Object object = this.lsync;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePopupWillBeOpened() {
        Object object = this.lsync;
        synchronized (object) {
            for (PopupListener listener : CollectionUtils.copy(this.listeners)) {
                listener.popupWillBeOpened();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePopupOpened() {
        Object object = this.lsync;
        synchronized (object) {
            for (PopupListener listener : CollectionUtils.copy(this.listeners)) {
                listener.popupOpened();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePopupWillBeClosed() {
        Object object = this.lsync;
        synchronized (object) {
            for (PopupListener listener : CollectionUtils.copy(this.listeners)) {
                listener.popupWillBeClosed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePopupClosed() {
        Object object = this.lsync;
        synchronized (object) {
            for (PopupListener listener : CollectionUtils.copy(this.listeners)) {
                listener.popupClosed();
            }
        }
    }

    public JWindow pack() {
        if (this.window != null) {
            this.window.pack();
        }
        return this.window;
    }

    @Override
    public JWindow center() {
        return WindowUtils.center(this.window);
    }

    @Override
    public JWindow center(Component relativeTo) {
        return WindowUtils.center(this.window, relativeTo);
    }

    @Override
    public JWindow center(int width, int height) {
        return WindowUtils.center(this.window, width, height);
    }

    @Override
    public JWindow center(Component relativeTo, int width, int height) {
        return WindowUtils.center(this.window, relativeTo, width, height);
    }

    @Override
    public JWindow packToWidth(int width) {
        return WindowUtils.packToWidth(this.window, width);
    }

    @Override
    public JWindow packToHeight(int height) {
        return WindowUtils.packToHeight(this.window, height);
    }

    @Override
    public JWindow packAndCenter() {
        return WindowUtils.packAndCenter(this.window);
    }

    @Override
    public JWindow packAndCenter(boolean animate) {
        return WindowUtils.packAndCenter(this.window, animate);
    }
}

