/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AbstractAsyncTreeDataProvider;
import com.alee.extended.tree.ChildrenListener;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.FileTreeNodeComparator;
import com.alee.extended.tree.FileTreeNodeFilter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.compare.Filter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileTreeDataProvider
extends AbstractAsyncTreeDataProvider<FileTreeNode> {
    protected List<File> rootFiles;

    public FileTreeDataProvider(File ... rootFiles) {
        this.rootFiles = CollectionUtils.asList((Object[])rootFiles);
        this.comparator = new FileTreeNodeComparator();
        this.filter = new FileTreeNodeFilter();
    }

    public FileTreeDataProvider(List<File> rootFiles) {
        this.rootFiles = rootFiles;
        this.comparator = new FileTreeNodeComparator();
        this.filter = new FileTreeNodeFilter();
    }

    public FileTreeDataProvider(Filter<FileTreeNode> filter, File ... rootFiles) {
        this.rootFiles = CollectionUtils.asList((Object[])rootFiles);
        this.comparator = new FileTreeNodeComparator();
        this.filter = filter;
    }

    public FileTreeDataProvider(Filter<FileTreeNode> filter, List<File> rootFiles) {
        this.rootFiles = rootFiles;
        this.comparator = new FileTreeNodeComparator();
        this.filter = filter;
    }

    @Override
    public FileTreeNode getRoot() {
        return this.rootFiles.size() == 1 ? new FileTreeNode(this.rootFiles.get(0)) : new FileTreeNode(null);
    }

    @Override
    public void loadChildren(FileTreeNode parent, ChildrenListener<FileTreeNode> listener) {
        try {
            listener.loadCompleted(parent.getFile() == null ? this.getRootChildren() : this.getFileChildren(parent));
        }
        catch (Throwable cause) {
            listener.loadFailed(cause);
        }
    }

    protected List<FileTreeNode> getRootChildren() {
        ArrayList<FileTreeNode> children = new ArrayList<FileTreeNode>(this.rootFiles.size());
        for (File rootFile : this.rootFiles) {
            children.add(new FileTreeNode(rootFile));
        }
        return children;
    }

    public List<FileTreeNode> getFileChildren(FileTreeNode node) {
        File[] childrenArray = node.getFile().listFiles();
        if (childrenArray == null || childrenArray.length == 0) {
            return new ArrayList<FileTreeNode>(0);
        }
        ArrayList<FileTreeNode> children = new ArrayList<FileTreeNode>(childrenArray.length);
        for (File f : childrenArray) {
            children.add(new FileTreeNode(f));
        }
        return children;
    }

    @Override
    public Filter<FileTreeNode> getChildrenFilter(FileTreeNode node) {
        return node.getFile() == null ? null : super.getChildrenFilter(node);
    }

    @Override
    public boolean isLeaf(FileTreeNode node) {
        return node.getFile() != null && !FileUtils.isDirectory((File)node.getFile());
    }
}

