/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.ExTreeDataProvider;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.collection.DoubleMap;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ExTreeModel<E extends UniqueNode>
extends WebTreeModel<E> {
    protected final WebTree<E> tree;
    protected final ExTreeDataProvider<E> dataProvider;
    protected E rootNode = null;
    protected final Object cacheLock = new Object();
    protected final Map<String, Boolean> nodeCached = new HashMap<String, Boolean>();
    protected final Map<String, List<E>> rawNodeChildrenCache = new HashMap<String, List<E>>();
    protected final DoubleMap<String, E> nodeById = new DoubleMap();

    public ExTreeModel(WebTree<E> tree, ExTreeDataProvider<E> dataProvider) {
        super(null);
        this.tree = tree;
        this.dataProvider = dataProvider;
        this.loadTreeData((UniqueNode)this.getRootNode());
    }

    public ExTreeDataProvider<E> getDataProvider() {
        return this.dataProvider;
    }

    public E getRoot() {
        if (this.rootNode == null) {
            this.rootNode = this.dataProvider.getRoot();
            this.cacheNodeById(this.rootNode);
        }
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.dataProvider.isLeaf((UniqueNode)node);
    }

    @Override
    public int getChildCount(Object parent) {
        UniqueNode node = (UniqueNode)parent;
        if (this.isLeaf(node)) {
            return 0;
        }
        if (this.areChildrenLoaded(node)) {
            return super.getChildCount(parent);
        }
        return this.loadChildren(node);
    }

    public E getChild(Object parent, int index) {
        return (E)((UniqueNode)super.getChild(parent, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areChildrenLoaded(E node) {
        Object object = this.cacheLock;
        synchronized (object) {
            Boolean cached = this.nodeCached.get(((UniqueNode)node).getId());
            return cached != null && cached != false;
        }
    }

    protected void loadTreeData(E node) {
        this.getChildCount(node);
    }

    @Override
    public void reload(TreeNode node) {
        UniqueNode reloadedNode = (UniqueNode)node;
        this.tree.cancelEditing();
        this.clearNodeChildrenCache(reloadedNode, false);
        reloadedNode.removeAllChildren();
        super.reload(reloadedNode);
        this.loadTreeData(reloadedNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildrenCache(E node, boolean clearNode) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (clearNode) {
                this.nodeById.remove((Object)((UniqueNode)node).getId());
            }
            this.nodeCached.remove(((UniqueNode)node).getId());
            List<E> children = this.rawNodeChildrenCache.remove(((UniqueNode)node).getId());
            if (children != null) {
                this.clearNodeChildrenCache(children, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildrenCache(List<E> nodes, boolean clearNodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (UniqueNode node : nodes) {
                this.clearNodeChildrenCache(node, clearNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeChildrenCache(E[] nodes, boolean clearNodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (E node : nodes) {
                this.clearNodeChildrenCache(node, clearNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheNodeById(E node) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.nodeById.put((Object)((UniqueNode)node).getId(), node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheNodesById(List<E> nodes) {
        Object object = this.cacheLock;
        synchronized (object) {
            for (UniqueNode node : nodes) {
                this.nodeById.put((Object)node.getId(), (Object)node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadChildren(E parent) {
        List<E> children = this.dataProvider.getChildren(parent);
        Object object = this.cacheLock;
        synchronized (object) {
            this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), children);
            this.cacheNodesById(children);
        }
        List<E> realChildren = this.filterAndSort(parent, children);
        Object object2 = this.cacheLock;
        synchronized (object2) {
            this.nodeCached.put(((UniqueNode)parent).getId(), true);
        }
        if (realChildren != null && realChildren.size() > 0) {
            this.insertNodesIntoImpl(realChildren, parent, 0);
        }
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildNodes(E parent, final List<E> children) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), children);
            this.cacheNodesById(children);
        }
        final List<E> realChildren = this.filterAndSort(parent, children);
        Object object2 = this.cacheLock;
        synchronized (object2) {
            this.nodeCached.put(((UniqueNode)parent).getId(), true);
        }
        SwingUtils.invokeLater((Runnable)new Runnable((UniqueNode)parent){
            final /* synthetic */ UniqueNode val$parent;
            {
                this.val$parent = uniqueNode;
            }

            @Override
            public void run() {
                if (realChildren != null && realChildren.size() > 0) {
                    ExTreeModel.this.clearNodeChildrenCache(children, false);
                    ExTreeModel.this.insertNodesIntoImpl(realChildren, this.val$parent, 0);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNodes(E parent, List<E> children) {
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList(children.size());
                this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), cachedChildren);
            }
            cachedChildren.addAll(children);
            this.cacheNodesById(children);
        }
        this.clearNodeChildrenCache(children, false);
        this.insertNodesIntoImpl(children, parent, ((DefaultMutableTreeNode)parent).getChildCount());
        this.updateSortingAndFiltering(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        if (node == null) {
            return;
        }
        UniqueNode childNode = (UniqueNode)node;
        UniqueNode parentNode = childNode.getParent();
        if (parentNode == null) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> children = this.rawNodeChildrenCache.get(parentNode.getId());
            if (children != null) {
                children.remove(childNode);
            }
        }
        this.clearNodeChildrenCache(childNode, true);
        childNode.removeAllChildren();
        super.removeNodeFromParent(node);
        this.updateSortingAndFiltering(parentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        UniqueNode childNode = (UniqueNode)newChild;
        UniqueNode parentNode = (UniqueNode)parent;
        Object object = this.cacheLock;
        synchronized (object) {
            List<UniqueNode> children = this.rawNodeChildrenCache.get(parentNode.getId());
            if (children == null) {
                children = new ArrayList(1);
                this.rawNodeChildrenCache.put(parentNode.getId(), children);
            }
            children.add(index, childNode);
            this.cacheNodeById(childNode);
        }
        this.clearNodeChildrenCache(childNode, false);
        this.insertNodeIntoImpl(childNode, parentNode, index);
        this.updateSortingAndFiltering(parentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodesInto(List<E> children, E parent, int index) {
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList(1);
                this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), cachedChildren);
            }
            cachedChildren.addAll(index, children);
            this.cacheNodesById(children);
        }
        this.clearNodeChildrenCache(children, false);
        this.insertNodesIntoImpl(children, parent, index);
        this.updateSortingAndFiltering(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNodesInto(E[] children, E parent, int index) {
        Object object = this.cacheLock;
        synchronized (object) {
            List<E> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList(1);
                this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), cachedChildren);
            }
            for (int i = children.length - 1; i >= 0; --i) {
                cachedChildren.add(index, children[i]);
            }
            this.cacheNodesById(Arrays.asList(children));
        }
        this.clearNodeChildrenCache((E)children, false);
        this.insertNodesIntoImpl((UniqueNode[])children, (UniqueNode)parent, index);
        this.updateSortingAndFiltering(parent);
    }

    protected void insertNodeIntoImpl(E child, E parent, int index) {
        super.insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
        this.loadTreeData(child);
    }

    protected void insertNodesIntoImpl(List<E> children, E parent, int index) {
        super.insertNodesInto(children, parent, index);
        for (UniqueNode child : children) {
            this.loadTreeData(child);
        }
    }

    protected void insertNodesIntoImpl(E[] children, E parent, int index) {
        super.insertNodesInto(children, parent, index);
        for (E child : children) {
            this.loadTreeData(child);
        }
    }

    public void updateSortingAndFiltering() {
        this.updateSortingAndFiltering(this.getRoot(), true);
    }

    public void updateSortingAndFiltering(E parentNode) {
        this.updateSortingAndFiltering(parentNode, false);
    }

    public void updateSortingAndFiltering(E parentNode, boolean recursively) {
        if (parentNode != null) {
            this.performSortingAndFiltering(parentNode, recursively);
        }
    }

    protected void performSortingAndFiltering(E parentNode, boolean recursively) {
        TreeState treeState = this.tree.getTreeState();
        if (recursively) {
            this.performSortingAndFilteringRecursivelyImpl(parentNode);
        } else {
            this.performSortingAndFilteringImpl(parentNode);
        }
        this.nodeStructureChanged((TreeNode)parentNode);
        this.tree.setTreeState(treeState);
    }

    protected void performSortingAndFilteringRecursivelyImpl(E parentNode) {
        this.performSortingAndFilteringImpl(parentNode);
        for (int i = 0; i < ((DefaultMutableTreeNode)parentNode).getChildCount(); ++i) {
            this.performSortingAndFilteringRecursivelyImpl((UniqueNode)((DefaultMutableTreeNode)parentNode).getChildAt(i));
        }
    }

    protected void performSortingAndFilteringImpl(E parentNode) {
        List<E> children = this.rawNodeChildrenCache.get(((UniqueNode)parentNode).getId());
        if (children != null) {
            ((DefaultMutableTreeNode)parentNode).removeAllChildren();
            List<E> realChildren = this.filterAndSort(parentNode, children);
            for (UniqueNode child : realChildren) {
                ((DefaultMutableTreeNode)parentNode).add(child);
            }
        }
    }

    protected List<E> filterAndSort(E parentNode, List<E> children) {
        if (children == null || children.size() == 0) {
            return new ArrayList(0);
        }
        Filter<E> filter = this.dataProvider.getChildrenFilter(parentNode);
        Comparator<E> comparator = this.dataProvider.getChildrenComparator(parentNode);
        if (filter != null) {
            ArrayList filtered = CollectionUtils.filter(children, filter);
            if (comparator != null) {
                Collections.sort(filtered, comparator);
            }
            return filtered;
        }
        if (comparator != null) {
            children = CollectionUtils.copy(children);
            Collections.sort(children, comparator);
        }
        return children;
    }

    public E findNode(String nodeId) {
        return (E)((UniqueNode)this.nodeById.get((Object)nodeId));
    }

    public DoubleMap<String, E> getNodesCache() {
        return MapUtils.copyDoubleMap(this.nodeById);
    }
}

