/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.NodesDropHandler;
import com.alee.extended.tree.NodesTransferable;
import com.alee.extended.tree.TreeDropHandler;
import com.alee.laf.tree.TreeUtils;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.utils.CollectionUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTransferHandler<N extends UniqueNode, T extends WebTree<N>, M extends WebTreeModel<N>>
extends TransferHandler {
    protected boolean optimizeDraggedNodes = true;
    protected boolean expandSingleNode = false;
    protected boolean expandMultiplyNodes = false;
    protected List<TreeDropHandler<N, T>> dropHandlers = this.createDropHandlers();
    protected List<N> draggedNodes;
    protected Map<String, List<Integer>> draggedNodeIndices;

    protected List<TreeDropHandler<N, T>> createDropHandlers() {
        return CollectionUtils.asList((Object[])new TreeDropHandler[]{new NodesDropHandler()});
    }

    public boolean isOptimizeDraggedNodes() {
        return this.optimizeDraggedNodes;
    }

    public void setOptimizeDraggedNodes(boolean optimize) {
        this.optimizeDraggedNodes = optimize;
    }

    public boolean isExpandSingleNode() {
        return this.expandSingleNode;
    }

    public void setExpandSingleNode(boolean expand) {
        this.expandSingleNode = expand;
    }

    public boolean isExpandMultiplyNodes() {
        return this.expandMultiplyNodes;
    }

    public void setExpandMultiplyNodes(boolean expand) {
        this.expandMultiplyNodes = expand;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        WebTree tree = (WebTree)c;
        List nodes = tree.getSelectedNodes();
        if (!nodes.isEmpty()) {
            if (nodes.contains(tree.getRootNode())) {
                return null;
            }
            if (this.optimizeDraggedNodes) {
                TreeUtils.optimizeNodes(nodes);
            }
            if (!this.canBeDragged(tree, nodes)) {
                return null;
            }
            ArrayList<UniqueNode> copies = new ArrayList<UniqueNode>();
            for (UniqueNode node : nodes) {
                copies.add(this.copy(tree, node));
            }
            this.draggedNodes = nodes;
            this.draggedNodeIndices = new HashMap<String, List<Integer>>(1);
            for (UniqueNode node : this.draggedNodes) {
                UniqueNode parent = node.getParent();
                List<Integer> indices = this.draggedNodeIndices.get(parent.getId());
                if (indices == null) {
                    indices = new ArrayList<Integer>(1);
                    this.draggedNodeIndices.put(parent.getId(), indices);
                }
                indices.add(parent.getIndex(node));
            }
            return this.createTransferable(tree, copies);
        }
        return null;
    }

    protected abstract boolean canBeDragged(T var1, List<N> var2);

    protected abstract N copy(T var1, N var2);

    protected Transferable createTransferable(T tree, List<N> nodes) {
        return new NodesTransferable<N>(nodes);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        UniqueNode destination;
        if (!support.isDrop()) {
            return false;
        }
        List<TreeDropHandler<N, T>> dropHandlers = this.getSupportedDropHandlers(support);
        if (CollectionUtils.isEmpty(dropHandlers)) {
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath path = dl.getPath();
        if (path == null) {
            return false;
        }
        WebTree tree = (WebTree)support.getComponent();
        if (!this.canDropTo(tree, destination = (UniqueNode)path.getLastPathComponent())) {
            return false;
        }
        if (this.isMoveAction(support.getDropAction()) && this.draggedNodes != null) {
            for (UniqueNode node : this.draggedNodes) {
                if (node != destination && !node.isNodeDescendant(destination)) continue;
                return false;
            }
        }
        boolean canBeDropped = false;
        for (TreeDropHandler<UniqueNode, WebTree> treeDropHandler : dropHandlers) {
            if (!treeDropHandler.canDrop(support, tree, destination)) continue;
            canBeDropped = true;
            break;
        }
        support.setShowDropLocation(canBeDropped);
        return canBeDropped;
    }

    protected List<TreeDropHandler<N, T>> getSupportedDropHandlers(TransferHandler.TransferSupport support) {
        ArrayList<TreeDropHandler<N, T>> handlers = new ArrayList<TreeDropHandler<N, T>>(this.dropHandlers.size());
        block0: for (TreeDropHandler<N, T> dropHandler : this.dropHandlers) {
            List<DataFlavor> flavors = dropHandler.getSupportedFlavors();
            if (CollectionUtils.isEmpty(flavors)) continue;
            for (DataFlavor flavor : flavors) {
                if (!support.isDataFlavorSupported(flavor)) continue;
                handlers.add(dropHandler);
                continue block0;
            }
        }
        return handlers;
    }

    protected boolean canDropTo(T tree, N destination) {
        return destination != null;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        TreeDropHandler<UniqueNode, WebTree> dropHandler;
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        int dropIndex = dl.getChildIndex();
        TreePath dest = dl.getPath();
        UniqueNode parent = (UniqueNode)dest.getLastPathComponent();
        WebTree tree = (WebTree)support.getComponent();
        WebTreeModel model = (WebTreeModel)tree.getModel();
        List<UniqueNode> nodes = null;
        Iterator<TreeDropHandler<N, T>> iterator = this.getSupportedDropHandlers(support).iterator();
        while (iterator.hasNext() && CollectionUtils.isEmpty(nodes = (dropHandler = iterator.next()).getDroppedNodes(support, tree, parent))) {
        }
        if (CollectionUtils.isEmpty(nodes)) {
            return false;
        }
        return this.prepareDropOperation(support, tree, nodes, dropIndex, parent, model);
    }

    protected boolean prepareDropOperation(TransferHandler.TransferSupport support, T tree, List<N> nodes, int dropIndex, N parent, M model) {
        if (!((WebTree)tree).isExpanded(parent)) {
            ((WebTree)tree).expandNode(parent);
        }
        int adjustedDropIndex = this.getAdjustedDropIndex(dropIndex, support.getDropAction(), parent);
        return this.performDropOperation(tree, nodes, parent, model, adjustedDropIndex);
    }

    protected boolean performDropOperation(T tree, List<N> nodes, N parent, M model, int index) {
        SwingUtilities.invokeLater(new Runnable((WebTreeModel)model, nodes, (UniqueNode)parent, index, (WebTree)tree){
            final /* synthetic */ WebTreeModel val$model;
            final /* synthetic */ List val$nodes;
            final /* synthetic */ UniqueNode val$parent;
            final /* synthetic */ int val$index;
            final /* synthetic */ WebTree val$tree;
            {
                this.val$model = webTreeModel;
                this.val$nodes = list;
                this.val$parent = uniqueNode;
                this.val$index = n;
                this.val$tree = webTree;
            }

            @Override
            public void run() {
                this.val$model.insertNodesInto(this.val$nodes, this.val$parent, this.val$index);
                if (AbstractTreeTransferHandler.this.expandSingleNode && this.val$nodes.size() == 1) {
                    this.val$tree.expandNode((DefaultMutableTreeNode)this.val$nodes.get(0));
                } else if (AbstractTreeTransferHandler.this.expandMultiplyNodes) {
                    for (UniqueNode node : this.val$nodes) {
                        this.val$tree.expandNode(node);
                    }
                }
                this.val$tree.setSelectedNodes(this.val$nodes);
                AbstractTreeTransferHandler.this.informNodesDropped(this.val$tree, this.val$nodes, this.val$parent, this.val$model, this.val$index);
            }
        });
        return true;
    }

    protected void informNodesDropped(T tree, List<N> nodes, N parent, M model, int index) {
        this.nodesDropped(nodes, parent, tree, model, index);
    }

    public void nodesDropped(List<N> nodes, N parent, T tree, M model, int index) {
    }

    protected int getAdjustedDropIndex(int dropIndex, int dropAction, N parent) {
        int adjustedDropIndex;
        int n = adjustedDropIndex = dropIndex == -1 ? ((DefaultMutableTreeNode)parent).getChildCount() : dropIndex;
        if (this.isMoveAction(dropAction) && this.draggedNodeIndices != null && this.draggedNodeIndices.containsKey(((UniqueNode)parent).getId())) {
            int initialIndex = adjustedDropIndex;
            for (Integer index : this.draggedNodeIndices.get(((UniqueNode)parent).getId())) {
                if (index >= initialIndex) continue;
                --adjustedDropIndex;
            }
        }
        return adjustedDropIndex;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.isMoveAction(action)) {
            WebTree tree = (WebTree)source;
            this.removeTreeNodes(tree, this.draggedNodes);
            this.draggedNodes = null;
        }
    }

    protected void removeTreeNodes(T tree, List<N> nodesToRemove) {
        ((WebTreeModel)((JTree)tree).getModel()).removeNodesFromParent(nodesToRemove);
    }

    protected <O> List<O> extract(List<N> nodes) {
        ArrayList<Object> objects = new ArrayList<Object>(nodes.size());
        for (UniqueNode node : nodes) {
            objects.add(node.getUserObject());
        }
        return objects;
    }

    protected boolean isMoveAction(int action) {
        return (action & 2) == 2;
    }

    protected boolean isCopyAction(int action) {
        return (action & 1) == 1;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

