/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.icon.OrientedIcon;
import com.alee.extended.panel.CollapsiblePaneListener;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.ChildStyleId;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import com.alee.painter.decoration.states.BoxOrientation;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.swing.DataProvider;
import com.alee.utils.swing.WebTimer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class WebCollapsiblePane
extends WebPanel
implements SwingConstants,
ShapeProvider,
LanguageMethods,
SettingsMethods {
    public static ImageIcon EXPAND_ICON = new ImageIcon(WebCollapsiblePane.class.getResource("icons/arrow.png"));
    public static ImageIcon COLLAPSE_ICON = ImageUtils.rotateImage180((ImageIcon)EXPAND_ICON);
    protected Boolean animate;
    protected ImageIcon expandIcon;
    protected ImageIcon collapseIcon;
    protected Boolean rotateStateIcon;
    protected Boolean showStateIcon;
    protected int stateIconPosition;
    protected int titlePanePosition;
    protected List<CollapsiblePaneListener> listeners = new ArrayList<CollapsiblePaneListener>(1);
    protected ImageIcon cachedExpandIcon = null;
    protected ImageIcon cachedDisabledExpandIcon = null;
    protected ImageIcon cachedCollapseIcon = null;
    protected ImageIcon cachedDisabledCollapseIcon = null;
    protected DataProvider<Boolean> stateChangeHandler = null;
    protected boolean expanded = true;
    protected float transitionProgress = 1.0f;
    protected float expandSpeed = 0.1f;
    protected WebTimer animator = null;
    protected boolean customTitle = false;
    protected HeaderPanel headerPanel;
    protected Component titleComponent;
    protected WebButton expandButton;
    protected WebPanel contentPanel;
    protected Component content = null;

    public WebCollapsiblePane() {
        this(StyleId.collapsiblepane, "");
    }

    public WebCollapsiblePane(String title) {
        this(StyleId.collapsiblepane, null, title);
    }

    public WebCollapsiblePane(ImageIcon icon, String title) {
        this(StyleId.collapsiblepane, icon, title, null);
    }

    public WebCollapsiblePane(Component content) {
        this(StyleId.collapsiblepane, null, "", content);
    }

    public WebCollapsiblePane(String title, Component content) {
        this(StyleId.collapsiblepane, null, title, content);
    }

    public WebCollapsiblePane(Icon icon, String title, Component content) {
        this(StyleId.collapsiblepane, icon, title, content);
    }

    public WebCollapsiblePane(StyleId id) {
        this(id, "");
    }

    public WebCollapsiblePane(StyleId id, String title) {
        this(id, null, title);
    }

    public WebCollapsiblePane(StyleId id, ImageIcon icon, String title) {
        this(id, icon, title, null);
    }

    public WebCollapsiblePane(StyleId id, Component content) {
        this(id, null, "", content);
    }

    public WebCollapsiblePane(StyleId id, String title, Component content) {
        this(id, null, title, content);
    }

    public WebCollapsiblePane(StyleId id, Icon icon, String title, Component content) {
        super(id, new BorderLayout(0, 0), new Component[0]);
        this.content = content;
        this.headerPanel = new HeaderPanel();
        this.headerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && Bounds.margin.of(WebCollapsiblePane.this).contains(e.getPoint())) {
                    WebCollapsiblePane.this.invertExpandState();
                    WebCollapsiblePane.this.takeFocus();
                }
            }
        });
        this.headerPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Hotkey.ENTER.isTriggered(e) || Hotkey.SPACE.isTriggered(e)) {
                    WebCollapsiblePane.this.invertExpandState();
                }
            }
        });
        this.updateHeaderPosition();
        this.updateDefaultTitleComponent(icon, title);
        this.expandButton = new WebButton(StyleId.collapsiblepaneExpandButton.at(this), (Icon)this.getCollapseIcon());
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCollapsiblePane.this.invertExpandState();
                WebCollapsiblePane.this.takeFocus();
            }
        });
        this.setStateIcons();
        this.updateStateIconPosition();
        this.contentPanel = new WebPanel(StyleId.collapsiblepaneContentPanel.at(this), new BorderLayout(0, 0), new Component[0]){

            @Override
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                if (WebCollapsiblePane.this.titlePanePosition == 1 || WebCollapsiblePane.this.titlePanePosition == 3) {
                    if (WebCollapsiblePane.this.content != null) {
                        Insets insets = this.getInsets();
                        ps.width = insets.left + WebCollapsiblePane.this.content.getPreferredSize().width + insets.right;
                    }
                    if (WebCollapsiblePane.this.transitionProgress < 1.0f) {
                        ps.height = Math.round((float)ps.height * WebCollapsiblePane.this.transitionProgress);
                    }
                } else {
                    if (WebCollapsiblePane.this.content != null) {
                        Insets insets = this.getInsets();
                        ps.height = insets.top + WebCollapsiblePane.this.content.getPreferredSize().height + insets.bottom;
                    }
                    if (WebCollapsiblePane.this.transitionProgress < 1.0f) {
                        ps.width = Math.round((float)ps.width * WebCollapsiblePane.this.transitionProgress);
                    }
                }
                return ps;
            }
        };
        this.add((Component)this.contentPanel, (Object)"Center");
        if (this.content != null) {
            this.contentPanel.add(this.content, (Object)"Center");
        }
        this.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebCollapsiblePane.this.updateStateIcons();
            }
        });
    }

    protected void takeFocus() {
        if (this.isShowing() && this.isEnabled()) {
            if (this.isFocusable()) {
                this.requestFocusInWindow();
            } else {
                this.transferFocus();
            }
        }
    }

    protected void updateDefaultTitleComponent() {
        this.updateDefaultTitleComponent(this.getIcon(), this.getTitle());
    }

    protected void updateDefaultTitleComponent(Icon icon, String title) {
        if (this.headerPanel != null && !this.customTitle) {
            if (this.titleComponent != null) {
                this.headerPanel.remove(this.titleComponent);
            }
            this.titleComponent = this.createDefaultTitleComponent(icon, title);
            this.headerPanel.add(this.titleComponent, (Object)"Center");
        }
    }

    protected void updateHeaderPosition() {
        if (this.headerPanel != null) {
            if (this.titlePanePosition == 1) {
                this.add((Component)this.headerPanel, (Object)"North");
            } else if (this.titlePanePosition == 3) {
                this.add((Component)this.headerPanel, (Object)"South");
            } else if (this.titlePanePosition == 2) {
                this.add((Component)this.headerPanel, (Object)"Before");
            } else if (this.titlePanePosition == 4) {
                this.add((Component)this.headerPanel, (Object)"After");
            }
            this.headerPanel.updateDecoration();
            this.revalidate();
        }
    }

    protected void updateStateIconPosition() {
        if (this.headerPanel != null && this.expandButton != null) {
            if (this.showStateIcon.booleanValue()) {
                if (this.titlePanePosition == 1 || this.titlePanePosition == 3) {
                    this.headerPanel.add((Component)this.expandButton, (Object)(this.stateIconPosition == 4 ? "After" : "Before"));
                } else if (this.titlePanePosition == 2) {
                    this.headerPanel.add((Component)this.expandButton, (Object)(this.stateIconPosition == 4 ? "First" : "Last"));
                } else if (this.titlePanePosition == 4) {
                    this.headerPanel.add((Component)this.expandButton, (Object)(this.stateIconPosition == 4 ? "Last" : "First"));
                }
            } else {
                this.headerPanel.remove((Component)this.expandButton);
            }
            this.headerPanel.revalidate();
        }
    }

    protected JComponent createDefaultTitleComponent(Icon icon, String title) {
        ChildStyleId id;
        switch (this.titlePanePosition) {
            case 1: {
                id = StyleId.collapsiblepaneTopTitleLabel;
                break;
            }
            case 2: {
                id = StyleId.collapsiblepaneLeftTitleLabel;
                break;
            }
            case 3: {
                id = StyleId.collapsiblepaneBottomTitleLabel;
                break;
            }
            case 4: {
                id = StyleId.collapsiblepaneRightTitleLabel;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown title pane position specified");
            }
        }
        return new WebLabel(id.at(this), title, icon, 10, new Object[0]);
    }

    public DataProvider<Boolean> getStateChangeHandler() {
        return this.stateChangeHandler;
    }

    public void setStateChangeHandler(DataProvider<Boolean> stateChangeHandler) {
        this.stateChangeHandler = stateChangeHandler;
    }

    public boolean isStateChangeEnabled() {
        return this.stateChangeHandler == null || (Boolean)this.stateChangeHandler.provide() != false;
    }

    public boolean isAnimating() {
        return this.animator != null && this.animator.isRunning();
    }

    public boolean invertExpandState() {
        return this.invertExpandState(this.animate);
    }

    public boolean invertExpandState(boolean animate) {
        return this.setExpanded(!this.isExpanded(), animate);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean setExpanded(boolean expanded) {
        return this.setExpanded(expanded, this.isShowing() && this.animate != false);
    }

    public boolean setExpanded(boolean expanded, boolean animate) {
        if (this.isEnabled()) {
            if (expanded) {
                return this.expand(animate);
            }
            return this.collapse(animate);
        }
        return false;
    }

    public boolean collapse() {
        return this.collapse(this.animate);
    }

    public boolean collapse(boolean animate) {
        if (!this.expanded || !this.isStateChangeEnabled()) {
            return false;
        }
        this.stopAnimation();
        this.expanded = false;
        this.setStateIcons();
        this.fireCollapsing();
        if (animate && this.isShowing()) {
            this.animator = new WebTimer("WebCollapsiblePane.collapseTimer", StyleConstants.fps48, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WebCollapsiblePane.this.transitionProgress > 0.0f) {
                        WebCollapsiblePane.this.transitionProgress = Math.max(0.0f, WebCollapsiblePane.this.transitionProgress - WebCollapsiblePane.this.expandSpeed);
                        WebCollapsiblePane.this.revalidate();
                    } else {
                        WebCollapsiblePane.this.transitionProgress = 0.0f;
                        WebCollapsiblePane.this.finishCollapseAction();
                        WebCollapsiblePane.this.animator.stop();
                    }
                }
            });
            this.animator.start();
        } else {
            this.transitionProgress = 0.0f;
            this.finishCollapseAction();
        }
        return true;
    }

    protected void finishCollapseAction() {
        if (this.headerPanel != null) {
            this.headerPanel.updateDecoration();
        }
        if (this.content != null) {
            this.content.setVisible(false);
        }
        this.revalidate();
        this.repaint();
        this.fireCollapsed();
    }

    public boolean expand() {
        return this.expand(this.animate);
    }

    public boolean expand(boolean animate) {
        if (this.expanded || !this.isStateChangeEnabled()) {
            return false;
        }
        this.stopAnimation();
        this.expanded = true;
        this.setStateIcons();
        if (this.headerPanel != null) {
            this.headerPanel.updateDecoration();
        }
        if (this.content != null) {
            this.content.setVisible(true);
        }
        this.fireExpanding();
        if (animate && this.isShowing()) {
            this.animator = new WebTimer("WebCollapsiblePane.expandTimer", StyleConstants.fps48, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WebCollapsiblePane.this.transitionProgress < 1.0f) {
                        WebCollapsiblePane.this.transitionProgress = Math.min(1.0f, WebCollapsiblePane.this.transitionProgress + WebCollapsiblePane.this.expandSpeed);
                        WebCollapsiblePane.this.revalidate();
                    } else {
                        WebCollapsiblePane.this.transitionProgress = 1.0f;
                        WebCollapsiblePane.this.finishExpandAction();
                        WebCollapsiblePane.this.animator.stop();
                    }
                }
            });
            this.animator.start();
        } else {
            this.transitionProgress = 1.0f;
            this.finishExpandAction();
        }
        return true;
    }

    protected void finishExpandAction() {
        this.revalidate();
        this.repaint();
        this.fireExpanded();
    }

    protected void stopAnimation() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
    }

    public int getTitlePanePosition() {
        return this.titlePanePosition;
    }

    public void setTitlePanePosition(int titlePanePosition) {
        this.titlePanePosition = titlePanePosition;
        this.updateDefaultTitleComponent();
        this.updateHeaderPosition();
        this.updateStateIcons();
        this.updateStateIconPosition();
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public Icon getIcon() {
        return this.customTitle ? null : (this.titleComponent != null ? ((WebLabel)this.titleComponent).getIcon() : null);
    }

    public void setIcon(Icon icon) {
        if (!this.customTitle) {
            ((WebLabel)this.titleComponent).setIcon(icon);
        }
    }

    public String getTitle() {
        return this.customTitle ? null : (this.titleComponent != null ? ((WebLabel)this.titleComponent).getText() : null);
    }

    public void setTitle(String title) {
        if (!this.customTitle) {
            ((WebLabel)this.titleComponent).setText(title);
        }
    }

    public void setTitleAlignment(int alignment) {
        if (!this.customTitle) {
            ((WebLabel)this.titleComponent).setHorizontalAlignment(alignment);
        }
    }

    public ImageIcon getCollapseIcon() {
        return this.collapseIcon != null ? this.collapseIcon : COLLAPSE_ICON;
    }

    public void setCollapseIcon(ImageIcon collapseIcon) {
        this.collapseIcon = collapseIcon;
        this.clearCachedCollapseIcons();
        this.setStateIcons();
    }

    public ImageIcon getExpandIcon() {
        return this.expandIcon != null ? this.expandIcon : EXPAND_ICON;
    }

    public void setExpandIcon(ImageIcon expandIcon) {
        this.expandIcon = expandIcon;
        this.clearCachedExpandIcons();
        this.setStateIcons();
    }

    public boolean isRotateStateIcon() {
        return this.rotateStateIcon;
    }

    public void setRotateStateIcon(boolean rotateStateIcon) {
        this.rotateStateIcon = rotateStateIcon;
        this.updateStateIcons();
    }

    public boolean isShowStateIcon() {
        return this.showStateIcon;
    }

    public void setShowStateIcon(boolean showStateIcon) {
        this.showStateIcon = showStateIcon;
        this.updateStateIconPosition();
    }

    public int getStateIconPosition() {
        return this.stateIconPosition;
    }

    public void setStateIconPosition(int stateIconPosition) {
        this.stateIconPosition = stateIconPosition;
        this.updateStateIconPosition();
    }

    protected void updateStateIcons() {
        this.clearCachedCollapseIcons();
        this.clearCachedExpandIcons();
        this.setStateIcons();
    }

    protected void setStateIcons() {
        if (this.expandButton != null) {
            if (this.expanded) {
                this.expandButton.setIcon(this.getCachedCollapseIcon());
                this.expandButton.setDisabledIcon(this.getCachedDisabledCollapseIcon());
            } else {
                this.expandButton.setIcon(this.getCachedExpandIcon());
                this.expandButton.setDisabledIcon(this.getCachedDisabledExpandIcon());
            }
        }
    }

    protected void clearCachedCollapseIcons() {
        this.cachedCollapseIcon = null;
        this.cachedDisabledCollapseIcon = null;
    }

    protected ImageIcon getCachedCollapseIcon() {
        if (this.cachedCollapseIcon == null) {
            if (!this.rotateStateIcon.booleanValue() || this.titlePanePosition == 1 || this.titlePanePosition == 3) {
                this.cachedCollapseIcon = new OrientedIcon(this.getCollapseIcon());
            } else if (this.titlePanePosition == 2) {
                this.cachedCollapseIcon = ImageUtils.rotateImage90CCW((ImageIcon)this.getCollapseIcon());
            } else if (this.titlePanePosition == 4) {
                this.cachedCollapseIcon = ImageUtils.rotateImage90CW((ImageIcon)this.getCollapseIcon());
            }
        }
        return this.cachedCollapseIcon;
    }

    protected ImageIcon getCachedDisabledCollapseIcon() {
        if (this.cachedDisabledCollapseIcon == null) {
            this.cachedDisabledCollapseIcon = ImageUtils.createDisabledCopy((ImageIcon)this.getCachedCollapseIcon());
        }
        return this.cachedDisabledCollapseIcon;
    }

    protected void clearCachedExpandIcons() {
        this.cachedExpandIcon = null;
        this.cachedDisabledExpandIcon = null;
    }

    protected ImageIcon getCachedExpandIcon() {
        if (this.cachedExpandIcon == null) {
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            if (!this.rotateStateIcon.booleanValue() || this.titlePanePosition == 1 || this.titlePanePosition == 3) {
                this.cachedExpandIcon = this.getExpandIcon();
            } else if (ltr ? this.titlePanePosition == 2 : this.titlePanePosition == 4) {
                this.cachedExpandIcon = ImageUtils.rotateImage90CCW((ImageIcon)this.getExpandIcon());
            } else if (ltr ? this.titlePanePosition == 4 : this.titlePanePosition == 2) {
                this.cachedExpandIcon = ImageUtils.rotateImage90CW((ImageIcon)this.getExpandIcon());
            }
        }
        return this.cachedExpandIcon;
    }

    protected ImageIcon getCachedDisabledExpandIcon() {
        if (this.cachedDisabledExpandIcon == null) {
            this.cachedDisabledExpandIcon = ImageUtils.createDisabledCopy((ImageIcon)this.getCachedExpandIcon());
        }
        return this.cachedDisabledExpandIcon;
    }

    public WebPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public WebButton getExpandButton() {
        return this.expandButton;
    }

    public Component getTitleComponent() {
        return this.titleComponent;
    }

    public void setTitleComponent(Component titleComponent) {
        if (this.titleComponent != null) {
            this.headerPanel.remove(this.titleComponent);
        }
        if (titleComponent != null) {
            this.headerPanel.add(titleComponent, (Object)"Center");
        }
        this.titleComponent = titleComponent;
        this.customTitle = true;
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        if (this.content != null) {
            this.contentPanel.remove(this.content);
        }
        this.content = content;
        content.setVisible(this.transitionProgress > 0.0f);
        this.contentPanel.add(content, (Object)"Center");
        this.revalidate();
    }

    public List<CollapsiblePaneListener> getCollapsiblePaneListeners() {
        return CollectionUtils.copy(this.listeners);
    }

    public void setCollapsiblePaneListeners(List<CollapsiblePaneListener> listeners) {
        this.listeners = listeners;
    }

    public void addCollapsiblePaneListener(CollapsiblePaneListener listener) {
        this.listeners.add(listener);
    }

    public void removeCollapsiblePaneListener(CollapsiblePaneListener listener) {
        this.listeners.remove(listener);
    }

    public void fireExpanding() {
        for (CollapsiblePaneListener listener : CollectionUtils.copy(this.listeners)) {
            listener.expanding(this);
        }
    }

    public void fireExpanded() {
        for (CollapsiblePaneListener listener : CollectionUtils.copy(this.listeners)) {
            listener.expanded(this);
        }
    }

    public void fireCollapsing() {
        for (CollapsiblePaneListener listener : CollectionUtils.copy(this.listeners)) {
            listener.collapsing(this);
        }
    }

    public void fireCollapsed() {
        for (CollapsiblePaneListener listener : CollectionUtils.copy(this.listeners)) {
            listener.collapsed(this);
        }
    }

    public float getTransitionProgress() {
        return this.transitionProgress;
    }

    public Dimension getBasePreferredSize() {
        Dimension ps = this.getPreferredSize();
        if (this.content == null || this.transitionProgress <= 0.0f) {
            return ps;
        }
        Dimension cps = this.content.getPreferredSize();
        if (this.titlePanePosition == 1 || this.titlePanePosition == 3) {
            return new Dimension(ps.width, ps.height - Math.round((float)cps.height * this.transitionProgress));
        }
        return new Dimension(ps.width - Math.round((float)cps.width * this.transitionProgress), ps.height);
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((JComponent)this);
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((JComponent)this);
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((JComponent)this, (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((JComponent)this);
    }

    public void registerSettings(String key) {
        SettingsManager.registerComponent((JComponent)this, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, (String)key, defaultValueClass);
    }

    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, defaultValueClass);
    }

    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, (Object)defaultValue);
    }

    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, defaultValueClass, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((JComponent)this, (String)group, (String)key, (Object)defaultValue, (boolean)loadInitialSettings, (boolean)applySettingsChanges);
    }

    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((JComponent)this, (SettingsProcessor)settingsProcessor);
    }

    public void unregisterSettings() {
        SettingsManager.unregisterComponent((JComponent)this);
    }

    public void loadSettings() {
        SettingsManager.loadComponentSettings((JComponent)this);
    }

    public void saveSettings() {
        SettingsManager.saveComponentSettings((JComponent)this);
    }

    public class HeaderPanel
    extends WebPanel
    implements Stateful {
        public HeaderPanel() {
            super(StyleId.collapsiblepaneHeaderPanel.at(WebCollapsiblePane.this), new BorderLayout(), new Component[0]);
        }

        @Override
        public List<String> getStates() {
            String state = WebCollapsiblePane.this.isExpanded() || WebCollapsiblePane.this.getTransitionProgress() > 0.0f ? "expanded" : "collapsed";
            String position = BoxOrientation.get(WebCollapsiblePane.this.getTitlePanePosition()).name();
            return CollectionUtils.asList((Object[])new String[]{state, position});
        }

        public void updateDecoration() {
            DecorationUtils.fireStatesChanged(this);
        }
    }
}

