/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.panel.WebSelectablePanel;
import com.alee.global.StyleConstants;
import com.alee.laf.panel.WebPanelUI;
import com.alee.painter.AbstractPainter;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;

public class SelectablePanelPainter
extends AbstractPainter<WebSelectablePanel, WebPanelUI> {
    public static final int GRIPPER_SIZE = 7;
    public static final int SINGLE_GRIPPER_STEP = 4;
    protected float[] fractions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
    protected Color[] lightColors = new Color[]{StyleConstants.transparent, Color.WHITE, Color.WHITE, StyleConstants.transparent};
    protected Color[] darkColors = new Color[]{StyleConstants.transparent, Color.GRAY, Color.GRAY, StyleConstants.transparent};

    @Override
    public Boolean isOpaque() {
        return true;
    }

    @Override
    public Insets getBorders() {
        return this.i(0, 7, 0, 0);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, WebSelectablePanel panel, WebPanelUI ui) {
        boolean notLast;
        boolean notFirst = panel.getIndex() > 0;
        boolean bl = notLast = panel.getIndex() < ((WebSelectablePanel)this.component).getTotal() - 1;
        if (panel.isFocused()) {
            g2d.setPaint(new GradientPaint(bounds.x, bounds.y, StyleConstants.topBgColor, bounds.x, bounds.y + bounds.height, StyleConstants.bottomBgColor));
            g2d.fill(bounds);
            Integer shift = panel.getComponentPane().getContainerLayout().getComponentShift(panel);
            boolean moved = panel.isDragged() && shift != null && shift != 0;
            g2d.setPaint(StyleConstants.darkBorderColor);
            if (notFirst || moved) {
                g2d.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
            }
            if (notLast || moved) {
                g2d.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
            }
        }
        if (panel.getComponentPane().isReorderingAllowed() && panel.getComponentPane().isShowReorderGrippers()) {
            int minY = bounds.y + 2 + (notFirst ? 1 : 0);
            int maxY = bounds.x + bounds.height - 2 - (notLast ? 1 : 0);
            int x = this.ltr ? bounds.x + 3 : bounds.x + bounds.width - 7 + 2;
            int y = minY + (maxY - minY) % 4 / 2;
            LinearGradientPaint light = new LinearGradientPaint(x, minY, x, maxY, this.fractions, this.lightColors);
            LinearGradientPaint dark = new LinearGradientPaint(x, minY, x, maxY, this.fractions, this.darkColors);
            while (y + 3 < maxY) {
                g2d.setPaint(light);
                g2d.fillRect(x + 1, y + 1, 2, 2);
                g2d.setPaint(dark);
                g2d.fillRect(x, y, 2, 2);
                y += 4;
            }
        }
    }
}

