/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class HorizontalOverflowLayout
extends AbstractLayoutManager {
    protected int overflow;

    public HorizontalOverflowLayout(int overflow) {
        this.overflow = overflow;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public void setOverflow(int overflow) {
        this.overflow = overflow;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension required = this.preferredLayoutSize(parent);
        Dimension available = new Dimension(required.width, parent.getSize().height);
        boolean min = required.width < available.width;
        Insets insets = parent.getInsets();
        int x = insets.left;
        int y = insets.top;
        int h = Math.max(available.height, required.height) - insets.top - insets.bottom;
        int xsWidth = available.width - required.width;
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            int w;
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            int n = w = min ? c.getMinimumSize().width : c.getPreferredSize().width;
            if (xsWidth > 0) {
                w += w * xsWidth / required.width;
            }
            c.setBounds(x, y, w, h);
            x += w - this.overflow;
        }
    }

    protected Dimension getLayoutSize(Container parent, boolean min) {
        int count = parent.getComponentCount();
        Dimension size = new Dimension(0, 0);
        for (int i = 0; i < count; ++i) {
            Component c = parent.getComponent(i);
            Dimension tmp = min ? c.getMinimumSize() : c.getPreferredSize();
            size.height = Math.max(tmp.height, size.height);
            size.width += tmp.width;
            if (i == 0) continue;
            size.width -= this.overflow;
        }
        Insets border = parent.getInsets();
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }
}

