/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.extended.language.DictionariesTransferHandler;
import com.alee.extended.language.DictionariesTreeEditor;
import com.alee.extended.language.DictionariesTreeRenderer;
import com.alee.laf.tree.WebTree;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.Value;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DictionariesTree
extends WebTree {
    private DefaultMutableTreeNode root;
    private DefaultTreeModel model;

    public DictionariesTree() {
        this.setEditable(true);
        this.setShowsRootHandles(false);
        this.setSelectionMode(1);
        this.setDragEnabled(true);
        DictionariesTransferHandler.install(this);
        this.root = new DefaultMutableTreeNode(null);
        this.model = new DefaultTreeModel(this.root);
        this.setModel(this.model);
        this.setCellRenderer(new DictionariesTreeRenderer());
        this.setCellEditor(new DictionariesTreeEditor(this));
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object object = event.getPath().getLastPathComponent();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                Object uo = node.getUserObject();
                if (uo instanceof Record) {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                        DictionariesTree.this.expandPath(new TreePath(child.getPath()));
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DefaultMutableTreeNode node;
                if (Hotkey.DELETE.isTriggered(e) && (node = DictionariesTree.this.getSelectedNode()) != null && node.getUserObject() != null) {
                    int row = DictionariesTree.this.getRowForPath(DictionariesTree.this.getSelectionPath());
                    Object type = node.getUserObject();
                    if (type instanceof Dictionary) {
                        Object uo = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
                        if (uo != null) {
                            Dictionary parent = (Dictionary)uo;
                            parent.removeSubDictionary((Dictionary)type);
                        }
                    } else if (type instanceof Record) {
                        Object uo = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
                        ((Dictionary)uo).removeRecord((Record)type);
                    } else if (type instanceof Value) {
                        Object uo = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
                        ((Record)uo).removeValue((Value)type);
                    } else if (type instanceof Text) {
                        Object uo = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
                        ((Value)uo).removeText((Text)type);
                    } else if (type instanceof Tooltip) {
                        Object uo = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
                        ((Value)uo).removeTooltip((Tooltip)type);
                    }
                    DictionariesTree.this.model.removeNodeFromParent(node);
                    if (DictionariesTree.this.getRowCount() > row) {
                        DictionariesTree.this.setSelectionRow(row);
                    } else if (row > 0) {
                        DictionariesTree.this.setSelectionRow(row - 1);
                    }
                }
            }
        });
    }

    public void selectAndShow(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        return path != null ? (DefaultMutableTreeNode)path.getLastPathComponent() : null;
    }

    public Object getSelectedValue() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            return node.getUserObject();
        }
        return null;
    }

    public void expandTillRecords() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object = this.getPathForRow(i).getLastPathComponent();
            Object uo = ((DefaultMutableTreeNode)object).getUserObject();
            if (uo != null && !(uo instanceof Dictionary)) continue;
            this.expandRow(i);
        }
    }

    public void loadDictionary(Dictionary dictionary) {
        DefaultMutableTreeNode dn = this.createDictionaryNode(dictionary);
        this.model.insertNodeInto(dn, this.root, this.root.getChildCount());
    }

    public DefaultMutableTreeNode createDictionaryNode(Dictionary dictionary) {
        DefaultMutableTreeNode dn = new DefaultMutableTreeNode(dictionary);
        if (dictionary.getRecords() != null) {
            for (Record record : dictionary.getRecords()) {
                dn.add(this.createRecordNode(record));
            }
        }
        if (dictionary.getSubdictionaries() != null) {
            for (Dictionary sub : dictionary.getSubdictionaries()) {
                dn.add(this.createDictionaryNode(sub));
            }
        }
        return dn;
    }

    public DefaultMutableTreeNode createRecordNode(Record record) {
        DefaultMutableTreeNode rn = new DefaultMutableTreeNode(record);
        if (record.getValues() != null) {
            for (Value value : record.getValues()) {
                rn.add(this.createValueNode(value));
            }
        }
        return rn;
    }

    public DefaultMutableTreeNode createValueNode(Value value) {
        DefaultMutableTreeNode vn = new DefaultMutableTreeNode(value);
        if (value.getTexts() != null) {
            for (Text text : value.getTexts()) {
                vn.add(this.createTextNode(text));
            }
        }
        if (value.getTooltips() != null) {
            for (Tooltip tooltip : value.getTooltips()) {
                vn.add(this.createTooltipNode(tooltip));
            }
        }
        return vn;
    }

    public DefaultMutableTreeNode createTextNode(Text text) {
        return new DefaultMutableTreeNode(text);
    }

    public DefaultMutableTreeNode createTooltipNode(Tooltip tooltip) {
        return new DefaultMutableTreeNode(tooltip);
    }

    public DefaultTreeModel getActualModel() {
        return this.model;
    }
}

