/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.api.IconSupport;
import com.alee.api.TitleSupport;
import com.alee.extended.inspector.InterfaceTree;
import com.alee.extended.inspector.info.AWTComponentInfo;
import com.alee.extended.inspector.info.ComponentInfo;
import com.alee.extended.inspector.info.JComponentInfo;
import com.alee.extended.inspector.info.StyleableInfo;
import com.alee.laf.tree.UniqueNode;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.StyleableComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.Icon;
import javax.swing.JComponent;

public class InterfaceTreeNode
extends UniqueNode
implements IconSupport,
TitleSupport {
    private static final ComponentInfo styleableInfo = new StyleableInfo();
    private static final ComponentInfo jComponentInfo = new JComponentInfo();
    private static final ComponentInfo awtComponentInfo = new AWTComponentInfo();
    protected final InterfaceTree tree;
    private ComponentAdapter componentAdapter;
    private ContainerAdapter containerAdapter;
    private StyleListener styleListener;

    public InterfaceTreeNode(final InterfaceTree tree, Component component) {
        super("" + component.hashCode(), component);
        this.tree = tree;
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                tree.updateNode(InterfaceTreeNode.this);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                tree.updateNode(InterfaceTreeNode.this);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                tree.repaint(InterfaceTreeNode.this);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                tree.repaint(InterfaceTreeNode.this);
            }
        };
        component.addComponentListener(this.componentAdapter);
        if (component instanceof Container) {
            this.containerAdapter = new ContainerAdapter(){

                @Override
                public void componentAdded(ContainerEvent e) {
                    tree.addChildNode(InterfaceTreeNode.this, new InterfaceTreeNode(tree, e.getChild()));
                }

                @Override
                public void componentRemoved(ContainerEvent e) {
                    Component child = e.getChild();
                    for (int i = 0; i < InterfaceTreeNode.this.getChildCount(); ++i) {
                        InterfaceTreeNode childAt = (InterfaceTreeNode)InterfaceTreeNode.this.getChildAt(i);
                        if (childAt.getComponent() != child) continue;
                        tree.removeNode(childAt);
                        childAt.destroy();
                        break;
                    }
                }
            };
            ((Container)component).addContainerListener(this.containerAdapter);
        }
        if (component instanceof JComponent && StyleableComponent.isSupported(component)) {
            this.styleListener = new StyleListener(){

                @Override
                public void skinChanged(JComponent component, Skin oldSkin, Skin newSkin) {
                }

                @Override
                public void styleChanged(JComponent component, StyleId oldStyleId, StyleId newStyleId) {
                }

                @Override
                public void skinUpdated(JComponent component, StyleId styleId) {
                    tree.repaint(InterfaceTreeNode.this);
                }
            };
            StyleManager.addStyleListener((JComponent)component, this.styleListener);
        }
    }

    private void destroy() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            InterfaceTreeNode childAt = (InterfaceTreeNode)this.getChildAt(i);
            childAt.destroy();
        }
        Component component = this.getComponent();
        component.removeComponentListener(this.componentAdapter);
        if (this.containerAdapter != null) {
            ((Container)component).removeContainerListener(this.containerAdapter);
        }
        if (this.styleListener != null) {
            StyleManager.removeStyleListener((JComponent)component, this.styleListener);
        }
        this.componentAdapter = null;
        this.containerAdapter = null;
        this.styleListener = null;
        this.setUserObject(null);
    }

    public Component getComponent() {
        return (Component)this.getUserObject();
    }

    public Icon getIcon() {
        Component component = this.getComponent();
        StyleableComponent type = this.getType(component);
        return this.getInfo(component).getIcon(type, component);
    }

    public String getTitle() {
        Component component = this.getComponent();
        StyleableComponent type = this.getType(component);
        return this.getInfo(component).getText(type, component);
    }

    protected StyleableComponent getType(Component component) {
        return StyleableComponent.isSupported(component) ? StyleableComponent.get((JComponent)component) : null;
    }

    protected ComponentInfo getInfo(Component component) {
        if (StyleableComponent.isSupported(component)) {
            return styleableInfo;
        }
        if (component instanceof JComponent) {
            return jComponentInfo;
        }
        return awtComponentInfo;
    }

    @Override
    public String toString() {
        return this.getTitle();
    }
}

