/* DUMPALL.CMD: This Rexx program runs the show for EXTRACT/MERGER
   package.
   (C)1994-1996 Turgut Kalfaoglu, All Rights Reserved

   This program is the one to run. It will do the following:
    * Loads EXTRACT.CFG to learn paths and message separator string
    * Deletes the S.UUE file
    * Runs DUMPGRP.EXE to load everything into the S.UUE file
      (the names of the groups to be loaded are taken from
       DUMPGRP's own configuration file, DUMPGRP.CFG)
    * Checks to see if DUMPGRP created S.UUE; exit if not.
    * Runs EXTRACT, which reads S.UUE, and outputs 'partial files'
      into the <PARTIALDIR> directory (location defined in EXTRACT.CFG)
    * Runs MERGER which reads EXTRACT.SUM and decides which partial
      files' pieces have all arrived, and merges the partial pieces
      into actual files. Merger then deletes the partial pieces that
      were successfully processed.
*/
parse arg site
/* if no news site was entered, we will default to the LAST one
   of the following list:
*/

if site = '' then do
  site = "news.metu.edu.tr"
  site = 'news.uni-hohenheim.de'
  site = 'liberty.uc.wlu.edu'
  site = 'baum02.ege.edu.tr'
  site = 'omega.gmd.de'
  site = 'news.ege.edu.tr'
  site = 'news.raksnet.com.tr'
  site = 'tomcat.msrcnavo.navy.mil'
end

/* This is what will be put between each message. This needs to be
 the same for EXTRACT.CFG as well.
*/

/* This is new with V.4; we read EXTRACT.CFG to learn paths and
   signature separator
*/
t = time('R')
f='EXTRACT.CFG'
say time() 'Parsing' f
goodvars = 'DOCSDIR PARTIALDIR ARCDIR SEPARATOR'
parse value '' with docsdir partialdir arcdir separator
do while lines(f)
   r = LINEIN(f)
   Parse var r before'='after
   If after=''  Then Iterate
   If before='' Then Iterate
   before=strip(before)
   after=strip(after)
   If pos(before,goodvars)=0 Then Iterate
   interpret before'= "'after'"'
End
r = LINEOUT(f,,)
If words(docsdir partialdir arcdir separator)<4 Then Do
   Say time() 'Error reading' f', or variable assignments in error in' f
   Exit
End

'CD' docsdir
if rc<>0 Then Exit rc

'DEL' ARCDIR'\S.UUE'
"DUMPGRP -s"site "-r -l"separator
If rc<>0 Then say 'DUMPGRP returns:' rc
if rc =  1 then exit rc
if rc = -1 then exit rc

/* Does S.UUE exist? */
If lines(ARCDIR'\S.UUE') < 1 Then Do
   Say time() 'No' ARCDIR'\S.UUE file -- quitting.'
   Signal Done
End
r = lineout(ARCDIR'\S.UUE',,)

'CD' arcdir
if rc<>0 then Exit rc

'ERASE INCOMP.ZUP'
'REN S.UUE INCOMP.ZUP'

/* NOEOF removes CTRL-Z that may be present in file.. Its usage is
  optional.
'..\NOEOF'
*/

if lines('INCOMP.OUT') > 0 Then Do
  r = lineout('INCOMP.OUT',,)
  'DEL INCOMP.ZUP'
  'REN INCOMP.OUT INCOMP.ZUP'
end

'CD' DOCSDIR
'EXTRACT'
'MERGER'
'CD' ARCDIR

'DEL INCOMP.BAK'
'REN INCOMP.ZUP INCOMP.BAK'
'CD' DOCSDIR
call DEUUE
'@RXQUEUE /CLEAR'
Call Carry '*.ZIP'
Call Carry '*.ARJ'
Call Carry '*.GIF'
Call Carry '*.JPG'
Call Carry '*.MPG'
Call Carry '*.DL'

Done:
secs = trunc(time('E'))
Say time() 'Normal completion of DUMPALL. Runtime was' secs 'seconds.'
exit

Carry:
arg pattern .
 '@DIR /B' pattern '| RXQUEUE'
 Do queued()
   parse pull fn .
   'COPY' fn arcdir
   If rc<>0 Then Exit rc
   'DEL' fn
 End
 Return

/* Here we decode the received pieces: */
DeUUE:
'FORALL *.GI : UUDDEL "@S" "@N.GIF"'
'FORALL *.JP : UUDDEL "@S" "@N.JPG"'
'FORALL *.ZI : UUDDEL "@S" "@N.ZIP"'
'FORALL *.MP : UUDDEL "@S" "@N.MPG"'
'FORALL *.DL : UUDDEL "@S" "@N.DL_"'
'FORALL *.AR : UUDDEL "@S" "@N.ARJ"'
Return

