/*********************************************************************
  exceptq.c
  $Id: exceptq.c,v 1.8 2010/04/28 15:38:58 Steven Exp $

 DLL containing an exception handler for gathering trap information
 This DLL dumps all important debugging Data and is accessible
 from both 16 bit and 32 bits programs

 DLL is 32-bit code, but can handle exceptions from 16-bit code
 Some functions use statics where autos could work to minimize stack usage
 Probably not useful these days

 Symbolic data can be extracted from
   Embedded PM32 debug data (VAC HLL format)
   DBG files (VAC HLL format)
   Embedded CodeView debug data
   DBG files (CodeView format)
   .sym files (generated by mapsym)

 vim: set tabs=4

  fixme to replace dis386
  fixme to have xlseek with error checking
  fixme to have xread with error checking
  fixme to use DosAllocMem rather than calloc/free - avoids death if heap corrupted
  fixme to merge CodeView debug reader into HLL debug reader - saved space
*/

/**********************************************************************/
/* Version: 2.2             |   Marc Fiammante (FIAMMANT at LGEPROFS) */
/*                          |   La Gaude FRANCE                       */
/*                          |   Internet: fiammante@vnet.ibm.com      */
/* Version: 5.0             |   John Currier  (JCURRIER at CLTVM1)    */
/*                          |   Internet: currier@vnet.ibm.com        */
/* Version: 6.0             |   Kim Rasmussen (krasmus@ibm.net)       */
/*                          |   Denmark                               */
/* Version: 6.1             |   Anthony Cruise (CRUISE at YKTVMH)     */
/*                          |   Watson Research                       */
/* Version: 6.2             |   John Currier  (JCURRIER at CLTVM1)    */
/*                          |   Internet: currier@vnet.ibm.com        */
/* Version: 6.3             |   Kim Rasmussen (kr@belle.dk)           */
/*                          |   Denmark                               */
/*                          |   Marc Fiammante (FIAMMANT at LGEPROFS) */
/*                          |   La Gaude FRANCE                       */
/*                          |   Internet: fiammante@vnet.ibm.com      */
/* Version: 6.4             |   Kim Rasmussen (kr@belle.dk)           */
/*                          |   Denmark - http://www.belle.dk/kr/     */
/* Version: 6.5             |   Steven Levine (steve53@earthlink.net) */
/* Version: 6.6             |   Steven Levine (steve53@earthlink.net) */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/**********************************************************************/
/* History:                                                           */
/* --------                                                           */
/*                                                                    */
/* created: Marc Fiammante December 1992                              */
/* changed: John Currier   August   1994                              */
/* changed: Kim Rasmussen, May 1995                                   */
/*    Dump of auto-variables added (32-bit only)                      */
/* changed: Anthony Cruise, May 1995                                  */
/*    Do not dump duplicate lines  (32-bit only)                      */
/* fixed  : Marc Fiammante thanks to Bill Siddall                     */
/*    Dump of auto-variables wrong values                             */
/* fixed  : John Currier fix stack thunk on non fatal exceptions      */
/*         fixed DosQueryMem Size test on return                      */
/* fixed  : Marc Fiammante find stack bottom from top to bottom       */
/*         avoid traps on disassemble.                                */
/* changed: Support for VisualAge C added (new debug format)          */
/* changed: Steven Levine Jul 2000                                    */
/*          Read32PmDebug: avoid autovar_def overflow trap            */
/*          Read32PmDebug: avoid locating wrong function vars         */
/*                         use symproc.length to bound lookup         */
/* changed: Steven Levine Aug 2005                                    */
/*          DosQueryModFromEIP Rework decl to match toolkit           */
/* changed: Steven Levine   Aug 2005                                  */
/*          Reformat with indent.exe                                  */
/*          Correct source filename decode                            */
/* changed: Steven Levine   Jan 2006                                  */
/*          Enhance 32-bit detect                                     */
/* changed: Steven Levine   Jul 2007                                  */
/*          More 32-bit rework.  More 16-bit support                  */
/* changed: Steven Levine   Aug 2007                                  */
/*          Generate hex trap file name                               */
/*          Show PID in hex/dec                                       */
/*          Show exceptq build date                                   */
/* changed: Steven Levine   Oct 2007                                  */
/*          List labels on stack                                      */
/*          Show more in hex/dec                                      */
/* changed: Steven Levine   Dec 2007                                  */
/*          Show exceptq version                                      */
/* changed: Steven Levine   Feb 2008                                  */
/*          Use bsedos.h                                              */
/*          Use more omf.h                                            */
/* changed: Steven Levine   Apr 2008                                  */
/*          Version 6.6                                               */
/*          Show stack as dwords or words                             */
/* changed: Steven Levine   May 2008                                  */
/*          Version 6.7                                               */
/*          Support oversized (>64KiB) symbol files                   */
/*          Support stripped LX executables                           */
/* changed: Steven Levine   May 2008                                  */
/*          Version 6.8                                               */
/*          Support Borland OA debug format - untested                */
/* changed: Steven Levine   Feb 2009                                  */
/*          Version 6.8                                               */
/*          Print blocks pointed to by registers                      */
/* changed: Steven Levine   Dec 2009                                  */
/*          Version 6.8                                               */
/*          Correct EDI display value                                 */
/*          Beep while dumping memory                                 */
/* changed: Steven Levine   Apr 2010                                  */
/*          Version 6.9                                               */
/*          Rework recursion logic to try to report exceptq traps     */
/*                                                                    */
/* changed: Steven Levine   Apr 2010                                  */
/*          Version 6.10                                              */
/*          Avoid buffer overflow with long C++ symbols               */
/*                                                                    */
/**********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#include <fcntl.h>
#include <sys\stat.h>
#include <share.h>
#include <io.h>

#define INCL_BASE
#define INCL_DOSEXCEPTIONS
#define INCL_DOSMODULEMGR		/* DosQueryMod... */
#define INCL_DOSSEMAPHORES
#define INCL_DOSPROFILE			// _QSPTRREC

#include <os2.h>

#include <exe.h>
#include <newexe.h>

// fixme to not need
#define  FOR_EXEHDR  1		/* avoid define conflicts between newexe.h and exe386.h */
#include <exe386.h>

#define EXCEPTQ_VERSION	"6.10"		// 25 Apr 10 SHL
#define WANT_CODEVIEW			// 10 Oct 07 SHL added
#define WANT_BC0A			// 22 May 08 SHL added
// #define WANT_DOSDEBUG		// 23 May 08 SHL added

#include "sym.h"
#include "omf.h"
#include "hlldbg.h"

#ifdef WANT_BC0A
#include "bcoadbg.h"
#endif

#ifndef DWORD
#define DWORD ULONG
#endif

#ifndef WORD
#define WORD  USHORT
#endif

#define FLATCS ((USHORT)0x5B)
#define FLATDS ((USHORT)0x53)

#pragma stack16(512)

static FILE *hTrap;

#ifdef WANT_DOSDEBUG

// DosDebug interface

typedef struct
{
    ULONG Pid;			/* Debuggee Process ID */
    ULONG Tid;			/* Debuggee Thread ID */
    LONG Cmd;			/* Command or Notification */
    LONG Value;			/* Generic Data Value */
    ULONG Addr;			/* Debuggee Address */
    ULONG Buffer;		/* Debugger Buffer Address */
    ULONG Len;			/* Length of Range */
    ULONG Index;		/* Generic Identifier Index */
    ULONG MTE;			/* Module Handle */
    ULONG EAX;			/* Register Set */
    ULONG ECX;
    ULONG EDX;
    ULONG EBX;
    ULONG ESP;
    ULONG EBP;
    ULONG ESI;
    ULONG EDI;
    ULONG EFlags;
    ULONG EIP;
    ULONG CSLim;		/* Byte Granular Limits */
    ULONG CSBase;		/* Byte Granular Base */
    UCHAR CSAcc;		/* Access Bytes */
    UCHAR CSAtr;		/* Attribute Bytes */
    USHORT CS;
    ULONG DSLim;
    ULONG DSBase;
    UCHAR DSAcc;
    UCHAR DSAtr;
    USHORT DS;
    ULONG ESLim;
    ULONG ESBase;
    UCHAR ESAcc;
    UCHAR ESAtr;
    USHORT ES;
    ULONG FSLim;
    ULONG FSBase;
    UCHAR FSAcc;
    UCHAR FSAtr;
    USHORT FS;
    ULONG GSLim;
    ULONG GSBase;
    UCHAR GSAcc;
    UCHAR GSAtr;
    USHORT GS;
    ULONG SSLim;
    ULONG SSBase;
    UCHAR SSAcc;
    UCHAR SSAtr;
    USHORT SS;
} tDbgBuf;

#endif // WANT_DOSDEBUG

static VOID ListModules(VOID);
static VOID PrintMemoryAt(PUCHAR puchAddress, PSZ pszDesc, BOOL is32Bit);
static VOID PrintMemory(PUCHAR puchBottom, PUCHAR puchTop, BOOL is32Bit);
static VOID PrintMemoryAttributes(PVOID pvAddress, PSZ pszDesc);

static VOID WalkStack(PVOID pvStackBottom, PVOID pvStackTop, ULONG ulEBP, USHORT uSS, ULONG ulEIP, USHORT uCS);

#ifdef WANT_CODEVIEW
static INT Read16CodeView(INT fh, USHORT usSegNum, USHORT usOffset, CHAR *FileName);
#endif

static INT Read32PmDebug(INT fh, USHORT usSegNum, ULONG ulOffset, CHAR *pszFileName);
static APIRET PrintLineNum(CHAR *pszFileName, ULONG ulObjNum, ULONG ulOffset);
static VOID PrintSymbolFromSymFile(CHAR *pszSymFileName, ULONG ulObjNum, ULONG ulOffset);
static VOID PrintLocalVariables(ULONG ulStackOffset);
static BYTE *FormatVarValue(PVOID pVar, BYTE type);

typedef ULONG *_Seg16 PULONG16;

APIRET16 APIENTRY16 DOS16SIZESEG(USHORT Seg, PULONG16 Size);

typedef APIRET16(APIENTRY16 _PFN16)();

ULONG APIENTRY DosSelToFlat(ULONG);

//=== DosQueryProcess status interface ===

APIRET16 APIENTRY16 DOSQPROCSTATUS(ULONG * _Seg16 pBuf, USHORT cbBuf);

#if 0 // 06 Feb 08 SHL fixme to be gone now using bsedos.h definitions

#ifdef WANT_DOSDEBUG

// 28 May 08 SHL fixme to test with WANT_DOSDEBUG enabled before deleting

#pragma pack(1)

typedef struct qsGrec_s
{
    ULONG cThrds;		/* number of threads in use */
    ULONG Reserved1;
    ULONG Reserved2;
} qsGrec_t;

/* Thread Record structure - Holds all per thread information. */
typedef struct qsTrec_s
{
    ULONG RecType;		/* Record Type */
    /* Thread rectype = 100 */
    USHORT tid;			/* thread ID */
    USHORT slot;		/* "unique" thread slot number */
    ULONG sleepid;		/* sleep id thread is sleeping on */
    ULONG priority;		/* thread priority */
    ULONG systime;		/* thread system time */
    ULONG usertime;		/* thread user time */
    UCHAR state;		/* thread state */
	PADCHAR;
	PADSHORT;
} qsTrec_t;

/* Process and Thread Data Section */
typedef struct qsPrec_s
{
    ULONG RecType;		/* type of record being processed */
    /* process rectype = 1       */
    qsTrec_t *pThrdRec;		/* ptr to 1st thread rec for this prc */
    USHORT pid;			/* process ID */
    USHORT ppid;		/* parent process ID */
    ULONG type;			/* process type */
    ULONG stat;			/* process status */
    ULONG sgid;			/* process screen group */
    USHORT hMte;		/* program module handle for process */
    USHORT cTCB;		/* # of TCBs in use in process */
    ULONG Reserved1;
    PVOID Reserved2;
    USHORT c16Sem;		/* # of 16 bit system sems in use by proc */
    USHORT cLib;		/* number of runtime linked libraries */
    USHORT cShrMem;		/* number of shared memory handles */
    USHORT Reserved3;
    USHORT *p16SemRec;		/* ptr to head of 16 bit sem inf for proc */
    USHORT *pLibRec;		/* ptr to list of runtime lib in use by */
    /*process */
    USHORT *pShrMemRec;		/* ptr to list of shared mem handles in */
    /* use by process */
    USHORT *Reserved4;
} qsPrec_t;

/* 16 Bit System Semaphore Section */
typedef struct qsS16Headrec_s
{
    ULONG RecType;		/* semaphore rectype = 3 */
    ULONG Reserved1;		/* overlays NextRec of 1st qsS16rec_t */
    ULONG Reserved2;
    ULONG S16TblOff;		/* index of first semaphore,SEE PSTAT OUTPUT */
    /* System Semaphore Information Section     */
} qsS16Headrec_t;

/* 16 bit System Semaphore Header Record Structure */
typedef struct qsS16rec_s
{
    ULONG NextRec;		/* offset to next record in buffer */
    UINT s_SysSemOwner;		/* thread owning this semaphore    */
    UCHAR s_SysSemFlag;		/* system semaphore flag bit field */
    UCHAR s_SysSemRefCnt;	/* number of references to this    */
				/* system semaphore                */
    UCHAR s_SysSemProcCnt;	/*number of requests by sem owner  */
    UCHAR Reserved1;
    ULONG Reserved2;
    UINT Reserved3;
    CHAR SemName[1];		/* start of semaphore name string */
} qsS16rec_t;

/* Executable Module Section */
typedef struct qsLrec_s
{
    PVOID pNextRec;		/* pointer to next record in buffer */
    USHORT hmte;		/* handle for this mte */
    USHORT Reserved1;		/* Reserved */
    ULONG ctImpMod;		/* # of imported modules in table */
    ULONG Reserved2;		/* Reserved */
    /* qsLObjrec_t * Reserved3;    Reserved */
    ULONG *Reserved3;		/* Reserved */
    UCHAR *pName;		/* ptr to name string following stru */
} qsLrec_t;

/* Shared Memory Segment Section */
typedef struct qsMrec_s
{
    struct qsMrec_s *MemNextRec;	/* offset to next record in buffer */
    USHORT hmem;		/* handle for shared memory */
    USHORT sel;			/* shared memory selector */
    USHORT refcnt;		/* reference count */
    CHAR Memname[1];		/* start of shared memory name string */
} qsMrec_t;

/* Pointer Record Section */
typedef struct qsPtrRec_s
{
    qsGrec_t *pGlobalRec;	/* ptr to the global data section   */
    qsPrec_t *pProcRec;		/* ptr to process record section    */
    qsS16Headrec_t *p16SemRec;	/* ptr to 16 bit sem section        */
    PVOID Reserved;		/* a reserved area                  */
    qsMrec_t *pShrMemRec;	/* ptr to shared mem section        */
    qsLrec_t *pLibRec;		/* ptr to exe module record section */
} qsPtrRec_t;

#endif // WANT_DOSDEBUG

#endif // 06 Feb 08 SHL fixme to be gone now using bsedos.h definitions

//=== end of DosQueryProcess status interface ===

USHORT Selector;

APIRET16 APIENTRY16 DOS16ALLOCSEG(USHORT cbSize,	/* number of bytes requested                   */
				  USHORT * _Seg16 pSel,	/* sector allocated (returned)                 */
				  USHORT fsAlloc);	/* sharing attributes of the allocated segment */

//=== dis386 interface ===

// default packing is 4 for VAC

#pragma pack(1)				// 06 Feb 08 SHL

typedef struct
{
    SHORT ilen;			/* Instruction length */
    LONG rref;			/* Value of any IP relative storage reference */
    USHORT sel;			/* Selector of any CS:eIP storage reference.   */
    LONG poff;			/* eIP value of any CS:eIP storage reference. */
    CHAR longoper;		/* YES/NO value. Is instr in 32 bit operand mode? * */
    CHAR longaddr;		/* YES/NO value. Is instr in 32 bit address mode? * */
    CHAR buf[40];		/* String holding disassembled instruction * */
} *_Seg16 RETURN_FROM_DISASM;

#pragma pack()				// 06 Feb 08 SHL

RETURN_FROM_DISASM CDECL16 DISASM(CHAR * _Seg16 pSource, USHORT usIPvalue, USHORT usSegSize);
RETURN_FROM_DISASM pDis386Data;

//=== end of dis386 interface ===

PVOID pvDis386Buffer;

static ULONG aulOSVersion[2];

BYTE *type_name[] =
{
    "8 bit signed                     ",	// 0x80
    "16 bit signed                    ",
    "32 bit signed                    ",
    "Unknown (0x83)                   ",
    "8 bit unsigned                   ",
    "16 bit unsigned                  ",
    "32 bit unsigned                  ",
    "Unknown (0x87)                   ",
    "32 bit real                      ",
    "64 bit real                      ",
    "80 bit real                      ",
    "Unknown (0x8B)                   ",
    "64 bit complex                   ",
    "128 bit complex                  ",
    "160 bit complex                  ",
    "Unknown (0x8F)                   ",
    "8 bit boolean                    ",	// 0x90
    "16 bit boolean                   ",
    "32 bit boolean                   ",
    "Unknown (0x93)                   ",
    "8 bit character                  ",
    "16 bit characters                ",
    "32 bit characters                ",
    "void                             ",
    "15 bit unsigned                  ",
    "24 bit unsigned                  ",
    "31 bit unsigned                  ",
    "Unknown (0x9B)                   ",
    "Unknown (0x9C)                   ",
    "Unknown (0x9D)                   ",
    "Unknown (0x9E)                   ",
    "Unknown (0x9F)                   ",
    "near pointer to 8 bit signed     ",	// 0xa0
    "near pointer to 16 bit signed    ",
    "near pointer to 32 bit signed    ",
    "Unknown (0xA3)                   ",
    "near pointer to 8 bit unsigned   ",
    "near pointer to 16 bit unsigned  ",
    "near pointer to 32 bit unsigned  ",
    "Unknown (0xA7)                   ",
    "near pointer to 32 bit real      ",
    "near pointer to 64 bit real      ",
    "near pointer to 80 bit real      ",
    "Unknown (0xAB)                   ",
    "near pointer to 64 bit complex   ",
    "near pointer to 128 bit complex  ",
    "near pointer to 160 bit complex  ",
    "Unknown (0xAF)                   ",
    "near pointer to 8 bit boolean    ",	// 0xb0
    "near pointer to 16 bit boolean   ",
    "near pointer to 32 bit boolean   ",
    "Unknown (0xB3)                   ",
    "near pointer to 8 bit character  ",
    "near pointer to 16 bit characters",
    "near pointer to 32 bit characters",
    "near pointer to void             ",
    "near pointer to 15 bit unsigned  ",
    "near pointer to 24 bit unsigned  ",
    "near pointer to 31 bit unsigned  ",
    "Unknown (0xBB)                   ",
    "Unknown (0xBC)                   ",
    "Unknown (0xBD)                   ",
    "Unknown (0xBE)                   ",
    "Unknown (0xBF)                   ",
    "far pointer to 8 bit signed      ",	// 0xc0
    "far pointer to 16 bit signed     ",
    "far pointer to 32 bit signed     ",
    "Unknown (0xC3)                   ",
    "far pointer to 8 bit unsigned    ",
    "far pointer to 16 bit unsigned   ",
    "far pointer to 32 bit unsigned   ",
    "Unknown (0xC7)                   ",
    "far pointer to 32 bit real       ",
    "far pointer to 64 bit real       ",
    "far pointer to 80 bit real       ",
    "Unknown (0xCB)                   ",
    "far pointer to 64 bit complex    ",
    "far pointer to 128 bit complex   ",
    "far pointer to 160 bit complex   ",
    "Unknown (0xCF)                   ",
    "far pointer to 8 bit boolean     ",	// 0xd0
    "far pointer to 16 bit boolean    ",
    "far pointer to 32 bit boolean    ",
    "Unknown (0xD3)                   ",
    "far pointer to 8 bit character   ",
    "far pointer to 16 bit characters ",
    "far pointer to 32 bit characters ",
    "far pointer to void              ",
    "far pointer to 15 bit unsigned   ",
    "far pointer to 24 bit unsigned   ",
    "far pointer to 31 bit unsigned   ",	// 0xda
};

typedef _PFN16 *_Seg16 PFN16;

static BOOL fInForceExit = FALSE;

// Statics that could be auto variables

static HMODULE hMod;
static ULONG ulObjNum;
static ULONG ulOffset;
static CHAR szBuffer[CCHMAXPATH];

static CHAR szModName[CCHMAXPATH];
static CHAR szFileName[CCHMAXPATH];
static ULONG ulSize;
static ULONG ulAttr;
// static ULONG ulFlags;		// 05 Dec 09 SHL
static ULONG ul;
static PSZ psz;
static USHORT us;

/**
 * Exception handler called by application
 */


static ULONG APIENTRY HandleFatalException(PEXCEPTIONREPORTRECORD pERepRec,
					   PEXCEPTIONREGISTRATIONRECORD pERegRec,
					   PCONTEXTRECORD pCtxRec,
					   PVOID p);

// Thanks to John Currier :
// Do not call 16 bit code in MyHandler function to prevent call
// to __EDCThunkProlog and problems in guard page exception handling
// Also reduce the stack size to 1K for true 16 bit calls.
// 16 bit calls thunk will now only occur on fatal exceptions

#pragma stack16(1024)

//== MyHandler() Per thread exception handler entry ==

ULONG APIENTRY MyHandler(PEXCEPTIONREPORTRECORD pERepRec,
			 PEXCEPTIONREGISTRATIONRECORD pERegRec,
			 PCONTEXTRECORD pCtxRec,
			 PVOID p)
{
    ULONG rc = XCPT_CONTINUE_SEARCH;

    if ((pERepRec->ExceptionNum & XCPT_SEVERITY_CODE) == XCPT_FATAL_EXCEPTION)
    {
	if (pERepRec->ExceptionNum != XCPT_PROCESS_TERMINATE &&
	    pERepRec->ExceptionNum != XCPT_UNWIND &&
	    pERepRec->ExceptionNum != XCPT_SIGNAL &&
	    pERepRec->ExceptionNum != XCPT_BREAKPOINT &&
	    pERepRec->ExceptionNum != XCPT_SINGLE_STEP &&
	    pERepRec->ExceptionNum != XCPT_ASYNC_PROCESS_TERMINATE)
	{
	    // If not one of the above handle here
	    rc = HandleFatalException(pERepRec, pERegRec, pCtxRec, p);
	}
    }

    return rc;
}

//== HandleFatalException() exception handler worker ==

static ULONG APIENTRY HandleFatalException(PEXCEPTIONREPORTRECORD pERepRec,
					   PEXCEPTIONREGISTRATIONRECORD pERegRec,
					   PCONTEXTRECORD pCtxRec,
					   PVOID p)
{
    PUCHAR puchValidStackBottom;
    PUCHAR puchStackPtr;
    // ULONG ulSize;			// 10 Oct 07 SHL
    // ULONG ulAttr;			// 10 Oct 07 SHL
    ULONG ulCSSize;
    APIRET rc;
    APIRET semrc;
    APIRET16 rc16;
    PTIB ptib;
    PPIB ppib;
    USHORT usMod16;
    USHORT us;
    ULONG ulNest;
    UCHAR szTrapFile[20];
#ifdef WANT_DOSDEBUG
    tDbgBuf DbgBuf;
#endif // WANT_DOSDEBUG
    // CHAR szModName[CCHMAXPATH];	// 10 Oct 07 SHL
    ULONG ulEIP;
    ULONG ulEBP;
    USHORT usCS;
    USHORT usSS;
    USHORT fisBigSeg;			// 10 Oct 07 SHL
    BOOL is32Bit;
    // USHORT usDupReported;		// 24 Feb 09 SHL
    PVOID pv;
    UCHAR abOldStuff[16];
    // CHAR szTranslate[17];		// 24 Feb 09 SHL

    static UINT cTrapCount;

    if (fInForceExit)
	return XCPT_CONTINUE_SEARCH;

    if ((pERepRec->ExceptionNum & XCPT_SEVERITY_CODE) != XCPT_FATAL_EXCEPTION)
    {
	/* printf("Other non fatal exception %8.8lx ",pERepRec->ExceptionNum); */
	/* printf("At address                %8.8lx\n",pERepRec->ExceptionAddress); */
    }
    else {
	if ((pERepRec->ExceptionNum != XCPT_PROCESS_TERMINATE) &&
	    (pERepRec->ExceptionNum != XCPT_UNWIND) &&
	    (pERepRec->ExceptionNum != XCPT_SIGNAL) &&
	    (pERepRec->ExceptionNum != XCPT_ASYNC_PROCESS_TERMINATE))
	{
	    // Got process exception we what to handle
	    // 25 Apr 10 SHL Try to report traps in exceptq without dieing again
	    if (!cTrapCount)
		DosEnterMustComplete(&ulNest);
	    else {
		// Trapped in handler
		DosUnsetExceptionHandler(pERegRec);
		if (hTrap == NULL)
		    hTrap = stderr;		// Try to get output somewhere
		if (hTrap != stderr)
		    fputs("\nException handler trapped\n",stderr);
	    }

	    // 25 Apr 10 SHL Avoid reopen if here because exceptq trapped
	    if (hTrap == NULL) {
		rc = DosGetInfoBlocks(&ptib, &ppib);
		if (rc == NO_ERROR) {
		    sprintf(szTrapFile, "%04X_%d.TRP",
			    ppib->pib_ulpid, ptib->tib_ptib2->tib2_ultid);
		}
		else
		    sprintf(szTrapFile, "TRAP.TRP");	// Can not get PID - use generic name
		printf("Creating %s\n", szTrapFile);
		hTrap = fopen(szTrapFile, "a");
		if (hTrap == NULL) {
		    printf("Can not append to %s - writing to stdout (%d)\n", szTrapFile, errno);
		    hTrap = stdout;
		}
	    }

	    DosError(FERR_DISABLEEXCEPTION | FERR_DISABLEHARDERR);

	    setbuf(hTrap, NULL);
	    fputs("/* Start of exception report */\n",hTrap);

	    if (cTrapCount) {
		// 25 Apr 10 SHL Try to report exceptq trap address in case we die again later
		if (pCtxRec->ContextFlags & CONTEXT_CONTROL) {
		    fprintf(hTrap, "\nException handler trapped at %4.4lX:%8.8lX\n",
			    pCtxRec->ctx_SegCs, pCtxRec->ctx_RegEip);
		}
		else
		    fputs("\nException handler trapped at unknown address\n",hTrap);
	    }
	    cTrapCount++;

	    fprintf(hTrap, "Exception %8.8lX occurred", pERepRec->ExceptionNum);
	    fprintf(hTrap, " at %s", _strtime(szBuffer));
	    fprintf(hTrap, " %s\n", _strdate(szBuffer));

	    if (pERepRec->ExceptionNum == XCPT_ACCESS_VIOLATION) {
		psz = NULL;
		switch (pERepRec->ExceptionInfo[0]) {
		case XCPT_READ_ACCESS:
		    fprintf(hTrap, "Attempting to read from %8.8lX\n", pERepRec->ExceptionInfo[1]);
		    break;
		case XCPT_WRITE_ACCESS:
		    fprintf(hTrap, "Attempting to write to %8.8lX\n", pERepRec->ExceptionInfo[1]);
		    break;
		case XCPT_EXECUTE_ACCESS:
		    fprintf(hTrap, "Attempting to execute at %8.8lX\n", pERepRec->ExceptionInfo[1]);
		    break;
		case XCPT_SPACE_ACCESS:
		    /* Thanks to John Currier              */
		    /* It looks like this is off by one... - fixme to know why */
		    fprintf(hTrap, "Attempt to access beyond selector %8.8X limit",
			    pERepRec->ExceptionInfo[1] ?
			      pERepRec->ExceptionInfo[1] + 1 : 0);
		    break;
		case XCPT_LIMIT_ACCESS:
		    psz = "Limit access fault\n";
		    break;
		case XCPT_UNKNOWN_ACCESS:
		    psz = "Unknown access fault\n";
		    break;
		default:
		    psz = "Other unknown access fault\n";
		} /* switch */
		if (psz)
		    fputs(psz, hTrap);
	    } /* if access violation */

	    fputc('\n', hTrap);

	    rc = DosQuerySysInfo(QSV_VERSION_MAJOR, QSV_VERSION_MINOR,
				 aulOSVersion, sizeof(aulOSVersion));
	    if (rc == NO_ERROR &&
		aulOSVersion[0] >= 20 &&
		aulOSVersion[1] >= 10) {
		/* version must be over 2.1 for DosQueryModFromEIP */
		fprintf(hTrap, "eCS/OS2 version %d.%d; exceptq version " EXCEPTQ_VERSION " built "__DATE__ "\n",
			aulOSVersion[0] / 10, aulOSVersion[1]);
		rc = DosQueryModFromEIP(&hMod, &ulObjNum, CCHMAXPATH,
					szModName, &ulOffset,
					(ULONG)pERepRec->ExceptionAddress);
		if (rc != NO_ERROR)
		    fputs("Invalid execution address\n", hTrap);
		else {
		    fprintf(hTrap, "Failing code module internal name %s\n", szModName);
		    rc = DosQueryModuleName(hMod, CCHMAXPATH, szFileName);
		    fprintf(hTrap, "Failing code module file name %s\n",
			    rc == NO_ERROR ? szFileName : szModName);
		    fprintf(hTrap, "Failing code at %8.8X (%4.4X:%8.8X)\n",
			    (ULONG)pERepRec->ExceptionAddress, ulObjNum + 1, ulOffset);
		    if (rc == NO_ERROR) {
			fputs("\n     File      Line#  Public Symbol\n", hTrap);
			fputs(  "   \n", hTrap);
			rc = PrintLineNum(szFileName, ulObjNum, ulOffset);
			if (rc == NO_ERROR)
			    PrintLocalVariables(pCtxRec->ctx_RegEbp);
			if (rc != NO_ERROR && strlen(szFileName) > 3) {
			    /* No embedded debug or DBG file, try symbol file */
			    strcpy(szFileName + strlen(szFileName) - 3, "SYM");
			    PrintSymbolFromSymFile(szFileName, ulObjNum, ulOffset);
			}
		    }
		}
	    }

	    fputs("\nĿ\n",hTrap);

	    if (pCtxRec->ContextFlags & CONTEXT_INTEGER) {
		// 11 Oct 07 SHL fixme to optimize
		fprintf(hTrap, " EAX : %8.8lX ", pCtxRec->ctx_RegEax);
		fprintf(hTrap, "EBX  : %8.8lX ", pCtxRec->ctx_RegEbx);
		fprintf(hTrap, "ECX : %8.8lX ", pCtxRec->ctx_RegEcx);
		fprintf(hTrap, "EDX  : %8.8lX \n", pCtxRec->ctx_RegEdx);
		fprintf(hTrap, " ESI : %8.8lX ", pCtxRec->ctx_RegEsi);
		fprintf(hTrap, "EDI  : %8.8lX                                \n", pCtxRec->ctx_RegEdi);	// 03 Dec 09 SHL
	    }
	    if (pCtxRec->ContextFlags & CONTEXT_CONTROL) {
		fprintf(hTrap, " ESP : %8.8lX ", pCtxRec->ctx_RegEsp);
		fprintf(hTrap, "EBP  : %8.8lX ", pCtxRec->ctx_RegEbp);
		fprintf(hTrap, "EIP : %8.8lX ", pCtxRec->ctx_RegEip);
		fprintf(hTrap, "EFLG : %8.8lX \n", pCtxRec->ctx_EFlags);

		fprintf(hTrap, " CS  : %4.4lX     ", pCtxRec->ctx_SegCs);

		rc16 = DOS16SIZESEG((USHORT)pCtxRec->ctx_SegCs, &ulCSSize);
		if (rc16 == NO_ERROR)
		    fprintf(hTrap, "CSLIM: %8.8lX ", ulCSSize);
		else if (pCtxRec->ctx_SegCs == FLATCS) {
		    ulCSSize = 0x1FFFFFFFL;	// 512MB fixme?
		    fprintf(hTrap, "CSLIM: %8.8lX ", ulCSSize);
		}
		else {
		    ulCSSize = 0;
		    fprintf(hTrap, "CSLIM: ???????? ", ulCSSize);
		}

		fprintf(hTrap, "SS  : %4.4lX     ", pCtxRec->ctx_SegSs);
		rc16 = DOS16SIZESEG((USHORT)pCtxRec->ctx_SegSs, &ulSize);
		if (rc16 == NO_ERROR)
		    fprintf(hTrap, "SSLIM: %8.8lX \n", ulSize);
		else if (pCtxRec->ctx_SegSs == FLATDS) {
		    fprintf(hTrap, "SSLIM: %8.8lX \n", 0x1FFFFFFFL);	// 512MB fixme?
		}
		else
		    fputs("SSLIM: ???????? \n",hTrap);
	    }
	    if (pCtxRec->ContextFlags & CONTEXT_SEGMENTS) {
		fprintf(hTrap, " DS  : %4.4lX     ", pCtxRec->ctx_SegDs);
		fprintf(hTrap, "ES   : %4.4lX     ", pCtxRec->ctx_SegEs);
		fprintf(hTrap, "FS  : %4.4lX     ", pCtxRec->ctx_SegFs);
		fprintf(hTrap, "GS   : %4.4lX     \n", pCtxRec->ctx_SegGs);
	    }

	    fputs("\n",hTrap);

	    if (~pCtxRec->ContextFlags & CONTEXT_CONTROL)
		fputs("\nControl context not available\n",hTrap);
	    else {
		// fixme to DosLoadModule dis386
		// fixme to replace dis386
		// fixme to check big seg better
		fisBigSeg = pCtxRec->ctx_SegCs == FLATCS || pCtxRec->ctx_RegEip > 0x00010000;
		if (fisBigSeg) {
		    // 32-bit code seg
		    /* Avoid traps in 16:16 Disasm DLL */
		    if (DosAllocMem(&pvDis386Buffer, 0x100, fALLOC) == NO_ERROR) {
			ulSize = 0x100;
			rc = DosQueryMem((PVOID)pCtxRec->ctx_RegEip, &ulSize, &ulAttr);
			if (rc == NO_ERROR &&
			    (ulAttr & (PAG_READ | PAG_EXECUTE)) == (PAG_READ | PAG_EXECUTE)) {
			    memcpy(pvDis386Buffer, (PVOID)pCtxRec->ctx_RegEip, ulSize);
			    pDis386Data = DISASM(pvDis386Buffer,
						 (USHORT)pCtxRec->ctx_RegEip,
						 fisBigSeg);
			    fprintf(hTrap, "\nFailing instruction at CS:EIP %4.4X:%8.8X is %s\n",
				    pCtxRec->ctx_SegCs,
				    pCtxRec->ctx_RegEip,
				    pDis386Data->buf);
			}
			else {
			    fprintf(hTrap, "\nCan not disassemble instruction at CS:EIP %4.4X:%8.8X\n",
				    pCtxRec->ctx_SegCs, pCtxRec->ctx_RegEip);
			}
		    }

		    fputs("\nĿ\n", hTrap);
		    fputs(" Register content analysis          \n", hTrap);
		    fputs("Ĵ\n", hTrap);
		    PrintMemoryAttributes((PVOID)pCtxRec->ctx_RegEax, "EAX");
		    PrintMemoryAttributes((PVOID)pCtxRec->ctx_RegEbx, "EBX");
		    PrintMemoryAttributes((PVOID)pCtxRec->ctx_RegEcx, "ECX");
		    PrintMemoryAttributes((PVOID)pCtxRec->ctx_RegEdx, "EDX");
		    PrintMemoryAttributes((PVOID)pCtxRec->ctx_RegEdi, "EDI");
		    PrintMemoryAttributes((PVOID)pCtxRec->ctx_RegEsi, "ESI");
		    fputs("\n",hTrap);
		}
		else {
		    // 16-bit code seg
		    if (ulCSSize > pCtxRec->ctx_RegEip) {
			pDis386Data = DISASM(MAKE16P(pCtxRec->ctx_SegCs,
						     pCtxRec->ctx_RegEip),
					     (USHORT)pCtxRec->ctx_RegEip,
					     fisBigSeg);
			fprintf(hTrap, "\nFailing instruction at CS:IP %4.4X:%4.4X is %s\n",
				pCtxRec->ctx_SegCs,
				pCtxRec->ctx_RegEip,
				pDis386Data->buf);
		    }
		    else {
			fprintf(hTrap, "\nCan not disassemble instruction at CS:IP %4.4X:%4.4X\n",
				pCtxRec->ctx_SegCs, pCtxRec->ctx_RegEip);
		    }

		    fputs("\nĿ\n", hTrap);
		    fputs(" Source Destination registers pair analysis \n", hTrap);
		    fputs("Ĵ\n", hTrap);
		    rc16 = DOS16SIZESEG((USHORT)pCtxRec->ctx_SegDs, &ulSize);
		    if (rc16 == NO_ERROR) {
			if ((USHORT)ulSize < (USHORT)pCtxRec->ctx_RegEsi)
			    fputs(" DS:SI points outside Data Segment          \n", hTrap);
			else
			    fputs(" DS:SI is a valid source                    \n", hTrap);
		    }
		    else
			fputs(" DS (Data Segment) Is Invalid               \n", hTrap);

		    rc16 = DOS16SIZESEG((USHORT)pCtxRec->ctx_SegEs, &ulSize);
		    if (rc16 == NO_ERROR) {
			if ((USHORT)ulSize < (USHORT)pCtxRec->ctx_RegEdi)
			    fputs(" ES:DI points outside Extra Segment         \n", hTrap);
			else
			    fputs(" ES:DI is a valid destination               \n", hTrap);
		    }
		    else
			fputs(" ES (Extra Segment) Is Invalid              \n", hTrap);

		    fputs("\n", hTrap);
		} /* if 16-bit seg */

		rc = DosGetInfoBlocks(&ptib, &ppib);
		if (rc == NO_ERROR) {
		    CHAR szFormat[10];
		    fprintf(hTrap, "\nThread slot %lX (%lu); Id %lX; Priority %p\n",
			    ptib->tib_ordinal,
			    ptib->tib_ordinal,
			    ptib->tib_ptib2->tib2_ultid,
			    ptib->tib_ptib2->tib2_ulpri);
		    pv = ptib->tib_pstack;
		    sprintf(szFormat, "%8.8lX", pv);
		    fprintf(hTrap, "Stack bottom %8.8lX (%4.4s:%4.4s); ", ptib->tib_pstack, szFormat, szFormat + 4);
		    pv = ptib->tib_pstacklimit;
		    sprintf(szFormat, "%8.8lX", pv);
		    fprintf(hTrap, "Stack top %8.8lX (%4.4s:%4.4s)\n", ptib->tib_pstacklimit, szFormat, szFormat + 4);
		    fprintf(hTrap, "Process id %4.4X (%lu); ",
			    ppib->pib_ulpid, ppib->pib_ulpid);

		    rc = DosQueryModuleName(ppib->pib_hmte, CCHMAXPATH, szFileName);
		    fprintf(hTrap, "Executable name %s\n",
			    rc == NO_ERROR ? szFileName : "N/A");

		    if (pCtxRec->ContextFlags & CONTEXT_CONTROL) {
			ulEIP = pCtxRec->ctx_RegEip;
			usCS = pCtxRec->ctx_SegCs;
			ulEBP = pCtxRec->ctx_RegEbp;
			usSS = pCtxRec->ctx_SegSs;
		    }
		    else {
			ulEIP = (ULONG)pERepRec->ExceptionAddress,
			usCS = 0;	// fixme to guess better
			ulEBP = (ULONG)ptib->tib_pstack;	// fixme to guess better
			usSS = 0;	// fixme to guess better
		    }

		    // fixme to bypass if insufficient context
		    WalkStack(ptib->tib_pstack,
			      ptib->tib_pstacklimit,
			      ulEBP,
			      usSS,
			      ulEIP,
			      usCS);

		    // Find accessible stack range

		    /* round to start of page to check first stack valid page - fixme to know why? */
		    /* Thanks to John Currier for pointing me the guard page problem */
		    for (puchStackPtr = ((PUCHAR)ptib->tib_pstacklimit);
			 puchStackPtr -= 0x1000;
			 puchStackPtr >= (PUCHAR)ptib->tib_pstack)
		    {
			ulSize = 0x1000;
			rc = DosQueryMem(puchStackPtr, &ulSize, &ulAttr);
			if (rc != NO_ERROR ||
			    ~ulAttr & PAG_COMMIT ||
			    ~ulAttr & PAG_READ)
			{
			   puchStackPtr += 0x1000;
			   break;
			}
		    }

		    if (puchStackPtr > (PUCHAR)ptib->tib_pstacklimit)
			fputs("\n/*--- Stack can not be accessed ---*/\n",hTrap);
		    else {

			is32Bit = usCS == FLATCS;
			abOldStuff[0] = ~(*puchStackPtr);	/* Ensure first line is printed */
			fprintf(hTrap, "\nAccessible Stack bottom at %p\n", puchStackPtr);

			puchValidStackBottom = puchStackPtr;

			// 10 Oct 07 SHL Display labels on stack

			fputs("\nLabels on Stack\n",hTrap);
			fputs("                                               Source     Line    Nearest\n", hTrap);
			fputs("  Stack    Address   Module    Obj:Offset       File      Numbr  Public Symbol\n", hTrap);
			fputs("       \n", hTrap);

			// Optimize start location
			puchStackPtr = puchValidStackBottom;
			if (pCtxRec->ContextFlags & CONTEXT_CONTROL) {
			    if ((pCtxRec->ctx_RegEbp & 0x3) == 0 &&
				     pCtxRec->ctx_RegEbp > (ULONG)puchStackPtr &&
				     (PVOID)pCtxRec->ctx_RegEbp < ptib->tib_pstacklimit)
			    {
				puchStackPtr = (PUCHAR)pCtxRec->ctx_RegEbp;
			    }
			    else if ((pCtxRec->ctx_RegEsp & 0x3) == 0 &&
				pCtxRec->ctx_RegEsp > (ULONG)puchStackPtr &&
				(PVOID)pCtxRec->ctx_RegEsp < ptib->tib_pstacklimit)
			    {
				puchStackPtr = (PUCHAR)pCtxRec->ctx_RegEsp;
			    }
			}

			for (; puchStackPtr < (PUCHAR)ptib->tib_pstacklimit;
			     puchStackPtr += 4)
			{
			    ul = *(PULONG)puchStackPtr;
			    if (ul < 0x10000L)
				continue;	// Check fast
			    ulSize = 4;
			    rc = DosQueryMem((PVOID)ul, &ulSize, &ulAttr);
			    if (rc != NO_ERROR || ~ulAttr & PAG_COMMIT || ~ulAttr & PAG_EXECUTE)
				continue;
			    rc = DosQueryModFromEIP(&hMod, &ulObjNum, CCHMAXPATH,
						    szModName, &ulOffset, ul);
			    if (rc != NO_ERROR)
				continue;
			    if (ulOffset == 0xffffffff)
				continue;
			    fprintf(hTrap, " %08X %08X %-8.8s %04X:%08X",
				    puchStackPtr,
				    ul,
				    szModName,
				    ulObjNum + 1,
				    ulOffset);
			    rc = DosQueryModuleName(hMod, CCHMAXPATH, szFileName);
			    if (rc != NO_ERROR) {
				fputc('\n', hTrap);
				continue;
			    }
			    rc = PrintLineNum(szFileName, ulObjNum, ulOffset);
#			    if 0	// Enable to test trap in handler logic
			    if (cTrapCount > 1)
				*(CHAR*)0 = cTrapCount;
#		            endif
			    /* if no embedded debug or DBG file try with symbol files */
			    if (rc != NO_ERROR) {
				/* Form .sym file name */
				strcpy(szFileName + strlen(szFileName) - 3, "SYM");
				PrintSymbolFromSymFile(szFileName, ulObjNum, ulOffset);
			    }
			} // for

			// Dump stack content

			fputs("\n/*--- Stack Bottom ---*/\n",hTrap);

			PrintMemory(puchValidStackBottom, (PUCHAR)ptib->tib_pstacklimit, is32Bit);

			fprintf(hTrap, "\n/*--- Stack Top ---*/\n");

		    } /* if range OK */

#		    if 0	// Enable to test trap in handler logic
		    *(CHAR*)0 = cTrapCount;
#		    endif

		    // Dump blocks pointed to by registers, 24 Feb 09 SHL

		    is32Bit = pCtxRec->ctx_SegDs == FLATDS;
		    PrintMemoryAt((PUCHAR)pCtxRec->ctx_RegEax, "EAX", is32Bit);
		    PrintMemoryAt((PUCHAR)pCtxRec->ctx_RegEbx, "EBX", is32Bit);
		    PrintMemoryAt((PUCHAR)pCtxRec->ctx_RegEcx, "ECX", is32Bit);
		    PrintMemoryAt((PUCHAR)pCtxRec->ctx_RegEdx, "EDX", is32Bit);
		    PrintMemoryAt((PUCHAR)pCtxRec->ctx_RegEdi, "EDI", is32Bit);
		    PrintMemoryAt((PUCHAR)pCtxRec->ctx_RegEsi, "ESI", is32Bit);

		    ListModules();

		} /* if no error */

	    } /* if CONTEXT_CONTROL */

	    fputs("/*--- End of exeption report ---*/\n",hTrap);

	    if (hTrap != stdout)
		fclose(hTrap);

	    DosExitMustComplete(&ulNest);
	    DosUnsetExceptionHandler(pERegRec);
	} /* if fatal */
    }

    return XCPT_CONTINUE_SEARCH;

} // HandleFatalException

//== SETEXCEPT() Define exception handler ==

// 28 May 08 SHL fixme to have 16 and 32-bit entry points

APIRET16 APIENTRY16 SETEXCEPT(PEXCEPTIONREGISTRATIONRECORD _Seg16 pxcpthand)
{
    APIRET rc;

    rc = DosError(FERR_DISABLEEXCEPTION | FERR_DISABLEHARDERR);
    printf("DosError rc %d\n", rc);
    pxcpthand->prev_structure = 0;
    pxcpthand->ExceptionHandler = &MyHandler;
    rc = DosSetExceptionHandler(pxcpthand);
    printf("DosSetExceptionHandler rc %d\n", rc);

    return NO_ERROR;
}

//== UNSETEXCEPT() Unset exception hanlder ==

APIRET16 APIENTRY16 UNSETEXCEPT(PEXCEPTIONREGISTRATIONRECORD _Seg16 pxcpthand)
{
    APIRET rc;

    rc = DosUnsetExceptionHandler(pxcpthand);
    printf("DosUnsetExceptionHandler rc %d\n", rc);
    return NO_ERROR;
}

// qsPtrRec_t *pRec;			// 06 Feb 08 SHL
QSPTRREC *pRec;

#ifdef WANT_DOSDEBUG

//== ListModules() List loaded modules using DosDebug ==

static VOID ListModules(VOID)
{
    APIRET rc;
    APIRET16 rc16;
    qsLrec_t *pLib;
    RESULTCODES ReturnCodes;

    UCHAR szLoadError[40];		/*DosExecPGM buffer */
    UCHAR *szProcessName = "DEBUGGEE.EXE";

    rc16 = DOS16ALLOCSEG(0xFFFF, &Selector, 0);
    if (rc16 != NO_ERROR)
	fprintf(hTrap, "DosAllocSeg Failed %hd\n", rc16);
    else {
	ULONG *pBuf;
	pBuf = MAKEP(Selector, 0);
	rc16 = DOSQPROCSTATUS(pBuf, 0xFFFF);
	if (rc16 != NO_ERROR)
	    fprintf(hTrap, "DosQProcStatus Failed %hd\n", rc16);
	else {
	    rc = DosExecPgm(szLoadError,		/* Object name buffer */
			    sizeof(szLoadError),	/* Length of object name buffer */
			    EXEC_TRACE,	/* Asynchronous/Trace flags */
			    "Debug",	/* Argument string */
			    NULL,	/* Environment string */
			    &ReturnCodes,	/* Termination codes */
			    szProcessName);	/* Program file name */
	    if (rc != NO_ERROR) {
		fprintf(hTrap, "rc %d; Process id %d; Return code %d \n",
			rc,
			ReturnCodes.codeTerminate,
			ReturnCodes.codeResult);
		return;
	    }
	    fprintf(hTrap, "Connecting  to PID %d\n", ReturnCodes.codeTerminate);
	    DbgBuf.Cmd = DBG_C_Connect;	/* Indicate that a Connect is requested */
	    DbgBuf.Pid = ReturnCodes.codeTerminate;
	    DbgBuf.Tid = 0;
	    DbgBuf.Value = DBG_L_386;
	    rc = DosDebug(&DbgBuf);
	    if (rc != NO_ERROR) {
		fprintf(hTrap, "DosDebug error return code = %ld Note %8.8lX\n", rc, DbgBuf.Cmd);
		fprintf(hTrap, "Value          = %8.8lX %ld\n", DbgBuf.Value, DbgBuf.Value);
	    }
	    fprintf(hTrap, "Connected to PID %d\n", ReturnCodes.codeTerminate);

	    pRec = (_QSPTRREC *) pBuf;
	    pLib = pRec->pLibRec;
	    while (pLib) {
		GetObjects(&DbgBuf, pLib->hmte, pLib->pName);
		pLib = pLib->pNextRec;
	    }				/* endwhile */
	}
    }

} // ListModules

//== GetObjects() Lists object for module using DosDebug ==

static VOID GetObjects(tDbgBuf *pDbgBuf, HMODULE hMte, PSZ pszName);

static VOID GetObjects(tDbgBuf *pDbgBuf, HMODULE hMte, PSZ pszName)
{
    APIRET rc;
    UINT uObjNum;

    pDbgBuf->MTE = (ULONG)hMte;
    rc = NO_ERROR;
    fprintf(hTrap, "DLL %s Handle %d\n", pszName, hMte);
    fputs("Object Number    Address    Length     Flags      Type\n", hTrap);

    for (uObjNum = 1; uObjNum < 256; uObjNum++) {
	pDbgBuf->Cmd = DBG_C_NumToAddr;
	pDbgBuf->Pid = ReturnCodes.codeTerminate;
	pDbgBuf->Value = uObjNum;	/* Get nth object address in module with given MTE */
	pDbgBuf->Buffer = 0;
	pDbgBuf->Len = 0;
	rc = DosDebug(pDbgBuf);
	if (rc == NO_ERROR && pDbgBuf->Cmd == NO_ERROR) {
	    // ULONG ulSize;		// 10 Oct 07 SHL
	    APIRET16 rc16;

	    pDbgBuf->Len = 0;
	    pDbgBuf->Value = 0;
	    if (pDbgBuf->Addr != 0) {
		pDbgBuf->Cmd = DBG_C_AddrToObject;
		pDbgBuf->Pid = ReturnCodes.codeTerminate;
		rc = DosDebug(pDbgBuf);
		// 17 Jul 07 SHL
		if (rc != NO_ERROR || pDbgBuf->Cmd != NO_ERROR) {
		    pDbgBuf->Len = 0;
		    pDbgBuf->Value = 0;
		}
	    }
	    fprintf(hTrap, "      % 6.6d    %8.8lX   %8.8lX   %8.8lX ", uObjNum,
		    pDbgBuf->Addr, pDbgBuf->Len, pDbgBuf->Value);
	    if (pDbgBuf->Addr != 0) {
		// fixme to know if DOS16SIZESEG really useful here
		rc16 = DOS16SIZESEG(SELECTOROF(pDbgBuf->Addr), &ulSize);
		if (rc16 == NO_ERROR && (~pDbgBuf->Value & OBJBIGDEF))
		    fprintf(hTrap, " - 16:16  Selector %4.4hX\n", SELECTOROF((PVOID)pDbgBuf->Addr));
		else
		    fputs(" - 32 Bits\n", hTrap);
	    }
	    else
		fputs(" - ?\n", hTrap);
	}
	else {
	    // printf("DosDebug return code = %ld Notification %8.8lX\n", rc,pDbgBuf->Cmd);
	    // printf("Value                = %8.8lX %ld\n",pDbgBuf->Value,pDbgBuf->Value);
	    break;
	}
    } /* for objects */
    fputc('\n', hTrap);

} // GetObjects

#else /* ifndef WANT_DOSDEBUG */

//== GetObjects() List objects for module ==

//== ListModules() List modules for executable  ==

static VOID ListModules()
{
    APIRET rc;
    APIRET16 rc16;

    PVOID pvBaseAddress;
    ULONG ulRegionSize;
    ULONG ulAllocationFlags;
    HMODULE hLastModule;
    // CHAR szModName[CCHMAXPATH];	// 10 Oct 07 SHL
    // ULONG ulSize;			// 10 Oct 07 SHL

    hLastModule = 0;
    pvBaseAddress = (PVOID)0x10000;	// Ring 3 apps
    ulRegionSize = 0x3FFFFFFF;		// 1GiB - 1
    fputs("\nĿ\n", hTrap);
    fputs(" List of currently accessed modules (DLLs) object addresses              ", hTrap);
    rc = DosQueryMem(pvBaseAddress, &ulRegionSize, &ulAllocationFlags);
    while (rc == NO_ERROR) {
	if (ulAllocationFlags & PAG_EXECUTE &&
	    ulAllocationFlags & PAG_BASE)
	{
	    rc = DosQueryModFromEIP(&hMod, &ulObjNum, CCHMAXPATH,
				    szModName, &ulOffset, (ULONG)pvBaseAddress);
	    if (rc == NO_ERROR) {
		if (hMod != hLastModule) {
		    DosBeep(650, 1);		// Tell user we're still working
		    rc = DosQueryModuleName(hMod, CCHMAXPATH, szFileName);
		    sprintf(szBuffer, "%lX (%lu)", hMod, hMod);
		    fputs("\nĴ\n", hTrap);
		    fprintf(hTrap, " Module %-45.45s Handle %-11.11s \n",
			    rc == NO_ERROR ? szFileName : szModName,
			    szBuffer);
		    fputs(" Object Number    Address    Length     Flags       Type                 ", hTrap);
		    hLastModule = hMod;
		}

		if (ulOffset == 0xffffffff) {
		    fprintf(hTrap, "\n %4.4X:%8.8X    %8.8lX   %8.8lX   %8.8lX ",
			    ulObjNum & 0xffff, ulOffset, pvBaseAddress, ulRegionSize, ulAllocationFlags);
		}
		else {
		    fprintf(hTrap, "\n       % 6.6d    %8.8lX   %8.8lX   %8.8lX ",
			    ulObjNum, pvBaseAddress, ulRegionSize, ulAllocationFlags);
		}

		// fixme to know of DOS16SIZESEG really needed these days
		// fixme to know if 16/32 bit
		rc16 = DOS16SIZESEG(SELECTOROF(pvBaseAddress), &ulSize);
		if (rc16 == NO_ERROR && ulRegionSize < 0x10000)
		    fprintf(hTrap, " - 16:16  Selector %4.4hX ", SELECTOROF((PVOID)pvBaseAddress));
		else
		    fputs(" - 32 Bits              ", hTrap);
	    }
	}

	if (ulAllocationFlags & PAG_FREE)
	    ulRegionSize = 0x10000;

	ulRegionSize += 0x0FFF;
	ulRegionSize &= 0xFFFFF000;	// Round to 64KB
	pvBaseAddress = (PCHAR)pvBaseAddress + ulRegionSize;
	ulRegionSize = ((PCHAR)0x3FFFFFFF) - (PCHAR)pvBaseAddress;

	// Find next valid region
	rc = DosQueryMem(pvBaseAddress, &ulRegionSize, &ulAllocationFlags);
	while (rc == ERROR_INVALID_ADDRESS ||
	       rc == ERROR_NO_OBJECT)
	{
	    pvBaseAddress = (PCHAR)pvBaseAddress + 0x10000;
	    if (pvBaseAddress > (PVOID)0x3FFFFFFF)
		break;

	    ulRegionSize = (PCHAR)0x3FFFFFFF - (PCHAR)pvBaseAddress;
	    rc = DosQueryMem(pvBaseAddress, &ulRegionSize, &ulAllocationFlags);
	} /* while */

	if (pvBaseAddress > (PVOID)0x3FFFFFFF)
	    break;			// Stop at 1GB

    } /* while OK */

    fputs("\n\n", hTrap);
} // ListModules

#endif /* ifndef WANT_DOSDEBUG */

//=== PrintMemoryAttributes() Print memory attributes ===

static VOID PrintMemoryAttributes(PVOID pvAddress, PSZ pszDesc)
{
    APIRET rc;
    // ULONG ulSize = 1;		// 10 Oct 07 SHL
    // ULONG ulAttr;			// 10 Oct 07 SHL

    ulSize = 1;
    rc = DosQueryMem(pvAddress, &ulSize, &ulAttr);
    if (rc != NO_ERROR)
	fprintf(hTrap, " %3.3s does not point to valid memory \n", pszDesc);
    else {
	if (ulAttr & PAG_FREE)
	    fprintf(hTrap, " %3.3s points to unallocated memory   \n", pszDesc);
	else {
	    if (~ulAttr & PAG_COMMIT)
		fprintf(hTrap, " %3.3s points to uncommited  memory   \n", pszDesc);
	    if (~ulAttr & PAG_WRITE)
		fprintf(hTrap, " %3.3s points to unwritable  memory   \n", pszDesc);
	    if (~ulAttr & PAG_READ)
		fprintf(hTrap, " %3.3s points to unreadable  memory   \n", pszDesc);
	}
    }
} // PrintMemoryAttributes

//=== WalkStack() Walk stack and print function addresses and local variables ===

/* Better New WalkStack From John Currier */

static VOID WalkStack(PVOID pvStackBottom, PVOID pvStackTop,
		      ULONG ulEBP, USHORT usSS,
		      ULONG ulEIP, USHORT usCS)
{
    ULONG ul32BitAddr;
    ULONG ulLastEbp;
    APIRET rc;
    // ULONG ulSize;			// 10 Oct 07 SHL
    // ULONG ulAttr;			// 10 Oct 07 SHL
    // HMODULE hMod;			// 10 Oct 07 SHL
    // ULONG ulObjNum;			// 10 Oct 07 SHL
    // ULONG ulOffset;			// 10 Oct 07 SHL
    BOOL isPass1 = TRUE;		// Use passed address 1st time thru

    BOOL is32Bit = usCS == FLATCS;

    // Note: we can't handle stacks bigger than 64K for now...

    fputs("\nCall Stack:\n", hTrap);
    fputs("                                             Source     Line     Nearest\n", hTrap);
    fputs("   EBP      Address Module    Obj:Offset      File      Numbr  Public Symbol\n", hTrap);
    fputs("       \n", hTrap);

    for (;;) {

	ulSize = 12;			// sufficient to hold ebp, cs:eip
	if (is32Bit)
	    rc = DosQueryMem((PVOID)(ulEBP), &ulSize, &ulAttr);
	else {
	    ul32BitAddr = (ULONG)(usSS & ~7) << 13 | ulEBP;	// Thunk
	    rc = DosQueryMem((PVOID)(ul32BitAddr), &ulSize, &ulAttr);
	}
	if (rc != NO_ERROR || ~ulAttr & PAG_COMMIT || ulSize < 12) {
	    if (is32Bit)
		fprintf(hTrap, "Invalid EBP %8.8X\n", ulEBP);
	    else
		fprintf(hTrap, "Invalid SS:BP: %4.4X:%4.4X\n", usSS, ulEBP);
	    break;
	}

	// If pass1, use passed initial values else get from stack
	if (!isPass1) {
	    if (is32Bit) {
		ulEIP = *((PULONG)(ulEBP + 4));
		if (ulEIP == FLATDS) {
		    /* If there's a "return address" of FLATDS following
		       EBP on the stack we have to adjust EBP by 44 bytes to get
		       at the real return address.  This has something to do with
		       calling 32-bit code via a 16-bit interface
		       This offset applies to VAC runtime and might vary for others.
		     */
		    ulEBP += 44;
		    ulEIP = *(PULONG)(ulEBP + 4);
		}
	    }
	    else {
		ulEIP = *((PUSHORT)(ul32BitAddr + 2));
		usCS = *(PUSHORT)(ul32BitAddr + 4);
		// If CS is now FLATDS, we are returning to 32 bit code from 16-bit code
		// fixme to check ulEIP == 0x150B?
		if (usCS == FLATDS) {
		    ulEBP = ul32BitAddr + 20;
		    usSS = FLATDS;
		    ulEIP = *(PULONG)(ulEBP + 4);
		    usCS = FLATCS;
		    is32Bit = TRUE;
		}
	    }
	}

	if (!is32Bit) {
	  // if the return address points to the stack then it's really just
	  // a pointer to the return address (UGH!).
	  if (usCS == usSS) {
	      ul32BitAddr = (ULONG)(usSS & ~7) << 13 | ulEIP;	// Thunk
	      ulEIP = *(PUSHORT)(ul32BitAddr);
	      usCS = *(PUSHORT)(ul32BitAddr + 2);
	  }

	  if (ulEIP == 0 && *(PUSHORT)ulEBP == 0) {
	      // End of the stack so these are both shifted by 2 bytes:
	      ul32BitAddr = (ULONG)(usSS & ~7) << 13 | ulEBP;	// Thunk
	      ulEIP = *(PUSHORT)(ul32BitAddr + 4);
	      usCS = *(PUSHORT)(ul32BitAddr + 6);
	  }
	}

	// For far calls in 16-bit programs have on the stack:
	//   BP:IP:CS
	//   where CS may be thunked
	//
	//     in byte order               swapped
	//    BP        IP   CS          BP   CS   IP
	//   4677      53B5 F7D0        7746 D0F7 B553
	//
	// for near calls 32bit programs have:
	//   EBP:EIP
	// and you'd have something like this (with SP added) (not
	// accurate values)
	//
	//       in byte order           swapped
	//      EBP       EIP         EBP       EIP
	//   4677 2900 53B5 F7D0   0029 7746 D0F7 B553
	//
	// So the basic difference is that 32bit programs have a 32bit
	// EBP and we can attempt to determine whether we have a 32bit
	// EBP by checking to see if its 'selector' is the same as SP.
	// Note that this technique limits us to checking stacks < 64K.
	//
	// Soooo, if IP (which maps into the same USHORT as the swapped
	// stack page in EBP) doesn't point to the stack (i.e. it could
	// be a 16bit IP) then see if CS is valid (as is or thunked).
	//
	// Note that there's the possibility of a 16bit return address
	// that has an offset that's the same as SP so we'll think it's
	// a 32bit return address and won't be able to successfully resolve
	// its details.

	if (!is32Bit ) {
	    if (ulEIP != usSS) {
		if (DOS16SIZESEG((USHORT)usCS, &ulSize) == NO_ERROR)
		    ; // ulRetAddr = MAKEULONG(ulEIP, usCS);	// 27 Jul 07 SHL
		else if (DOS16SIZESEG((usCS << 3) | 7, &ulSize) == NO_ERROR) {
		    // usCS = (usCS << 3) | 7;
		    // ulRetAddr = (ULONG)(USHORT * _Seg16)MAKEULONG(ulEIP, usCS);
		}
		else {
		    is32Bit = TRUE;
		    // fixme to be sure this is right
		    ulEIP = (ULONG)usCS << 16 | ulEIP;
		    usCS = FLATCS;	// fixme?
		}
	    }
	    else {
		// fixme to get adjusted EIP?
		is32Bit = TRUE;
		usCS = FLATCS;		// fixme?
	    }
	}

	if (isPass1)
	    fputs(" Trap  ->", hTrap);
	else
	    fprintf(hTrap, " %8.8X", ulEBP);

	if (is32Bit)
	    fprintf(hTrap, "  %8.8X", ulEIP);
	else
	    fprintf(hTrap, " %04.04X:%04.04X", usCS, ulEIP);

	if (aulOSVersion[0] >= 20 && aulOSVersion[1] >= 10) {
	    DosBeep(650, 1);		// Tell user we're still working
	    ulSize = 10;		/* Inserted by Kim Rasmussen 26/06 1996 to avoid error 87 when Size is 0 */
	    if (is32Bit)
		ul32BitAddr = ulEIP;
	    else
		ul32BitAddr = (ULONG)(usCS & ~7) << 13 | ulEIP;	// Thunk

	    rc = DosQueryMem((PVOID)ul32BitAddr, &ulSize, &ulAttr);
	    if (rc != NO_ERROR || ~ulAttr & PAG_COMMIT) {
		fprintf(hTrap, " Invalid address: %8.8X\n", ul32BitAddr);
		break;			/* avoid infinite loops */
	    }
	    else {
		// CHAR szModName[CCHMAXPATH];	// 10 Oct 07 SHL

		rc = DosQueryModFromEIP(&hMod, &ulObjNum, sizeof(szModName),
					szModName, &ulOffset, (ULONG)ul32BitAddr);
		if (rc == NO_ERROR && ulObjNum != -1) {

		    fprintf(hTrap, " %-8.8s %04X:%08X", szModName, ulObjNum + 1, ulOffset);

		    rc = DosQueryModuleName(hMod, sizeof(szFileName), szFileName);

		    if (rc == NO_ERROR) {
			// Try for line number info from debug data
			rc = PrintLineNum(szFileName, ulObjNum, ulOffset);
			/* if no debug data try with symbol files */
			if (rc != NO_ERROR && strlen(szFileName) > 3) {
			    strcpy(szFileName + strlen(szFileName) - 3, "SYM");
			    PrintSymbolFromSymFile(szFileName, ulObjNum, ulOffset);
			}
		    }
		}
		else
		    fputs("  *Unknown*", hTrap);
	    } // if valid address
	} // if >= v2.1

	fputc('\n', hTrap);

	if (is32Bit) {
	    /* If EBP points to the FLATDS rather than something that looks like an
	       pointer, we are probably looking at a thunk sequence
	       For VAC this is 0x44 bytes in size
	       19 Jul 07 SHL
	    */

	    if (*(PULONG)ulEBP == FLATDS)
		ulEBP += 0x44;
	    if (*(PULONG)ulEBP == 0) {
		fputs("End of Call Stack\n", hTrap);
		break;
	    }
	}
	else {
	    ul32BitAddr = (ULONG)(usSS & ~7) << 13 | ulEBP;	// Thunk
	    ulEBP = *(PUSHORT)ul32BitAddr;
	    // 0x0000 0xFFFF fixme?
	    if (ulEBP == 0 && *(PUSHORT)(ul32BitAddr + 2) == 0) {
		fputs("End of Call Stack\n", hTrap);
		break;
	    }
	}

	if (isPass1)
	    isPass1 = FALSE;
	else {
	    ulLastEbp = ulEBP;

	    /* Inserted by Kim Rasmussen 26/06 1996 to allow big stacks */
	    if (is32Bit)
		ulEBP = *(PULONG)ulLastEbp;
	    else
		ulEBP = MAKEULONG(ulEBP, usSS);

	    if (is32Bit)
		PrintLocalVariables(ulEBP);

	    if (ulEBP < ulLastEbp) {
		fputs("Lost Stack chain - new EBP below previous\n", hTrap);
		break;
	    }
	}

	ulSize = 4;
	if (is32Bit)
	    rc = DosQueryMem((PVOID)ulEBP, &ulSize, &ulAttr);
	else {
	    ul32BitAddr = (ULONG)(usSS & ~7) << 13 | ulEBP;	// Thunk
	    rc = DosQueryMem((PVOID)ul32BitAddr, &ulSize, &ulAttr);
	}
	if (rc != NO_ERROR || ulSize < 4) {
	    if (is32Bit)
		fprintf(hTrap, "Lost Stack chain - invalid EBP %8.8X\n", ulEBP);
	    else
		fprintf(hTrap, "Lost Stack chain - invalid SS:BP %4.4X:%4.4X\n", usSS, ulEBP);
	    break;
	}

    } // forever

} // WalkStack

/**
 * Print memory block if address valid
 */

static VOID PrintMemoryAt(PUCHAR puchAddress, PSZ pszDesc, BOOL is32Bit)
{
    APIRET rc;
    // ULONG ulSize = 1;		// 10 Oct 07 SHL
    // ULONG ulAttr;			// 10 Oct 07 SHL

    ulSize = 512;
    rc = DosQueryMem(puchAddress, &ulSize, &ulAttr);
    if (rc == NO_ERROR && (ulAttr & (PAG_COMMIT | PAG_READ)) == (PAG_COMMIT | PAG_READ)) {
	if (ulSize > 512)
	  ulSize = 512;		// Limit
	fprintf(hTrap, "\n/*--- Memory pointed to by %3.3s (%8.8lX) ---*/\n", pszDesc, puchAddress);

	PrintMemory(puchAddress, puchAddress + ulSize, is32Bit);

	fprintf(hTrap, "\n/*--- End of memory pointed to by %3.3s ---*/\n", pszDesc);
    }
} // PrintMemoryAt

/**
 * Print validated memory block
 * @param puchBottom is lower address
 * @param puchTop is upper address + 1
 */

static VOID PrintMemory(PUCHAR puchBottom, PUCHAR puchTop, BOOL is32Bit)
{
    CHAR szTranslate[17];
    UCHAR abOldStuff[16];
    USHORT usMod16 = 0;
    PUCHAR puch;
    USHORT usDupReported;
    *szTranslate = 0;

    DosBeep(650, 1);		// Tell user we're still working

    // Format left side as dwords for 32-bit code, words for 16-bit code
    // Format right side as masked bytes

    for (puch = puchBottom; puch < puchTop;) {
	if (usMod16 == 0) {
	    /* Starting new output line */
	    if (memcmp(abOldStuff, puch, 16)) {
		/* Save for dup checking */
		memcpy(abOldStuff, puch, 16);
		usDupReported = 0;
	    }
	    else {
		/* Suppress duplicate data */
		if (usDupReported == 0) {
		    usDupReported = 1;
		    fprintf(hTrap, "%s%s\n %8.8X :",
			    *szTranslate != '\n' ? "  " : "",
			    szTranslate,
			    puch);
		    fputs("  lines not printed same as above", hTrap);
		    strcpy(szTranslate, "\n");
		}
		puch += 16;
		continue;
	    }

	    szTranslate[16] = 0;
	    fprintf(hTrap, "%s%s\n %8.8X :",
		    *szTranslate && *szTranslate != '\n' ? "  " : "",
		    szTranslate,
		    puch);
	    *szTranslate = 0;
	} /* if usMod16 */

	if (is32Bit)
	  fprintf(hTrap, "%08.8X ", *(ULONG*)puch);
	else
	  fprintf(hTrap, "%04.4X ", *(USHORT*)puch);

	for (us = 0 ; us < (is32Bit ? 4 : 2); us++) {
	  if (isprint(*puch) && *puch >= 0x20)
	      szTranslate[usMod16] = *puch;
	  else
	      szTranslate[usMod16] = '.';
	  usMod16++;
	  puch++;
	}

	usMod16 &= 0xf;

    } /* for */

    fprintf(hTrap, "%s%s\n", *szTranslate != '\n' ? "  " : "", szTranslate);

} // PrintMemory



//=== PrintSymbolFromSymFile() Lookup symbol in .sym file ===

// #define DBG_LRG 1			// Enable to generate large .sym file debug output

// #define DBG_SYM 1			// Enable to generate .sym file debug output

static VOID PrintSymbolFromSymFile(CHAR *pszSymFileName, ULONG ulObjNum, ULONG ulOffset)
{
    // Avoid using stack space
    static FILE *fpSymFile;
    static MAPDEF MapDef;
    static SEGDEF SegDef;
    static SEGDEF *pSegDef;
    static SYMDEF32 SymDef32;
    static SYMDEF16 SymDef16;
    // static CHAR szBuffer[256];	// 10 Oct 07 SHL
    static USHORT usSegNum;
    static USHORT usSymNum;
    static ULONG  ulLastSymVal;
    static ULONG ulSegOffset;
    static ULONG ulNextSegOffset;	// 22 May 08 Large file support
    static USHORT usSymOffset;
    static ULONG ulSymOffsetAdjust;	// Large file support
    static USHORT usLastSymOffset;	// Large file support
    static ULONG ulSymPtrOffset;
    static ULONG ulSymPtrAdjust;	// Large file support

    // 12 Dec 07 SHL fixme to be gone debug
    // static ULONG ulDebug1;
    // static ULONG ulDebug2;

    fpSymFile = fopen(pszSymFileName, "rb");
    if (fpSymFile == NULL) {
	// Try current directory too
	psz = strrchr(pszSymFileName, '\\');
	if (psz)
	    fpSymFile = fopen(psz + 1, "rb");
    }
    if (fpSymFile == NULL) {
#ifdef DBG_SYM
	fprintf(hTrap, "Can not open symbol file %s (%u)\n",pszSymFileName, errno);
#endif
	fputc('\n', hTrap);
	return;
    }
    if (fread(&MapDef, sizeof(MAPDEF), 1, fpSymFile) != 1) {
	fputs(" Can not read MapDef ",hTrap);
	return;
    }

    ulSegOffset = SEGDEFOFFSET(MapDef);

    for (usSegNum = 0; usSegNum < MapDef.cSegs; usSegNum++) {
#	ifdef DBG_LRG
	fprintf(hTrap, "\n  * ulSegOffset 0x%08X Segment #%d\n",ulSegOffset,usSegNum+1);
#	endif

	if (fseek(fpSymFile, ulSegOffset, SEEK_SET)) {
	    fprintf(hTrap, " Can not seek to SegfDef at %x ", ulSegOffset);
	    return;
	}

	if (fread(&SegDef, sizeof(SEGDEF), 1, fpSymFile) != 1) {
	    fprintf(hTrap, " Can not read to SegfDef at %x ", ulSegOffset);
	    return;
	}

	if (usSegNum == ulObjNum) {

	    /* 23 May 08 SHL Add oversized .sym file support
	       Symbol table format uses 16-bit offsets to point at the symbol
	       pointer table and to point at SymDef entries.  This breaks if there
	       are more than approx 64KiB of SymDefs.  To workaround this,
	       we assume that the symbol pointer table ends at the next SegDef
	       or at the end of file.  We then use the difference between the
	       calculated offset of the end of the pointer table and the calculated
	       offset to the next SegDef to calculate an adjusting offset.
	       This offset is applied to symbol pointer table lookups.
	       We also assume that the SymDef offsets in the symbol pointer table
	       are monotonic and detect 64KiB boundary crossings to calculate an
	       adjusting offset.  This offset is applied to SymDef entry indexing.
	    */
	    // Calc location of symbol pointer table based on values
	    ulSymPtrOffset=SYMDEFOFFSET(ulSegOffset,SegDef,SegDef.cSymbols);
	    // Calc location of next segment
	    if (usSegNum + 1 == MapDef.cSegs) {
	       fseek(fpSymFile,0,SEEK_END);
	       ulNextSegOffset = ftell(fpSymFile);
	    }
	    else
	       ulNextSegOffset=NEXTSEGDEFOFFSET(SegDef);
	    // Calc offset error in 64K blocks
	    ulSymPtrAdjust = (ulNextSegOffset - ulSymPtrOffset) / 0x10000;
	    // Calc offset adjust - will be 0 for normal files
	    ulSymPtrAdjust *= 0x10000;

#	    ifdef DBG_LRG
	    if (ulSymPtrAdjust)
	       fprintf(hTrap, "  * Adjusting pSymDef by 0x%lx for large file\n",ulSymPtrAdjust);
#	    endif

	    usSymOffset = 0;
	    ulSymOffsetAdjust = 0;

	    // At requested object
	    strcpy(szBuffer, "Start");	// In case no symbol at offset 0
	    ulLastSymVal = 0;

	    for (usSymNum = 0; usSymNum <= SegDef.cSymbols; usSymNum++) {
		ulSymPtrOffset = SYMDEFOFFSET(ulSegOffset, SegDef, usSymNum);
		ulSymPtrOffset += ulSymPtrAdjust;	// 22 May 08 SHL Adjust for large files
#		ifdef DBG_LRG
		fprintf(hTrap, "  * ulSymPtrOffset 0x%08X Sym #%d",ulSymPtrOffset,usSymNum+1);
#		endif
		if (fseek(fpSymFile, ulSymPtrOffset, SEEK_SET)) {
		  fprintf(hTrap, " Can not seek to SymDef offset at %x ", ulSymPtrOffset);
		  return;
		}
		usLastSymOffset = usSymOffset;
		if (fread(&usSymOffset, sizeof(USHORT), 1, fpSymFile) != 1) {
		    fprintf(hTrap, " Can not read SymDef offset at %x ", ulSymPtrOffset);
		    return;
		}
#		ifdef DBG_LRG
		fprintf(hTrap, " usSymOffset 0x%X",usSymOffset);
#		endif
		// If symbol entries crossed 64K boundary, bump adjusting offset
		if (usSymOffset < usLastSymOffset) {
		    ulSymOffsetAdjust += 0x10000;
#		    ifdef DBG_LRG
		    fprintf(hTrap, "\n  * Adjusting usSymOffset by 0x%lx for large file\n    ",ulSymOffsetAdjust);
#		    endif
		}
		ul = usSymOffset+ulSegOffset+ulSymOffsetAdjust;
#		ifdef DBG_LRG
		fprintf(hTrap, " SymDef at 0x%08X\n",ul);
#		endif
		if (fseek(fpSymFile, ul, SEEK_SET)) {
		    fprintf(hTrap, " Can not seek to SymDef at %x ", ul);
		    return;
		}
		if (SegDef.bFlags & 0x01) {
		    // 32-bit segment
		    if (fread(&SymDef32, sizeof(SYMDEF32), 1, fpSymFile) != 1) {
			fprintf(hTrap, " Can not read to SymDef32 at %x ", ul);
			return;
		    }
		    // If requested offset greater than previous symbol offset and
		    // requested offset less than current symbol offset then
		    // time to display
		    ul = ulOffset >= ulLastSymVal && ulOffset < SymDef32.wSymVal;
		    if (ul) {
#			ifdef DBG_LRG
			fputs("    ->",hTrap);
#			endif
			// Time to display
			// 12 Dec 07 SHL fixme to be gone debug
			// ulDebug1 = ulLastSymVal;
			// ulDebug2 = SymDef32.wSymVal;
			if (ulOffset == ulLastSymVal) {
			    // 12 Dec 07 SHL fixme to be gone debug
			    // fprintf(hTrap, " %s (%X %X %X)", szBuffer, ulOffset, ulDebug1, ulDebug2);
			    fprintf(hTrap, " %s", szBuffer);
			    break;	// Done
			}
			else {
			    fprintf(hTrap, " between %s + %X ", szBuffer, ulOffset - ulLastSymVal);
			}
		    }

		    // Remeber symbol and offset
		    ulLastSymVal = SymDef32.wSymVal;
		    szBuffer[0] = SymDef32.achSymName[0];
		    if (fread(&szBuffer[1], 1, SymDef32.cbSymName, fpSymFile) != SymDef32.cbSymName) {
		      fprintf(hTrap, " Can not read to SymDef32 symbol at %x ", ul);
		      return;
		    }
		    szBuffer[SymDef32.cbSymName] = 0;

		    // If requested offset between symbols or at symbol time to display
		    if (ul) {
			// Time to display
			// 12 Dec 07 SHL fixme to be gone debug
			// fprintf(hTrap, "and %s - %X (%X %X %X)", szBuffer, ulLastSymVal - ulOffset, ulOffset, ulDebug1, ulDebug2);
			fprintf(hTrap, "and %s - %X", szBuffer, ulLastSymVal - ulOffset);
			break;		// Done
		    }
		    else if (usSymNum + 1 == SegDef.cSymbols) {
			ul = ulOffset >= ulLastSymVal && *szBuffer;
			if (ul) {
			    if (ulOffset == ulLastSymVal) {
				// 12 Dec 07 SHL fixme to be gone debug
				// fprintf(hTrap, " %s", szBuffer);
				fprintf(hTrap, " %s (%X)", szBuffer, ulOffset);
			    }
			    else {
				// 12 Dec 07 SHL fixme to be gone debug
				// fprintf(hTrap, " near %s + %X (%X)", szBuffer, ulOffset - ulLastSymVal, ulOffset);
				fprintf(hTrap, " near %s + %X ", szBuffer, ulOffset - ulLastSymVal);
			    }
			}
		    }
		} // if 32-bit
		else {
		    // 16-bit segment
		    if (fread(&SymDef16, sizeof(SYMDEF16), 1, fpSymFile) != 1) {
		      fprintf(hTrap, " Can not read to SymDef16 at %x ", ul);
		      return;
		    }
		    // 11 Oct 07 SHL fixme to be like 32 bit above
		    if (SymDef16.wSymVal > ulOffset) {
			if (ulOffset == ulLastSymVal) {
			    fprintf(hTrap, " %s", szBuffer);
			    break;	// Done
			}
			else
			    fprintf(hTrap, " between %s + %X ", szBuffer, ulOffset - ulLastSymVal);
		    }

		    ulLastSymVal = SymDef16.wSymVal;
		    szBuffer[0] = SymDef16.achSymName[0];
		    if (fread(&szBuffer[1], 1, SymDef16.cbSymName, fpSymFile) != SymDef16.cbSymName) {
		      fprintf(hTrap, " Can not read to SymDef16 sym at %x ", ul);
		      return;
		    }
		    szBuffer[SymDef16.cbSymName] = 0;
		    if (SymDef16.wSymVal > ulOffset) {
			fprintf(hTrap, "and %s - %X", szBuffer, ulLastSymVal - ulOffset);
			break;		// Done
		    }
		} // if 16-bit
	    } // for symbols
	    break; // Done with symbol
	} // if this segment
	ulSegOffset = NEXTSEGDEFOFFSET(SegDef);
    } /* for segments */
    fclose(fpSymFile);
    fputc('\n', hTrap);

} // PrintSymbolFromSymFile

static VOID WakeThreads(VOID);

//== ForceExit() Force application exit by forced trap - fixme to know if this works ==

VOID APIENTRY ForceExit()
{
    EXCEPTIONREPORTRECORD except;
    PCHAR Trap = NULL;

    fInForceExit = TRUE;
    fclose(stderr);			/* I don't want error messages since all is intentional */
    DosError(FERR_DISABLEEXCEPTION | FERR_DISABLEHARDERR);
    DosEnterCritSec();
    WakeThreads();
    printf("Exiting by exception\n");
    DosSetPriority(PRTYS_THREAD, PRTYC_FOREGROUNDSERVER, PRTYD_MAXIMUM, 0);
    DosExitCritSec();
    *Trap = 0;				// Say bye bye

} // ForceExit

//== WakeThreads() Wake all waiting threads fixme ==

static VOID WakeThreads()
{
    APIRET rc;
    APIRET16 rc16;
    QSPREC *pProc;			// 06 Feb 08 SHL
    QSTREC *pThread;			// 06 Feb 08 SHL
    ULONG ListedThreads = 0;
    PTIB ptib;
    PPIB ppib;

    DosGetInfoBlocks(&ptib, &ppib);

    rc16 = DOS16ALLOCSEG(0xFFFF, &Selector, 0);
    if (rc16 != NO_ERROR)
	printf("DosAllocSeg Failed %hd\n", rc16);
    else {
	ULONG *pBuf;
	pBuf = MAKEP(Selector, 0);
	rc16 = DOSQPROCSTATUS(pBuf, 0xFFFF);
	if (rc16 != NO_ERROR)
	    printf("DosQProcStatus Failed %hd\n", rc16);
	else {
	    pRec = (QSPTRREC *) pBuf;	// 06 Feb 08 SHL
	    pProc = (QSPREC *) (pRec->pProcRec);	// 06 Feb 08 SHL
	    ListedThreads = 0;
	    while (ListedThreads < pRec->pGlobalRec->cThrds) {
		INT Tid;

		if (pProc->pThrdRec == NULL)
		    break;
		ListedThreads += pProc->cTCB;
		if (ppib->pib_ulpid == pProc->pid) {
		    for (Tid = 0; Tid < pProc->cTCB; Tid++) {
			pThread = pProc->pThrdRec + Tid;
			// if fixme?
			if (pThread->state == 0x09) {
			    printf("Resuming Thread %d\n", (TID) pThread->tid);
			    DosResumeThread((TID) pThread->tid);
			}
		    }			/* endfor */
		    break;
		}			/* endif  */
		// 06 Feb 08 SHL
		pProc = (QSPREC *)(((PUCHAR)pProc) + sizeof(QSPREC) +
				   sizeof(USHORT) *
				     (pProc->c16Sem + pProc->cLib + pProc->cShrMem) +
				   pProc->cTCB * sizeof(QSTREC));

	    } /* while */
	}
    }

} // WakeThreads

//===========================
//== Debug info extractors ==
//===========================

// 24 May 08 SHL fixme to be in debuginfo.h?
// 24 May 08 SHL fixme to use omf.h everwhere

#ifndef DWORD
#define DWORD LONG
#endif

#ifndef WORD
#define WORD  SHORT
#endif

// fixme to use omf.h definitions
// see ow\bld\watcom\h\hll.h

#pragma pack(1)

debug_tail_rec debug_tail;

debug_head_rec debug_head;

ssModule ssmod;

ssModule32 ssmod32;
ssPublic sspub;
ssPublic32 sspub32;



// 27 May 08 SHL fixme to know who uses this

struct DbugRec
{				/* debug info struct ure used in linked * list */
    struct DbugRec far *pnext;	/* next node *//* 013 */
    char far *SourceFile;	/* source file name *013 */
    USHORT TypeOfProgram;	/* dll or exe *014* */
    USHORT LineNumber;	/* line number in source file */
    USHORT OffSet;	/* offset into loaded module */
    USHORT Selector;	/* code segment 014 */
    USHORT OpCode;	/* Opcode replaced with BreakPt */
    ULONG Count;	/* count over Break Point */
};

typedef struct DbugRec DBUG;
typedef struct DbugRec far *DBUGPTR;	/* 013 */

#pragma pack()

// keep large strings static to limit stack usage

static CHAR szNearestFile[256];		// %s, for current cs:eip, 25 Apr 10 SHL was 128
static CHAR szNearestLine[16];		// #%hu, for current cs:eip
static CHAR szNearestPubDesc[512];	// %s, for current cs:eip, 25 Apr 10 SHL was 128

static ULONG lfaBase;			// Used by PrintLineNum, Read16CodeView and Read32PmDebug

/* ------------------------------------------------------------------ */

//=== PrintLineNum() Print line number info from embedded debug data or DBG file ===

static APIRET PrintLineNum(CHAR *pszFileName, ULONG ulObjNum, ULONG ulOffset)
{
    APIRET rc = NO_ERROR;

    // Make static to limit stack usage - could be auto
    static INT fh;
    static struct exe_hdr old_hdr;
    static struct new_exe new_hdr;
    static PSZ pszFlpFmt = " %s%s %s\n";
    static struct new_seg *pNewSeg;

    *szNearestPubDesc, 0;		// Reset
    *szNearestLine, 0;
    *szNearestFile = 0;

    fh = sopen(pszFileName, O_RDONLY | O_BINARY, SH_DENYNO);
    if (fh == -1) {
	fprintf(hTrap, "Can not open %s (%d)\n", pszFileName, errno);
	rc = 1;
    }
    else {
	/* Read old Exe header */
	if (read(fh, &old_hdr, 64) == -1L) {
	    fprintf(hTrap, "Can not read old exe header %d\n", errno);
	    close(fh);
	    return 2;
	}
	if (NE_MAGIC(*(struct new_exe*)&old_hdr) == E32MAGIC)
	    // 23 May 08 SHL Support stripped LX exes
	    memcpy(&new_hdr, &old_hdr, 64);	// MZ header stripped
	else {
	    /* Seek to new Exe header */
	    if (lseek(fh, (LONG)E_LFANEW(old_hdr), SEEK_SET) == -1L) {
		fprintf(hTrap, "Can not seek to new exe header %d\n", errno);
		close(fh);
		return 3;
	    }
	    if (read(fh, (PVOID )&new_hdr, 64) == -1L) {
		fprintf(hTrap, "Can not read new exe header %d\n", errno);
		close(fh);
		return 4;
	    }
	}
	/* Check EXE signature (LX) */
	if (NE_MAGIC(new_hdr) == E32MAGIC) {
	    /* Flat 32 executable (LX) */
	    rc = Read32PmDebug(fh, ulObjNum + 1, ulOffset, pszFileName);
	    close(fh);
	    if (rc == NO_ERROR)
		fprintf(hTrap, pszFlpFmt, szNearestFile, szNearestLine, szNearestPubDesc);
	    else {
		/* If debug data not in executable, try for DBG file */
		strcpy(pszFileName + strlen(pszFileName) - 3, "DBG");
		fh = sopen(pszFileName, O_RDONLY | O_BINARY, SH_DENYNO);
		if (fh != -1) {
		    rc = Read32PmDebug(fh, ulObjNum + 1, ulOffset, pszFileName);
		    if (rc == NO_ERROR)
			fprintf(hTrap, pszFlpFmt, szNearestFile, szNearestLine, szNearestPubDesc);
		    close(fh);
		}
	    }
	}
	else if (NE_MAGIC(new_hdr) == NEMAGIC) {
#	    ifdef WANT_CODEVIEW
	    /* 16:16 executable (NE) */
	    // Allocate segment table buffer
	    if ((pNewSeg = (struct new_seg *)calloc(NE_CSEG(new_hdr), sizeof(struct new_seg))) == NULL)
	    {
		fputs("Out of memory!", hTrap);
		close(fh);
		return -1;
	    }
	    if (lseek(fh, E_LFANEW(old_hdr) + NE_SEGTAB(new_hdr), SEEK_SET) == -1L) {
		fprintf(hTrap, "Can not seek to segment table in %s (%d)\n", pszFileName, errno);
		free(pNewSeg);
		close(fh);
		return 9;
	    }

	    if (read(fh, pNewSeg, NE_CSEG(new_hdr) * sizeof(struct new_seg)) == -1)
	    {
		fprintf(hTrap, "Can not read segment table from %s (%d)\n", pszFileName, errno);
		free(pNewSeg);
		close(fh);
		return 10;
	    }
	    rc = Read16CodeView(fh, ulObjNum + 1, ulOffset, pszFileName);
	    if (rc == NO_ERROR)
		fprintf(hTrap, pszFlpFmt, szNearestFile, szNearestLine, szNearestPubDesc);
	    free(pNewSeg);
	    close(fh);

	    /* If debug data not in executable, try DBG file */
	    if (rc != NO_ERROR) {
		strcpy(pszFileName + strlen(pszFileName) - 3, "DBG");	/* Build DBG File name */
		fh = sopen(pszFileName, O_RDONLY | O_BINARY, SH_DENYNO);
		if (fh != -1) {
		    rc = Read16CodeView(fh, ulObjNum + 1, ulOffset, pszFileName);
		    if (rc == NO_ERROR)
			fprintf(hTrap, pszFlpFmt, szNearestFile, szNearestLine, szNearestPubDesc);
		    close(fh);
		}
	    }
#	    endif // WANT_CODEVIEW
	}
	else {
	    /* Unknown executable */
	    fputs("Could not find exe signature", hTrap);
	    close(fh);
	    rc = 11;
	}
    }

    return rc;

} // PrintLineNum

// keep large strings static to limit stack usage

static CHAR szFuncName[256];		// Last function name read from debug data // 25 Apr 10 SHL was 128
static ULONG ulNearestPubOffset;	// Used to local var matching
static BYTE szVarName[256];		// Last variable name read from debug data

#ifdef WANT_CODEVIEW

//== Read16CodeView() Read 16 bit CodeView data for cs:ip, return data in globals ==

static INT Read16CodeView(INT fh, USHORT usSegNum, USHORT usOffset, CHAR *pszFileName)
{
    // Make static to limit stack usage - could be auto
    static USHORT offset;
    static USHORT usNearestPublic;
    static USHORT usNearestLine;
    static USHORT numdir;
    static USHORT namelen;
    static USHORT numlines;
    static USHORT line;
    static USHORT ModIndex;
    static INT nBytesRead;		// fixme to be ULONG?
    static UINT uDirNdx;
    static UINT uLineNdx;
    static ssDir16 *pDirTab;

    ModIndex = 0;
    /* Check if CODEVIEW data exists */
    if (lseek(fh, -8L, SEEK_END) == -1) {
	fprintf(hTrap, "Error %u seeking CodeView table in %s\n", errno, pszFileName);
	return 18;
    }
    if (read(fh, &debug_tail, 8) == -1) {
	fprintf(hTrap, "Error %u reading debug info from %s\n", errno, pszFileName);
	return 19;
    }
    if (debug_tail.signature != HLLDBG_SIG) {
	/* fputs("\nNo CodeView information stored.\n",hTrap); */
	return 100;
    }
    if ((lfaBase = lseek(fh, -debug_tail.offset, SEEK_END)) == -1L) {
	fprintf(hTrap, "Error %u seeking codeview data header in %s\n", errno, pszFileName);
	return 20;
    }
    if (read(fh, &debug_head, 8) == -1) {
	fprintf(hTrap, "Error %u reading codeview data header in %s\n", errno, pszFileName);
	return 21;
    }
    if (lseek(fh, debug_head.lfoDir - 8, SEEK_CUR) == -1) {
	fprintf(hTrap, "Error %u seeking dir codeview data in %s\n", errno, pszFileName);
	return 22;
    }
    if (read(fh, &numdir, 2) == -1) {
	fprintf(hTrap, "Error %u reading dir codeview data in %s\n", errno, pszFileName);
	return 23;
    }
    /* Allocate dir table buffer */
    if ((pDirTab = (ssDir16 *)calloc(numdir, sizeof(ssDir16))) == NULL) {
	fputs("Out of memory!", hTrap);
	return -1;
    }

    /* Read dir table into buffer */
    if (read(fh, pDirTab, numdir * sizeof(ssDir16)) == -1) {
	fprintf(hTrap, "Error %u reading codeview DirTab from %s\n", errno, pszFileName);
	free(pDirTab);
	return 24;
    }

    uDirNdx = 0;
    while (uDirNdx < numdir) {
	if (pDirTab[uDirNdx].sst != SSTMODULES) {
	    uDirNdx++;
	    continue;
	}
	usNearestPublic = 0;
	usNearestLine = 0;
	/* point to subsection */
	if (lseek(fh, pDirTab[uDirNdx].lfoStart + lfaBase, SEEK_SET) == -1) {
	    fprintf(hTrap, "Error %u seeking to csBase in %s\n", errno, pszFileName);
	    return 25;
	}
	if (read(fh, &ssmod.csBase, sizeof(ssmod)) == -1) {
	    fprintf(hTrap, "Error %u reading csBase from %s\n", errno, pszFileName);
	    return 26;
	}
	if (read(fh, szModName, (UINT)ssmod.csize) == -1) {
	    fprintf(hTrap, "Error %u reading module name from %s\n", errno, pszFileName);
	    return 27;
	}
	ModIndex = pDirTab[uDirNdx].modindex;
	szModName[ssmod.csize] = 0;
	uDirNdx++;
	while (pDirTab[uDirNdx].modindex == ModIndex && uDirNdx < numdir) {
	    /* point to subsection */
	    if (lseek(fh, pDirTab[uDirNdx].lfoStart + lfaBase, SEEK_SET) == -1) {
		fprintf(hTrap, "Error %u seeking to SST_ section in %s\n", errno, pszFileName);
		return 28;
	    }
	    switch (pDirTab[uDirNdx].sst) {
	    case SSTPUBLICS:
		nBytesRead = 0;
		while (nBytesRead < pDirTab[uDirNdx].cb) {
		    // 10 Oct 07 SHL fixme to check read errors
		    nBytesRead += read(fh, &sspub.offset, sizeof(sspub));
		    nBytesRead += read(fh, szFuncName, (unsigned)sspub.csize);
		    szFuncName[sspub.csize] = 0;
		    if (sspub.segment == usSegNum &&
			sspub.offset >= usNearestPublic &&
			sspub.offset <= usOffset)
		    {
			// Found better match
			usNearestPublic = sspub.offset;
			sprintf(szNearestPubDesc, "%s%s %04hX:%04hX (%s)",
				sspub.type == 1 ? "Abs " : "",
				szFuncName,
				sspub.segment,
				sspub.offset,
				szModName);
		    }
		}
		break;

	    case SSTSRCLINES2:
	    case SSTSRCLINES:
		if (usSegNum != ssmod.csBase)
		    break;
		namelen = 0;
		read(fh, &namelen, 1);
		read(fh, szFuncName, namelen);
		szFuncName[namelen] = 0;
		/* skip 2 zero bytes */
		if (pDirTab[uDirNdx].sst == SSTSRCLINES2)
		    read(fh, &numlines, 2);
		read(fh, &numlines, 2);
		for (uLineNdx = 0; uLineNdx < numlines; uLineNdx++) {
		    read(fh, &line, 2);
		    read(fh, &offset, 2);
		    if (offset <= usOffset && offset >= usNearestLine) {
			// Got better match
			usNearestLine = offset;
			sprintf(szNearestLine, "#%hu", line);
			strcpy(szNearestFile, szFuncName);
		    }
		}
		break;
	    } /* switch */
	    uDirNdx++;
	} /* while modindex */
    } /* while uDirNdx < numdir */
    free(pDirTab);
    return NO_ERROR;

} // Read16CodeView

#endif // WANT_CODEVIEW

//=== IBM HLL debug info (NB04) - fixme ===

#define MAX_USERDEFS 150
#define MAX_POINTERS 150

USHORT userdef_count;
USHORT pointer_count;

struct
{
    USHORT idx;
    USHORT type_index;
    BYTE name[33];
} userdefs[MAX_USERDEFS];

struct
{
    USHORT idx;
    USHORT type_index;
    BYTE type_qual;
    BYTE name[33];
} pointers[MAX_POINTERS];

/**
 * Read32PmDebug() Read IBM 32-bit HLL debug info for cs:eip (NB04)
 * Matched data returned in globals
 */

#define MAX_AUTOVARS		50	// 25 Apr 10 SHL was 100
#define MAX_AUTONAMBYTES	64	// 25 Apr 10 SHL added, was hardcoded 128
struct
{
    BYTE name[MAX_AUTONAMBYTES];
    ULONG stack_offset;
    USHORT type_idx;
} autovars[MAX_AUTOVARS];

static ULONG autovar_count = 0;
static ULONG ulSymOffset;		// Offset of function to match for local variables display
static CHAR szSymFuncName[256];		// Function name at this offset, 25 Apr 10 SHL was 128

// #define DBG_HLL 1			// Enable to generate HLL debug output

static INT Read32PmDebug(INT fh, USHORT usSegNum, ULONG ulOffset, CHAR *pszFileName)
{
    UINT CurrSymSeg = 0;
    UINT ulNearestPub = 0;
    UINT NearestFile = 0;
    UINT NearestLine = 0;
    UINT ssdir_count;
    UINT namelen;
    UINT numlines;
    UINT uModIndex = 0;
    INT nBytesRead;
    UINT uDirNdx;
    UINT uNdx;
    ssLineEntry32 LineEntry;
    ssFileNum32 FileInfo;
    ssFirstLineEntry32 FirstLine;
    BOOL dump_vars = FALSE;
    USHORT idx;
    BOOL read_types = FALSE;
    ULONG ul;
    ULONG ulFileOffset;
    ssDir32 *pDirTab32;

    /* See if any debug data info */
    if (lseek(fh, -8L, SEEK_END) == -1) {
	fprintf(hTrap, "Can not seek SEEK_END - 8 %s (%d)\n", pszFileName, errno);
	return 18;
    }

    if (read(fh, &debug_tail, 8) == -1) {
	fprintf(hTrap, "Can not read debug sig from %s (%d)\n", pszFileName, errno);
	return 19;
    }
    if (debug_tail.signature != HLLDBG_SIG) {
	/* fputs("\nNo HLL debug data stored.\n",hTrap); */
	return 100;
    }

    if ((lfaBase = lseek(fh, -debug_tail.offset, SEEK_END)) == -1L) {
	fprintf(hTrap, "Can not seek to debug data tail in %s (%d)\n", pszFileName, errno);
	return 20;
    }

    if (read(fh, &debug_head, 8) == -1) {
	fprintf(hTrap, "Error %u reading HLL debug data header in %s\n", errno, pszFileName);
	return 21;
    }

    // 27 May 08 SHL fixme to read entire hll_dirinfo header
    if (lseek(fh, debug_head.lfoDir - 8 + 4, SEEK_CUR) == -1) {
	fprintf(hTrap, "Error %u seeking to HLL debug data directory in %s\n", errno, pszFileName);
	return 22;
    }

    if (read(fh, &ssdir_count, 4) == -1) {
	fprintf(hTrap, "Error %u reading HLL debug data directory count in %s\n", errno, pszFileName);
	return 23;
    }

    /* Allocate buffer to hold subsection directory table */
    if ((pDirTab32 = (ssDir32 *)calloc(ssdir_count, sizeof(ssDir32))) == NULL) {
	fputs("Out of memory!", hTrap);
	return -1;
    }

    /* Read subsection directory into buffer */
    if (read(fh, pDirTab32, ssdir_count * sizeof(ssDir32)) == -1) {
	fprintf(hTrap, "Error %u reading HLL debug data directory from %s\n", errno, pszFileName);
	free(pDirTab32);
	return 24;
    }

    for (uDirNdx = 0; uDirNdx < ssdir_count;) {
	// Scan directory for 1st module record
	if (pDirTab32[uDirNdx].sst != SSTMODULES) {
	    uDirNdx++;
	    continue;
	}
	/* point to subsection */
	lseek(fh, pDirTab32[uDirNdx].lfoStart + lfaBase, SEEK_SET);
	read(fh, &ssmod32.csBase, sizeof(ssmod32));	// Read module header

	read(fh, szModName, (unsigned) ssmod32.csize);	// Read name

	uModIndex = pDirTab32[uDirNdx].modindex;
	szModName[ssmod32.csize] = 0;
	uDirNdx++;

	for (; pDirTab32[uDirNdx].modindex == uModIndex && uDirNdx < ssdir_count; uDirNdx++) {
	    /* Position to subsection */
	    if (lseek(fh, pDirTab32[uDirNdx].lfoStart + lfaBase, SEEK_SET) == -1) {
		fprintf(hTrap, "Error %u seeking data in %s\n", errno, pszFileName);
		free(pDirTab32);
		return 25;
	    }

	    switch (pDirTab32[uDirNdx].sst) {

	    case SSTPUBLICS:
		nBytesRead = 0;
		while (nBytesRead < pDirTab32[uDirNdx].cb) {
		    // 24 May 08 SHL fixme to check read errors
		    nBytesRead += read(fh, &sspub32.offset, sizeof(sspub32));
		    nBytesRead += read(fh, szFuncName, (unsigned) sspub32.csize);
		    szFuncName[sspub32.csize] = 0;
		    if (sspub32.segment == usSegNum &&
			sspub32.offset >= ulNearestPub &&
			sspub32.offset <= ulOffset)
		    {
			// Found closer function
			ulNearestPub = sspub32.offset;
			ulNearestPubOffset = ulNearestPub;	// Remember for local var matching
			read_types = TRUE;
			// 25 Apr 10 SHL Avoid buffer overflow
			sprintf(szNearestPubDesc, "%s%s %04X:%08X (%s)",
				sspub32.type == 1 ? "Abs " : "",
				szFuncName,
				sspub32.segment,
				sspub32.offset,
				szModName);
		    }
		}
		break;

	    case SSTSYMBOLS:
		/* Read symbols, so we can dump the auto variables on the stack */
		if (usSegNum != ssmod32.csBase)
		    break;

		nBytesRead = 0;
		while (nBytesRead < pDirTab32[uDirNdx].cb) {
		    USHORT usLength;
		    BYTE b1;
		    BYTE b2;
		    BYTE bType;
		    static symseg_rec symseg;
		    static symauto_rec symauto;
		    static symproc_rec symproc;

		    /* Read encoded length of this subentry */
		    nBytesRead += read(fh, &b1, 1);
		    if (b1 & 0x80) {
			nBytesRead += read(fh, &b2, 1);
			usLength = ((b1 & 0x7F) << 8) + b2;
		    }
		    else
			usLength = b1;

		    ulFileOffset = tell(fh);

		    nBytesRead += read(fh, &bType, 1);

		    switch (bType) {
		    case SYM_CHANGESEG:
			read(fh, &symseg, sizeof(symseg));
			CurrSymSeg = symseg.seg_no;
			break;

		    case SYM_PROC:
		    case SYM_CPPPROC:
			read(fh, &symproc, sizeof(symproc));
			read(fh, szVarName, symproc.name_len);
			szVarName[symproc.name_len] = 0;

			if (CurrSymSeg == usSegNum &&
			    ulOffset >= symproc.offset &&
			    ulOffset < symproc.offset + symproc.length)
			{
			    // Got function name, try to find locals
			    dump_vars = TRUE;
			    autovar_count = 0;
			    ulSymOffset = symproc.offset;
			    strcpy(szSymFuncName, szVarName);
			}
			else
			    dump_vars = FALSE;
			break;

		    case SYM_AUTO:
			if (!dump_vars)
			    break;

			read(fh, &symauto, sizeof(symauto));
			read(fh, szVarName, symauto.name_len);
			szVarName[symauto.name_len] = 0;

			if (autovar_count < MAX_AUTOVARS) {
			    // 25 Apr 10 SHL avoid overflow
			    strncpy(autovars[autovar_count].name, szVarName, MAX_AUTONAMBYTES);
			    autovars[autovar_count].name[MAX_AUTONAMBYTES - 1] = 0;
			    autovars[autovar_count].stack_offset = symauto.stack_offset;
			    autovars[autovar_count].type_idx = symauto.type_idx;
			    autovar_count++;
			}
			break;

		    } // switch bType

		    nBytesRead += usLength;
		    lseek(fh, ulFileOffset + usLength, SEEK_SET);	// Position to next symbol record
		} // while
		break;			// SSTSYMBOLS

	    case SSTTYPES:
		if (!read_types)
		    break;

		nBytesRead = 0;
		idx = 0x200;
		userdef_count = 0;
		pointer_count = 0;
		while (nBytesRead < pDirTab32[uDirNdx].cb) {
		    static type_rec type;
		    static type_userdefrec udef;
		    static type_pointerrec point;

		    /* Remember current file offset */
		    ulFileOffset = tell(fh);

		    /* Read the length of this subentry */
		    read(fh, &type, sizeof(type));
		    nBytesRead += sizeof(type);

		    switch (type.type) {
		    case TYPE_USERDEF:
			if (userdef_count >= MAX_USERDEFS)
			    break;

			read(fh, &udef, sizeof(udef));
			read(fh, szVarName, udef.name_len);
			szVarName[udef.name_len] = 0;

			// Insert userdef in table
			userdefs[userdef_count].idx = idx;
			userdefs[userdef_count].type_index = udef.type_index;
			memcpy(userdefs[userdef_count].name, szVarName, min(udef.name_len + 1, 32));
			userdefs[userdef_count].name[32] = 0;
			userdef_count++;
			break;

		    case TYPE_POINTER:
			if (pointer_count >= MAX_POINTERS)
			    break;

			read(fh, &point, sizeof(point));
			read(fh, szVarName, point.name_len);
			szVarName[point.name_len] = 0;

			// Insert pointer def in table
			pointers[pointer_count].idx = idx;
			pointers[pointer_count].type_index = point.type_index;
			memcpy(pointers[pointer_count].name, szVarName, min(point.name_len + 1, 32));
			pointers[pointer_count].name[32] = 0;
			pointers[pointer_count].type_qual = type.type_qual;
			pointer_count++;
			break;
		    } // switch type.type

		    ++idx;
		    nBytesRead += type.length;
		    lseek(fh, ulFileOffset + type.length + 2, SEEK_SET);
		} // while
		break;			// SSTTYPES

	    case SSTSRCLINES32:
		if (usSegNum != ssmod32.csBase)
		    break;

		/* find first type 0 line number record
		 * skip leading type 3 pszFileName list records
		 */
		ulFileOffset = 0;
		do {
		    read(fh, &FirstLine, sizeof(FirstLine));

		    if (FirstLine.LineNum != 0) {
			fputs("Missing Line table information\n", hTrap);
			FirstLine.numlines = 0;
			break;
		    }
		    /* If type 0..3, read rest of header
		     * Type 4 omits length/seg_address field
		     */
		    if (FirstLine.entry_type < 4) {
			read(fh, &ul, 4);
			// If type 3, remember start of file names table and position after
			if (FirstLine.entry_type == 3) {
			    if (!ulFileOffset)
				ulFileOffset = tell(fh);
			    lseek(fh, ul, SEEK_CUR);
			}
		    }
		} while (FirstLine.entry_type == 3);

		numlines = FirstLine.numlines;

		for (uNdx = 0; uNdx < numlines; uNdx++) {
		    switch (FirstLine.entry_type) {
		    case LINEREC_SRC_LINES:
			read(fh, &LineEntry, sizeof(LineEntry));
			/* Changed by Kim Rasmussen 26/06 1996 to ignore linenumber 0 */
			/* if (LineEntry.ulOffset+ssmod32.csOff<=ulOffset && LineEntry.ulOffset+ssmod32.csOff>=NearestLine) {} */
			if (LineEntry.LineNum &&
			    LineEntry.ulOffset + ssmod32.csOff >= NearestLine &&
			    LineEntry.ulOffset + ssmod32.csOff <= ulOffset)
			{
			    // Found better match
			    NearestLine = LineEntry.ulOffset;
			    NearestFile = LineEntry.FileNum;
			    sprintf(szNearestLine, "#%hu", LineEntry.LineNum);
			}
			break;

		    case LINEREC_LIST_LINES:
			lseek(fh, sizeof(linlist_rec), SEEK_CUR);
			break;

		    case LINEREC_SRCLIST_LINES:
			lseek(fh, sizeof(linsourcelist_rec), SEEK_CUR);
			break;

		    case LINEREC_FILENAMES:
			lseek(fh, sizeof(filenam_rec), SEEK_CUR);
			break;

		    case LINEREC_PATHINFO:
			lseek(fh, sizeof(pathtab_rec), SEEK_CUR);
			break;
		    } /* switch FirstLine.entry_type */
		} /* for */

		if (NearestFile != 0) {
		    // Have filename index - find name
		    // lseek back to filenames entry
		    lseek(fh, ulFileOffset, SEEK_SET);
		    read(fh, &FileInfo, sizeof(FileInfo));
		    namelen = 0;
		    for (uNdx = 1; uNdx <= FileInfo.file_count; uNdx++) {
			namelen = 0;	// in case read error
			read(fh, &namelen, 1);
			read(fh, szFuncName, namelen);
			if (uNdx == NearestFile)
			    break;	// Got it
		    }
		    szFuncName[namelen] = 0;
		    psz = strrchr(szFuncName, '\\');
		    if (psz == NULL)
			psz = szFuncName;
		    else
			psz++;
		    strcpy(szNearestFile, psz);	// Record file name
		}
		else {
		    *szNearestFile = 0;
		}
		break; // SSTSRCLINES32

#ifdef DBG_HLL
	    default:
		fprintf(hTrap, "HLL type %u unknown%s\n", pDirTab32[uDirNdx].sst);
#endif
	    } /* switch sst */
	} /* for same module */
    } /* for uDirNdx < ssdir_count */

    free(pDirTab32);
    return NO_ERROR;

} // Read32PmDebug


#ifdef WANT_BC0A

/**
 * Read Borland BCOA 32-bit debug info for cs:eip (FB09)
 * Return matching data in globals
 * @return 0 if OK else non-zero error code
 */


static INT ReadBCOADebug(INT fh, USHORT usSegNum, ULONG ulOffset, CHAR *pszFileName);

#define DBG_BCOA 1			// Enable to generate BCOA debug output

static INT ReadBCOADebug(INT fh, USHORT usSegNum, ULONG ulOffset, CHAR *pszFileName)
{
    UINT CurrSymSeg = 0;
    UINT ulNearestPub = 0;
    UINT NearestFile = 0;
    UINT NearestLine = 0;
    UINT ssdir_count;
    UINT namelen;
    UINT numlines;
    UINT uModIndex = 0;
    INT nBytesRead;
    UINT uDirNdx;
    UINT uNdx;
    ssLineEntry32 LineEntry;
    ssFileNum32 FileInfo;
    ssFirstLineEntry32 FirstLine;
    BOOL dump_vars = FALSE;
    USHORT idx;
    BOOL read_types = FALSE;
    ULONG ul;
    ULONG ulFileOffset;
    ssDir32 *pDirTab32;

    /* See if any debug data info */
    if (lseek(fh, -8L, SEEK_END) == -1) {
	fprintf(hTrap, "Can not seek SEEK_END - 8 %s (%d)\n", pszFileName, errno);
	return 18;
    }

    if (read(fh, &debug_tail, 8) == -1) {
	fprintf(hTrap, "Can not read debug sig from %s (%d)\n", pszFileName, errno);
	return 19;
    }
    if (debug_tail.signature != BCOADBG_SIG) {
	/* fputs("\nNo BCOA debug data stored.\n",hTrap); */
	return 100;
    }

    if ((lfaBase = lseek(fh, -debug_tail.offset, SEEK_END)) == -1L) {
	fprintf(hTrap, "Can not seek to debug data tail in %s (%d)\n", pszFileName, errno);
	return 20;
    }

    if (read(fh, &debug_head, 8) == -1) {
	fprintf(hTrap, "Error %u reading BCOA debug data header in %s\n", errno, pszFileName);
	return 21;
    }

    // 27 May 08 SHL fixme to read entire hll_dirinfo header
    if (lseek(fh, debug_head.lfoDir - 8 + 4, SEEK_CUR) == -1) {
	fprintf(hTrap, "Error %u seeking to BCOA debug data directory in %s\n", errno, pszFileName);
	return 22;
    }

    if (read(fh, &ssdir_count, 4) == -1) {
	fprintf(hTrap, "Error %u reading BCOA debug data directory count in %s\n", errno, pszFileName);
	return 23;
    }

    /* Allocate buffer to hold subsection directory table */
    if ((pDirTab32 = (ssDir32 *)calloc(ssdir_count, sizeof(ssDir32))) == NULL)
    {
	fputs("Out of memory!", hTrap);
	return -1;
    }

    /* Read subsection directory into buffer */
    if (read(fh, pDirTab32, ssdir_count * sizeof(ssDir32)) == -1) {
	fprintf(hTrap, "Error %u reading BCOA debug data directory from %s\n", errno, pszFileName);
	free(pDirTab32);
	return 24;
    }

    for (uDirNdx = 0; uDirNdx < ssdir_count;) {
	// Scan directory for 1st module record
	if (pDirTab32[uDirNdx].sst != SSTMODULES) {
	    uDirNdx++;
	    continue;
	}
	/* point to subsection */
	lseek(fh, pDirTab32[uDirNdx].lfoStart + lfaBase, SEEK_SET);
	read(fh, &ssmod32.csBase, sizeof(ssmod32));	// Read module header

	read(fh, szModName, (unsigned) ssmod32.csize);	// Read name

	uModIndex = pDirTab32[uDirNdx].modindex;
	szModName[ssmod32.csize] = 0;
	uDirNdx++;

	for (; pDirTab32[uDirNdx].modindex == uModIndex && uDirNdx < ssdir_count; uDirNdx++) {
	    /* Position to subsection */
	    if (lseek(fh, pDirTab32[uDirNdx].lfoStart + lfaBase, SEEK_SET) == -1) {
		fprintf(hTrap, "Error %u seeking data in %s\n", errno, pszFileName);
		free(pDirTab32);
		return 25;
	    }

	    switch (pDirTab32[uDirNdx].sst) {

	    case SSTPUBLICS:
		nBytesRead = 0;
		while (nBytesRead < pDirTab32[uDirNdx].cb) {
		    // 24 May 08 SHL fixme to check read errors
		    nBytesRead += read(fh, &sspub32.offset, sizeof(sspub32));
		    nBytesRead += read(fh, szFuncName, (unsigned) sspub32.csize);
		    szFuncName[sspub32.csize] = 0;
		    if (sspub32.segment == usSegNum &&
			sspub32.offset >= ulNearestPub &&
			sspub32.offset <= ulOffset)
		    {
			// Found closer function
			ulNearestPub = sspub32.offset;
			ulNearestPubOffset = ulNearestPub;	// Remember for local var matching
			read_types = TRUE;
			sprintf(szNearestPubDesc, "%s%s %04X:%08X (%s)",
				sspub32.type == 1 ? "Abs " : "",
				szFuncName,
				sspub32.segment,
				sspub32.offset,
				szModName);
		    }
		}
		break;

	    case SSTSYMBOLS:
		/* Read symbols, so we can dump the auto variables on the stack */
		if (usSegNum != ssmod32.csBase)
		    break;

		nBytesRead = 0;
		while (nBytesRead < pDirTab32[uDirNdx].cb) {
		    USHORT usLength;
		    BYTE b1;
		    BYTE b2;
		    BYTE bType;
		    static symseg_rec symseg;
		    static symauto_rec symauto;
		    static symproc_rec symproc;

		    /* Read encoded length of this subentry */
		    nBytesRead += read(fh, &b1, 1);
		    if (b1 & 0x80) {
			nBytesRead += read(fh, &b2, 1);
			usLength = ((b1 & 0x7F) << 8) + b2;
		    }
		    else
			usLength = b1;

		    ulFileOffset = tell(fh);

		    nBytesRead += read(fh, &bType, 1);

		    switch (bType) {
		    case SYM_CHANGESEG:
			read(fh, &symseg, sizeof(symseg));
			CurrSymSeg = symseg.seg_no;
			break;

		    case SYM_PROC:
		    case SYM_CPPPROC:
			read(fh, &symproc, sizeof(symproc));
			read(fh, szVarName, symproc.name_len);
			szVarName[symproc.name_len] = 0;

			if (CurrSymSeg == usSegNum &&
			    ulOffset >= symproc.offset &&
			    ulOffset < symproc.offset + symproc.length)
			{
			    // Got function name, try to find locals
			    dump_vars = TRUE;
			    autovar_count = 0;
			    ulSymOffset = symproc.offset;
			    strcpy(szSymFuncName, szVarName);
			}
			else
			    dump_vars = FALSE;
			break;

		    case SYM_AUTO:
			if (!dump_vars)
			    break;

			read(fh, &symauto, sizeof(symauto));
			read(fh, szVarName, symauto.name_len);
			szVarName[symauto.name_len] = 0;

			if (autovar_count < MAX_AUTOVARS) {
			    strncpy(autovars[autovar_count].name, szVarName, MAX_AUTONAMBYTES);
			    autovars[autovar_count].name[MAX_AUTONAMBYTES - 1] = 0;
			    autovars[autovar_count].stack_offset = symauto.stack_offset;
			    autovars[autovar_count].type_idx = symauto.type_idx;
			    autovar_count++;
			}
			break;

		    } // switch bType

		    nBytesRead += usLength;
		    lseek(fh, ulFileOffset + usLength, SEEK_SET);	// Position to next symbol record
		} // while
		break;			// SSTSYMBOLS

	    case SSTTYPES:
		if (!read_types)
		    break;

		nBytesRead = 0;
		idx = 0x200;
		userdef_count = 0;
		pointer_count = 0;
		while (nBytesRead < pDirTab32[uDirNdx].cb) {
		    static type_rec type;
		    static type_userdefrec udef;
		    static type_pointerrec point;

		    /* Remember current file offset */
		    ulFileOffset = tell(fh);

		    /* Read the length of this subentry */
		    read(fh, &type, sizeof(type));
		    nBytesRead += sizeof(type);

		    switch (type.type) {
		    case TYPE_USERDEF:
			if (userdef_count >= MAX_USERDEFS)
			    break;

			read(fh, &udef, sizeof(udef));
			read(fh, szVarName, udef.name_len);
			szVarName[udef.name_len] = 0;

			// Insert userdef in table
			userdefs[userdef_count].idx = idx;
			userdefs[userdef_count].type_index = udef.type_index;
			memcpy(userdefs[userdef_count].name, szVarName, min(udef.name_len + 1, 32));
			userdefs[userdef_count].name[32] = 0;
			userdef_count++;
			break;

		    case TYPE_POINTER:
			if (pointer_count >= MAX_POINTERS)
			    break;

			read(fh, &point, sizeof(point));
			read(fh, szVarName, point.name_len);
			szVarName[point.name_len] = 0;

			// Insert pointer def in table
			pointers[pointer_count].idx = idx;
			pointers[pointer_count].type_index = point.type_index;
			memcpy(pointers[pointer_count].name, szVarName, min(point.name_len + 1, 32));
			pointers[pointer_count].name[32] = 0;
			pointers[pointer_count].type_qual = type.type_qual;
			pointer_count++;
			break;
		    } // switch type.type

		    ++idx;
		    nBytesRead += type.length;
		    lseek(fh, ulFileOffset + type.length + 2, SEEK_SET);
		} // while
		break;			// SSTTYPES

	    case SSTSRCLINES32:
		if (usSegNum != ssmod32.csBase)
		    break;

		/* find first type 0 line number record
		 * skip leading type 3 pszFileName list records
		 */
		ulFileOffset = 0;
		do {
		    read(fh, &FirstLine, sizeof(FirstLine));

		    if (FirstLine.LineNum != 0) {
			fputs("Missing Line table information\n", hTrap);
			FirstLine.numlines = 0;
			break;
		    }
		    /* If type 0..3, read rest of header
		     * Type 4 omits length/seg_address field
		     */
		    if (FirstLine.entry_type < 4) {
			read(fh, &ul, 4);
			// If type 3, remember start of file names table and position after
			if (FirstLine.entry_type == 3) {
			    if (!ulFileOffset)
				ulFileOffset = tell(fh);
			    lseek(fh, ul, SEEK_CUR);
			}
		    }
		} while (FirstLine.entry_type == 3);

		numlines = FirstLine.numlines;

		for (uNdx = 0; uNdx < numlines; uNdx++) {
		    switch (FirstLine.entry_type) {
		    case LINEREC_SRC_LINES:
			read(fh, &LineEntry, sizeof(LineEntry));
			/* Changed by Kim Rasmussen 26/06 1996 to ignore linenumber 0 */
			/* if (LineEntry.ulOffset+ssmod32.csOff<=ulOffset && LineEntry.ulOffset+ssmod32.csOff>=NearestLine) {} */
			if (LineEntry.LineNum &&
			    LineEntry.ulOffset + ssmod32.csOff >= NearestLine &&
			    LineEntry.ulOffset + ssmod32.csOff <= ulOffset)
			{
			    // Found better match
			    NearestLine = LineEntry.ulOffset;
			    NearestFile = LineEntry.FileNum;
			    sprintf(szNearestLine, "#%hu", LineEntry.LineNum);
			}
			break;

		    case LINEREC_LIST_LINES:
			lseek(fh, sizeof(linlist_rec), SEEK_CUR);
			break;

		    case LINEREC_SRCLIST_LINES:
			lseek(fh, sizeof(linsourcelist_rec), SEEK_CUR);
			break;

		    case LINEREC_FILENAMES:
			lseek(fh, sizeof(filenam_rec), SEEK_CUR);
			break;

		    case LINEREC_PATHINFO:
			lseek(fh, sizeof(pathtab_rec), SEEK_CUR);
			break;
		    } /* switch FirstLine.entry_type */
		} /* for */

		if (NearestFile != 0) {
		    // Have filename index - find name
		    // lseek back to filenames entry
		    lseek(fh, ulFileOffset, SEEK_SET);
		    read(fh, &FileInfo, sizeof(FileInfo));
		    namelen = 0;
		    for (uNdx = 1; uNdx <= FileInfo.file_count; uNdx++) {
			namelen = 0;	// in case read error
			read(fh, &namelen, 1);
			read(fh, szFuncName, namelen);
			if (uNdx == NearestFile)
			    break;	// Got it
		    }
		    szFuncName[namelen] = 0;
		    psz = strrchr(szFuncName, '\\');
		    if (psz == NULL)
			psz = szFuncName;
		    else
			psz++;
		    strcpy(szNearestFile, psz);	// Record file name
		}
		else {
		    *szNearestFile = 0;
		}
		break; // SSTSRCLINES32

#ifdef DBG_BCOA
	    default:
		fprintf(hTrap, "BCOA type %u unknown%s\n", pDirTab32[uDirNdx].sst);
#endif

	    } /* switch sst */
	} /* for same module */
    } /* for uDirNdx < ssdir_count */

    free(pDirTab32);
    return NO_ERROR;

} // ReadBCOADebug

#endif // WANT_BC0A

//== FormatVarValue() Format variable value, return string ==

static BYTE *FormatVarValue(PVOID pVar, BYTE type)
{
    APIRET rc;

    // 28 May 08 SHL fixme to be switch case
    if (type == 0)
	sprintf(szBuffer, "%hd", *(signed char *)pVar);
    else if (type == 1)
	sprintf(szBuffer, "%hd", *(signed short *)pVar);
    else if (type == 2)
	sprintf(szBuffer, "%ld", *(signed long *)pVar);
    else if (type == 4)
	sprintf(szBuffer, "%hu", *(BYTE *)pVar);
    else if (type == 5)
	sprintf(szBuffer, "%hu", *(USHORT *)pVar);
    else if (type == 6)
	sprintf(szBuffer, "%lu", *(ULONG *)pVar);
    else if (type == 8)
	sprintf(szBuffer, "%f", *(float *)pVar);
    else if (type == 9)
	sprintf(szBuffer, "%f", *(double *)pVar);
    else if (type == 10)
	sprintf(szBuffer, "%f", *(long double *)pVar);
    else if (type == 16)
	sprintf(szBuffer, "%s", *(char *)pVar ? "TRUE" : "FALSE");
    else if (type == 17)
	sprintf(szBuffer, "%s", *(short *)pVar ? "TRUE" : "FALSE");
    else if (type == 18)
	sprintf(szBuffer, "%s", *(long *)pVar ? "TRUE" : "FALSE");
    else if (type == 20)
	sprintf(szBuffer, "%c", *(char *)pVar);
    else if (type == 21)
	sprintf(szBuffer, "%lc", *(short *)pVar);
    else if (type == 22)
	sprintf(szBuffer, "%lc", *(long *)pVar);
    else if (type == 23)
	sprintf(szBuffer, "void");
    else if (type >= 32) {
	// ULONG ulAttr;		// 10 Oct 07 SHL
	// ULONG ulSize = 1;		// 10 Oct 07 SHL
	ulSize = 1;

	rc = DosQueryMem((PVOID)*(ULONG *)pVar, &ulSize, &ulAttr);
	if (rc != NO_ERROR)
	    sprintf(szBuffer, "0x%p invalid", *(ULONG *)pVar);
	else {
	    sprintf(szBuffer, "0x%p", *(ULONG *)pVar);
	    if (ulAttr & PAG_FREE)
		strcat(szBuffer, " unallocated memory");
	    else {
		if (~ulAttr & PAG_COMMIT)
		    strcat(szBuffer, " uncommited");
		if (~ulAttr & PAG_WRITE)
		    strcat(szBuffer, " unwritable");
		if (~ulAttr & PAG_READ)
		    strcat(szBuffer, " unreadable");
	    }
	}
    }
    else {
      strcpy(szBuffer, "Unknown");
    }

    return szBuffer;

} // FormatVarValue

/**
 * Search saved user type definitions and print values if matched
 * @return TRUE if matched else FALSE
 */

static BOOL search_userdefs(ULONG stackofs, USHORT var_no)
{
    USHORT pos;

    for (pos = 0; pos < userdef_count && userdefs[pos].idx != autovars[var_no].type_idx; pos++)
	; // do nothing

    if (pos < userdef_count) {
	// Found it
	if (userdefs[pos].type_index >= 0x80 && userdefs[pos].type_index <= 0xDA)
	{
	    fprintf(hTrap, "%- 6d %- 20.20s %- 33.33s %s\n",
		    autovars[var_no].stack_offset,
		    autovars[var_no].name,
		    userdefs[pos].name,
		    FormatVarValue((PVOID)(stackofs + autovars[var_no].stack_offset),
				   userdefs[pos].type_index - 0x80));
	    return TRUE;
	}
	/* If the result isn't a simple type, let's act as we didn't find it */
    } // if found

    return FALSE;
} // search_userdefs

/**
 * Search saved pointer definitions and print values if matched
 * @return TRUE if matched else FALSE
 */

static BOOL search_pointers(ULONG stackofs, USHORT var_no)
{
    USHORT pos;
    USHORT upos;
    static BYTE str[35];

    for (pos = 0; pos < pointer_count && pointers[pos].idx != autovars[var_no].type_idx; pos++)
	; // do nothing

    if (pos < pointer_count) {
	// Found it
	if (pointers[pos].type_index >= 0x80 && pointers[pos].type_index <= 0xDA)
	{
	    strcpy(str, type_name[pointers[pos].type_index - 0x80]);
	    strcat(str, " *");
	    fprintf(hTrap, "%- 6d %- 20.20s %- 33.33s %s\n",
		    autovars[var_no].stack_offset,
		    autovars[var_no].name,
		    str,
		    FormatVarValue((PVOID)(stackofs + autovars[var_no].stack_offset), 32));
	    return TRUE;
	}
	else {
	    /* If the result isn't a simple type, look for it in the other lists */
	    for (upos = 0; upos < userdef_count && userdefs[upos].idx != pointers[pos].type_index; upos++)
		; // do nothing

	    if (upos < userdef_count) {
		strcpy(str, userdefs[upos].name);
		strcat(str, " *");
		fprintf(hTrap, "%- 6d %- 20.20s %- 33.33s %s\n",
			autovars[var_no].stack_offset,
			autovars[var_no].name,
			str,
			FormatVarValue((PVOID)(stackofs + autovars[var_no].stack_offset), 32));
		return TRUE;
	    }
	    else {
		/* If it isn't a userdef, for now give up and just print as much as we know */
		sprintf(str, "Pointer to type 0x%X", pointers[pos].type_index);

		fprintf(hTrap, "%- 6d %- 20.20s %- 33.33s %s\n",
			autovars[var_no].stack_offset,
			autovars[var_no].name,
			str,
			FormatVarValue((PVOID)(stackofs + autovars[var_no].stack_offset), 32));

		return TRUE;
	    }
	} // if not simple
    } // if found

    return FALSE;
} // search_pointers

/**
 * Print local variable values from stored data
 */

static VOID PrintLocalVariables(ULONG ulStackOffset)
{
    USHORT n;
    BOOL AutoVarsFound = FALSE;

    if (ulSymOffset == ulNearestPubOffset) {
	// Found locals for this function
	for (n = 0; n < autovar_count; n++) {
	    if (AutoVarsFound == FALSE) {
		AutoVarsFound = TRUE;
		fprintf(hTrap, "List of auto variables at EBP %p in %s:\n", ulStackOffset, szSymFuncName);
		fputs("Offset Name                 Type                              Value            \n", hTrap);
		fputs("   \n", hTrap);
	    }

	    /* If it's one of the simple types */
	    if (autovars[n].type_idx >= 0x80 && autovars[n].type_idx <= 0xDA)
	    {
		fprintf(hTrap, "%- 6d %- 20.20s %- 33.33s %s\n",
			autovars[n].stack_offset,
			autovars[n].name,
			type_name[autovars[n].type_idx - 0x80],
		FormatVarValue((PVOID)(ulStackOffset + autovars[n].stack_offset),
			  autovars[n].type_idx - 0x80));
	    }
	    else {
		/* Complex type, check if we know what it is */
		if (!search_userdefs(ulStackOffset, n)) {
		    if (!search_pointers(ulStackOffset, n)) {
			fprintf(hTrap, "%- 6d %-20.20s 0x%X\n",
				autovars[n].stack_offset,
				autovars[n].name,
				autovars[n].type_idx);
		    }
		}
	    }
	}
#if 0 // fixme to be gone?
	if (!AutoVarsFound)
	    fprintf(hTrap, "  No auto variables found in %s.\n", szFuncName);
#endif
	if (AutoVarsFound)
	    fputc('\n', hTrap);
    }
} // PrintLocalVariables

// The end
