/* ͻ
 File last saved 5 Mar 2000 at 02:32:07 []                                 
   Ķ
        Filename instobjs.cmd                                              
            Created 1 Sep 1998 at 12:11:04                                    
            Comment Installs various objects onto the Desktop for Ellie02.    
 18 Jun 1999    8Rewrite.                                                  
 21 Jun 1999   95Updated for FAT drives (renamed > 8chr fns)               
                 seticlient now seti                                       
  6 Jul 1999    9Animated icons for Ellie and wavfldr.  Inc warning for    
                 replacing Ellie folder containing foreign data.           
 30 Jul 1999  124Creates Ellie URLs                                        
   ͼ
*/

SIGNAL ON syntax
SIGNAL ON halt

if LoadRexxUtil() then EXIT 99

elliedir = SysIni('USER', 'AiG', 'Ellie_Home')
elliever = SysIni('USER', 'AiG', 'Ellie_Ver')
select
    when elliedir = 'ERROR:' then do
       say "   Ellie is not registered with OS/2.  Please run REGISTER.CMD from"
       say "   the directory you unzipped Ellie into."
       exit 98; end /* do */
    when elliever <> '0.3r3a' then do
       say "You are attempting run this script on a previously installed but older"
       say "or newer version of Ellie.  Start again by running INSTALL.CMD."
       exit 97; end /* do */

    otherwise do

        say "   "
        say "   ** Install and register Ellie objects with your system **"
        say "   This program registers various objects and installs Ellie"
        say "   folders on the Desktop."
        say
        say "   In creating the Ellie folder on the Desktop, if a previous Ellie"
        say "   folder is found its contents will be lost."
        say
        say "   Ensure that any non-Ellie data you may within this folder is"
        say "   moved from it prior to continuing."
        say "   "
        say "   Are you sure you want to continue..?" '07'x
        call charout, "   Type YES to continue >___" || copies('08'x,3)

        pull ky
        if translate(ky) = 'YES' then
            call Process
        else
            say '   Program aborted.'

    end /* ow */
end /* select */
EXIT; /*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: */
/* :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: */
/* :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: */
Process:
crlf = '0d0a'x
ok = '' || crlf
no = '' || '07'x || crlf
err = 0
call charout , "   Creating Ellie objects............................"
rc = SysCreateObject('WPFolder', "Ellie",'<WP_DESKTOP>',,
                     'BACKGROUND='elliedir'\ellie_bg.bmp,S,1,I;',
                     'OPEN=DEFAULT;ICONFILE='elliedir'\ef1.ico;ICONNFILE=1,'elliedir'\ef2.ico;ICONVIEWPOS=60,50,40,40;OBJECTID=<AIG_ELLIE_FLDR>', 'R')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end

call charout , "   Creating the Ellie program object................."
rc = SysCreateObject('WPProgram','Ellie','<AIG_ELLIE_FLDR>',,
                    'ICONFILE='elliedir'\ellie.ico;MINWIN=HIDE;EXENAME='elliedir'\ellie.exe;OBJECTID=<AIG_ELLIE>', 'R')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end


call charout , "   Creating Ellie's WAV folder......................."
rc = SysCreateObject('WPFolder', "EllieWAVs",'<AIG_ELLIE_FLDR>',,
                     'BACKGROUND='elliedir'\amsg_bg.bmp;ICONVIEW=FLOWED,MINI',
                     'OPEN=DEFAULT;ICONFILE='elliedir'\wavfldr.ico;ICONNFILE=1,'elliedir'\wavfldr2.ico;OBJECTID=<AIG_ELLIE_WAVS>', 'R')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end

call charout , "   Shadowing some WAVs to Ellie's WAV folder........."
rc = SysFileTree(elliedir'\WAVs\*.wav', 'wav.')
do w = 1 to wav.0

    parse var wav.w with . . . wavfile
    rc = SysCreateShadow(strip(wavfile), '<AIG_ELLIE_WAVS>')
    if rc = 1  then call charout , ''; else do; call charout , '' ; err = 1; end

end /* do */
call charout , crlf
call charout , "   Shadowing the ReadMe to Ellie's folder............"
rc = SysCreateShadow(elliedir'\readmev3.txt', '<AIG_ELLIE_FLDR>')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end

call charout , "   Shadowing the Notes textfile to Ellie's folder...."
rc = SysCreateShadow(elliedir'\notes.txt', '<AIG_ELLIE_FLDR>')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end

call charout , "   Shadowing the SETI CLIENT ReadMe to Ellie's folder."
rc = SysCreateShadow(elliedir'\seti.txt', '<AIG_ELLIE_FLDR>')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end


call charout , "   Creating a folder for Ellie's URLs................"
rc = SysCreateObject('WPUrlFolder', "Ellie's Website pages",'<AIG_ELLIE_FLDR>',,
                    'SHOWALLINTREEVIEW=YES;DEFAULTVIEW=TREE;OBJECTID=<AIG_ELLIE_URLFLDR>', 'U')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end

call charout , "   Creating an URL for Ellie's Homepage.............."
rc = SysCreateObject('WPUrl',"Ellie's Homepage",'<AIG_ELLIE_URLFLDR>',,
                    'URL=http://www.cee3.demon.co.uk/ellie;OBJECTID=<ELLIEURL_HOMEPAGE>', 'U')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end

call charout , "   Creating an URL for Ellie's FAQs.................."
rc = SysCreateObject('WPUrl',"Ellie FAQs",'<AIG_ELLIE_URLFLDR>',,
                    'URL=http://www.cee3.demon.co.uk/ellie/ellie_faq.html;OBJECTID=<ELLIEURL_FAQ>', 'U')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end

call charout , "   Creating an URL for OS/2 Warp SETI@Home club......"
rc = SysCreateObject('WPUrl',"OS/2 Warp SETI@Home Club",'<AIG_ELLIE_URLFLDR>',,
                    'URL=http://setiathome.ssl.berkeley.edu/stats/team/team_1331.html', 'U')
if rc = 1  then call charout , ok; else do; call charout , no ; err = 1; end

/* - - - process completed - - - */
if err = 1 then do
    say
    say "There was an error creating the required objects for Ellie.  If you got this"
    say "far and ended up with an error something is out of my control and must"
    say "be peculiar to your system. You can try running Ellie though advanced client"
    say "control features may not function."
end
else do
    call SysOpenObject '<AIG_ELLIE_FLDR>', 'DEFAULT', 'TRUE'
    say
    say
    say "   Do you want me to doubleclick on the Ellie object and run her"
    call charout , "   for you now .(Y)es or (N)o ? " 
    pull ky
    if translate(ky) = 'Y' then
        call SysOpenObject '<AIG_ELLIE>', 'DEFAULT', 'TRUE'

    say
    say "   Have fun! Let me know of any problems, WIBNIfs (Wouldn't It Be"
    say "   Nice If's), mathematical algorithms or features to integrate into"
    say "   future versions of Ellie.  Clive."
    say "   Check http://www.cee3.demon.co.uk/ellie for news and updates"
    say '07'x

end /* do */

return
/* :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: */
/* :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: */
LoadRexxUtil:
if rxFuncQuery('SysLoadFuncs') then do
    if rxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs') then do
        say 'Installation Error! (Phase 2)   Unable to load RexxUtil library.' '07'x
        say 'Please check that you have Rexx installed on your system.' '07'x
        return 1; end
    call SysLoadFuncs
end
return 0
/* :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: */
syntax:
 say sourceline(sigl)
 say "syntax error on line ["sigl"]"
 say errortext(rc)
 trace ?R; NOP; EXIT
 return
halt:
 say "Ctrl-Break pressed.  Halting...  ** Warning ** This product may not be"
 say " installed completely!"
 EXIT
/* :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: */

