/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonModel;
import org.jvnet.substance.utils.FadeTracker;
import org.jvnet.substance.utils.Trackable;

public class RolloverControlListener
implements MouseListener,
MouseMotionListener {
    private boolean isMouseInside;
    private ButtonModel model;
    private Trackable trackableUI;

    public RolloverControlListener(Trackable trackableUI, ButtonModel model) {
        this.trackableUI = trackableUI;
        this.model = model;
        this.isMouseInside = false;
    }

    public void mouseEntered(MouseEvent e) {
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        boolean isInside = this.trackableUI.isInside(e);
        boolean isInsideChanged = this.isMouseInside != isInside;
        this.isMouseInside = isInside;
        this.model.setRollover(isInside);
        this.model.setEnabled(component.isEnabled());
        if (isInsideChanged) {
            FadeTracker.getInstance().trackFade(component, FadeTracker.FadeKind.ROLLOVER, isInside, false);
        }
        component.repaint();
    }

    public void mouseExited(MouseEvent e) {
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        boolean isInsideChanged = this.isMouseInside;
        this.isMouseInside = false;
        this.model.setRollover(false);
        this.model.setEnabled(component.isEnabled());
        if (isInsideChanged) {
            FadeTracker.getInstance().trackFade(component, FadeTracker.FadeKind.ROLLOVER, this.isMouseInside, false);
        }
        component.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        boolean isInside = this.trackableUI.isInside(e);
        boolean isInsideChanged = this.isMouseInside != isInside;
        this.isMouseInside = isInside;
        this.model.setRollover(this.isMouseInside);
        this.model.setPressed(false);
        this.model.setArmed(false);
        this.model.setSelected(false);
        this.model.setEnabled(component.isEnabled());
        if (isInsideChanged) {
            FadeTracker.getInstance().trackFade(component, FadeTracker.FadeKind.ROLLOVER, isInside, false);
        }
        component.repaint();
    }

    public void mousePressed(MouseEvent e) {
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        boolean isInside = this.trackableUI.isInside(e);
        boolean isInsideChanged = this.isMouseInside != isInside;
        this.isMouseInside = isInside;
        this.model.setRollover(this.isMouseInside);
        if (this.isMouseInside) {
            this.model.setPressed(true);
            this.model.setArmed(true);
            this.model.setSelected(true);
        }
        this.model.setEnabled(component.isEnabled());
        if (isInsideChanged) {
            FadeTracker.getInstance().trackFade(component, FadeTracker.FadeKind.ROLLOVER, isInside, false);
        }
        component.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        boolean isInside = this.trackableUI.isInside(e);
        boolean isInsideChanged = this.isMouseInside != isInside;
        this.isMouseInside = isInside;
        this.model.setEnabled(component.isEnabled());
        if (isInsideChanged) {
            FadeTracker.getInstance().trackFade(component, FadeTracker.FadeKind.ROLLOVER, isInside, false);
        }
        component.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        boolean isInside = this.trackableUI.isInside(e);
        boolean isInsideChanged = this.isMouseInside != isInside;
        this.isMouseInside = isInside;
        this.model.setRollover(isInside);
        this.model.setEnabled(component.isEnabled());
        if (isInsideChanged) {
            FadeTracker.getInstance().trackFade(component, FadeTracker.FadeKind.ROLLOVER, isInside, false);
        }
        component.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }
}

