/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceSplitPaneUI;

public class SubstanceSplitPaneDivider
extends BasicSplitPaneDivider {
    private int inset = 2;

    public SubstanceSplitPaneDivider(SubstanceSplitPaneUI ui) {
        super(ui);
    }

    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Insets insets = this.getInsets();
        g.setColor(UIManager.getColor("SplitPane.dividerFocusColor"));
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        Dimension size = this.getSize();
        size.width -= this.inset * 2;
        size.height -= this.inset * 2;
        int drawX = this.inset;
        int drawY = this.inset;
        if (insets != null) {
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            drawX += insets.left;
            drawY += insets.top;
        }
        super.paint(g);
    }

    protected JButton createLeftOneTouchButton() {
        Icon verticalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 1, SubstanceLookAndFeel.getColorScheme());
        Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 7, SubstanceLookAndFeel.getColorScheme());
        JButton b = new JButton(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.putClientProperty("substancelaf.buttonpaintnever", Boolean.TRUE);
        b.setRequestFocusEnabled(false);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        return b;
    }

    protected JButton createRightOneTouchButton() {
        Icon verticalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 5, SubstanceLookAndFeel.getColorScheme());
        Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 3, SubstanceLookAndFeel.getColorScheme());
        JButton b = new JButton(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.putClientProperty("substancelaf.buttonpaintnever", Boolean.TRUE);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    public void updateOneTouchButtons(int orientation) {
        if (orientation == 0) {
            if (this.leftButton != null) {
                this.leftButton.setIcon(SubstanceImageCreator.getArrowIcon(7, 5, 1, SubstanceLookAndFeel.getColorScheme()));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(SubstanceImageCreator.getArrowIcon(7, 5, 5, SubstanceLookAndFeel.getColorScheme()));
            }
        } else {
            if (this.leftButton != null) {
                this.leftButton.setIcon(SubstanceImageCreator.getArrowIcon(7, 5, 7, SubstanceLookAndFeel.getColorScheme()));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(SubstanceImageCreator.getArrowIcon(7, 5, 3, SubstanceLookAndFeel.getColorScheme()));
            }
        }
    }
}

