/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.RootPaneContainer;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CText;
import org.eclipse.swt.internal.swing.TextFilterEvent;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int tabs;
    int oldStart;
    int oldEnd;
    boolean doubleClick;
    boolean ignoreModify;
    boolean ignoreCharacter;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = System.getProperty("line.separator");

    public Text(Composite composite, int n2) {
        super(composite, Text.checkStyle(n2));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        CText cText = (CText)((Object)this.handle);
        String string2 = cText.getText();
        cText.setText(string2 + string);
    }

    static int checkStyle(int n2) {
        if ((n2 & 4) != 0 && (n2 & 2) != 0) {
            n2 &= 0xFFFFFFFD;
        }
        if (((n2 = Text.checkBits(n2, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n2 &= 0xFFFFFCBF;
        }
        if ((n2 & 0x40) != 0) {
            n2 |= 2;
            n2 &= 0xFFFFFEFF;
        }
        if ((n2 & 2) != 0) {
            n2 &= 0xFFBFFFFF;
        }
        if ((n2 & 6) != 0) {
            return n2;
        }
        if ((n2 & 0x300) != 0) {
            return n2 | 2;
        }
        return n2 | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        CText cText = (CText)((Object)this.handle);
        cText.setSelectionStart(0);
        cText.setSelectionStart(0);
    }

    public void copy() {
        this.checkWidget();
        ((CText)((Object)this.handle)).copy();
    }

    Container createHandle() {
        return (Container)((Object)CText.Factory.newInstance(this, this.style));
    }

    void createWidget() {
        super.createWidget();
        this.doubleClick = true;
        this.tabs = 8;
        this.setTabStops(8);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        ((CText)((Object)this.handle)).cut();
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).getCaretLineNumber();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        java.awt.Point point = ((CText)((Object)this.handle)).getCaretLocation();
        return new Point(point.x, point.y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).getCaretPosition();
    }

    public int getCharCount() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).getText().length();
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).getEchoChar();
    }

    public boolean getEditable() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).isEditable();
    }

    public int getLineCount() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).getLineCount();
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).getRowHeight();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        CText cText = (CText)((Object)this.handle);
        return new Point(cText.getSelectionStart(), cText.getSelectionEnd());
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point point = this.getSelection();
        return point.y - point.x;
    }

    public String getSelectionText() {
        this.checkWidget();
        Point point = this.getSelection();
        return this.getText().substring(point.x, point.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    public String getText() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).getText();
    }

    public String getText(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3 || 0 > n3) {
            return "";
        }
        CText cText = (CText)((Object)this.handle);
        int n4 = cText.getText().length();
        n3 = Math.min(n3, n4 - 1);
        if ((n2 = Math.max(0, n2)) > n3) {
            return "";
        }
        try {
            return cText.getText(n2, n3 - n2);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public int getTextLimit() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).getTextLimit();
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return ((CText)((Object)this.handle)).getViewPosition().y / this.getLineHeight();
    }

    public int getTopPixel() {
        this.checkWidget();
        return ((CText)((Object)this.handle)).getViewPosition().y;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        CText cText = (CText)((Object)this.handle);
        cText.replaceSelection(string);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        ((CText)((Object)this.handle)).paste();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        ((CText)((Object)this.handle)).selectAll();
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClick = bl;
    }

    public void setEchoChar(char c2) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        ((CText)((Object)this.handle)).setEchoChar(c2);
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!bl) {
            this.style |= 8;
        }
        ((CText)((Object)this.handle)).setEditable(bl);
    }

    public void setOrientation(int n2) {
        this.checkWidget();
        int n3 = 0x6000000;
        if ((n2 & n3) == 0 || (n2 & n3) == n3) {
            return;
        }
        this.style &= ~n3;
        this.style |= n2 & n3;
        ComponentOrientation componentOrientation = (this.style & 0x4000000) != 0 ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
        ((CText)((Object)this.handle)).setComponentOrientation(componentOrientation);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        ((CText)((Object)this.handle)).setSelectionStart(n2);
        ((CText)((Object)this.handle)).setSelectionEnd(n2);
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        ((CText)((Object)this.handle)).setSelectionStart(n2);
        ((CText)((Object)this.handle)).setSelectionEnd(n3);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        this.tabs = n2;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int n2) {
        ((CText)((Object)this.handle)).setTabSize(n2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        CText cText = (CText)((Object)this.handle);
        cText.setText(string);
        if ((this.style & 2) != 0) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            this.error(7);
        }
        ((CText)((Object)this.handle)).setTextLimit(n2);
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        CText cText = (CText)((Object)this.handle);
        cText.setViewPosition(new java.awt.Point(cText.getViewPosition().x, n2 / this.getLineHeight()));
    }

    public void showSelection() {
        this.checkWidget();
        ((CText)((Object)this.handle)).showSelection();
    }

    String verifyText(String string, int n2, int n3, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n2;
        event2.end = n3;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        if (eventObject instanceof TextFilterEvent) {
            if (!this.hooks(25)) {
                super.processEvent(eventObject);
                return;
            }
        } else {
            super.processEvent(eventObject);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(eventObject);
            return;
        }
        try {
            if (eventObject instanceof TextFilterEvent) {
                TextFilterEvent textFilterEvent = (TextFilterEvent)eventObject;
                textFilterEvent.setText(this.verifyText(textFilterEvent.getText(), textFilterEvent.getStart(), textFilterEvent.getStart() + textFilterEvent.getEnd(), this.createKeyEvent(textFilterEvent.getKeyEvent())));
            }
            super.processEvent(eventObject);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }

    protected boolean isTraversalKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                return (this.style & 2) == 0 || ((RootPaneContainer)((Object)this.getShell().handle)).getRootPane().getDefaultButton() != null;
            }
        }
        return super.isTraversalKey(keyEvent);
    }

    protected int getTraversalKeyDetail(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                return 4;
            }
        }
        return super.getTraversalKeyDetail(keyEvent);
    }

    protected boolean getTraversalKeyDefault(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 9: 
            case 10: {
                int n2 = keyEvent.getModifiers();
                if ((n2 & 2) != 0 || (n2 & 1) != 0) break;
                return (this.style & 2) == 0;
            }
        }
        return super.getTraversalKeyDefault(keyEvent);
    }

    protected void validateTraversalKey(KeyEvent keyEvent, Event event) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (event.doit) {
                    if (!this.hooks(14)) {
                        JButton jButton;
                        if (event.detail == 4 && (jButton = ((RootPaneContainer)((Object)this.getShell().handle)).getRootPane().getDefaultButton()) != null) {
                            jButton.requestFocus();
                            jButton.doClick();
                        }
                    } else {
                        this.sendEvent(14);
                    }
                    keyEvent.consume();
                    break;
                }
                if ((this.style & 2) != 0) break;
                keyEvent.consume();
                break;
            }
            default: {
                super.validateTraversalKey(keyEvent, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(DocumentEvent documentEvent) {
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            return;
        }
        try {
            this.postEvent(24, new Event());
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

