/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CTabFolder;
import org.eclipse.swt.internal.swing.CTabItem;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    ArrayList itemList;

    public TabFolder(Composite composite, int n2) {
        super(composite, TabFolder.checkStyle(n2));
    }

    Control[] _getChildren() {
        Component[] componentArray = ((CControl)((Object)this.handle)).getClientArea().getComponents();
        if (componentArray.length == 0) {
            return new Control[0];
        }
        ArrayList<Control> arrayList = new ArrayList<Control>(componentArray.length);
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Control control;
            CTabItem cTabItem;
            Component component = componentArray[i2];
            if (!(component instanceof CTabItem) || (component = (cTabItem = (CTabItem)((Object)component)).getContent()) == null || (control = this.display.getControl(component)) == null || control == this) continue;
            arrayList.add(control);
        }
        return arrayList.toArray(new Control[0]);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        n2 = TabFolder.checkBits(n2, 128, 1024, 0, 0, 0, 0);
        return n2 & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    boolean autoAddChildren() {
        return false;
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state &= 0xFFFFFEFD;
    }

    protected Container createHandle() {
        return (Container)((Object)CTabFolder.Factory.newInstance(this, this.style));
    }

    void createItem(TabItem tabItem, int n2) {
        int n3 = this.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.itemList.add(n2, tabItem);
        this.handle.add((Component)tabItem.handle, n2);
        this.handle.invalidate();
        this.handle.validate();
    }

    void createWidget() {
        super.createWidget();
        this.itemList = new ArrayList();
    }

    void destroyItem(TabItem tabItem) {
        int n2 = this.indexOf(tabItem);
        if (n2 != -1) {
            this.handle.remove(tabItem.handle);
            this.handle.invalidate();
            this.handle.validate();
            this.handle.repaint();
        }
        this.itemList = null;
    }

    public TabItem getItem(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        return (TabItem)this.itemList.get(n2);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemList.size();
    }

    public TabItem[] getItems() {
        this.checkWidget();
        return this.itemList.toArray(new TabItem[0]);
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n2 = ((CTabFolder)((Object)this.handle)).getSelectedIndex();
        if (n2 == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{(TabItem)this.itemList.get(n2)};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return ((CTabFolder)((Object)this.handle)).getSelectedIndex();
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.itemList.get(i2) != tabItem) continue;
            return i2;
        }
        return -1;
    }

    void releaseChildren(boolean bl) {
        if (this.itemList != null) {
            int n2 = this.getItemCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                TabItem tabItem = (TabItem)this.itemList.get(i2);
                if (tabItem.isDisposed()) continue;
                tabItem.release(false);
            }
            this.itemList = null;
        }
        super.releaseChildren(bl);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            TabItem tabItem = (TabItem)this.itemList.get(i2);
            if (tabItem.control != control) continue;
            tabItem.setControl(null);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setSelection(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            ((CTabFolder)((Object)this.handle)).setSelectedIndex(-1);
        } else {
            ((CTabFolder)((Object)this.handle)).setSelectedIndex(this.indexOf(tabItemArray[tabItemArray.length - 1]));
        }
    }

    public void setSelection(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            return;
        }
        ((CTabFolder)((Object)this.handle)).setSelectedIndex(n2);
    }

    Point minimumSize(int n2, int n3, boolean bl) {
        Dimension dimension = this.handle.getPreferredSize();
        return new Point(dimension.width, dimension.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        if (eventObject instanceof ChangeEvent) {
            if (!this.hooks(13)) {
                super.processEvent(eventObject);
                return;
            }
        } else {
            super.processEvent(eventObject);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(eventObject);
            return;
        }
        try {
            if (eventObject instanceof ChangeEvent) {
                int n2 = ((CTabFolder)((Object)this.handle)).getSelectedIndex();
                Event event = new Event();
                if (n2 >= 0) {
                    event.item = (Widget)this.itemList.get(n2);
                }
                this.sendEvent(13, event);
            }
            super.processEvent(eventObject);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

