/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Container;
import java.awt.Dimension;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CLink;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;

    public Link(Composite composite, int n2) {
        super(composite, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state |= 0x100;
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        this.checkWidget();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Link.this.isAdjustingSize = true;
            }
        });
        Dimension dimension = this.handle.getSize();
        if (n2 == -1) {
            this.handle.setSize(((CLink)((Object)this.handle)).getPreferredWidth(), 0);
        } else {
            this.handle.setSize(n2, 0);
        }
        Point point = super.computeSize(n2, n3, bl);
        this.handle.setSize(dimension);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Link.this.isAdjustingSize = false;
            }
        });
        return point;
    }

    Container createHandle() {
        return (Container)((Object)CLink.Factory.newInstance(this, this.style));
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text == null ? "" : this.text;
    }

    boolean mnemonicHit(char c2) {
        Composite composite = this.parent;
        while (composite != null) {
            int n2;
            Control[] controlArray = composite._getChildren();
            for (n2 = 0; n2 < controlArray.length && controlArray[n2] != this; ++n2) {
            }
            if (++n2 < controlArray.length && controlArray[n2].setFocus()) {
                return true;
            }
            composite = composite.parent;
        }
        return false;
    }

    boolean mnemonicMatch(char c2) {
        char c3 = this.findMnemonic(this.getText());
        if (c3 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c2) == Character.toUpperCase(c3);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.checkWidget();
        this.text = string;
        int n2 = this.findMnemonicIndex(string);
        if (n2 > 0) {
            String string2 = string.substring(0, n2 - 1).replaceAll("&&", "&");
            string = string2 + string.substring(n2).replaceAll("&&", "&");
        } else {
            string = string.replaceAll("&&", "&");
        }
        ((CLink)((Object)this.handle)).setLinkText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        if (eventObject instanceof HyperlinkEvent) {
            if (!this.hooks(13)) {
                super.processEvent(eventObject);
                return;
            }
        } else {
            super.processEvent(eventObject);
            return;
        }
        if (this.isDisposed()) {
            super.processEvent(eventObject);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(eventObject);
            return;
        }
        try {
            if (eventObject instanceof HyperlinkEvent) {
                Event event = new Event();
                event.text = ((HyperlinkEvent)eventObject).getDescription();
                this.sendEvent(13, event);
            }
            super.processEvent(eventObject);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

