/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.swing.CExpandBar;
import org.eclipse.swt.internal.swing.CExpandItem;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    Container handle;

    public ExpandItem(ExpandBar expandBar, int n2) {
        this(expandBar, n2, expandBar.getItemCount());
    }

    public ExpandItem(ExpandBar expandBar, int n2, int n3) {
        super(expandBar, n2);
        this.parent = expandBar;
        this.handle = this.createHandle();
        expandBar.createItem(this, n2, n3);
    }

    Container createHandle() {
        return (Container)((Object)CExpandItem.Factory.newInstance(this, this.style));
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return ((CExpandBar)((Object)this.parent.handle)).isExpanded(this.handle);
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return ((CExpandBar)((Object)this.parent.handle)).getTitleBarSize((Component)this.handle).height;
    }

    public int getHeight() {
        this.checkWidget();
        return ((CExpandBar)((Object)this.parent.handle)).getSize().height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        this.handle.remove(control.handle);
        this.control = control;
        if (control != null) {
            this.handle.add((Component)control.handle, "Center");
        }
        this.handle.invalidate();
        this.handle.validate();
        this.handle.repaint();
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        ((CExpandBar)((Object)this.parent.handle)).setExpanded(this.handle, bl);
    }

    public void setHeight(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (Compatibility.IS_JAVA_5_OR_GREATER) {
            this.handle.setPreferredSize(new Dimension(this.handle.getPreferredSize().width, n2));
        } else if (this.handle instanceof JComponent) {
            ((JComponent)this.handle).setPreferredSize(new Dimension(this.handle.getPreferredSize().width, n2));
        }
        ((JComponent)this.handle).revalidate();
        this.handle.repaint();
    }

    public void setImage(Image image) {
        super.setImage(image);
        ((CExpandBar)((Object)this.parent.handle)).setIcon(this.handle, new ImageIcon(image.handle));
    }

    public void setText(String string) {
        super.setText(string);
        ((CExpandBar)((Object)this.parent.handle)).setText(this.handle, this.text);
    }
}

