/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class JIconRadioButton
extends JRadioButton {
    public void setIcon(Icon icon) {
        if (icon != null) {
            super.setIcon(new Icon(icon){
                protected Icon icon1;
                protected Icon icon2;
                {
                    this.icon1 = ((BasicRadioButtonUI)JIconRadioButton.this.getUI()).getDefaultIcon();
                    this.icon2 = icon;
                }

                public int getIconWidth() {
                    return this.icon1.getIconWidth() + this.icon2.getIconWidth() + JIconRadioButton.this.getIconTextGap();
                }

                public int getIconHeight() {
                    return Math.max(this.icon1.getIconHeight(), this.icon2.getIconHeight());
                }

                public void paintIcon(Component c2, Graphics g2, int x, int y) {
                    int h1 = this.icon1.getIconHeight();
                    int h2 = this.icon2.getIconHeight();
                    int max = Math.max(h1, h2);
                    this.icon1.paintIcon(c2, g2, x, y + (max - h1) / 2);
                    this.icon2.paintIcon(c2, g2, x + this.icon1.getIconWidth() + JIconRadioButton.this.getIconTextGap(), y + (max - h2) / 2);
                }
            });
        } else {
            super.setIcon(icon);
        }
    }
}

