/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CText;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.TextFilterEvent;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;

class CTextField
extends JPasswordField
implements CText {
    protected Text handle;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected KeyEvent keyEvent = null;
    protected int textLimit = Text.LIMIT;
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CTextField(Text text, int n2) {
        this.handle = text;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        this.setEchoChar('\u0000');
        this.init(n2);
    }

    public boolean isOpaque() {
        return this.backgroundImageIcon == null && super.isOpaque();
    }

    protected void paintComponent(Graphics graphics) {
        Utils.paintTiledImage(this, graphics, this.backgroundImageIcon);
        super.paintComponent(graphics);
    }

    protected void init(int n2) {
        if ((n2 & 0x800) == 0) {
            this.setBorder(null);
        }
        if ((n2 & 0x1000000) != 0) {
            this.setHorizontalAlignment(0);
        } else if ((n2 & 0x20000) != 0) {
            this.setHorizontalAlignment(4);
        }
        this.setEditable((n2 & 8) == 0);
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e2) {
                CTextField.this.keyEvent = e2;
            }

            public void keyReleased(KeyEvent e2) {
                CTextField.this.keyEvent = null;
            }

            public void keyTyped(KeyEvent e2) {
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e2) {
                CTextField.this.handle.processEvent(e2);
            }

            public void insertUpdate(DocumentEvent e2) {
                CTextField.this.handle.processEvent(e2);
            }

            public void removeUpdate(DocumentEvent e2) {
                CTextField.this.handle.processEvent(e2);
            }
        });
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new DocumentFilter(){

            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (CTextField.this.getText().length() - length + text.length() > CTextField.this.getTextLimit()) {
                    return;
                }
                TextFilterEvent filterEvent = new TextFilterEvent(this, text, offset, length, CTextField.this.keyEvent);
                CTextField.this.handle.processEvent(filterEvent);
                String s2 = filterEvent.getText();
                if (s2 != null) {
                    super.replace(fb, offset, length, s2, attrs);
                }
            }

            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                TextFilterEvent filterEvent = new TextFilterEvent(this, "", offset, length, CTextField.this.keyEvent);
                CTextField.this.handle.processEvent(filterEvent);
                String s2 = filterEvent.getText();
                if (s2 != null) {
                    super.replace(fb, offset, length, s2, null);
                }
            }
        });
    }

    public Container getClientArea() {
        return this;
    }

    public void setText(String string) {
        super.setText(string.replaceAll("[\r\n]", ""));
    }

    public void setEchoChar(char c2) {
        super.setEchoChar(c2);
        if (c2 == '\u0000') {
            LookAndFeelUtils.applyTextFieldStyle(this);
        } else {
            LookAndFeelUtils.applyPasswordFieldStyle(this);
        }
    }

    public void setTabSize(int n2) {
    }

    public int getLineCount() {
        return 1;
    }

    public Point getCaretLocation() {
        return new Point(this.getCaretPosition(), 0);
    }

    public void showSelection() {
        try {
            Rectangle rectangle = this.modelToView(this.getSelectionStart());
            Rectangle rectangle2 = this.modelToView(this.getSelectionEnd());
            rectangle.add(rectangle2);
            this.scrollRectToVisible(rectangle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getCaretLineNumber() {
        return 0;
    }

    public int getRowHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    public Point getViewPosition() {
        try {
            Rectangle rectangle = this.modelToView(0);
            return new Point(rectangle.x, rectangle.y);
        }
        catch (Exception exception) {
            return new Point(0, 0);
        }
    }

    public void setViewPosition(Point point) {
        try {
            Rectangle rectangle = this.modelToView(point.x);
            this.scrollRectToVisible(rectangle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTextLimit(int n2) {
        this.textLimit = n2;
        String string = this.getText();
        if (string.length() > n2) {
            this.setText(string.substring(0, n2));
        }
    }

    public int getTextLimit() {
        return this.textLimit;
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (this.userAttributeHandler == null) {
            return super.getCursor();
        }
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        for (Scrollable scrollable = this.handle; scrollable != null && scrollable.handle != null; scrollable = scrollable.getParent()) {
            Cursor cursor = ((CControl)((Object)scrollable.handle)).getUserAttributeHandler().cursor;
            if (cursor == null) continue;
            return cursor;
        }
        return super.getCursor();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.setOpaque(true);
                break;
            }
            case 2: {
                this.setOpaque(false);
            }
        }
    }

    public JScrollBar getHorizontalScrollBar() {
        return null;
    }

    public JScrollBar getVerticalScrollBar() {
        return null;
    }
}

