/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CList;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

class CListImplementation
extends JScrollPane
implements CList {
    protected List handle;
    protected JList list;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected boolean isAdjustingSelection;
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this.list;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CListImplementation(List list, int n2) {
        this.handle = list;
        this.list = new JList(new DefaultListModel()){

            public Color getBackground() {
                return CListImplementation.this != null && CListImplementation.this.userAttributeHandler != null && CListImplementation.this.userAttributeHandler.background != null ? CListImplementation.this.userAttributeHandler.background : super.getBackground();
            }

            public Color getForeground() {
                return CListImplementation.this != null && CListImplementation.this.userAttributeHandler != null && CListImplementation.this.userAttributeHandler.foreground != null ? CListImplementation.this.userAttributeHandler.foreground : super.getForeground();
            }

            public Font getFont() {
                return CListImplementation.this != null && CListImplementation.this.userAttributeHandler != null && CListImplementation.this.userAttributeHandler.font != null ? CListImplementation.this.userAttributeHandler.font : super.getFont();
            }

            public Cursor getCursor() {
                if (Utils.globalCursor != null) {
                    return Utils.globalCursor;
                }
                return CListImplementation.this != null && CListImplementation.this.userAttributeHandler != null && CListImplementation.this.userAttributeHandler.cursor != null ? CListImplementation.this.userAttributeHandler.cursor : super.getCursor();
            }

            public boolean isOpaque() {
                return CListImplementation.this.backgroundImageIcon == null && super.isOpaque();
            }
        };
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public boolean isOpaque() {
                return CListImplementation.this.list.isOpaque() && super.isOpaque();
            }
        });
        this.userAttributeHandler = new CControl.UserAttributeHandler(this.list);
        JViewport jViewport = new JViewport(){

            public boolean isOpaque() {
                return CListImplementation.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                Utils.paintTiledImage(this, g2, CListImplementation.this.backgroundImageIcon);
                super.paintComponent(g2);
            }

            public Color getBackground() {
                return CListImplementation.this != null && CListImplementation.this.userAttributeHandler != null && CListImplementation.this.userAttributeHandler.background != null ? CListImplementation.this.userAttributeHandler.background : super.getBackground();
            }
        };
        this.setViewport(jViewport);
        jViewport.setView(this.list);
        this.init(n2);
    }

    protected void init(int n2) {
        this.setFont(this.list.getFont());
        if ((n2 & 0x800) == 0) {
            this.setBorder(null);
            this.list.setBorder(null);
        }
        if ((n2 & 0x100) == 0) {
            this.setHorizontalScrollBarPolicy(31);
        }
        if ((n2 & 0x200) == 0) {
            this.setVerticalScrollBarPolicy(21);
        }
        this.list.setSelectionMode((n2 & 2) != 0 ? 2 : 0);
        Utils.installMouseListener(this.list, this.handle);
        Utils.installKeyListener(this.list, this.handle);
        Utils.installFocusListener(this.list, this.handle);
        Utils.installComponentListener(this, this.handle);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    CListImplementation.this.handle.processEvent(new ActionEvent(CListImplementation.this.list, 1001, null));
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (!CListImplementation.this.isAdjustingSelection) {
                    CListImplementation.this.handle.processEvent(e2);
                }
            }
        });
    }

    public boolean isFocusable() {
        return this.list.isFocusable();
    }

    public void requestFocus() {
        this.list.requestFocus();
        if (this.list.getModel().getSize() > 0 && this.list.getSelectedIndex() < 0) {
            this.isAdjustingSelection = true;
            ListSelectionModel listSelectionModel = this.list.getSelectionModel();
            if (listSelectionModel.getLeadSelectionIndex() < 0) {
                listSelectionModel.setAnchorSelectionIndex(0);
                listSelectionModel.setLeadSelectionIndex(0);
                listSelectionModel.clearSelection();
            }
            this.isAdjustingSelection = false;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.list != null) {
            this.list.setFont(font);
        }
    }

    public Container getClientArea() {
        return this.list;
    }

    public Dimension getPreferredSize() {
        int n2 = this.getItemCount();
        int n3 = super.getPreferredSize().height;
        if (n2 > 0) {
            Rectangle rectangle = this.list.getCellBounds(n2 - 1, n2 - 1);
            n3 = rectangle.y + 2 * rectangle.height + SwingUtilities.convertPoint((Component)this.list, (int)0, (int)0, (Component)this).y + 1;
        }
        return new Dimension(super.getPreferredSize().width, n3);
    }

    public void addElement(Object object) {
        ((DefaultListModel)this.list.getModel()).addElement(object);
    }

    public void insertElementAt(Object object, int n2) {
        ((DefaultListModel)this.list.getModel()).insertElementAt(object, n2);
    }

    public void removeElementAt(int n2) {
        ((DefaultListModel)this.list.getModel()).removeElementAt(n2);
    }

    public void removeRange(int n2, int n3) {
        ((DefaultListModel)this.list.getModel()).removeRange(n2, n3);
    }

    public void removeAllElements() {
        ((DefaultListModel)this.list.getModel()).removeAllElements();
    }

    public Object getElementAt(int n2) {
        return this.list.getModel().getElementAt(n2);
    }

    public void setElementAt(Object object, int n2) {
        ((DefaultListModel)this.list.getModel()).setElementAt(object, n2);
    }

    public void setElements(Object[] objectArray) {
        this.removeAllElements();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            defaultListModel.addElement(objectArray[i2]);
        }
    }

    public int indexOf(Object object, int n2) {
        return ((DefaultListModel)this.list.getModel()).indexOf(object, n2);
    }

    public int getItemCount() {
        return this.list.getModel().getSize();
    }

    public int getMinSelectionIndex() {
        return this.list.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.list.getSelectionModel().getMaxSelectionIndex();
    }

    public int[] getSelectionIndices() {
        int n2 = this.getMinSelectionIndex();
        if (n2 == -1) {
            return new int[0];
        }
        int n3 = this.getMaxSelectionIndex();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n3 - n2 + 1);
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.isSelectedIndex(i2)) continue;
            arrayList.add(new Integer(i2));
        }
        int[] nArray = new int[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            nArray[i3] = (Integer)arrayList.get(i3);
        }
        return nArray;
    }

    public boolean isSelectedIndex(int n2) {
        return this.list.getSelectionModel().isSelectedIndex(n2);
    }

    public void setSelectedElements(Object[] objectArray) {
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n2 = defaultListModel.indexOf(objectArray[i2]);
            if (n2 < 0) continue;
            this.list.setSelectedIndex(n2);
        }
    }

    public void addSelectionInterval(int n2, int n3) {
        this.list.getSelectionModel().addSelectionInterval(n2, n3);
    }

    public void setSelectionInterval(int n2, int n3) {
        this.list.getSelectionModel().setSelectionInterval(n2, n3);
    }

    public void removeSelectionInterval(int n2, int n3) {
        this.list.getSelectionModel().removeSelectionInterval(n2, n3);
    }

    public void showSelection() {
        int n2 = this.list.getMinSelectionIndex();
        if (n2 == -1) {
            return;
        }
        int n3 = this.list.getMaxSelectionIndex();
        this.scrollRectToVisible(this.list.getCellBounds(n2, n3));
    }

    public int getFirstVisibleIndex() {
        return this.list.getFirstVisibleIndex();
    }

    public void setFirstVisibleIndex(int n2) {
        if (n2 < 0) {
            return;
        }
        if (n2 >= this.getItemCount()) {
            return;
        }
        this.scrollRectToVisible(new Rectangle(0, 0, this.getWidth(), 0));
        this.scrollRectToVisible(this.list.getCellBounds(n2, n2));
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.setOpaque(true);
                this.getViewport().setOpaque(true);
                this.list.setOpaque(true);
                break;
            }
            case 2: {
                this.setOpaque(false);
                this.getViewport().setOpaque(false);
                this.list.setOpaque(false);
            }
        }
    }

    public Rectangle getCellBounds(int n2) {
        return this.list.getCellBounds(n2, n2);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.list.setEnabled(bl);
    }

    public int getFocusIndex() {
        return this.list.getSelectionModel().getLeadSelectionIndex();
    }
}

