/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class WinBMPFileFormat
extends FileFormat {
    static final int BMPFileHeaderSize = 14;
    static final int BMPHeaderFixedSize = 40;
    int importantColors;
    Point pelsPerMeter = new Point(0, 0);

    WinBMPFileFormat() {
    }

    int compress(int n2, byte[] byArray, int n3, int n4, byte[] byArray2, boolean bl) {
        if (n2 == 1) {
            return this.compressRLE8Data(byArray, n3, n4, byArray2, bl);
        }
        if (n2 == 2) {
            return this.compressRLE4Data(byArray, n3, n4, byArray2, bl);
        }
        SWT.error(40);
        return 0;
    }

    int compressRLE4Data(byte[] byArray, int n2, int n3, byte[] byArray2, boolean bl) {
        int n4 = n2;
        int n5 = n2 + n3;
        int n6 = 0;
        int n7 = 0;
        while (n4 < n5) {
            int n8;
            int n9 = n5 - n4 - 1;
            if (n9 > 127) {
                n9 = 127;
            }
            for (n8 = 0; n8 < n9 && byArray[n4 + n8] != byArray[n4 + n8 + 1]; ++n8) {
            }
            if (n8 < 127 && n8 == n9) {
                ++n8;
            }
            switch (n8) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[n6] = 2;
                    byArray2[++n6] = byArray[n4];
                    ++n6;
                    ++n4;
                    n7 += 2;
                    break;
                }
                default: {
                    byArray2[n6] = 0;
                    byArray2[++n6] = (byte)(n8 + n8);
                    ++n6;
                    for (int i2 = n8; i2 > 0; --i2) {
                        byArray2[n6] = byArray[n4];
                        ++n6;
                        ++n4;
                    }
                    n7 += 2 + n8;
                    if ((n8 & 1) == 0) break;
                    byArray2[n6] = 0;
                    ++n6;
                    ++n7;
                }
            }
            if ((n9 = n5 - n4) <= 0) continue;
            if (n9 > 127) {
                n9 = 127;
            }
            byte by = byArray[n4];
            for (n8 = 1; n8 < n9 && byArray[n4 + n8] == by; ++n8) {
            }
            byArray2[n6] = (byte)(n8 + n8);
            byArray2[++n6] = by;
            ++n6;
            n4 += n8;
            n7 += 2;
        }
        byArray2[n6] = 0;
        ++n6;
        if (bl) {
            byArray2[n6] = 1;
            ++n6;
        } else {
            byArray2[n6] = 0;
            ++n6;
        }
        return n7 += 2;
    }

    int compressRLE8Data(byte[] byArray, int n2, int n3, byte[] byArray2, boolean bl) {
        int n4 = n2;
        int n5 = n2 + n3;
        int n6 = 0;
        int n7 = 0;
        while (n4 < n5) {
            int n8;
            int n9 = n5 - n4 - 1;
            if (n9 > 254) {
                n9 = 254;
            }
            for (n8 = 0; n8 < n9 && byArray[n4 + n8] != byArray[n4 + n8 + 1]; ++n8) {
            }
            if (n8 == n9) {
                ++n8;
            }
            switch (n8) {
                case 0: {
                    break;
                }
                case 2: {
                    byArray2[n6] = 1;
                    byArray2[++n6] = byArray[n4];
                    ++n6;
                    ++n4;
                    n7 += 2;
                }
                case 1: {
                    byArray2[n6] = 1;
                    byArray2[++n6] = byArray[n4];
                    ++n6;
                    ++n4;
                    n7 += 2;
                    break;
                }
                default: {
                    byArray2[n6] = 0;
                    byArray2[++n6] = (byte)n8;
                    ++n6;
                    for (int i2 = n8; i2 > 0; --i2) {
                        byArray2[n6] = byArray[n4];
                        ++n6;
                        ++n4;
                    }
                    n7 += 2 + n8;
                    if ((n8 & 1) == 0) break;
                    byArray2[n6] = 0;
                    ++n6;
                    ++n7;
                }
            }
            if ((n9 = n5 - n4) <= 0) continue;
            if (n9 > 255) {
                n9 = 255;
            }
            byte by = byArray[n4];
            for (n8 = 1; n8 < n9 && byArray[n4 + n8] == by; ++n8) {
            }
            byArray2[n6] = (byte)n8;
            byArray2[++n6] = by;
            ++n6;
            n4 += n8;
            n7 += 2;
        }
        byArray2[n6] = 0;
        ++n6;
        if (bl) {
            byArray2[n6] = 1;
            ++n6;
        } else {
            byArray2[n6] = 0;
            ++n6;
        }
        return n7 += 2;
    }

    void decompressData(byte[] byArray, byte[] byArray2, int n2, int n3) {
        if (n3 == 1) {
            if (this.decompressRLE8Data(byArray, byArray.length, n2, byArray2, byArray2.length) <= 0) {
                SWT.error(40);
            }
            return;
        }
        if (n3 == 2) {
            if (this.decompressRLE4Data(byArray, byArray.length, n2, byArray2, byArray2.length) <= 0) {
                SWT.error(40);
            }
            return;
        }
        SWT.error(40);
    }

    int decompressRLE4Data(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = 0;
        int n6 = n2;
        int n7 = 0;
        int n8 = n4;
        int n9 = 0;
        int n10 = 0;
        block5: while (n5 < n6) {
            int n11;
            int n12 = byArray[n5] & 0xFF;
            ++n5;
            if (n12 == 0) {
                n12 = byArray[n5] & 0xFF;
                ++n5;
                switch (n12) {
                    case 0: {
                        n9 = 0;
                        if ((n7 = ++n10 * n3) < n8) continue block5;
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        n9 += byArray[n5] & 0xFF;
                        n10 += byArray[++n5] & 0xFF;
                        ++n5;
                        n7 = n10 * n3 + n9 / 2;
                        if (n7 < n8) continue block5;
                        return -1;
                    }
                }
                if ((n12 & 1) != 0) {
                    return -1;
                }
                n9 += n12;
                if ((n12 /= 2) > n6 - n5) {
                    return -1;
                }
                if (n12 > n8 - n7) {
                    return -1;
                }
                for (n11 = 0; n11 < n12; ++n11) {
                    byArray2[n7] = byArray[n5];
                    ++n7;
                    ++n5;
                }
                if ((n5 & 1) == 0) continue;
                ++n5;
                continue;
            }
            if ((n12 & 1) != 0) {
                return -1;
            }
            n9 += n12;
            n11 = byArray[n5];
            ++n5;
            if ((n12 /= 2) > n8 - n7) {
                return -1;
            }
            for (int i2 = 0; i2 < n12; ++i2) {
                byArray2[n7] = n11;
                ++n7;
            }
        }
        return 1;
    }

    int decompressRLE8Data(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = 0;
        int n6 = n2;
        int n7 = 0;
        int n8 = n4;
        int n9 = 0;
        int n10 = 0;
        block5: while (n5 < n6) {
            int n11;
            int n12 = byArray[n5] & 0xFF;
            ++n5;
            if (n12 == 0) {
                n12 = byArray[n5] & 0xFF;
                ++n5;
                switch (n12) {
                    case 0: {
                        n9 = 0;
                        if ((n7 = ++n10 * n3) < n8) continue block5;
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        n9 += byArray[n5] & 0xFF;
                        n10 += byArray[++n5] & 0xFF;
                        ++n5;
                        n7 = n10 * n3 + n9;
                        if (n7 < n8) continue block5;
                        return -1;
                    }
                }
                if (n12 > n6 - n5) {
                    return -1;
                }
                if (n12 > n8 - n7) {
                    return -1;
                }
                for (n11 = 0; n11 < n12; ++n11) {
                    byArray2[n7] = byArray[n5];
                    ++n7;
                    ++n5;
                }
                if ((n5 & 1) != 0) {
                    ++n5;
                }
                n9 += n12;
                continue;
            }
            n11 = byArray[n5];
            ++n5;
            if (n12 > n8 - n7) {
                return -1;
            }
            for (int i2 = 0; i2 < n12; ++i2) {
                byArray2[n7] = n11;
                ++n7;
            }
            n9 += n12;
        }
        return 1;
    }

    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[18];
            lEDataInputStream.read(byArray);
            lEDataInputStream.unread(byArray);
            int n2 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8 | (byArray[16] & 0xFF) << 16 | (byArray[17] & 0xFF) << 24;
            return byArray[0] == 66 && byArray[1] == 77 && n2 >= 40;
        }
        catch (Exception exception) {
            return false;
        }
    }

    byte[] loadData(byte[] byArray) {
        int n2 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        int n3 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        int n4 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        int n5 = (n2 * n4 + 7) / 8;
        n5 = (n5 + 3) / 4 * 4;
        byte[] byArray2 = this.loadData(byArray, n5);
        this.flipScanLines(byArray2, n5, n3);
        return byArray2;
    }

    byte[] loadData(byte[] byArray, int n2) {
        int n3 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        int n4 = n3 * n2;
        byte[] byArray2 = new byte[n4];
        int n5 = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF) << 24;
        if (n5 == 0) {
            try {
                if (this.inputStream.read(byArray2) != n4) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        } else {
            int n6 = byArray[20] & 0xFF | (byArray[21] & 0xFF) << 8 | (byArray[22] & 0xFF) << 16 | (byArray[23] & 0xFF) << 24;
            byte[] byArray3 = new byte[n6];
            try {
                if (this.inputStream.read(byArray3) != n6) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            this.decompressData(byArray3, byArray2, n2, n5);
        }
        return byArray2;
    }

    int[] loadFileHeader() {
        int[] nArray = new int[5];
        try {
            nArray[0] = this.inputStream.readShort();
            nArray[1] = this.inputStream.readInt();
            nArray[2] = this.inputStream.readShort();
            nArray[3] = this.inputStream.readShort();
            nArray[4] = this.inputStream.readInt();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (nArray[0] != 19778) {
            SWT.error(40);
        }
        return nArray;
    }

    ImageData[] loadFromByteStream() {
        int[] nArray = this.loadFileHeader();
        byte[] byArray = new byte[40];
        try {
            this.inputStream.read(byArray);
        }
        catch (Exception exception) {
            SWT.error(39, exception);
        }
        int n2 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        int n3 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        int n4 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        PaletteData paletteData = this.loadPalette(byArray);
        if (this.inputStream.getPosition() < nArray[4]) {
            try {
                this.inputStream.skip(nArray[4] - this.inputStream.getPosition());
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        byte[] byArray2 = this.loadData(byArray);
        this.compression = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF) << 24;
        this.importantColors = byArray[36] & 0xFF | (byArray[37] & 0xFF) << 8 | (byArray[38] & 0xFF) << 16 | (byArray[39] & 0xFF) << 24;
        int n5 = byArray[24] & 0xFF | (byArray[25] & 0xFF) << 8 | (byArray[26] & 0xFF) << 16 | (byArray[27] & 0xFF) << 24;
        int n6 = byArray[28] & 0xFF | (byArray[29] & 0xFF) << 8 | (byArray[30] & 0xFF) << 16 | (byArray[31] & 0xFF) << 24;
        this.pelsPerMeter = new Point(n5, n6);
        int n7 = this.compression == 1 || this.compression == 2 ? 1 : 0;
        return new ImageData[]{ImageData.internal_new(n2, n3, n4, paletteData, 4, byArray2, 0, null, null, -1, -1, n7, 0, 0, 0, 0)};
    }

    PaletteData loadPalette(byte[] byArray) {
        int n2 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        if (n2 <= 8) {
            int n3 = byArray[32] & 0xFF | (byArray[33] & 0xFF) << 8 | (byArray[34] & 0xFF) << 16 | (byArray[35] & 0xFF) << 24;
            if (n3 == 0) {
                n3 = 1 << n2;
            } else if (n3 > 256) {
                n3 = 256;
            }
            byte[] byArray2 = new byte[n3 * 4];
            try {
                if (this.inputStream.read(byArray2) != byArray2.length) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            return this.paletteFromBytes(byArray2, n3);
        }
        if (n2 == 16) {
            return new PaletteData(31744, 992, 31);
        }
        if (n2 == 24) {
            return new PaletteData(255, 65280, 0xFF0000);
        }
        return new PaletteData(65280, 0xFF0000, -16777216);
    }

    PaletteData paletteFromBytes(byte[] byArray, int n2) {
        int n3 = 0;
        RGB[] rGBArray = new RGB[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            rGBArray[i2] = new RGB(byArray[n3 + 2] & 0xFF, byArray[n3 + 1] & 0xFF, byArray[n3] & 0xFF);
            n3 += 4;
        }
        return new PaletteData(rGBArray);
    }

    static byte[] paletteToBytes(PaletteData paletteData) {
        int n2 = paletteData.colors == null ? 0 : (paletteData.colors.length < 256 ? paletteData.colors.length : 256);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            RGB rGB = paletteData.colors[i2];
            byArray[n3] = (byte)rGB.blue;
            byArray[n3 + 1] = (byte)rGB.green;
            byArray[n3 + 2] = (byte)rGB.red;
            n3 += 4;
        }
        return byArray;
    }

    int unloadData(ImageData imageData, OutputStream outputStream, int n2) {
        int n3 = 0;
        try {
            if (n2 == 0) {
                return this.unloadDataNoCompression(imageData, outputStream);
            }
            int n4 = (imageData.width * imageData.depth + 7) / 8;
            int n5 = (n4 + 3) / 4 * 4;
            int n6 = imageData.bytesPerLine;
            byte[] byArray = new byte[n5 * 2];
            int n7 = n6 * (imageData.height - 1);
            byte[] byArray2 = imageData.data;
            n3 = 0;
            byte[] byArray3 = new byte[32768];
            int n8 = 0;
            for (int i2 = imageData.height - 1; i2 >= 0; --i2) {
                int n9 = this.compress(n2, byArray2, n7, n4, byArray, i2 == 0);
                if (n8 + n9 > byArray3.length) {
                    outputStream.write(byArray3, 0, n8);
                    n8 = 0;
                }
                System.arraycopy(byArray, 0, byArray3, n8, n9);
                n8 += n9;
                n3 += n9;
                n7 -= n6;
            }
            if (n8 > 0) {
                outputStream.write(byArray3, 0, n8);
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return n3;
    }

    int unloadDataNoCompression(ImageData imageData, OutputStream outputStream) {
        int n2 = 0;
        try {
            int n3 = (imageData.width * imageData.depth + 7) / 8;
            n2 = (n3 + 3) / 4 * 4;
            int n4 = 32678 / n2;
            byte[] byArray = new byte[n4 * n2];
            byte[] byArray2 = imageData.data;
            int n5 = imageData.bytesPerLine;
            int n6 = n5 * (imageData.height - 1);
            if (imageData.depth == 16) {
                for (int i2 = 0; i2 < imageData.height; i2 += n4) {
                    int n7 = imageData.height - i2;
                    if (n4 < n7) {
                        n7 = n4;
                    }
                    int n8 = 0;
                    for (int i3 = 0; i3 < n7; ++i3) {
                        for (int i4 = 0; i4 < n3; i4 += 2) {
                            byArray[n8 + i4 + 1] = byArray2[n6 + i4 + 1];
                            byArray[n8 + i4] = byArray2[n6 + i4];
                        }
                        n8 += n2;
                        n6 -= n5;
                    }
                    outputStream.write(byArray, 0, n8);
                }
            } else {
                for (int i5 = 0; i5 < imageData.height; i5 += n4) {
                    int n9 = imageData.height - i5;
                    int n10 = n9 < n4 ? n9 : n4;
                    int n11 = 0;
                    for (int i6 = 0; i6 < n10; ++i6) {
                        System.arraycopy(byArray2, n6, byArray, n11, n3);
                        n11 += n2;
                        n6 -= n5;
                    }
                    outputStream.write(byArray, 0, n11);
                }
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return n2 * imageData.height;
    }

    void unloadIntoByteStream(ImageLoader imageLoader) {
        byte[] byArray;
        int n2;
        int n3;
        ImageData imageData = imageLoader.data[0];
        if (imageData.depth != 1 && imageData.depth != 4 && imageData.depth != 8 && imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32) {
            SWT.error(38);
        }
        if (!((n3 = this.compression) == 0 || n3 == 1 && imageData.depth == 8 || n3 == 2 && imageData.depth == 4)) {
            SWT.error(40);
        }
        PaletteData paletteData = imageData.palette;
        if (imageData.depth == 16 || imageData.depth == 24 || imageData.depth == 32) {
            if (!paletteData.isDirect) {
                SWT.error(40);
            }
            n2 = 0;
            byArray = null;
        } else {
            if (paletteData.isDirect) {
                SWT.error(40);
            }
            n2 = paletteData.colors.length;
            byArray = WinBMPFileFormat.paletteToBytes(paletteData);
        }
        int n4 = 54;
        int[] nArray = new int[]{19778, 0, 0, 0, n4};
        if (byArray != null) {
            nArray[4] = nArray[4] + byArray.length;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.unloadData(imageData, byteArrayOutputStream, n3);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        nArray[1] = nArray[4] + byArray2.length;
        try {
            this.outputStream.writeShort(nArray[0]);
            this.outputStream.writeInt(nArray[1]);
            this.outputStream.writeShort(nArray[2]);
            this.outputStream.writeShort(nArray[3]);
            this.outputStream.writeInt(nArray[4]);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        try {
            this.outputStream.writeInt(40);
            this.outputStream.writeInt(imageData.width);
            this.outputStream.writeInt(imageData.height);
            this.outputStream.writeShort(1);
            this.outputStream.writeShort((short)imageData.depth);
            this.outputStream.writeInt(n3);
            this.outputStream.writeInt(byArray2.length);
            this.outputStream.writeInt(this.pelsPerMeter.x);
            this.outputStream.writeInt(this.pelsPerMeter.y);
            this.outputStream.writeInt(n2);
            this.outputStream.writeInt(this.importantColors);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (n2 > 0) {
            try {
                this.outputStream.write(byArray);
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        try {
            this.outputStream.write(byArray2);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    void flipScanLines(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = (n3 - 1) * n2;
        for (int i2 = 0; i2 < n3 / 2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                byte by = byArray[i3 + n4];
                byArray[i3 + n4] = byArray[i3 + n5];
                byArray[i3 + n5] = by;
            }
            n4 += n2;
            n5 -= n2;
        }
    }
}

