/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;

class StyledTextDragAndDropEffect
extends DragAndDropEffect {
    StyledText text;
    long scrollBeginTime;
    int scrollX = -1;
    int scrollY = -1;
    static final int SCROLL_HYSTERESIS = 100;
    static final int SCROLL_TOLERANCE = 20;

    StyledTextDragAndDropEffect(StyledText styledText) {
        this.text = styledText;
    }

    void showDropTargetEffect(int n2, int n3, int n4) {
        int n5;
        int n6;
        Object object;
        Point point = this.text.getDisplay().map(null, this.text, n3, n4);
        if ((n2 & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (this.text.getCharCount() == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (this.scrollX != -1 && this.scrollY != -1 && this.scrollBeginTime != 0L && (point.x >= this.scrollX && point.x <= this.scrollX + 20 || point.y >= this.scrollY && point.y <= this.scrollY + 20)) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int n7;
                object = this.text.getClientArea();
                Rectangle rectangle = this.text.getTextBounds(0, 0);
                n6 = rectangle.width;
                if (point.x < ((Rectangle)object).x + 2 * n6) {
                    n7 = this.text.getHorizontalPixel();
                    this.text.setHorizontalPixel(n7 - n6);
                    if (this.text.getHorizontalPixel() != n7) {
                        this.text.redraw();
                    }
                }
                if (point.x > ((Rectangle)object).width - 2 * n6) {
                    n7 = this.text.getHorizontalPixel();
                    this.text.setHorizontalPixel(n7 + n6);
                    if (this.text.getHorizontalPixel() != n7) {
                        this.text.redraw();
                    }
                }
                if (point.y < ((Rectangle)object).y + (n7 = rectangle.height)) {
                    n5 = this.text.getTopPixel();
                    this.text.setTopPixel(n5 - n7);
                    if (this.text.getTopPixel() != n5) {
                        this.text.redraw();
                    }
                }
                if (point.y > ((Rectangle)object).height - n7) {
                    n5 = this.text.getTopPixel();
                    this.text.setTopPixel(n5 + n7);
                    if (this.text.getTopPixel() != n5) {
                        this.text.redraw();
                    }
                }
                this.scrollBeginTime = 0L;
                this.scrollY = -1;
                this.scrollX = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 100L;
            this.scrollX = point.x;
            this.scrollY = point.y;
        }
        if ((n2 & 1) != 0) {
            object = this.text.getContent();
            int n8 = this.text.getCaretOffset();
            n6 = -1;
            try {
                n6 = this.text.getOffsetAtLocation(point);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n5 = object.getCharCount();
                Point point2 = this.text.getLocationAtOffset(n5);
                if (point.y >= point2.y) {
                    try {
                        n6 = this.text.getOffsetAtLocation(new Point(point.x, point2.y));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        n6 = n5;
                    }
                }
                try {
                    int n9 = this.text.getOffsetAtLocation(new Point(0, point.y));
                    int n10 = n5;
                    int n11 = object.getLineAtOffset(n9);
                    int n12 = object.getLineCount();
                    if (n11 + 1 < n12) {
                        n10 = object.getOffsetAtLine(n11 + 1) - 1;
                    }
                    int n13 = this.text.getLineHeight(n9);
                    for (int i2 = n10; i2 >= n9; --i2) {
                        Point point3 = this.text.getLocationAtOffset(i2);
                        if (point3.x >= point.x || point3.y >= point.y || point3.y + n13 <= point.y) continue;
                        n6 = i2;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    n6 = -1;
                }
            }
            if (n6 != -1 && n6 != n8) {
                int n14 = object.getLineAtOffset(n6);
                n5 = object.getOffsetAtLine(n14);
                int n15 = n6 - n5;
                if (n15 > object.getLine(n14).length()) {
                    n6 = Math.max(0, n6 - 1);
                }
                this.text.setFocus();
                OS.ImageList_DragShowNolock((boolean)false);
                this.text.setCaretOffset(n6);
                OS.ImageList_DragShowNolock((boolean)true);
            }
        }
    }
}

