/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$Clipboard;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread() && !SwingUtilities.isEventDispatchThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = (class$org$eclipse$swt$dnd$Clipboard == null ? (class$org$eclipse$swt$dnd$Clipboard = Clipboard.class$((String)"org.eclipse.swt.dnd.Clipboard")) : class$org$eclipse$swt$dnd$Clipboard).getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread() && !SwingUtilities.isEventDispatchThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int n2) {
        this.checkWidget();
        try {
            java.awt.datatransfer.Clipboard clipboard;
            if ((n2 & 1) != 0) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(null, null);
            }
            if ((n2 & 2) != 0 && (clipboard = Toolkit.getDefaultToolkit().getSystemSelection()) != null) {
                clipboard.setContents(null, null);
            }
        }
        catch (Exception exception) {
            DND.error(2002);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread() && !SwingUtilities.isEventDispatchThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int n2) {
        java.awt.datatransfer.Clipboard clipboard;
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        ArrayList<java.awt.datatransfer.Clipboard> arrayList = new ArrayList<java.awt.datatransfer.Clipboard>();
        if ((n2 & 2) != 0 && (clipboard = Toolkit.getDefaultToolkit().getSystemSelection()) != null) {
            arrayList.add(clipboard);
        }
        if ((n2 & 1) != 0) {
            arrayList.add(Toolkit.getDefaultToolkit().getSystemClipboard());
        }
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            java.awt.datatransfer.Clipboard clipboard2 = (java.awt.datatransfer.Clipboard)arrayList.get(i2);
            TransferData[] transferDataArray = transfer.getSupportedTypes();
            for (int i3 = 0; i3 < transferDataArray.length; ++i3) {
                Object object;
                TransferData transferData = transferDataArray[i3];
                if (Compatibility.IS_JAVA_5_OR_GREATER) {
                    object = transferData.dataFlavor;
                    if (!clipboard2.isDataFlavorAvailable((DataFlavor)object)) continue;
                    try {
                        Transferable transferable = clipboard2.getContents(null);
                        if (transferable != null) {
                            transferData.transferable = transferable;
                            return transfer.nativeToJava(transferData);
                        }
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    object = clipboard2.getContents(null);
                    if (object == null) continue;
                    transferData.transferable = object;
                    return transfer.nativeToJava(transferData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray) {
        this.setContents(objectArray, transferArray, 1);
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray, int n2) {
        java.awt.datatransfer.Clipboard clipboard;
        Object object;
        DataFlavor[] dataFlavorArray;
        this.checkWidget();
        if (objectArray == null || transferArray == null || objectArray.length != transferArray.length || objectArray.length == 0) {
            DND.error(5);
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null && transferArray[i2] != null && transferArray[i2].validate(objectArray[i2])) continue;
            DND.error(5);
        }
        ArrayList<Transferable> arrayList = new ArrayList<Transferable>();
        ArrayList<DataFlavor> arrayList2 = new ArrayList<DataFlavor>();
        for (int i3 = 0; i3 < transferArray.length; ++i3) {
            dataFlavorArray = new TransferData();
            object = transferArray[i3];
            dataFlavorArray.dataFlavor = ((Transfer)object).getDataFlavor();
            ((Transfer)object).javaToNative(objectArray[i3], (TransferData)dataFlavorArray);
            arrayList2.add(dataFlavorArray.dataFlavor);
            arrayList.add(dataFlavorArray.transferable);
        }
        Transferable[] transferableArray = arrayList.toArray(new Transferable[0]);
        dataFlavorArray = arrayList2.toArray(new DataFlavor[0]);
        object = new Transferable(){

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                int i2 = 0;
                while (i2 < flavors.length) {
                    if (flavors[i2].equals(flavor)) {
                        try {
                            return transferables[i2].getTransferData(flavor);
                        }
                        catch (IOException iOException) {
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            // empty catch block
                        }
                    }
                    ++i2;
                }
                throw new UnsupportedFlavorException(flavor);
            }

            public DataFlavor[] getTransferDataFlavors() {
                return (DataFlavor[])flavors.clone();
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                int i2 = 0;
                while (i2 < flavors.length) {
                    if (flavors[i2].equals(flavor)) {
                        return true;
                    }
                    ++i2;
                }
                return false;
            }
        };
        ArrayList<java.awt.datatransfer.Clipboard> arrayList3 = new ArrayList<java.awt.datatransfer.Clipboard>();
        if ((n2 & 2) != 0 && (clipboard = Toolkit.getDefaultToolkit().getSystemSelection()) != null) {
            arrayList3.add(clipboard);
        }
        if ((n2 & 1) != 0) {
            arrayList3.add(Toolkit.getDefaultToolkit().getSystemClipboard());
        }
        for (int i4 = arrayList3.size() - 1; i4 >= 0; --i4) {
            java.awt.datatransfer.Clipboard clipboard2 = (java.awt.datatransfer.Clipboard)arrayList3.get(i4);
            clipboard2.setContents((Transferable)object, null);
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int n2) {
        int n3;
        java.awt.datatransfer.Clipboard clipboard;
        this.checkWidget();
        ArrayList<java.awt.datatransfer.Clipboard> arrayList = new ArrayList<java.awt.datatransfer.Clipboard>();
        if ((n2 & 2) != 0 && (clipboard = Toolkit.getDefaultToolkit().getSystemSelection()) != null) {
            arrayList.add(clipboard);
        }
        if ((n2 & 1) != 0) {
            arrayList.add(Toolkit.getDefaultToolkit().getSystemClipboard());
        }
        if ((n3 = arrayList.size() - 1) >= 0) {
            java.awt.datatransfer.Clipboard clipboard2 = (java.awt.datatransfer.Clipboard)arrayList.get(n3);
            DataFlavor[] dataFlavorArray = clipboard2.getAvailableDataFlavors();
            TransferData[] transferDataArray = new TransferData[dataFlavorArray.length];
            for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
                TransferData transferData = new TransferData();
                transferData.dataFlavor = dataFlavorArray[i2];
                transferDataArray[i2] = transferData;
            }
            return transferDataArray;
        }
        return new TransferData[0];
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        DataFlavor[] dataFlavorArray = Toolkit.getDefaultToolkit().getSystemClipboard().getAvailableDataFlavors();
        String[] stringArray = new String[dataFlavorArray.length];
        for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
            stringArray[i2] = dataFlavorArray[i2].getDefaultRepresentationClassAsString();
        }
        return stringArray;
    }
}

