/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.beeger.squareness.theme.DefaultSquarenessTheme;
import net.beeger.squareness.theme.PropertiesSquarenessTheme;
import net.beeger.squareness.theme.SquarenessTheme;
import net.beeger.squareness.util.SquarenessBorderFactory;
import net.beeger.squareness.util.SquarenessIconFactory;
import org.jvnet.lafplugin.ComponentPluginManager;

public class SquarenessLookAndFeel
extends MetalLookAndFeel {
    private static final String PLUGIN_FILE_NAME = "META-INF/squareness-plugin.xml";
    private static final ComponentPluginManager _plugins = new ComponentPluginManager("META-INF/squareness-plugin.xml");
    private static final String DESCRIPTION = "Squareness Look And Feel";
    private static final String ID = "Squareness";
    private static final String NAME = "Squareness";
    private static SquarenessTheme _currentSquarenessTheme;

    public static void setCurrentSquarenessTheme(SquarenessTheme theme) {
        _currentSquarenessTheme = theme;
        MetalLookAndFeel.setCurrentTheme(theme);
    }

    public static SquarenessTheme getCurrentSquarenessTheme() {
        if (_currentSquarenessTheme == null) {
            SquarenessLookAndFeel.loadThemePackageTheme();
        }
        if (_currentSquarenessTheme == null) {
            SquarenessLookAndFeel.setCurrentSquarenessTheme(new DefaultSquarenessTheme());
        }
        return _currentSquarenessTheme;
    }

    public static void loadThemePackageTheme() {
        InputStream themeSelectorStream = SquarenessLookAndFeel.class.getResourceAsStream("/themeselector.slfts");
        if (themeSelectorStream != null) {
            Properties themeSelector = new Properties();
            try {
                themeSelector.load(themeSelectorStream);
                String themeFileName = themeSelector.getProperty("currentTheme");
                if (themeFileName != null && themeFileName.trim().length() > 0) {
                    Properties theme = new Properties();
                    theme.load(SquarenessLookAndFeel.class.getResourceAsStream("/" + themeFileName));
                    SquarenessLookAndFeel.setCurrentSquarenessTheme(new PropertiesSquarenessTheme(theme));
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            catch (PropertiesSquarenessTheme.LoadException e3) {
                e3.printStackTrace();
            }
        }
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getID() {
        return "Squareness";
    }

    public String getName() {
        return "Squareness";
    }

    public void initialize() {
        super.initialize();
        _plugins.initializeAll();
    }

    public void uninitialize() {
        super.uninitialize();
        _plugins.uninitializeAll();
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String packageName = "net.beeger.squareness.delegate.";
        table.put("ButtonUI", packageName + "SquarenessButtonUI");
        table.put("RadioButtonUI", packageName + "SquarenessRadioButtonUI");
        table.put("CheckBoxUI", packageName + "SquarenessCheckBoxUI");
        table.put("ToolBarUI", packageName + "SquarenessToolBarUI");
        table.put("ToggleButtonUI", packageName + "SquarenessToggleButtonUI");
        table.put("ScrollBarUI", packageName + "SquarenessScrollBarUI");
        table.put("TabbedPaneUI", packageName + "SquarenessTabbedPaneUI");
        table.put("ComboBoxUI", packageName + "SquarenessComboBoxUI");
        table.put("SliderUI", packageName + "SquarenessSliderUI");
        table.put("InternalFrameUI", packageName + "SquarenessInternalFrameUI");
        table.put("SpinnerUI", packageName + "SquarenessSpinnerUI");
        table.put("RootPaneUI", packageName + "SquarenessRootPaneUI");
        table.put("ProgressBarUI", "javax.swing.plaf.basic.BasicProgressBarUI");
        table.put("SplitPaneUI", "javax.swing.plaf.basic.BasicSplitPaneUI");
    }

    protected void initComponentDefaults(UIDefaults table) {
        SquarenessLookAndFeel.setCurrentTheme(new DefaultSquarenessTheme());
        super.initComponentDefaults(table);
        table.put("scrollArrowLeft", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getLeftIcon();
            }
        });
        table.put("scrollArrowRight", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getRightIcon();
            }
        });
        table.put("scrollArrowUp", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getUpIcon();
            }
        });
        table.put("scrollArrowDown", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getDownIcon();
            }
        });
        table.put("spinUp", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getSpinUpIcon();
            }
        });
        table.put("spinDown", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getSpinDownIcon();
            }
        });
        UIDefaults.LazyValue borderWithMargin = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessBorderFactory.getControlBorderWithMargin();
            }
        };
        UIDefaults.LazyValue borderWithoutMargin = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessBorderFactory.getControlBorderWithoutMargin();
            }
        };
        UIDefaults.LazyValue progressBarBorder = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessBorderFactory.getProgressBarBorder();
            }
        };
        UIDefaults.LazyValue tableHeaderCellBorder = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessBorderFactory.getTableHeaderCellBorder();
            }
        };
        table.put("Button.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor());
        table.put("Button.border", borderWithMargin);
        table.put("ToggleButton.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor());
        table.put("ToggleButton.border", borderWithMargin);
        table.put("RadioButton.icon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getRadioButtonIcon();
            }
        });
        table.put("CheckBox.icon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getCheckBoxIcon();
            }
        });
        UIDefaults.LazyValue emptyborder = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
            }
        };
        UIDefaults.LazyValue menuItemBorder = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessBorderFactory.getMenuItemBorder();
            }
        };
        UIDefaults.LazyValue menuItemCheckIcon = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getMenuItemCheckIcon();
            }
        };
        UIDefaults.LazyValue menuItemArrowIcon = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getMenuItemArrowIcon();
            }
        };
        table.put("TextField.border", borderWithoutMargin);
        table.put("FormattedTextField.border", borderWithoutMargin);
        table.put("PasswordField.border", borderWithoutMargin);
        table.put("MenuBar.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        table.put("MenuBar.border", emptyborder);
        table.put("Menu.background", (Object)null);
        table.put("Menu.border", menuItemBorder);
        table.put("Menu.borderPainted", Boolean.TRUE);
        table.put("Menu.selectionForeground", table.get("textHighlightText"));
        table.put("Menu.selectionBackground", table.get("textHighlight"));
        table.put("Menu.arrowIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getMenuArrowIcon();
            }
        });
        table.put("Menu.checkIcon", menuItemCheckIcon);
        table.put("MenuItem.background", (Object)null);
        table.put("MenuItem.border", menuItemBorder);
        table.put("MenuItem.borderPainted", Boolean.TRUE);
        table.put("MenuItem.selectionForeground", table.get("textHighlightText"));
        table.put("MenuItem.selectionBackground", table.get("textHighlight"));
        table.put("MenuItem.checkIcon", menuItemCheckIcon);
        table.put("RadioButtonMenuItem.background", (Object)null);
        table.put("RadioButtonMenuItem.border", menuItemBorder);
        table.put("RadioButtonMenuItem.borderPainted", Boolean.TRUE);
        table.put("RadioButtonMenuItem.selectionForeground", table.get("textHighlightText"));
        table.put("RadioButtonMenuItem.selectionBackground", table.get("textHighlight"));
        table.put("RadioButtonMenuItem.checkIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getRadioButtonMenuItemCheckIcon();
            }
        });
        table.put("RadioButtonMenuItem.arrowIcon", menuItemArrowIcon);
        table.put("CheckBoxMenuItem.background", (Object)null);
        table.put("CheckBoxMenuItem.border", menuItemBorder);
        table.put("CheckBoxMenuItem.borderPainted", Boolean.TRUE);
        table.put("CheckBoxMenuItem.selectionForeground", table.get("textHighlightText"));
        table.put("CheckBoxMenuItem.selectionBackground", table.get("textHighlight"));
        table.put("CheckBoxMenuItem.checkIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getCheckBoxMenuItemCheckIcon();
            }
        });
        table.put("CheckBoxMenuItem.arrowIcon", menuItemArrowIcon);
        table.put("Separator.foreground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        table.put("Separator.background", (Object)null);
        table.put("PopupMenu.border", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessBorderFactory.getNonSpacingControlBorderWithoutMargin();
            }
        });
        UIDefaults.LazyValue frameBorder = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessBorderFactory.getInternalFrameBorder();
            }
        };
        table.put("InternalFrame.border", frameBorder);
        table.put("InternalFrame.icon", (Object)null);
        table.put("InternalFrame.maximizeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getMaximizeFrameIcon();
            }
        });
        table.put("InternalFrame.minimizeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getMinimizeFrameIcon();
            }
        });
        table.put("InternalFrame.iconifyIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getIconifyFrameIcon();
            }
        });
        table.put("InternalFrame.closeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SquarenessIconFactory.getCloseFrameIcon();
            }
        });
        table.put("RootPane.frameBorder", frameBorder);
        table.put("RootPane.plainDialogBorder", frameBorder);
        table.put("RootPane.informationDialogBorder", frameBorder);
        table.put("RootPane.errorDialogBorder", frameBorder);
        table.put("RootPane.colorChooserDialogBorder", frameBorder);
        table.put("RootPane.fileChooserDialogBorder", frameBorder);
        table.put("RootPane.questionDialogBorder", frameBorder);
        table.put("RootPane.warningDialogBorder", frameBorder);
        table.put("ScrollBar.thumb", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor());
        table.put("ScrollBar.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        table.put("ScrollBar.width", new Integer(17));
        table.put("ScrollPane.border", borderWithoutMargin);
        table.put("TableHeader.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor());
        table.put("ToolBar.border", emptyborder);
        table.put("ToolBar.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        table.put("ComboBox.border", borderWithoutMargin);
        table.put("ComboBox.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextInputBackgroundColor());
        table.put("ComboBox.selectionBackground", table.get("textHighlight"));
        table.put("ComboBox.selectionForeground", table.get("textHighlightText"));
        table.put("ProgressBar.border", progressBarBorder);
        table.put("ProgressBar.cellLength", new Integer(1));
        table.put("ProgressBar.cellSpacing", new Integer(1));
        table.put("ProgressBar.selectionForeground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("ProgressBar.selectionBackground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("ProgressBar.foreground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        table.put("ProgressBar.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        table.put("SplitPane.highlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        table.put("SplitPane.shadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        table.put("SplitPane.darkShadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        table.put("SplitPane.border", (Object)null);
        table.put("SplitPaneDivider.border", (Object)null);
        table.put("TabbedPane.selected", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        table.put("TabbedPane.shadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor().brighter().brighter());
        table.put("TabbedPane.darkShadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        table.put("TabbedPane.highlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor().brighter().brighter());
        table.put("TabbedPane.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        table.put("TabbedPane.selected", (Object)null);
        table.put("Viewport.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        table.put("Table.scrollPaneBorder", borderWithoutMargin);
        table.put("TableHeader.cellBorder", tableHeaderCellBorder);
        table.put("Panel.background", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        table.put("Panel.foreground", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("Tree.collapsedIcon", LookAndFeel.makeIcon(this.getClass(), "icons/treecollapsed.gif"));
        table.put("Tree.expandedIcon", LookAndFeel.makeIcon(this.getClass(), "icons/treeexpanded.gif"));
        table.put("Tree.openIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderopened.gif"));
        table.put("Tree.closedIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderclosed.gif"));
        table.put("Tree.leafIcon", LookAndFeel.makeIcon(this.getClass(), "icons/document.gif"));
        table.put("FileView.directoryIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderclosed.gif"));
        table.put("FileView.fileIcon", LookAndFeel.makeIcon(this.getClass(), "icons/document.gif"));
        table.put("FileView.computerIcon", LookAndFeel.makeIcon(this.getClass(), "icons/computer.gif"));
        table.put("FileView.hardDriveIcon", LookAndFeel.makeIcon(this.getClass(), "icons/hd.gif"));
        table.put("FileView.floppyDriveIcon", LookAndFeel.makeIcon(this.getClass(), "icons/floppy.gif"));
        table.put("FileChooser.detailsViewIcon", LookAndFeel.makeIcon(this.getClass(), "icons/detail.gif"));
        table.put("FileChooser.homeFolderIcon", LookAndFeel.makeIcon(this.getClass(), "icons/home.gif"));
        table.put("FileChooser.listViewIcon", LookAndFeel.makeIcon(this.getClass(), "icons/list.gif"));
        table.put("FileChooser.newFolderIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderclosed.gif"));
        table.put("FileChooser.upFolderIcon", LookAndFeel.makeIcon(this.getClass(), "icons/folderup.gif"));
        _plugins.processAllDefaultsEntries(UIManager.getDefaults(), _currentSquarenessTheme);
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        table.put("desktop", SquarenessLookAndFeel.getCurrentSquarenessTheme().getDesktopColor());
        table.put("activeCaption", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        table.put("activeCaptionText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("activeCaptionBorder", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        table.put("inactiveCaption", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        table.put("inactiveCaptionText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getDisabledBorderColor());
        table.put("inactiveCaptionBorder", SquarenessLookAndFeel.getCurrentSquarenessTheme().getInactiveWindowBorderColor());
        table.put("window", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextInputBackgroundColor());
        table.put("windowBorder", SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        table.put("windowText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("menu", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        table.put("menuText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("text", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextInputBackgroundColor());
        table.put("textText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("textHighlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        table.put("textHighlightText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("textInactiveText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("control", SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        table.put("controlText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        table.put("controlHighlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        table.put("controlLtHighlight", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        table.put("controlShadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundShadowColor());
        table.put("controlDkShadow", SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundShadowColor());
        table.put("scrollbar", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        table.put("info", SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        table.put("infoText", SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
    }
}

