/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

final class WindowsIconFactory {
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;

    private WindowsIconFactory() {
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x, int y) {
            AbstractButton b2 = (AbstractButton)c2;
            ButtonModel model = b2.getModel();
            g2.setColor(UIManager.getColor(model.isPressed() && model.isArmed() || !model.isEnabled() ? "RadioButton.background" : "RadioButton.interiorBackground"));
            g2.fillRect(x + 2, y + 2, 8, 8);
            g2.setColor(UIManager.getColor("RadioButton.shadow"));
            g2.drawLine(x + 4, y + 0, x + 7, y + 0);
            g2.drawLine(x + 2, y + 1, x + 3, y + 1);
            g2.drawLine(x + 8, y + 1, x + 9, y + 1);
            g2.drawLine(x + 1, y + 2, x + 1, y + 3);
            g2.drawLine(x + 0, y + 4, x + 0, y + 7);
            g2.drawLine(x + 1, y + 8, x + 1, y + 9);
            g2.setColor(UIManager.getColor("RadioButton.highlight"));
            g2.drawLine(x + 2, y + 10, x + 3, y + 10);
            g2.drawLine(x + 4, y + 11, x + 7, y + 11);
            g2.drawLine(x + 8, y + 10, x + 9, y + 10);
            g2.drawLine(x + 10, y + 9, x + 10, y + 8);
            g2.drawLine(x + 11, y + 7, x + 11, y + 4);
            g2.drawLine(x + 10, y + 3, x + 10, y + 2);
            g2.setColor(UIManager.getColor("RadioButton.darkShadow"));
            g2.drawLine(x + 4, y + 1, x + 7, y + 1);
            g2.drawLine(x + 2, y + 2, x + 3, y + 2);
            g2.drawLine(x + 8, y + 2, x + 9, y + 2);
            g2.drawLine(x + 2, y + 3, x + 2, y + 3);
            g2.drawLine(x + 1, y + 4, x + 1, y + 7);
            g2.drawLine(x + 2, y + 8, x + 2, y + 8);
            g2.setColor(UIManager.getColor("RadioButton.light"));
            g2.drawLine(x + 2, y + 9, x + 3, y + 9);
            g2.drawLine(x + 4, y + 10, x + 7, y + 10);
            g2.drawLine(x + 8, y + 9, x + 9, y + 9);
            g2.drawLine(x + 9, y + 8, x + 9, y + 8);
            g2.drawLine(x + 10, y + 7, x + 10, y + 4);
            g2.drawLine(x + 9, y + 3, x + 9, y + 3);
            if (model.isSelected()) {
                g2.setColor(UIManager.getColor("RadioButton.checkColor"));
                g2.fillRect(x + 4, y + 5, 4, 2);
                g2.fillRect(x + 5, y + 4, 2, 4);
            }
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        private static final int SIZE = 13;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x, int y) {
            JCheckBox cb = (JCheckBox)c2;
            ButtonModel model = cb.getModel();
            if (!cb.isBorderPaintedFlat()) {
                g2.setColor(UIManager.getColor("CheckBox.shadow"));
                g2.drawLine(x, y, x + 11, y);
                g2.drawLine(x, y + 1, x, y + 11);
                g2.setColor(UIManager.getColor("CheckBox.highlight"));
                g2.drawLine(x + 12, y, x + 12, y + 12);
                g2.drawLine(x, y + 12, x + 11, y + 12);
                g2.setColor(UIManager.getColor("CheckBox.darkShadow"));
                g2.drawLine(x + 1, y + 1, x + 10, y + 1);
                g2.drawLine(x + 1, y + 2, x + 1, y + 10);
                g2.setColor(UIManager.getColor("CheckBox.light"));
                g2.drawLine(x + 1, y + 11, x + 11, y + 11);
                g2.drawLine(x + 11, y + 1, x + 11, y + 10);
            } else {
                g2.setColor(UIManager.getColor("CheckBox.shadow"));
                g2.drawRect(x + 1, y + 1, 10, 10);
            }
            g2.setColor(UIManager.getColor(model.isPressed() && model.isArmed() || !model.isEnabled() ? "CheckBox.background" : "CheckBox.interiorBackground"));
            g2.fillRect(x + 2, y + 2, 9, 9);
            g2.setColor(UIManager.getColor(model.isEnabled() ? "CheckBox.checkColor" : "CheckBox.shadow"));
            if (model.isSelected()) {
                g2.drawLine(x + 9, y + 3, x + 9, y + 3);
                g2.drawLine(x + 8, y + 4, x + 9, y + 4);
                g2.drawLine(x + 7, y + 5, x + 9, y + 5);
                g2.drawLine(x + 6, y + 6, x + 8, y + 6);
                g2.drawLine(x + 3, y + 7, x + 7, y + 7);
                g2.drawLine(x + 4, y + 8, x + 6, y + 8);
                g2.drawLine(x + 5, y + 9, x + 5, y + 9);
                g2.drawLine(x + 3, y + 5, x + 3, y + 5);
                g2.drawLine(x + 3, y + 6, x + 4, y + 6);
            }
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }
}

