//
// $Header: d:\\32bits\\ext2-os2\\misc\\rcs\\ext2_lw.c,v 1.2 1997/03/16 12:38:49 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>
#include <stdio.h>
#include  <stdlib.h>

#include <os2/vfsapi.h>

void shrink_cache_thread(void *parm) {
    ULONG  parmio;
    ULONG  dataio;
    APIRET rc;

    if ((rc = DosSetPriority(PRTYS_THREAD, PRTYC_IDLETIME, -30, 0)) == NO_ERROR) {
        while(1) {
            parmio = 0;
            dataio = 0;
            /*
             * cache shrink captive thread - We should normally never return from DosFsCtl.
             */
            if ((rc = DosFSCtl (
                                NULL,  0, &dataio,
                                NULL,  0, &parmio,
                                EXT2_OS2_SHRINK_CACHE,  "ext2",
                                -1,  FSCTL_FSDNAME)) != NO_ERROR) {
                fprintf(stderr, "DosFSCtl failed with rc = %d\n", rc);
                DosSleep(1000); // To avoid CPU hog in case of error
            }
        }
    } else {
        fprintf(stderr, "DosSetPriority failed with rc = %d\n", rc);
    }

}

void bdflush_thread(void *parm) {
    APIRET rc;
    ULONG  parmio;
    ULONG  dataio;
    
    if ((rc = DosSetPriority(PRTYS_THREAD, PRTYC_FOREGROUNDSERVER, 0, 0)) == NO_ERROR) {
        while(1) {
            parmio = 0;
            dataio = 0;
            /*
             * bdflush captive thread - We should normally never return from DosFsCtl.
             */
            if ((rc = DosFSCtl (
                                NULL,  0, &dataio,
                                NULL,  0, &parmio,
                                EXT2_OS2_BDFLUSH,  "ext2",
                                -1,  FSCTL_FSDNAME)) != NO_ERROR) {
                fprintf(stderr, "DosFSCtl failed with rc = %d\n", rc);
                DosSleep(1000); // To avoid CPU hog in case of error
            }
        }
    } else {
        fprintf(stderr, "DosSetPriority failed with rc = %d\n", rc);
    }
}

int main(int argc, char **argv) {
    APIRET rc;
    HEV    hev;

    if ((rc = DosCreateEventSem(0, &hev, 0, 0)) == NO_ERROR) {
        if (_beginthread(shrink_cache_thread, 0, 16384, 0) != -1) {
            if (_beginthread(bdflush_thread, 0, 16384, 0) != -1) {
                DosWaitEventSem(hev, SEM_INDEFINITE_WAIT);
                DosCloseEventSem(hev); // We should NEVER reach this line
            } else {
                fprintf(stderr, "Couldn't start bdflush thread");
            }
        } else {
            fprintf(stderr, "Couldn't start shrink cache thread");
        }
    } else {
        fprintf(stderr, "Couldn't create event semaphore");
    }
}
