//
// $Header: d:\\32bits\\ext2-os2\\minifsd\\rcs\\mfs.c,v 9.1 1997/03/15 22:31:04 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSERRORS
#define INCL_DOSDEVIOCTL
#define INCL_NOPMAPI
#include <os2.h>
#include <fsh.h>

#include <string.h>

#include <os2/types.h>
#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <os2/os2proto.h>
#include <os2/minifsd.h>
#include <os2/volume.h>

BIOSPARAMETERBLOCK far *bootbpb;

extern struct super_block  stage1_superblk;

extern long nr_files;
extern long nr_free_files;
extern long nr_used_files;
extern struct file *free_files;
extern struct file *used_files;
extern void (*file_remove_from_list)(struct file *, struct file **, long *);

extern long nr_supers;
extern long nr_free_supers;
extern long nr_used_supers;
extern struct super_block *free_supers;
extern struct super_block *used_supers;
extern void (*supers_remove_from_list)(struct super_block *, struct super_block **, long *);

extern struct inode * first_inode;
extern long nr_inodes;
extern long nr_free_inodes;

struct inode_hash_entry {
        struct inode * inode;
        int updating;
};
extern struct inode_hash_entry hash_table[];

/*
 * data structure to be passed to the FSD
 */
struct minifsd_to_fsd_data  mfs_data = {
    /*
     * magic number for sanity checks
     */
    MINIFSD_DATA_MAGIC,

    /*
     * file section
     */
    &used_files,
    &free_files,
    &nr_files,
    &nr_free_files,
    &nr_used_files,
    0,

    /*
     * inode section
     */
    &first_inode,
    &nr_inodes,
    &nr_free_inodes,
    hash_table,
    0,                             // obsolete field

    /*
     * superblock section
     */
    &used_supers,
    &free_supers,
    &nr_supers,
    &nr_free_supers,
    &nr_used_supers,
    0,

};

int far pascal _loadds MFS_CHGFILEPTR(
    unsigned long  offset,              /* offset       */
    unsigned short type                 /* type         */
) {

//    printk("**** MFS_CHGFILEPTR(ofs=%ld type=%d)", offset, type);

    if (!used_files)
        ext2_os2_panic(0, "MFS_CHGFILEPTR : used_files = 0");
    if (used_files->f_magic != FILE_MAGIC)
        ext2_os2_panic(0, "MFS_CHGFILEPTR : invalid magic number");

    switch(type) {
        case 0 :
            used_files->f_pos = offset;
            break;

        case 1 :
            used_files->f_pos = used_files->f_pos + offset;
            break;

        case 2 :
            used_files->f_pos = used_files->f_inode->i_size + offset;
            break;

        default :
            ext2_os2_panic(0, "MFS_CHFILEPTR : unknown type %d", type);
    }

    return NO_ERROR;
}

int far pascal _loadds MFS_CLOSE(void) {

    printk("**** MFS_CLOSE");

    if (!used_files)
        ext2_os2_panic(0, "MFS_CLOSE : flist = 0");
    if (used_files->f_magic != FILE_MAGIC)
        ext2_os2_panic(0, "MFS_CLOSE : invalid magic number");

    vfs_close(used_files);


    return NO_ERROR;
}

struct bootdata {
    magic_t bootdata_magic;
    USHORT  bootdrive;
};

int far pascal _loadds MFS_INIT(
    void far *bootdata,                 /* bootdata     */
    char far *number,                   /* number io    */
    long far *vectorripl,               /* vectorripl   */
    void far *bpb,                      /* bpb          */
    unsigned long far *pMiniFSD,        /* pMiniFSD     */
    unsigned long far *dump             /* dump address */
) {
#if 0
    struct bootdata *boot;
#endif
    printk("**** MFS_INIT");

    printk("\tstruct inode            : %d", sizeof(struct inode));
    printk("\tstruct super_block      : %d", sizeof(struct super_block));
    printk("\tstruct file             : %d", sizeof(struct file));
    printk("\tstruct ext2_inode       : %d", sizeof(struct ext2_inode));
    printk("\tstruct ext2_super_block : %d", sizeof(struct ext2_super_block));
    printk("\tstruct minifsd_data     : %d", sizeof(struct minifsd_to_fsd_data));
    printk("\tstruct ext2_sb_info     : %d", sizeof(struct ext2_sb_info));


    bootbpb     = (BIOSPARAMETERBLOCK far *)bpb;
#if 0
    boot = (struct bootdata *)bootdata;

    if (!boot)
        ext2_os2_panic(0, "MFS_INIT - can't retrieve  boot data from micro FSD");
    if (boot->bootdata_magic != BOOTDATA_MAGIC)
        ext2_os2_panic(0, "MFS_INIT - boot data with invalid magic number (%0X)", boot->bootdata_magic);

    MFSH_SETBOOTDRIVE(boot->bootdrive);
#else
//    if (bootbpb->usReservedSectors != BOOTDATA_MAGIC)
//        ext2_os2_panic(0, "MFS_INIT - boot data with invalid magic number (%0X)", bootbpb->usReservedSectors);
    if (bootbpb->abReserved[1] != BOOTDATA_MAGIC_LO)
        ext2_os2_panic(0, "MFS_INIT - boot data with invalid magic number (%0X)", bootbpb->abReserved[1]);
    if (bootbpb->abReserved[2] != BOOTDATA_MAGIC_HI)
        ext2_os2_panic(0, "MFS_INIT - boot data with invalid magic number (%0X)", bootbpb->abReserved[2]);

//    MFSH_SETBOOTDRIVE(bootbpb->usSectorsPerFAT);
//    bootbpb->usSectorsPerFAT   = 0;
//    bootbpb->usReservedSectors = 0;
    MFSH_SETBOOTDRIVE(bootbpb->abReserved[0]);

#endif
    *number     = 0;                            // N/A here : local FSD
    *vectorripl = 0;                            // no ripl data
    *dump       = 0;                            // no alternate dump routine
    *pMiniFSD   = (unsigned long)((void far *)(&mfs_data));     // data to pass to normal FSD

    stage1_superblk.sector_size       = (UINT32)bootbpb->usBytesPerSector;
    stage1_superblk.nb_sectors        = (UINT32)bootbpb->cLargeSectors;
    stage1_superblk.s_blocksize       = BLOCK_SIZE;
    stage1_superblk.sectors_per_block = BLOCK_SIZE / stage1_superblk.sector_size;
    stage1_superblk.s_dev             = 0;
//    stage1_superblk.s_op              = &ext2_sops;
    stage1_superblk.s_flags           = MS_RDONLY;          // MINIFSD is ALWAYS readonly


    inode_init();
    buffer_init();

    stage1_ext2_read_super();

    mfs_data.file_remove_from_list = file_remove_from_list;
    mfs_data.super_remove_from_list = supers_remove_from_list;

    return NO_ERROR;
}

int far pascal _loadds MFS_OPEN(
    char far *name,                     /* name         */
    unsigned long far *size             /* size         */
) {
    int  rc;
    char LocalName[CCHMAXPATH];

    struct file *f;

    if ((*name != '/') && (*name != '\\'))
        strcpy(LocalName, "C:\\");
    else
        strcpy(LocalName, "C:");

    strcat(LocalName, name);

    printk("**** MFS_OPEN(%s) pre-invocation", LocalName);

    f     = _open_by_name(&stage1_superblk, LocalName, 0);
    if (f) {
        *size = f->f_inode->i_size;
        rc = NO_ERROR;
    } else {
        *size = 0;
        rc = ERROR_FILE_NOT_FOUND;
    }

    printk("     MFS_OPEN(%s) post invocation - rc = %d", LocalName, rc);
    return rc;
}

int far pascal _loadds MFS_READ(
    char far *data,             /* data         */
    unsigned short far *length  /* length       */
) {
    unsigned long len;
    int rc;

    printk("**** MFS_READ pre-invocation - buf = %04X:%04X len = %u", (__segment)data, OFFSETOF(data), *length);

    if (!used_files)
        ext2_os2_panic(0, "MFS_READ : flist = 0");
    if (used_files->f_magic != FILE_MAGIC)
        ext2_os2_panic(0, "MFS_READ : invalid magic number");

    len = (unsigned long)*length;
    rc = VFS_read(used_files, data, (loff_t)len, &len); /* failure in VFS_read = panic */
    *length = (unsigned short)len;


    printk("     MFS_READ post-invocation- rc = %d", rc);

    return rc;
}

int far pascal _loadds MFS_TERM(void) {

    printk("**** MFS_TERM");

    return NO_ERROR;
}
