//
// $Header: d:\\32bits\\ext2-os2\\minifsd\\ext2\\rcs\\file.c,v 9.1 1997/03/15 22:33:48 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



/*
 *  linux/fs/ext2/file.c
 *
 *  Copyright (C) 1992, 1993, 1994  Remy Card (card@masi.ibp.fr)
 *                                  Laboratoire MASI - Institut Blaise Pascal
 *                                  Universite Pierre et Marie Curie (Paris VI)
 *
 *  from
 *
 *  linux/fs/minix/file.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 *  ext2 fs regular file handling primitives
 */

#ifdef OS2
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                    // From the "Developer Connection Device Driver Kit" version 2.0

#include <fsh.h>                    // From the IFS toolkit

#include <string.h>
#endif

#ifndef OS2
#include <asm/segment.h>
#include <asm/system.h>

#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/ext2_fs.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/stat.h>
#include <linux/locks.h>
#else
#include <os2/types.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/ext2_fs.h>
#include <linux/e2_proto.h>
#include <linux/fs_proto.h>
#include <os2/os2proto.h>
#include <linux/sched.h>
#include <linux/locks.h>
#include <linux/stat.h>
#include <linux/fcntl.h>
#include <os2/log.h>
#endif

#define        NBUF        2

#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))

#ifndef OS2
#include <linux/fs.h>
#include <linux/ext2_fs.h>
#else
#include <linux/fs.h>
#include <linux/ext2_fs.h>
#endif

#ifndef OS2
static int ext2_file_read (struct inode *, struct file *, char *, int);
static int ext2_file_write (struct inode *, struct file *, char *, int);
static void ext2_release_file (struct inode *, struct file *);
#else
static long ext2_file_read (struct inode *inode, struct file * filp,
                    char *buf, long count);
static long ext2_file_write (struct inode * inode, struct file * filp,
                            char * buf, long count);
static void ext2_release_file (struct inode * inode, struct file * filp);
#endif



#ifndef OS2
/*
 * We have mostly NULL's here: the current defaults are ok for
 * the ext2 filesystem.
 */
static struct file_operations ext2_file_operations = {
        NULL,                        /* lseek - default */
        ext2_file_read,                /* read */
        ext2_file_write,        /* write */
        NULL,                        /* readdir - bad */
        NULL,                        /* select - default */
        ext2_ioctl,                /* ioctl */
        generic_mmap,                  /* mmap */
        NULL,                        /* no special open is needed */
        ext2_release_file,        /* release */
        ext2_sync_file,                /* fsync */
        NULL,                        /* fasync */
        NULL,                        /* check_media_change */
        NULL                        /* revalidate */
};

struct inode_operations ext2_file_inode_operations = {
        &ext2_file_operations,/* default file operations */
        NULL,                        /* create */
        NULL,                        /* lookup */
        NULL,                        /* link */
        NULL,                        /* unlink */
        NULL,                        /* symlink */
        NULL,                        /* mkdir */
        NULL,                        /* rmdir */
        NULL,                        /* mknod */
        NULL,                        /* rename */
        NULL,                        /* readlink */
        NULL,                        /* follow_link */
        ext2_bmap,                /* bmap */
        ext2_truncate,                /* truncate */
        ext2_permission,        /* permission */
        NULL                        /* smap */
};
#else
static struct file_operations ext2_file_operations = {
        NULL,                        /* lseek - default */
        ext2_file_read,              /* read */
        NULL,                        /* write */
        NULL,                        /* readdir - bad */
        NULL,                        /* select - default */
        NULL,                        /* ioctl */
        NULL,                        /* mmap */
        NULL,                        /* no special open is needed */
        NULL,                        /* release */
        NULL,                        /* fsync */
        NULL,                        /* fasync */
        NULL,                        /* check_media_change */
        NULL                         /* revalidate */
};
struct inode_operations ext2_file_inode_operations = {
        &ext2_file_operations,/* default file operations */
        NULL,                        /* create */
        NULL,                        /* lookup */
        NULL,                        /* link */
        NULL,                        /* unlink */
        NULL,                        /* symlink */
        NULL,                        /* mkdir */
        NULL,                        /* rmdir */
        NULL,                        /* mknod */
        NULL,                        /* rename */
        NULL,                        /* readlink */
        NULL,                        /* follow_link */
        NULL,                        /* bmap */
        NULL,                        /* truncate */
        NULL,                        /* permission */
        NULL                         /* smap */
};
#endif


unsigned long event;

#ifdef OS2
static long ext2_file_read (struct inode *inode, struct file * filp,
                    char *buf, long count)
{
        long read, left, chars;
        long block, blocks, offset;
        int bhrequest, uptodate;
        long clusterblocks;
        struct buffer_head **bhb, **bhe;
        struct buffer_head * bhreq[NBUF];
        struct buffer_head * buflist[NBUF];
        struct super_block *sb;
        long size;
        int err;
#else
static int ext2_file_read (struct inode * inode, struct file * filp,
                    char * buf, int count)
{
        int read, left, chars;
        int block, blocks, offset;
        int bhrequest, uptodate;
        int clusterblocks;
        struct buffer_head ** bhb, ** bhe;
        struct buffer_head * bhreq[NBUF];
        struct buffer_head * buflist[NBUF];
        struct super_block * sb;
        unsigned int size;
        int err;
#endif

        if (!inode) {
                printk ("ext2_file_read: inode = NULL\n");
                return -EINVAL;
        }
        sb = inode->i_sb;
#ifdef OS2

        if (!S_ISREG(inode->i_mode) &&
            !S_ISDIR(inode->i_mode)) {            // Le temps de porter ext2_readdir .....
#else
        if (!S_ISREG(inode->i_mode)) {
#endif
                ext2_warning (sb, "ext2_file_read", "mode = %07o",
                              inode->i_mode);
                return -EINVAL;
        }

        offset = filp->f_pos;
        size = inode->i_size;
        if (offset > size)
                left = 0;
        else
                left = size - offset;
        if (left > count)
                left = count;
        if (left <= 0)
                return 0;
        read = 0;
        block = offset >> EXT2_BLOCK_SIZE_BITS(sb);
        offset &= (sb->s_blocksize - 1);
        size = (size + sb->s_blocksize - 1) >> EXT2_BLOCK_SIZE_BITS(sb);
        blocks = (left + offset + sb->s_blocksize - 1) >> EXT2_BLOCK_SIZE_BITS(sb);
        bhb = bhe = buflist;
        if (filp->f_reada) {
#ifndef OS2
                if (blocks < read_ahead[MAJOR(inode->i_dev)] >> (EXT2_BLOCK_SIZE_BITS(sb) - 9))
                    blocks = read_ahead[MAJOR(inode->i_dev)] >> (EXT2_BLOCK_SIZE_BITS(sb) - 9);
#else
                if (blocks < read_ahead[0] >> (EXT2_BLOCK_SIZE_BITS(sb) - 9))
                    blocks = read_ahead[0] >> (EXT2_BLOCK_SIZE_BITS(sb) - 9);
#endif
                if (block + blocks > size)
                        blocks = size - block;
        }

        /*
         * We do this in a two stage process.  We first try and request
         * as many blocks as we can, then we wait for the first one to
         * complete, and then we try and wrap up as many as are actually
         * done.  This routine is rather generic, in that it can be used
         * in a filesystem by substituting the appropriate function in
         * for getblk
         *
         * This routine is optimized to make maximum use of the various
         * buffers and caches.
         */

        clusterblocks = 0;

        do {
                bhrequest = 0;
                uptodate = 1;
                while (blocks) {

                        --blocks;
#ifndef OS2
#if 1
                        if(!clusterblocks) clusterblocks = ext2_getcluster(inode, block);
                        if(clusterblocks) clusterblocks--;
#endif
#endif
                        *bhb = ext2_getblk (inode, block++, 0, &err);
                        if (*bhb && !(*bhb)->b_uptodate) {
                                uptodate = 0;
                                bhreq[bhrequest++] = *bhb;
                        }

                        if (++bhb == &buflist[NBUF])
                                bhb = buflist;

                        /*
                         * If the block we have on hand is uptodate, go ahead
                         * and complete processing
                         */
                        if (uptodate)
                                break;

                        if (bhb == bhe)
                                break;
                }

                /*
                 * Now request them all
                 */
                if (bhrequest)
                        ll_rw_block (READ, bhrequest, bhreq);

                do {
                        /*
                         * Finish off all I/O that has actually completed
                         */
                        if (*bhe) {
                                wait_on_buffer (*bhe);
                                if (!(*bhe)->b_uptodate) { /* read error? */
                                        bforget(*bhe);
                                        if (++bhe == &buflist[NBUF])
                                          bhe = buflist;
                                        left = 0;
                                        break;
                                }
                        }
#ifdef OS2
                        if (left < (off_t)(sb->s_blocksize) - offset)
#else
                        if (left < sb->s_blocksize - offset)
#endif
                                chars = left;
                        else
                                chars = sb->s_blocksize - offset;
                        filp->f_pos += chars;
                        left -= chars;
                        read += chars;
                        if (*bhe) {
#ifndef OS2
                                memcpy_tofs (buf, offset + (*bhe)->b_data,
                                             chars);
#else
                                memcpy(buf, offset + (*bhe)->b_data,
                                             chars);
#endif
                                bforget (*bhe);
                                buf += chars;
                        } else {
#ifndef OS2
                                while (chars-- > 0)
                                        put_fs_byte (0, buf++);
#else
                                memset(buf, 0, chars);
                                buf += chars;
#endif
                        }
                        offset = 0;
                        if (++bhe == &buflist[NBUF])
                                bhe = buflist;

                } while (left > 0 && bhe != bhb && (!*bhe || !(*bhe)->b_lock));
        } while (left > 0);

        /*
         * Release the read-ahead blocks
         */
        while (bhe != bhb) {
                bforget (*bhe);
                if (++bhe == &buflist[NBUF])
                        bhe = buflist;
        }
        if (!read)
                return -EIO;
        filp->f_reada = 1;
        if (!IS_RDONLY(inode)) {
                inode->i_atime = CURRENT_TIME;
                inode->i_dirt = 1;
        }
        return read;
}

