; The following is the MYCNF.E used to build the .ex files for the OS/2 2.0
; Enhanced Editor.  It is included in EMACROS.FLS as an example; please do
; *not* use it as a base MYCNF.E.  The MYCNF.E should only include changes
; from the STDCNF.E defaults; defining *everything* just makes it more
; difficult to debug problems.  The defaults are shown in parentheses.
; For possible values for each setting, see the documentation or STDCNF.E.

const
   HOST_SUPPORT = 'EMUL'       -- ('STD') Use E3EMUL.  Following are for it:
     USING = 'IBM'               -- ('CM') Send/Receive protocol    Needed for MVS
     MVS = 1                     -- (0) Include MVS support
     HOST_LT_REQUIRED = 1        -- (0) H: refers to PC; HA: refers to host.
     C_KEYWORD_HIGHLIGHTING = 1
     E_KEYWORD_HIGHLIGHTING = 1
     REXX_KEYWORD_HIGHLIGHTING = 1
     TEX_KEYWORD_HIGHLIGHTING = 1
     PAS_KEYWORD_HIGHLIGHTING = 1
     HOLD_INDENT_IN_STREAM_MODE = 1 --- (1) Stay at indent level after enter
                                    ---     in stream mode
     WANT_EMACS_SEMICOLON = 0       --- Semicolon also changes lines in C or Pascal modes
     WANT_PASCAL_IS_NOT_C = 1       --- Disable C-like stuff (like ';') for Pascal
compile if EVERSION < '6.00c'
   LINK_HOST_SUPPORT = 1       -- (0) Must link in host support; no room in base.
compile endif
-- C/C++ Files
   C_SYNTAX_ASSIST = 1
   C_EXTENSIONS = 'C SQC RC'                 --- moved 'H' to CPP (to get correct handling of 
   CPP_EXTENSIONS = 'CPP CC M H HPP CXX HXX' --- class definitions, added 'RC' to C and 'M', 'CC' to CPP
-- Rexx/E Files
   REXX_SYNTAX_ASSIST = 1      -- (0) Include Rexx syntax assist
   E_SYNTAX_ASSIST = 1         -- (1) The product doesn't need E syntax assist!
-- Pascal Files
   WANT_END_COMMENTED = 1
   WANT_PROC_BEGIN_COMMENTED = 0
-- Java Files
   JAVA_SYNTAX_ASSIST = 1
   JAVA_KEYWORD_HIGHLIGHTING = 1
   JAVA_SYNTAX_INDENT = 1
compile if EVERSION < '6.00c'
   WANT_STACK_CMDS = 'SWITCH'  -- (0) Include this; nice to have
compile else
   WANT_STACK_CMDS = 1          -- (0) Leave on all the time; can't toggle w/ new menus
compile endif
   WANT_ET_COMMAND = 0         -- (1) The product doesn't get ETPM.
   WANT_ALL = 1                -- (0) Include this; nice to have
   WANT_SEARCH_PATH = 1        -- (0) Include this; nice to have
   WANT_LAN_SUPPORT = 1        -- (0) Include this; nice to have
compile if EVERSION < '6.00c'  -- (Slows down startup)
   CHECK_FOR_LEXAM = 1         -- (0) Give them spell checking if they already have LEXAM.DLL
compile endif

   my_DEFAULT_EDIT_OPTIONS = '/t'  -- ('') Default should be to keep (not expand) tabs
   my_DEFAULT_SEARCH_OPTIONS = 'C' -- Ignore Case!!!
   SETSTAY = '?'               -- (0) Enable the STAY comamnd
   WANT_STREAM_MODE = 'SWITCH' -- (0) Enable switching stream mode on and off
compile if EVERSION < 6    -- Don't bother with this for the beta version.
   my_STREAM_MODE = 1          -- (0) Default is to start with it on
compile endif
   WANT_CUA_MARKING = 'SWITCH' -- (0) Enable switching between CUA and advanced marking
compile if EVERSION < 6    -- Don't bother with this for the beta version.
   my_CUA_marking_switch = 1   -- (0) Default is to start with it on
   RING_OPTIONAL = 0           -- (0) Enables Ring on / Ring off code
   my_RING_ENABLED = 1         -- (1) Make it stupid for CUA
   NO_ESCAPE = 1               -- (0) CUA says Escape key can't go to command dialog.
compile endif
   SUPPORT_BOOK_ICON = 0       -- (1) No "Book icon" on Options
   ENHANCED_ENTER_KEYS = 1     -- (0) Let users configure each enter key separately
   ENHANCED_PRINT_SUPPORT = 1  -- (0) Support list of printers
compile if EVERSION < '6.00c'  -- Slows down startup; must add back for DBCS countries
   WANT_DBCS_SUPPORT = 1       -- (0) Include support for DBCS
compile endif
compile if EVERSION < '6.00c'
   EXTRA_EX = 1                -- (0) To make room in EPM.EX for everything we need
   WANT_EPM_SHELL = 'HIDDEN'   -- (0) Include the function, but not initially visible.
compile else
   WANT_EPM_SHELL = 1          -- (0) Include the shell support.
compile endif
   WANT_BRACKET_MATCHING = 1   -- (0) Include bracket matching code.
   WANT_KEYWORD_HELP = 1       -- (0) Include keyword lookup code.
   WANT_LONGNAMES = 'SWITCH'   -- (0) Enable switching on longname support
   WANT_PROFILE = 'SWITCH'     -- (0) Enable switching on Rexx profile support
compile if defined(NO_ESCAPE)
   TOGGLE_ESCAPE = 1           -- (0) Enable toggling Esc to activate command dialog.
compile endif
   TOGGLE_TAB = 1              -- (0) Enable toggling Tab key to insert a tab character.
   SYNTAX_INDENT = 4           -- (3) Automatic indent after '{' etc.
   C_TABS       = 4            -- (3) Without ETPM, users can't customize, so don't set.
   C_MARGINS    = 1            -- (1 254 1)  "
   REXX_TABS    = 0            -- (3)        "
   REXX_MARGINS = 0            -- (1 254 1)  "
   P_TABS       = 2            -- (3)        "
   P_MARGINS    = 0            -- (1 254 1)  "
   P_SYNTAX_INDENT = 2         -- (SYNTAX_INDENT)
   BLOCK_ACTIONBAR_ACCELERATORS= 1  -- (1) Switch CUA menu support on/off
   my_CUA_MENU_ACCEL = 1       -- (0) Don't block CUA accelerators for action bar selections.
   WANT_NODISMISS_MENUS = 1    -- (1) Don't make Pref. & Frame Ctrls menus NODISMISS
compile if EVERSION < '5.60'
   WANT_TRUNCATED_WARNING = 1  -- (0) Give a pop-up for "Lines truncated" warning
compile endif
   DYNAMIC_CURSOR_STYLE = 1    -- (0) Allow selecting cursor style at run time
   EPM_POINTER = 'SWITCH'      -- (2) Allow selecting mouse pointer style at run time
compile if EVERSION >= 6
;; STD_MENU_NAME = 'ovshmenu.e' -- (undef) Use WOVSH menu style
;; STD_MENU_NAME = 'fevshmnu.e' -- (undef) Use WFEVSH menu style
   STD_MENU_NAME = 'mymenu.e' -- (undef) Use WFEVSH menu style
   my_STACK_CMDS = 1           -- (0) Initialize to stack cmds visible
   WANT_TAGS = 1               -- (0) Include support for 'tags' file
   INITIAL_TOOLBAR = 0         -- (Undef) Start out off, so window appears more quickly
compile endif

define
   DRAGCOLOR = ''              -- (YELLOW + MAGENTAB) This will use .markcolor for the .dragcolor.

compile if defined(BLACK)
define
   HIGHLIGHT_COLOR = Yellow + Magentab  -- ('') Default is no highlight after Locate
   MARKCOLOR                = White + BlackB  -- (BLUE + GREYB)
compile endif


--- TeX-Stuff!!!

--- ********* CUSTEPM *******************
compile if not defined(WANT_AUTOMATIC_LATEX_MENU)
 WANT_AUTOMATIC_LATEX_MENU = 1
compile endif
