/* mktime3.c */

/* 7.12.3 "The implementation shall behave as if no other library
   functions call these functions." */

#include <time.h>
#include <assert.h>
#include <string.h>

int main (void)
{
  static struct tm tm1, tm2;
  struct tm *ptm2;
  time_t t1, t2;
  size_t n2;
  char *p;
  char temp[100];
  char safe[25+1];

  tm1.tm_sec = 17; tm1.tm_min = 42; tm1.tm_hour = 11;
  tm1.tm_mday = 10; tm1.tm_mon = 4; tm1.tm_year = 85;
  tm1.tm_isdst = -1;

  tm2.tm_sec = 23; tm2.tm_min = 24; tm2.tm_hour = 21;
  tm2.tm_mday = 4; tm2.tm_mon = 10; tm2.tm_year = 95;
  tm2.tm_isdst = -1;

  p = asctime (&tm1);
  assert (p != NULL);
  assert (strlen (p) < sizeof (safe));
  strcpy (safe, p);
  t2 = mktime (&tm2);
  assert (t2 != (time_t)-1);
  assert (strcmp (p, safe) == 0);
  n2 = strftime (temp, sizeof (temp), "%c", &tm2);
  assert (n2 > 0);
  assert (strcmp (p, safe) == 0);

  ptm2 = gmtime (&t2);
  assert (ptm2 != NULL);
  tm2 = *ptm2;
  t1 = mktime (&tm1);
  assert (t1 != (time_t)-1);
  assert (memcmp (&tm2, ptm2, sizeof (tm2)) == 0);

  p = ctime (&t1);
  assert (p != NULL);
  assert (memcmp (&tm2, ptm2, sizeof (tm2)) == 0);

  return 0;
}
