/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.inch.ComponentPanel;
import emsl.system.UndoAction;
import emsl.system.UndoClient;
import emsl.system.UndoGroup;
import emsl.system.UndoManager;
import emsl.text.AttributeList;
import emsl.text.TextData;
import emsl.text.TextPanel;

public class TextUndo
implements UndoClient {
    private TextPanel textPanel;
    private UndoManager undoManager;

    public TextUndo(TextPanel textPanel) {
        this.textPanel = textPanel;
        this.undoManager = new UndoManager("TextPanelUndoManager");
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void undo(UndoAction undoAction) {
        String string = undoAction.getUndoName();
        if (this.textPanel.getTextSelector().isSelected()) {
            this.textPanel.getTextSelector().selectionOff();
            this.textPanel.repaint();
        }
        if (string.equals("Insert Text")) {
            this.undoInsert(undoAction);
        }
        if (string.equals("Delete Text")) {
            this.undoDelete(undoAction);
        }
        if (string.equals("Style Change")) {
            this.undoStyle(undoAction);
        }
        if (string.equals("Owner Change")) {
            this.undoOwner(undoAction);
        }
    }

    public void redo(UndoAction undoAction) {
        String string = undoAction.getUndoName();
        if (this.textPanel.getTextSelector().isSelected()) {
            this.textPanel.getTextSelector().selectionOff();
            this.textPanel.repaint();
        }
        if (string.equals("Insert Text")) {
            this.redoInsert(undoAction);
        }
        if (string.equals("Delete Text")) {
            this.redoDelete(undoAction);
        }
        if (string.equals("Style Change")) {
            this.redoStyle(undoAction);
        }
        if (string.equals("Owner Change")) {
            this.redoOwner(undoAction);
        }
    }

    public UndoGroup getUndoGroup(String string) {
        UndoGroup undoGroup = new UndoGroup(this, string);
        return undoGroup;
    }

    public void setUndoGroup(UndoGroup undoGroup) {
        if (!undoGroup.isEmpty()) {
            this.undoManager.setUndo(undoGroup);
        }
    }

    public void setUndoInsert(UndoGroup undoGroup, Object object, int n, int n2) {
        UndoAction undoAction = new UndoAction("Insert Text");
        undoAction.setUndoData("InsertStart", new Integer(n));
        undoAction.setUndoData("InsertLength", new Integer(n2));
        undoAction.setUndoData("InsertData", object);
        undoGroup.setUndoAction(undoAction);
    }

    private void undoInsert(UndoAction undoAction) {
        try {
            Integer n = (Integer)undoAction.getUndoData("InsertStart");
            Integer n2 = (Integer)undoAction.getUndoData("InsertLength");
            undoAction.getUndoData("InsertData");
            this.textPanel.delete(n, n2, null);
            this.textPanel.layoutAfterChange(n - 1);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void redoInsert(UndoAction undoAction) {
        try {
            Integer n = (Integer)undoAction.getUndoData("InsertStart");
            Integer cfr_ignored_0 = (Integer)undoAction.getUndoData("InsertLength");
            Object object = undoAction.getUndoData("InsertData");
            if (object instanceof String) {
                this.textPanel.insert((String)object, (int)n, null);
            }
            if (object instanceof TextData) {
                this.textPanel.insert((TextData)object, (int)n, null);
            }
            if (object instanceof ComponentPanel) {
                this.textPanel.insert((ComponentPanel)object, (int)n, null);
            }
            this.textPanel.layoutAfterChange(n - 1);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setUndoDelete(UndoGroup undoGroup, int n, int n2, boolean bl) {
        UndoAction undoAction = new UndoAction("Delete Text");
        TextData textData = this.textPanel.getTextData().getTextData(n, n2, false);
        undoAction.setUndoData("DeleteData", textData);
        undoAction.setUndoData("DeleteStart", new Integer(n));
        undoAction.setUndoData("DeleteEnd", new Integer(n2));
        undoAction.setUndoData("WasSelected", new Boolean(bl));
        undoGroup.setUndoAction(undoAction);
    }

    private void undoDelete(UndoAction undoAction) {
        try {
            TextData textData = (TextData)undoAction.getUndoData("DeleteData");
            Integer n = (Integer)undoAction.getUndoData("DeleteStart");
            Integer n2 = (Integer)undoAction.getUndoData("DeleteEnd");
            Boolean bl = (Boolean)undoAction.getUndoData("WasSelected");
            this.textPanel.insert(textData, (int)n, null);
            this.textPanel.layoutAfterChange(n - 1);
            if (bl.booleanValue()) {
                this.textPanel.getTextSelector().setSelection(n, n2);
                this.textPanel.repaint();
                return;
            }
        }
        catch (Exception exception) {}
    }

    private void redoDelete(UndoAction undoAction) {
        try {
            TextData cfr_ignored_0 = (TextData)undoAction.getUndoData("DeleteData");
            Integer n = (Integer)undoAction.getUndoData("DeleteStart");
            Integer n2 = (Integer)undoAction.getUndoData("DeleteEnd");
            Boolean cfr_ignored_1 = (Boolean)undoAction.getUndoData("WasSelected");
            int n3 = n2 - n + 1;
            this.textPanel.delete(n, n3, null);
            this.textPanel.layoutAfterChange(n - 1);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setUndoStyle(UndoGroup undoGroup, int n, int n2, AttributeList attributeList, AttributeList attributeList2) {
        UndoAction undoAction = new UndoAction("Style Change");
        undoAction.setUndoData("OldStyleList", attributeList);
        undoAction.setUndoData("NewStyleList", attributeList2);
        undoAction.setUndoData("StartIndex", new Integer(n));
        undoAction.setUndoData("EndIndex", new Integer(n2));
        undoGroup.setUndoAction(undoAction);
    }

    private void undoStyle(UndoAction undoAction) {
        try {
            AttributeList attributeList = (AttributeList)undoAction.getUndoData("OldStyleList");
            this.textPanel.getTextData().setStyleList((AttributeList)attributeList.clone());
            int n = (Integer)undoAction.getUndoData("StartIndex");
            int n2 = (Integer)undoAction.getUndoData("EndIndex");
            this.textPanel.layoutRange(n, n2);
            this.textPanel.getTextSelector().setSelection(n, n2);
            this.textPanel.repaint();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void redoStyle(UndoAction undoAction) {
        try {
            AttributeList attributeList = (AttributeList)undoAction.getUndoData("NewStyleList");
            this.textPanel.getTextData().setStyleList((AttributeList)attributeList.clone());
            int n = (Integer)undoAction.getUndoData("StartIndex");
            int n2 = (Integer)undoAction.getUndoData("EndIndex");
            this.textPanel.layoutRange(n, n2);
            this.textPanel.getTextSelector().setSelection(n, n2);
            this.textPanel.repaint();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setUndoOwner(UndoGroup undoGroup) {
        UndoAction undoAction = new UndoAction("Owner Change");
        AttributeList attributeList = this.textPanel.getTextData().getOwnerList();
        AttributeList attributeList2 = (AttributeList)attributeList.clone();
        undoAction.setUndoData("OldOwnerList", attributeList2);
        undoGroup.setUndoAction(undoAction);
    }

    private void undoOwner(UndoAction undoAction) {
        try {
            AttributeList attributeList = (AttributeList)undoAction.getUndoData("OldOwnerList");
            this.textPanel.getTextData().setOwnerList(attributeList);
            this.textPanel.layoutPage();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void redoOwner(UndoAction undoAction) {
        try {
            AttributeList attributeList = (AttributeList)undoAction.getUndoData("OldOwnerList");
            this.textPanel.getTextData().setOwnerList(attributeList);
            this.textPanel.layoutPage();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

