/*
 * Decompiled with CFR 0.152.
 */
package emsl.objects;

import emsl.objects.FontPlus;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.Serializable;

public class TextStyle
implements Serializable {
    public static final int SPACING_SINGLE = 1;
    public static final int SPACING_DOUBLE = 2;
    public static final int SPACING_ONE_AND_HALF = 3;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 3;
    public static final int ALIGN_JUSTIFY = 4;
    private String styleName;
    private TextStyle baseStyle;
    private String fontName;
    private int fontStyle;
    private int fontSize;
    private Color foreground;
    private int spacing;
    private int alignment;
    private FontPlus fontPlus;
    private transient FontPlus scaledFontPlus;
    private int viewScale;

    public TextStyle() {
        this.setBaseStyle(null);
        this.setStyleName(null);
        this.setFontPlus(null);
        this.setForeground(null);
        this.setSpacing(-1);
        this.setAlignment(-1);
        this.fontPlus = null;
        this.scaledFontPlus = null;
        this.viewScale = 0;
    }

    public TextStyle(TextStyle textStyle) {
        this();
        this.setBaseStyle(textStyle);
    }

    public TextStyle(String string) {
        this();
        this.setStyleName(string);
    }

    public TextStyle(String string, TextStyle textStyle) {
        this(textStyle);
        this.setStyleName(string);
    }

    public Object clone() {
        TextStyle textStyle = new TextStyle();
        textStyle.setBaseStyle(this.getBaseStyle());
        textStyle.setStyleName(this.getStyleName());
        textStyle.setFontPlus(this.getFontPlus());
        textStyle.setForeground(this.getForeground());
        textStyle.setSpacing(this.getSpacing());
        textStyle.setAlignment(this.getAlignment());
        textStyle.setViewScale(this.getViewScale());
        return textStyle;
    }

    public boolean equals(TextStyle textStyle) {
        if (this.getBaseStyle() != textStyle.getBaseStyle()) {
            return false;
        }
        if (!this.getStyleName().equals(textStyle.getStyleName())) {
            return false;
        }
        if (!this.getFontPlus().equals(textStyle.getFontPlus())) {
            return false;
        }
        if (!this.getForeground().equals(textStyle.getForeground())) {
            return false;
        }
        if (this.getSpacing() != textStyle.getSpacing()) {
            return false;
        }
        return this.getAlignment() == textStyle.getAlignment();
    }

    public boolean equals(Object object) {
        if (object instanceof TextStyle) {
            return this.equals((TextStyle)object);
        }
        return false;
    }

    public void setBaseStyle(TextStyle textStyle) {
        this.baseStyle = textStyle;
        this.setForeground(this.getForeground());
        this.setSpacing(this.getSpacing());
        this.setAlignment(this.getAlignment());
        this.setFontPlus(this.getFontPlus());
        this.fontPlus = null;
        this.scaledFontPlus = null;
        this.viewScale = this.getViewScale();
    }

    public void setStyleName(String string) {
        if (string == null) {
            string = "NoName";
        }
        this.styleName = new String(string);
    }

    public void setForeground(Color color) {
        if (this.baseStyle != null && this.baseStyle.getForeground().equals(color)) {
            color = null;
        }
        this.foreground = color;
    }

    public void setSpacing(int n) {
        if (this.baseStyle != null && this.baseStyle.getSpacing() == n) {
            n = -1;
        }
        this.spacing = n;
    }

    public void setAlignment(int n) {
        if (this.baseStyle != null && this.baseStyle.getAlignment() == n) {
            n = -1;
        }
        this.alignment = n;
    }

    public TextStyle getBaseStyle() {
        return this.baseStyle;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getForeground();
        }
        return Color.black;
    }

    public int getSpacing() {
        if (this.spacing > 0) {
            return this.spacing;
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getSpacing();
        }
        return 1;
    }

    public int getAlignment() {
        if (this.alignment > 0) {
            return this.alignment;
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getAlignment();
        }
        return 1;
    }

    public Font getFont() {
        if (this.fontPlus == null) {
            this.getFontPlus();
        }
        return this.fontPlus.getAWTFont();
    }

    public FontPlus getFontPlus() {
        if (this.fontPlus == null) {
            this.fontPlus = new FontPlus(this.getFontName(), this.getFontStyle(), this.getFontSize());
        }
        return this.fontPlus;
    }

    public FontPlus getScaledFontPlus() {
        if (this.viewScale == 100) {
            return this.getFontPlus();
        }
        if (this.scaledFontPlus == null) {
            this.scaledFontPlus = new FontPlus(this.getFontName(), this.getFontStyle(), this.getScaledFontSize());
        }
        return this.scaledFontPlus;
    }

    public String getFontName() {
        if (this.fontName != null) {
            return this.fontName;
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getFontName();
        }
        return "SansSerif";
    }

    public int getFontSize() {
        if (this.fontSize > 0) {
            return this.fontSize;
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getFontSize();
        }
        return 12;
    }

    public int getScaledFontSize() {
        if (this.fontSize > 0) {
            return this.fontSize * this.viewScale / 100;
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getFontSize() * this.viewScale / 100;
        }
        return 12 * this.viewScale / 100;
    }

    public int getFontStyle() {
        if (this.fontStyle >= 0) {
            return this.fontStyle;
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getFontStyle();
        }
        return 0;
    }

    public void setFontPlus(FontPlus fontPlus) {
        this.fontPlus = null;
        this.scaledFontPlus = null;
        if (fontPlus == null) {
            this.setFontName(null);
            this.setFontSize(-1);
            this.setFontStyle(-1);
            return;
        }
        this.setFontName(fontPlus.getName());
        this.setFontSize(fontPlus.getSize());
        this.setFontStyle(fontPlus.getStyle());
    }

    public void setFontName(String string) {
        this.fontPlus = null;
        this.scaledFontPlus = null;
        if (this.baseStyle != null && this.baseStyle.getFontName().equals(string)) {
            string = null;
        }
        this.fontName = string;
    }

    public void setFontSize(int n) {
        this.fontPlus = null;
        this.scaledFontPlus = null;
        if (this.baseStyle != null && this.baseStyle.getFontSize() == n) {
            n = -1;
        }
        this.fontSize = n;
    }

    public void setFontStyle(int n) {
        this.fontPlus = null;
        this.scaledFontPlus = null;
        if (this.baseStyle != null && this.baseStyle.getFontStyle() == n) {
            n = -1;
        }
        this.fontStyle = n;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontPlus().getFontMetrics();
    }

    public FontMetrics getScaledFontMetrics() {
        return this.getScaledFontPlus().getFontMetrics();
    }

    public void setViewScale(int n) {
        if (n == this.viewScale) {
            return;
        }
        this.viewScale = n;
        this.scaledFontPlus = null;
    }

    public int getViewScale() {
        if (this.viewScale > 0) {
            return this.viewScale;
        }
        if (this.baseStyle != null) {
            return this.baseStyle.getViewScale();
        }
        return 100;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(this.getStyleName()) + " : ";
        if (this.baseStyle != null) {
            string = String.valueOf(string) + this.getBaseStyle().getStyleName() + " +  ";
        }
        if (this.baseStyle == null || this.fontName != null) {
            string = String.valueOf(string) + this.getFontName() + "  ";
        }
        if (this.baseStyle == null || this.fontSize > 0) {
            string = String.valueOf(string) + this.getFontSize() + "pt  ";
        }
        if (this.baseStyle == null || this.fontStyle >= 0) {
            FontPlus fontPlus = this.getFontPlus();
            if (fontPlus.isPlain()) {
                string = String.valueOf(string) + "Plain  ";
            }
            if (fontPlus.isBold()) {
                string = String.valueOf(string) + "Bold  ";
            }
            if (fontPlus.isItalic()) {
                string = String.valueOf(string) + "Italic  ";
            }
            if (fontPlus.isUnderline()) {
                string = String.valueOf(string) + "Underline  ";
            }
        }
        if (this.baseStyle == null || this.spacing > 0) {
            if (this.getSpacing() == 1) {
                string = String.valueOf(string) + "spacing=1  ";
            }
            if (this.getSpacing() == 2) {
                string = String.valueOf(string) + "spacing=2  ";
            }
            if (this.getSpacing() == 3) {
                string = String.valueOf(string) + "spacing=1.5  ";
            }
        }
        if (this.baseStyle == null || this.alignment > 0) {
            if (this.getAlignment() == 1) {
                string = String.valueOf(string) + "align=left  ";
            }
            if (this.getAlignment() == 2) {
                string = String.valueOf(string) + "align=right  ";
            }
            if (this.getAlignment() == 3) {
                string = String.valueOf(string) + "align=center  ";
            }
            if (this.getAlignment() == 4) {
                string = String.valueOf(string) + "align=justify  ";
            }
        }
        return string;
    }
}

