/*
 * Decompiled with CFR 0.152.
 */
package emsl.editors;

import emsl.awt.GUIButton;
import emsl.awt.GUIDialogueBox;
import emsl.awt.GUIPanel;
import emsl.editors.FileEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;

public class PropertyPaint
extends GUIButton
implements ActionListener {
    private transient PropertyEditor editor;

    public PropertyPaint(PropertyEditor propertyEditor) {
        super(new Dimension(10, 30), "");
        this.editor = propertyEditor;
        this.addActionListener(this);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Rectangle rectangle = new Rectangle(2, 2, this.getSize().width - 6, this.getSize().height - 6);
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.setColor(Color.black);
        this.editor.paintValue(graphics2, rectangle);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.editor.supportsCustomEditor()) {
            return;
        }
        Component component = this.editor.getCustomEditor();
        if (component == null) {
            return;
        }
        if (this.editor instanceof FileEditor) {
            ((FileEditor)this.editor).getCustomEditor(this.getParentFrame());
            return;
        }
        GUIDialogueBox gUIDialogueBox = this.createDialogueBox(component);
        gUIDialogueBox.display();
        gUIDialogueBox.dispose();
    }

    private GUIDialogueBox createDialogueBox(Component component) {
        GUIDialogueBox gUIDialogueBox = new GUIDialogueBox(this.getParentFrame(), "Property Editor", false);
        gUIDialogueBox.addExitButtons("OK");
        GUIPanel gUIPanel = gUIDialogueBox.getDisplayPanel();
        gUIPanel.setLayout(new BorderLayout());
        gUIPanel.add("Center", component);
        return gUIDialogueBox;
    }
}

