/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIButton;
import emsl.awt.GUIIconBox;
import emsl.awt.GUIPopUpButton;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.StringTokenizer;

public class GUIChoice
extends GUIPopUpButton
implements ComponentListener {
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    public static final int CENTER = 1;
    private int alignment;
    private String choices;
    private String delimeter;
    private int elementHeight;

    public GUIChoice(Dimension dimension, String string, String string2) {
        super(dimension);
        this.setChoices(string);
        this.setDelimeter(string2);
        this.setAlignment(0);
        this.addComponentListener(this);
    }

    public GUIChoice(Dimension dimension, String string) {
        this(dimension, string, ",");
    }

    public GUIChoice(Dimension dimension) {
        this(dimension, "", ",");
    }

    public void setAlignment(int n) {
        this.alignment = n;
        super.setAlignment(n);
        this.redoPopUp();
    }

    public void setChoices(String string) {
        this.choices = new String(string);
        this.redoPopUp();
    }

    public void setChoices(String[] stringArray) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(String.valueOf(stringArray[n]) + ",");
                ++n;
            }
            this.setChoices(stringBuffer.toString());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setDelimeter(String string) {
        this.delimeter = new String(string);
        this.redoPopUp();
    }

    public void setElementHeight(int n) {
        this.elementHeight = n;
        this.redoPopUp();
    }

    private void redoPopUp() {
        if (this.delimeter == null || this.choices == null) {
            return;
        }
        String string = this.getText();
        Dimension dimension = this.getSize();
        if (this.elementHeight != 0) {
            dimension.height = this.elementHeight;
        }
        GUIIconBox gUIIconBox = new GUIIconBox(1, 0, "iconBox");
        StringTokenizer stringTokenizer = new StringTokenizer(this.choices, this.delimeter, false);
        String string2 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equals("")) continue;
            GUIButton gUIButton = new GUIButton(dimension, string3);
            gUIButton.setAlignment(this.alignment);
            gUIIconBox.add(gUIButton);
            ++n;
            if (string2 != null) continue;
            string2 = string3;
        }
        gUIIconBox.setColumns(n / 15 + 1);
        this.setIconBox(gUIIconBox);
        if (string != null) {
            this.select(string, true);
            return;
        }
        this.select(string2, true);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.redoPopUp();
    }
}

